/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.blocks.pulley;

import com.bwt.block_entities.BwtBlockEntities;
import com.bwt.blocks.AnchorBlock;
import com.bwt.blocks.BwtBlocks;
import com.bwt.blocks.RopeBlock;
import com.bwt.blocks.pulley.PulleyBlock;
import com.bwt.blocks.pulley.PulleyScreenHandler;
import com.bwt.entities.MovingRopeEntity;
import com.bwt.items.BwtItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.UUID;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2457;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2768;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_4538;
import net.minecraft.class_7225;

public class PulleyBlockEntity
extends class_2586
implements class_3908,
class_1263 {
    protected static final int INVENTORY_SIZE = 4;
    public final Inventory inventory = new Inventory(4);
    public final InventoryStorage inventoryWrapper = InventoryStorage.of((class_1263)this.inventory, null);
    protected int mechPower;
    private MovingRopeEntity rope;
    private UUID ropeId;
    protected final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> PulleyBlockEntity.this.mechPower;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    PulleyBlockEntity.this.mechPower = value > 0 ? 1 : 0;
                    break;
                }
            }
        }

        public int method_17389() {
            return 1;
        }
    };

    public PulleyBlockEntity(class_2338 pos, class_2680 state) {
        super(BwtBlockEntities.pulleyBlockEntity, pos, state);
    }

    public static boolean isMechPowered(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)PulleyBlock.MECH_POWERED);
    }

    public static boolean isRedstonePowered(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)PulleyBlock.POWERED);
    }

    public boolean isRaising(class_2680 state) {
        return PulleyBlockEntity.isMechPowered(state) && !PulleyBlockEntity.isRedstonePowered(state);
    }

    public boolean isLowering(class_2680 state) {
        return !PulleyBlockEntity.isMechPowered(state) && !PulleyBlockEntity.isRedstonePowered(state) && this.inventory.field_5828.stream().anyMatch(itemStack -> itemStack.method_31574(BwtItems.ropeItem) && itemStack.method_7947() > 0);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, PulleyBlockEntity blockEntity) {
        if (world.field_9236) {
            return;
        }
        blockEntity.tryNextOperation(world, pos, state);
    }

    private void tryNextOperation(class_1937 world, class_2338 pos, class_2680 state) {
        if (this.doesRopeEntityExist(world)) {
            return;
        }
        if (this.canGoDown(world, pos, state, false)) {
            this.goDown(world, pos);
            return;
        }
        if (this.canGoUp(world, pos, state)) {
            this.goUp(world, pos);
        }
    }

    private boolean doesRopeEntityExist(class_1937 world) {
        if (this.rope != null && !this.rope.method_31481()) {
            return true;
        }
        if (this.ropeId == null) {
            return false;
        }
        if (!(world instanceof class_3218)) {
            return true;
        }
        class_3218 serverWorld = (class_3218)world;
        class_1297 entity = serverWorld.method_14190(this.ropeId);
        if (entity == null) {
            return true;
        }
        if (entity instanceof MovingRopeEntity) {
            MovingRopeEntity movingRopeEntity;
            this.rope = movingRopeEntity = (MovingRopeEntity)entity;
            this.ropeId = null;
            return true;
        }
        return false;
    }

    private boolean validRopeConnector(class_2680 state) {
        return state.method_27852(BwtBlocks.anchorBlock) && state.method_11654((class_2769)AnchorBlock.field_10927) == class_2350.field_11036 || state.method_27852((class_2248)BwtBlocks.ropeBlock);
    }

    private boolean canGoUp(class_1937 world, class_2338 pos, class_2680 state) {
        if (!this.isRaising(state)) {
            return false;
        }
        if (!this.putRope(true)) {
            return false;
        }
        class_2338 lowest = RopeBlock.getBottomRopePos(world, pos);
        return !lowest.equals((Object)pos);
    }

    private boolean canGoDown(class_1937 world, class_2338 pos, class_2680 state, boolean isMoving) {
        if (!this.isLowering(state)) {
            return false;
        }
        if (!this.hasRope()) {
            return false;
        }
        class_2338 newPos = RopeBlock.getBottomRopePos(world, pos).method_10074();
        class_2680 newState = world.method_8320(newPos);
        boolean flag = !isMoving && this.validRopeConnector(newState);
        return newPos.method_10264() > world.method_31607() && (newState.method_45474() || flag) && newPos.method_10084().method_10264() > world.method_31607();
    }

    private void goUp(class_1937 world, class_2338 pos) {
        class_2338 lowest = RopeBlock.getBottomRopePos(world, pos);
        class_2680 belowState = world.method_8320(lowest.method_10074());
        this.rope = new MovingRopeEntity(world, pos, lowest, lowest.method_10084().method_10264());
        this.ropeId = null;
        if (this.validRopeConnector(belowState) && !this.movePlatform(world, lowest.method_10074(), true)) {
            this.rope = null;
            return;
        }
        world.method_8396(null, pos.method_10074(), BwtBlocks.ropeBlock.method_9564().method_26231().method_10595(), class_3419.field_15245, 0.4f + world.field_9229.method_43057() * 0.1f, 1.0f);
        world.method_8649((class_1297)this.rope);
        world.method_8650(lowest, false);
        this.putRope(false);
    }

    private void goDown(class_1937 world, class_2338 pos) {
        class_2338 newPos = RopeBlock.getBottomRopePos(world, pos).method_10074();
        class_2680 bottomState = world.method_8320(newPos);
        this.rope = new MovingRopeEntity(world, pos, newPos.method_10084(), newPos.method_10264());
        this.ropeId = null;
        if (this.validRopeConnector(bottomState) && !this.movePlatform(world, newPos, false)) {
            this.rope = null;
            return;
        }
        world.method_8649((class_1297)this.rope);
    }

    private boolean movePlatform(class_1937 world, class_2338 anchor, boolean up) {
        class_2680 state = world.method_8320(anchor);
        if (!this.validRopeConnector(state)) {
            return false;
        }
        HashSet<class_2338> platformBlocks = new HashSet<class_2338>();
        platformBlocks.add(anchor);
        class_2338 below = anchor.method_10074();
        class_2680 belowState = world.method_8320(below);
        if (this.isPlatform(belowState) ? !this.addToList(world, below, below, platformBlocks, up) : !up && !this.isIgnoreable(belowState)) {
            return false;
        }
        if (!world.field_9236) {
            for (class_2338 blockPos : platformBlocks) {
                class_2338 offset = blockPos.method_10059((class_2382)anchor.method_10084());
                this.rope.addBlock((class_2382)offset, world, blockPos, world.method_8320(blockPos));
                class_2680 upState = world.method_8320(blockPos.method_10084());
                if (!this.isMoveableBlock(upState)) continue;
                if (upState.method_26204() instanceof class_2241) {
                    upState = this.flattenRail(upState);
                }
                if (upState.method_26204() instanceof class_2457) {
                    upState = (class_2680)upState.method_11657((class_2769)class_2457.field_11432, (Comparable)Integer.valueOf(0));
                }
                this.rope.addBlock(new class_2382(offset.method_10263(), offset.method_10264() + 1, offset.method_10260()), world, blockPos.method_10084(), upState);
            }
            this.rope.getBlockMap().entrySet().stream().sorted((a, b) -> ((class_2382)b.getKey()).method_10264() - ((class_2382)a.getKey()).method_10264()).forEach(entry -> {
                class_2338 blockPos = anchor.method_10084().method_10081((class_2382)entry.getKey());
                world.method_8650(blockPos, false);
            });
        }
        return true;
    }

    public boolean isIgnoreable(class_2680 state) {
        return state.method_45474();
    }

    public boolean isMoveableBlock(class_2680 state) {
        return state.method_27852(class_2246.field_10091) || state.method_26204() instanceof class_2241;
    }

    public boolean isPlatform(class_2680 state) {
        return state.method_27852(BwtBlocks.platformBlock);
    }

    private class_2680 flattenRail(class_2680 state) {
        class_2754 property = state.method_28498((class_2769)class_2741.field_12507) ? class_2741.field_12507 : (state.method_28498((class_2769)class_2741.field_12542) ? class_2741.field_12542 : null);
        class_2768 currentShape = (class_2768)state.method_11654((class_2769)property);
        return (class_2680)state.method_11657((class_2769)property, (Comparable)(switch (currentShape) {
            case class_2768.field_12667, class_2768.field_12666 -> class_2768.field_12674;
            case class_2768.field_12670, class_2768.field_12668 -> class_2768.field_12665;
            default -> currentShape;
        }));
    }

    private boolean addToList(class_1937 world, class_2338 pos, class_2338 sourcePos, HashSet<class_2338> set, boolean up) {
        class_2338 distance = pos.method_10059((class_2382)sourcePos);
        if (Math.abs(distance.method_10263()) > 2 || Math.abs(distance.method_10260()) > 2 || Math.abs(distance.method_10264()) > 5) {
            return false;
        }
        if (!this.isPlatform(world.method_8320(pos))) {
            return true;
        }
        class_2338 blockCheck = up ? pos.method_10084() : pos.method_10074();
        class_2680 otherState = world.method_8320(blockCheck);
        if (!(this.isIgnoreable(otherState) || this.isMoveableBlock(otherState) || this.isPlatform(otherState) || set.contains(blockCheck))) {
            return false;
        }
        set.add(pos);
        ArrayList fails = new ArrayList();
        Arrays.stream(class_2350.values()).map(arg_0 -> ((class_2338)pos).method_10093(arg_0)).forEach(offsetPos -> {
            class_2338 distance2 = offsetPos.method_10059((class_2382)sourcePos);
            if (Math.abs(distance2.method_10263()) > 2 || Math.abs(distance2.method_10260()) > 2 || Math.abs(distance2.method_10264()) > 5) {
                return;
            }
            if (fails.isEmpty() && !set.contains(offsetPos) && !this.addToList(world, (class_2338)offsetPos, sourcePos, set, up)) {
                fails.add(offsetPos);
            }
        });
        return fails.isEmpty();
    }

    public boolean onJobCompleted(class_1937 world, class_2338 pulleyPos, class_2680 pulleyState, boolean up, int targetY) {
        class_2338 ropePos = new class_2338(pulleyPos.method_10263(), targetY - (up ? 1 : 0), pulleyPos.method_10260());
        class_2680 state = world.method_8320(ropePos);
        class_2680 defaultRopeState = BwtBlocks.ropeBlock.method_9564();
        if (!up) {
            if (state.method_45474() && defaultRopeState.method_26184((class_4538)world, ropePos) && this.hasRope()) {
                world.method_8396(null, pulleyPos.method_10074(), defaultRopeState.method_26231().method_10598(), class_3419.field_15245, 0.4f, 1.0f);
                world.method_8501(ropePos, defaultRopeState);
                this.takeRope(false);
            } else {
                this.tryNextOperation(world, pulleyPos, pulleyState);
                this.rope.method_31472();
                this.ropeId = null;
                return false;
            }
        }
        if ((this.rope.isMovingUp() ? this.canGoUp(world, pulleyPos, pulleyState) : this.canGoDown(world, pulleyPos, pulleyState, true)) && !this.rope.isPathBlocked()) {
            this.rope.setTargetY(targetY + (this.rope.isMovingUp() ? 1 : -1));
            if (up && !world.method_8320(ropePos.method_10084()).method_26164(class_3481.field_51989)) {
                world.method_8396(null, pulleyPos.method_10074(), defaultRopeState.method_26231().method_10595(), class_3419.field_15245, 0.4f + world.field_9229.method_43057() * 0.1f, 1.0f);
                world.method_8650(ropePos.method_10084(), false);
                this.putRope(false);
            }
            return true;
        }
        this.tryNextOperation(world, pulleyPos, pulleyState);
        this.rope.method_31472();
        this.ropeId = null;
        return false;
    }

    protected boolean takeRope(int count, boolean simulate) {
        try (Transaction transaction = Transaction.openOuter();){
            long numExtracted = this.inventoryWrapper.extract((Object)ItemVariant.of((class_1799)BwtItems.ropeItem.method_7854()), (long)count, (TransactionContext)transaction);
            if (simulate) {
                transaction.abort();
            } else {
                transaction.commit();
            }
            boolean bl = numExtracted >= (long)count;
            return bl;
        }
    }

    protected boolean takeRope(boolean simulate) {
        return this.takeRope(1, simulate);
    }

    protected boolean putRope(int count, boolean simulate) {
        try (Transaction transaction = Transaction.openOuter();){
            long numExtracted = this.inventoryWrapper.insert((Object)ItemVariant.of((class_1799)BwtItems.ropeItem.method_7854()), (long)count, (TransactionContext)transaction);
            if (simulate) {
                transaction.abort();
            } else {
                transaction.commit();
            }
            boolean bl = numExtracted >= (long)count;
            return bl;
        }
    }

    protected boolean putRope(boolean simulate) {
        return this.putRope(1, simulate);
    }

    public boolean hasRope(int count) {
        return this.takeRope(count, true);
    }

    public boolean hasRope() {
        return this.hasRope(1);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.inventory.method_7659(nbt.method_10554("Inventory", 10), registryLookup);
        this.mechPower = nbt.method_10550("mechPower");
        if (nbt.method_10545("ropeId")) {
            this.ropeId = nbt.method_25926("ropeId");
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10566("Inventory", (class_2520)this.inventory.method_7660(registryLookup));
        nbt.method_10569("mechPower", this.mechPower);
        if (this.rope != null && !this.rope.method_31481()) {
            nbt.method_25927("ropeId", this.rope.method_5667());
        }
    }

    public void method_31662(class_1937 world) {
        super.method_31662(world);
    }

    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new PulleyScreenHandler(syncId, playerInventory, (class_1263)this.inventory, this.propertyDelegate);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)this.method_11010().method_26204().method_9539());
    }

    public int method_5439() {
        return this.inventory.method_5439();
    }

    public boolean method_5442() {
        return this.inventory.method_5442();
    }

    public class_1799 method_5438(int slot) {
        return this.inventory.method_5438(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        return this.inventory.method_5434(slot, amount);
    }

    public class_1799 method_5441(int slot) {
        return this.inventory.method_5441(slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.inventory.method_5447(slot, stack);
    }

    public boolean method_5443(class_1657 player) {
        return this.inventory.method_5443(player);
    }

    public void method_5448() {
        this.inventory.method_5448();
    }

    public class Inventory
    extends class_1277 {
        public Inventory(int size) {
            super(size);
        }

        public void method_5431() {
            PulleyBlockEntity.this.method_5431();
        }
    }
}

