/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.blocks.turntable;

import com.bwt.block_entities.BwtBlockEntities;
import com.bwt.blocks.BwtBlocks;
import com.bwt.blocks.turntable.CanRotateHelper;
import com.bwt.blocks.turntable.HorizontalBlockAttachmentHelper;
import com.bwt.blocks.turntable.RotationProcessHelper;
import com.bwt.blocks.turntable.TurntableBlock;
import com.bwt.blocks.turntable.VerticalBlockAttachmentHelper;
import com.bwt.mixin.MovableBlockEntityMixin;
import com.bwt.recipes.BwtRecipes;
import com.bwt.recipes.turntable.TurntableRecipe;
import com.bwt.recipes.turntable.TurntableRecipeInput;
import com.bwt.sounds.BwtSoundEvents;
import com.bwt.utils.BlockPosAndState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1264;
import net.minecraft.class_1863;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_4538;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;

public class TurntableBlockEntity
extends class_2586 {
    protected static final int blocksAboveToRotate = 2;
    protected static final int[] ticksToRotate = new int[]{10, 20, 40, 80};
    protected static final int turnsToCraft = 8;
    public int rotationTickCounter;
    public int craftingTurnCounter;

    public TurntableBlockEntity(class_2338 pos, class_2680 state) {
        super(BwtBlockEntities.turntableBlockEntity, pos, state);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.rotationTickCounter = nbt.method_10550("rotationTickCounter");
        this.craftingTurnCounter = nbt.method_10550("craftingTurnCounter");
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10569("rotationTickCounter", this.rotationTickCounter);
        nbt.method_10569("craftingTurnCounter", this.craftingTurnCounter);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, TurntableBlockEntity blockEntity) {
        if (world.field_9236) {
            return;
        }
        if (!state.method_27852(BwtBlocks.turntableBlock) || !((Boolean)state.method_11654((class_2769)TurntableBlock.MECH_POWERED)).booleanValue()) {
            blockEntity.rotationTickCounter = 0;
            return;
        }
        int tickSetting = (Integer)state.method_11654((class_2769)TurntableBlock.TICK_SETTING);
        ++blockEntity.rotationTickCounter;
        if (blockEntity.rotationTickCounter >= ticksToRotate[tickSetting]) {
            world.method_8396(null, pos, BwtSoundEvents.TURNTABLE_TURNING_CLICK, class_3419.field_15245, 0.05f, 1.0f);
            blockEntity.rotationTickCounter = 0;
            TurntableBlockEntity.rotateTurnTable(world, pos, state, blockEntity);
        }
    }

    protected static void rotateTurnTable(class_1937 world, class_2338 pos, class_2680 state, TurntableBlockEntity blockEntity) {
        class_2470 rotation = (Boolean)state.method_11654((class_2769)TurntableBlock.POWERED) != false ? class_2470.field_11463 : class_2470.field_11465;
        List<BlockPosAndState> blocksToRotate = TurntableBlockEntity.getBlocksToRotate(world, pos);
        List<BlockPosAndState> attachedBlocksBeingRotated = TurntableBlockEntity.getAttachedBlocksBeingRotated(world, blocksToRotate);
        List<BlockPosAndState> attachedBlockDestinations = TurntableBlockEntity.getAttachedBlockDestinations(world, pos, attachedBlocksBeingRotated, rotation);
        TurntableBlockEntity.pickUpAttachedBlocks(world, attachedBlocksBeingRotated, attachedBlockDestinations);
        TurntableBlockEntity.rotateCentralColumnBlocks(world, blocksToRotate, blockEntity, rotation);
        TurntableBlockEntity.placeRotatedAttachedBlocks(world, attachedBlocksBeingRotated, attachedBlockDestinations, rotation);
        state.method_30101((class_1936)world, pos, 1);
    }

    protected static List<BlockPosAndState> getBlocksToRotate(class_1937 world, class_2338 turntablePos) {
        class_2338 blockAbovePos;
        class_2680 blockAboveState;
        class_1863 recipeManager = world.method_8433();
        ArrayList<BlockPosAndState> blocksToRotate = new ArrayList<BlockPosAndState>();
        for (int j = 1; j <= 2 && !(blockAboveState = world.method_8320(blockAbovePos = turntablePos.method_10086(j))).method_26164(class_3481.field_51989) && CanRotateHelper.canRotate(world, blockAbovePos, blockAboveState); ++j) {
            class_2586 blockAboveEntity = world.method_8321(blockAbovePos);
            blocksToRotate.add(new BlockPosAndState(blockAbovePos, blockAboveState, blockAboveEntity));
            TurntableRecipeInput recipeInput = new TurntableRecipeInput(blockAboveState.method_26204());
            boolean recipeExistsForBlock = recipeManager.method_8132(BwtRecipes.TURNTABLE_RECIPE_TYPE, (class_9695)recipeInput, world).isPresent();
            if (recipeExistsForBlock || !VerticalBlockAttachmentHelper.canPropagateRotationUpwards(world, blockAbovePos, blockAboveState)) break;
        }
        return blocksToRotate;
    }

    protected static List<BlockPosAndState> getAttachedBlocksBeingRotated(class_1937 world, List<BlockPosAndState> blocksToRotate) {
        ArrayList<BlockPosAndState> attachedBlocks = new ArrayList<BlockPosAndState>();
        for (BlockPosAndState centralColumnPosAndState : blocksToRotate) {
            class_2338 centralColumnPos = centralColumnPosAndState.pos();
            class_2680 centralColumnState = centralColumnPosAndState.state();
            attachedBlocks.addAll(Arrays.stream(class_2350.values()).filter(direction -> direction.method_10166().method_10179()).map(arg_0 -> ((class_2338)centralColumnPos).method_10093(arg_0)).map(attachedPos -> BlockPosAndState.of((class_1936)world, attachedPos)).filter(attachedPosAndState -> HorizontalBlockAttachmentHelper.isAttached(centralColumnPos, centralColumnState, attachedPosAndState.pos(), attachedPosAndState.state())).toList());
        }
        return attachedBlocks;
    }

    protected static List<BlockPosAndState> getAttachedBlockDestinations(class_1937 world, class_2338 turntablePos, List<BlockPosAndState> attachedBlocksBeingRotated, class_2470 rotation) {
        return attachedBlocksBeingRotated.stream().map(attachedPosAndState -> {
            class_2338 attachedPos = attachedPosAndState.pos();
            class_2338 centralColumnPos = new class_2338(turntablePos.method_10263(), attachedPos.method_10264(), turntablePos.method_10260());
            class_2338 directionVector = attachedPos.method_10059((class_2382)centralColumnPos);
            class_2350 direction = class_2350.method_50026((int)directionVector.method_10263(), (int)0, (int)directionVector.method_10260());
            class_2338 attachedDestinationPos = centralColumnPos.method_10093(rotation.equals((Object)class_2470.field_11463) ? Objects.requireNonNull(direction).method_10170() : Objects.requireNonNull(direction).method_10160());
            return BlockPosAndState.of((class_1936)world, attachedDestinationPos);
        }).toList();
    }

    protected static void pickUpAttachedBlocks(class_1937 world, List<BlockPosAndState> attachedBlocksBeingRotated, List<BlockPosAndState> destinations) {
        HashSet attachedPositions = attachedBlocksBeingRotated.stream().map(BlockPosAndState::pos).collect(Collectors.toCollection(HashSet::new));
        for (int idx = 0; idx < attachedBlocksBeingRotated.size(); ++idx) {
            BlockPosAndState attachedPosAndState = attachedBlocksBeingRotated.get(idx);
            BlockPosAndState destination = destinations.get(idx);
            class_2338 attachedPos = attachedPosAndState.pos();
            class_2680 attachedState = attachedPosAndState.state();
            class_2586 attachedBlockEntity = attachedPosAndState.blockEntity();
            if (attachedPositions.contains(destination.pos()) || destination.state().method_45474()) {
                if (attachedBlockEntity != null) {
                    world.method_8544(attachedPos);
                }
                world.method_8650(attachedPos, false);
                world.method_8455(attachedPos, attachedState.method_26204());
                continue;
            }
            world.method_22352(attachedPos, true);
        }
    }

    protected static void rotateCentralColumnBlocks(class_1937 world, List<BlockPosAndState> blocksToRotate, TurntableBlockEntity blockEntity, class_2470 rotation) {
        class_1863 recipeManager = world.method_8433();
        boolean recipeFound = false;
        for (BlockPosAndState blockToRotate : blocksToRotate) {
            class_2338 blockToRotatePos = blockToRotate.pos();
            class_2680 blockToRotateState = blockToRotate.state();
            class_2586 blockToRotateEntity = blockToRotate.blockEntity();
            class_2680 rotatedState = blockToRotateState.method_26186(rotation);
            RotationProcessHelper.processRotation(world, blockToRotatePos, blockToRotateState, rotatedState, blockToRotateEntity);
            TurntableRecipeInput recipeInput = new TurntableRecipeInput(blockToRotateState.method_26204());
            Optional<TurntableRecipe> recipe = recipeManager.method_8132(BwtRecipes.TURNTABLE_RECIPE_TYPE, (class_9695)recipeInput, world).map(class_8786::comp_1933);
            if (!recipe.isPresent()) continue;
            recipeFound = true;
            ++blockEntity.craftingTurnCounter;
            world.method_20290(2001, blockToRotatePos, class_2248.method_9507((class_2680)blockToRotateState));
            if (blockEntity.craftingTurnCounter < 8) continue;
            blockEntity.craftingTurnCounter = 0;
            world.method_8501(blockToRotatePos, recipe.get().getOutput().method_9564());
            class_1264.method_17349((class_1937)world, (class_2338)blockToRotatePos, recipe.get().getDrops());
        }
        if (!recipeFound) {
            blockEntity.craftingTurnCounter = 0;
        }
    }

    protected static void placeRotatedAttachedBlocks(class_1937 world, List<BlockPosAndState> attachedBlocksBeingRotated, List<BlockPosAndState> destinations, class_2470 rotation) {
        HashSet attachedPositions = attachedBlocksBeingRotated.stream().map(BlockPosAndState::pos).collect(Collectors.toCollection(HashSet::new));
        for (int idx = 0; idx < attachedBlocksBeingRotated.size(); ++idx) {
            BlockPosAndState attachedPosAndState = attachedBlocksBeingRotated.get(idx);
            BlockPosAndState destination = destinations.get(idx);
            class_2338 attachedPos = attachedPosAndState.pos();
            class_2680 attachedState = attachedPosAndState.state();
            class_2586 attachedBlockEntity = attachedPosAndState.blockEntity();
            if (attachedPositions.contains(destination.pos()) || destination.state().method_45474()) {
                class_2680 attachedStateRotated = attachedState.method_26186(rotation);
                world.method_8501(destination.pos(), attachedStateRotated);
                attachedStateRotated.method_26204().method_9567(world, destination.pos(), attachedStateRotated, null, attachedStateRotated.method_26204().method_9574((class_4538)world, destination.pos(), attachedStateRotated));
                if (attachedBlockEntity == null) continue;
                ((MovableBlockEntityMixin)attachedBlockEntity).setPos(destination.pos());
                attachedBlockEntity.method_31664(attachedStateRotated);
                attachedBlockEntity.method_5431();
                world.method_8438(attachedBlockEntity);
                continue;
            }
            world.method_22352(attachedPos, true);
        }
    }
}

