/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.emi;

import com.bwt.BetterWithTime;
import com.bwt.blocks.BwtBlocks;
import com.bwt.blocks.mech_hopper.MechHopperBlock;
import com.bwt.emi.recipehandlers.EmiCookingPotRecipeHandler;
import com.bwt.emi.recipehandlers.EmiMillStoneRecipeHandler;
import com.bwt.emi.recipehandlers.EmiSoulForgeRecipeHandler;
import com.bwt.emi.recipes.EmiCookingPotRecipe;
import com.bwt.emi.recipes.EmiHopperFilterPermitList;
import com.bwt.emi.recipes.EmiHopperFilterRecipe;
import com.bwt.emi.recipes.EmiKilnRecipe;
import com.bwt.emi.recipes.EmiMillstoneRecipe;
import com.bwt.emi.recipes.EmiSawRecipe;
import com.bwt.emi.recipes.EmiSoulForgeRecipe;
import com.bwt.emi.recipes.EmiTurntableRecipe;
import com.bwt.recipes.BlockIngredient;
import com.bwt.recipes.BwtRecipes;
import com.bwt.recipes.IngredientWithCount;
import com.bwt.recipes.cooking_pots.AbstractCookingPotRecipe;
import com.bwt.recipes.hopper_filter.HopperFilterRecipe;
import com.bwt.recipes.kiln.KilnRecipe;
import com.bwt.recipes.mill_stone.MillStoneRecipe;
import com.bwt.recipes.saw.SawRecipe;
import com.bwt.recipes.soul_bottling.SoulBottlingRecipe;
import com.bwt.recipes.soul_forge.SoulForgeRecipe;
import com.bwt.recipes.turntable.TurntableRecipe;
import com.bwt.utils.Id;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2960;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_7710;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.minecraft.class_9695;

@Environment(value=EnvType.CLIENT)
public class BwtEmiPlugin
implements EmiPlugin {
    public static final class_2960 WIDGETS = Id.of("textures/gui/container/emiwidgets.png");
    public static EmiRecipeCategory CAULDRON = BwtEmiPlugin.category("cauldron", EmiStack.of((class_1935)BwtBlocks.cauldronBlock));
    public static EmiRecipeCategory STOKED_CAULDRON = BwtEmiPlugin.category("stoked_cauldron", EmiStack.of((class_1935)BwtBlocks.cauldronBlock));
    public static EmiRecipeCategory CRUCIBLE = BwtEmiPlugin.category("crucible", EmiStack.of((class_1935)BwtBlocks.crucibleBlock));
    public static EmiRecipeCategory STOKED_CRUCIBLE = BwtEmiPlugin.category("stoked_crucible", EmiStack.of((class_1935)BwtBlocks.crucibleBlock));
    public static EmiRecipeCategory STOKED_CRUCIBLE_RECLAIM = BwtEmiPlugin.category("stoked_crucible_reclaim", EmiStack.of((class_1935)BwtBlocks.crucibleBlock));
    public static EmiRecipeCategory MILL_STONE = BwtEmiPlugin.category("mill_stone", EmiStack.of((class_1935)BwtBlocks.millStoneBlock));
    public static EmiRecipeCategory SAW = BwtEmiPlugin.category("saw", EmiStack.of((class_1935)BwtBlocks.sawBlock));
    public static EmiRecipeCategory TURNTABLE = BwtEmiPlugin.category("turntable", EmiStack.of((class_1935)BwtBlocks.turntableBlock));
    public static EmiRecipeCategory KILN = BwtEmiPlugin.category("kiln", EmiStack.of((class_1935)class_2246.field_10104));
    public static EmiRecipeCategory SOUL_FORGE = BwtEmiPlugin.category("soul_forge", EmiStack.of((class_1935)BwtBlocks.soulForgeBlock));
    public static EmiRecipeCategory HOPPER_SOULS = BwtEmiPlugin.category("hopper_souls", EmiStack.of((class_1935)BwtBlocks.hopperBlock));
    public static EmiRecipeCategory HOPPER_FILTERING = BwtEmiPlugin.category("hopper_filtering", EmiStack.of((class_1935)BwtBlocks.hopperBlock));

    public static EmiRenderable simplifiedEmiStack(EmiStack stack) {
        return stack;
    }

    public static EmiRecipeCategory category(String id, EmiStack icon) {
        return new EmiRecipeCategory(Id.of(id), (EmiRenderable)icon);
    }

    public static EmiRecipeCategory category(String id, EmiStack icon, Comparator<EmiRecipe> comp) {
        return new EmiRecipeCategory(class_2960.method_60655((String)"btw", (String)id), (EmiRenderable)icon, (EmiRenderable)new EmiTexture(class_2960.method_60655((String)"emi", (String)("textures/simple_icons/" + id + ".png")), 0, 0, 16, 16, 16, 16, 16, 16), comp);
    }

    private static <C extends class_9695, T extends class_1860<C>> List<class_8786<T>> getRecipes(EmiRegistry registry, class_3956<T> type) {
        return registry.getRecipeManager().method_30027(type);
    }

    private static <C extends class_9695, T extends class_3955> List<class_8786<T>> getRecipes(EmiRegistry registry, class_3956<T> type, Predicate<class_7710> category) {
        return registry.getRecipeManager().method_30027(type).stream().filter(r -> category.test(((class_3955)r.comp_1933()).method_45441())).toList();
    }

    public void register(EmiRegistry reg) {
        reg.addCategory(CAULDRON);
        reg.addCategory(STOKED_CAULDRON);
        reg.addCategory(CRUCIBLE);
        reg.addCategory(STOKED_CRUCIBLE);
        reg.addCategory(STOKED_CRUCIBLE_RECLAIM);
        reg.addCategory(MILL_STONE);
        reg.addCategory(SAW);
        reg.addCategory(TURNTABLE);
        reg.addCategory(KILN);
        reg.addCategory(SOUL_FORGE);
        reg.addCategory(HOPPER_SOULS);
        reg.addCategory(HOPPER_FILTERING);
        reg.addRecipeHandler(BetterWithTime.cauldronScreenHandler, new EmiCookingPotRecipeHandler(CAULDRON, STOKED_CAULDRON));
        reg.addRecipeHandler(BetterWithTime.crucibleScreenHandler, new EmiCookingPotRecipeHandler(CRUCIBLE, STOKED_CRUCIBLE, STOKED_CRUCIBLE_RECLAIM));
        reg.addRecipeHandler(BetterWithTime.millStoneScreenHandler, (EmiRecipeHandler)new EmiMillStoneRecipeHandler(MILL_STONE));
        reg.addRecipeHandler(BetterWithTime.soulForgeScreenHandler, (EmiRecipeHandler)new EmiSoulForgeRecipeHandler.FourByFour());
        reg.addRecipeHandler(BetterWithTime.soulForgeScreenHandler, (EmiRecipeHandler)new EmiSoulForgeRecipeHandler.ThreeByThree());
        reg.addWorkstation(CAULDRON, (EmiIngredient)EmiStack.of((class_1935)BwtBlocks.cauldronBlock));
        reg.addWorkstation(STOKED_CAULDRON, (EmiIngredient)EmiStack.of((class_1935)BwtBlocks.cauldronBlock));
        reg.addWorkstation(CRUCIBLE, (EmiIngredient)EmiStack.of((class_1935)BwtBlocks.crucibleBlock));
        reg.addWorkstation(STOKED_CRUCIBLE, (EmiIngredient)EmiStack.of((class_1935)BwtBlocks.crucibleBlock));
        reg.addWorkstation(MILL_STONE, (EmiIngredient)EmiStack.of((class_1935)BwtBlocks.millStoneBlock));
        reg.addWorkstation(SAW, (EmiIngredient)EmiStack.of((class_1935)BwtBlocks.sawBlock));
        reg.addWorkstation(TURNTABLE, (EmiIngredient)EmiStack.of((class_1935)BwtBlocks.turntableBlock));
        reg.addWorkstation(KILN, (EmiIngredient)EmiStack.of((class_1935)class_2246.field_10104));
        reg.addWorkstation(SOUL_FORGE, (EmiIngredient)EmiStack.of((class_1935)BwtBlocks.soulForgeBlock));
        reg.addWorkstation(VanillaEmiRecipeCategories.CRAFTING, (EmiIngredient)EmiStack.of((class_1935)BwtBlocks.soulForgeBlock));
        reg.addWorkstation(HOPPER_SOULS, (EmiIngredient)EmiStack.of((class_1935)BwtBlocks.hopperBlock));
        reg.addWorkstation(HOPPER_FILTERING, (EmiIngredient)EmiStack.of((class_1935)BwtBlocks.hopperBlock));
        BwtEmiPlugin.getRecipes(reg, BwtRecipes.CAULDRON_RECIPE_TYPE).stream().map(recipeEntry -> new EmiCookingPotRecipe(CAULDRON, recipeEntry)).forEach(arg_0 -> ((EmiRegistry)reg).addRecipe(arg_0));
        BwtEmiPlugin.getRecipes(reg, BwtRecipes.STOKED_CAULDRON_RECIPE_TYPE).stream().map(recipeEntry -> new EmiCookingPotRecipe(STOKED_CAULDRON, recipeEntry)).forEach(arg_0 -> ((EmiRegistry)reg).addRecipe(arg_0));
        BwtEmiPlugin.getRecipes(reg, BwtRecipes.CRUCIBLE_RECIPE_TYPE).stream().map(recipeEntry -> new EmiCookingPotRecipe(CRUCIBLE, recipeEntry)).forEach(arg_0 -> ((EmiRegistry)reg).addRecipe(arg_0));
        BwtEmiPlugin.getRecipes(reg, BwtRecipes.STOKED_CRUCIBLE_RECIPE_TYPE).stream().map(recipeEntry -> new EmiCookingPotRecipe(((AbstractCookingPotRecipe)recipeEntry.comp_1933()).getCategory().equals((Object)AbstractCookingPotRecipe.CookingPotRecipeCategory.RECLAIM) ? STOKED_CRUCIBLE_RECLAIM : STOKED_CRUCIBLE, recipeEntry)).forEach(arg_0 -> ((EmiRegistry)reg).addRecipe(arg_0));
        BwtEmiPlugin.getRecipes(reg, BwtRecipes.MILL_STONE_RECIPE_TYPE).stream().map(recipeEntry -> new EmiMillstoneRecipe(MILL_STONE, (class_8786<MillStoneRecipe>)recipeEntry)).forEach(arg_0 -> ((EmiRegistry)reg).addRecipe(arg_0));
        BwtEmiPlugin.getRecipes(reg, BwtRecipes.SAW_RECIPE_TYPE).stream().map(recipeEntry -> new EmiSawRecipe(SAW, (class_8786<SawRecipe>)recipeEntry)).forEach(arg_0 -> ((EmiRegistry)reg).addRecipe(arg_0));
        BwtEmiPlugin.getRecipes(reg, BwtRecipes.TURNTABLE_RECIPE_TYPE).stream().map(recipeEntry -> new EmiTurntableRecipe(TURNTABLE, (class_8786<TurntableRecipe>)recipeEntry)).forEach(arg_0 -> ((EmiRegistry)reg).addRecipe(arg_0));
        BwtEmiPlugin.getRecipes(reg, BwtRecipes.KILN_RECIPE_TYPE).stream().map(recipeEntry -> new EmiKilnRecipe(KILN, (class_8786<KilnRecipe>)recipeEntry)).forEach(arg_0 -> ((EmiRegistry)reg).addRecipe(arg_0));
        BwtEmiPlugin.getRecipes(reg, BwtRecipes.SOUL_FORGE_RECIPE_TYPE, c -> c != class_7710.field_40248).stream().sorted(Comparator.comparingInt(r -> ((SoulForgeRecipe)r.comp_1933()).method_45441().ordinal())).map(EmiSoulForgeRecipe::new).forEach(arg_0 -> ((EmiRegistry)reg).addRecipe(arg_0));
        BwtEmiPlugin.getRecipes(reg, BwtRecipes.SOUL_FORGE_RECIPE_TYPE, c -> c == class_7710.field_40248).stream().map(EmiSoulForgeRecipe::new).forEach(arg_0 -> ((EmiRegistry)reg).addRecipe(arg_0));
        List<class_8786<HopperFilterRecipe>> hopperFilterRecipes = BwtEmiPlugin.getRecipes(reg, BwtRecipes.HOPPER_FILTER_RECIPE_TYPE);
        List<class_8786<SoulBottlingRecipe>> soulBottlingRecipes = BwtEmiPlugin.getRecipes(reg, BwtRecipes.SOUL_BOTTLING_RECIPE_TYPE);
        Stream<class_8786> hopperFilterRecipesNoSouls = hopperFilterRecipes.stream().filter(r -> ((HopperFilterRecipe)r.comp_1933()).soulCount() == 0);
        hopperFilterRecipesNoSouls.map(r -> new EmiHopperFilterRecipe(HOPPER_FILTERING, (class_8786<HopperFilterRecipe>)r)).forEach(arg_0 -> ((EmiRegistry)reg).addRecipe(arg_0));
        hopperFilterRecipes.stream().filter(r -> ((HopperFilterRecipe)r.comp_1933()).soulCount() >= 1).forEach(hopperFilterRecipeEntry -> {
            reg.addRecipe((EmiRecipe)new EmiHopperFilterRecipe(HOPPER_SOULS, (class_8786<HopperFilterRecipe>)hopperFilterRecipeEntry));
            soulBottlingRecipes.stream().map(soulBottleRecipeEntry -> new EmiHopperFilterRecipe(HOPPER_SOULS, (class_8786<HopperFilterRecipe>)hopperFilterRecipeEntry).withSoulBottlingRecipe((class_8786<SoulBottlingRecipe>)soulBottleRecipeEntry)).forEach(arg_0 -> ((EmiRegistry)reg).addRecipe(arg_0));
        });
        MechHopperBlock.filterMap.forEach((filter, permitted) -> {
            if (permitted instanceof MechHopperBlock.TagFilter) {
                MechHopperBlock.TagFilter f = (MechHopperBlock.TagFilter)permitted;
                EmiIngredient emiPermitted = EmiIngredient.of(f.tagKey());
                class_2960 id = Id.of(class_7923.field_41178.method_10221(filter).method_12832() + "_hopper_filter");
                reg.addRecipe((EmiRecipe)new EmiHopperFilterPermitList(id, (EmiIngredient)EmiStack.of((class_1935)filter), emiPermitted));
            }
        });
    }

    public static EmiIngredient from(IngredientWithCount ingredientWithCount) {
        return EmiIngredient.of((class_1856)ingredientWithCount.ingredient(), (long)ingredientWithCount.count());
    }

    public static EmiIngredient from(BlockIngredient blockIngredient) {
        ArrayList ingredientList = new ArrayList();
        blockIngredient.optionalBlock().map(EmiStack::of).ifPresent(ingredientList::add);
        blockIngredient.optionalBlockTagKey().map(EmiIngredient::of).ifPresent(ingredientList::add);
        return EmiIngredient.of(ingredientList);
    }
}

