/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.emi.recipes;

import com.bwt.blocks.BwtBlocks;
import com.bwt.emi.BwtEmiPlugin;
import com.bwt.emi.recipes.EmiSoulBottlingRecipe;
import com.bwt.recipes.hopper_filter.HopperFilterRecipe;
import com.bwt.recipes.soul_bottling.SoulBottlingRecipe;
import com.bwt.utils.Id;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class EmiHopperFilterRecipe
implements EmiRecipe {
    public static final EmiTexture EMPTY_GEAR = new EmiTexture(BwtEmiPlugin.WIDGETS, 0, 0, 14, 14);
    public static final EmiTexture FULL_GEAR = new EmiTexture(BwtEmiPlugin.WIDGETS, 14, 0, 14, 14);
    public static final EmiTexture ARROW = new EmiTexture(BwtEmiPlugin.WIDGETS, 28, 0, 22, 15);
    public static final class_2960 BACKGROUND = Id.of("textures/gui/container/hopper_recipe.png");
    private final class_2960 id;
    protected final EmiRecipeCategory category;
    protected final EmiIngredient ingredient;
    protected final EmiIngredient filter;
    protected final int soulCount;
    protected final EmiStack result;
    protected final EmiStack byproduct;
    protected EmiSoulBottlingRecipe soulBottlingRecipe;

    public EmiHopperFilterRecipe(EmiRecipeCategory category, class_8786<HopperFilterRecipe> recipeEntry) {
        this(category, recipeEntry.comp_1932(), (HopperFilterRecipe)recipeEntry.comp_1933());
    }

    public EmiHopperFilterRecipe(EmiRecipeCategory category, class_2960 id, HopperFilterRecipe recipe) {
        this(category, id, EmiIngredient.of((class_1856)recipe.ingredient()), EmiIngredient.of((class_1856)recipe.filter()), recipe.soulCount(), EmiStack.of((class_1799)recipe.result()), EmiStack.of((class_1799)recipe.byproduct()));
    }

    public EmiHopperFilterRecipe(EmiRecipeCategory category, class_2960 id, EmiIngredient ingredient, EmiIngredient filter, int soulCount, EmiStack result, EmiStack byproduct) {
        this.category = category;
        this.id = id;
        this.ingredient = ingredient;
        this.filter = filter;
        this.soulCount = soulCount;
        this.result = result;
        this.byproduct = byproduct;
        this.soulBottlingRecipe = null;
    }

    public EmiHopperFilterRecipe withSoulBottlingRecipe(class_2960 id, SoulBottlingRecipe recipe) {
        this.soulBottlingRecipe = new EmiSoulBottlingRecipe(id, recipe);
        return this;
    }

    public EmiHopperFilterRecipe withSoulBottlingRecipe(class_8786<SoulBottlingRecipe> recipeEntry) {
        return this.withSoulBottlingRecipe(recipeEntry.comp_1932(), (SoulBottlingRecipe)recipeEntry.comp_1933());
    }

    public EmiRecipeCategory getCategory() {
        return this.category;
    }

    @Nullable
    public class_2960 getId() {
        if (this.soulBottlingRecipe != null) {
            return Id.of(String.format("/%s-%s", this.id.method_12832(), this.soulBottlingRecipe.getId().method_12832()));
        }
        return class_2960.method_60655((String)this.id.method_12836(), (String)("/" + this.id.method_12832()));
    }

    public List<EmiIngredient> getInputs() {
        ArrayList<EmiIngredient> list = new ArrayList<EmiIngredient>(List.of(this.ingredient));
        if (this.soulBottlingRecipe != null) {
            list.addAll(this.soulBottlingRecipe.getInputs());
        }
        return list;
    }

    public List<EmiStack> getOutputs() {
        ArrayList<EmiStack> list = new ArrayList<EmiStack>(List.of(this.result, this.byproduct));
        if (this.soulBottlingRecipe != null) {
            list.addAll(this.soulBottlingRecipe.getOutputs());
        }
        return list;
    }

    public int getDisplayWidth() {
        return 90;
    }

    public int getDisplayHeight() {
        return 72;
    }

    public EmiIngredient getIngredient() {
        if (this.soulBottlingRecipe != null) {
            int createdSoulCount = this.soulCount;
            int requiredSoulCount = this.soulBottlingRecipe.soulCount;
            long ingredientsRequired = (long)requiredSoulCount / (long)createdSoulCount;
            EmiIngredient copy = this.ingredient.copy().setAmount(ingredientsRequired);
            return copy;
        }
        return this.ingredient;
    }

    public EmiStack getByproduct() {
        if (this.soulBottlingRecipe != null && this.byproduct != null) {
            int createdSoulCount = this.soulCount;
            int requiredSoulCount = this.soulBottlingRecipe.soulCount;
            long byproductsCreated = (long)requiredSoulCount / (long)createdSoulCount;
            EmiStack copy = this.byproduct.copy().setAmount(byproductsCreated);
            return copy;
        }
        return this.byproduct;
    }

    public EmiStack getResult() {
        return this.result;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(BACKGROUND, 0, 0, 90, 72, 0, 0);
        widgets.addSlot(this.getIngredient(), 9, 0).drawBack(true).recipeContext((EmiRecipe)this);
        EmiStack byproduct = this.getByproduct();
        if (byproduct != null) {
            widgets.addSlot((EmiIngredient)byproduct, 63, 0).drawBack(true).recipeContext((EmiRecipe)this);
        }
        widgets.addSlot(this.filter, 36, 18).drawBack(false).recipeContext((EmiRecipe)this);
        widgets.addSlot((EmiIngredient)EmiStack.of((class_1935)BwtBlocks.hopperBlock), 36, 36).drawBack(false).recipeContext((EmiRecipe)this);
        EmiStack result = this.getResult();
        if (result != null && !result.isEmpty()) {
            widgets.addSlot((EmiIngredient)this.getResult(), 63, 36).drawBack(true).recipeContext((EmiRecipe)this);
            widgets.addTexture(BACKGROUND, 52, 38, 10, 13, 24, 72);
        }
        if (this.soulBottlingRecipe != null) {
            this.soulBottlingRecipe.addWidgets(widgets);
        }
    }
}

