/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.entities;

import com.bwt.damage_types.BwtDamageTypes;
import com.bwt.entities.BwtEntities;
import com.bwt.items.BwtItems;
import com.bwt.sounds.BwtSoundEvents;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import net.minecraft.class_1264;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1542;
import net.minecraft.class_1676;
import net.minecraft.class_173;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_3489;
import net.minecraft.class_3856;
import net.minecraft.class_39;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_8110;
import net.minecraft.class_8111;
import net.minecraft.class_8567;

public class DynamiteEntity
extends class_1676
implements class_3856 {
    public static final int TICKS_TO_DETONATE = 100;
    private static final class_2940<class_1799> ITEM = class_2945.method_12791(DynamiteEntity.class, (class_2941)class_2943.field_13322);
    public static class_2940<Integer> FUSE = class_2945.method_12791(DynamiteEntity.class, (class_2941)class_2943.field_13327);

    protected DynamiteEntity(class_1299<DynamiteEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public DynamiteEntity(double x, double y, double z, class_1937 world) {
        this(BwtEntities.dynamiteEntity, world);
        this.method_5814(x, y, z);
    }

    public DynamiteEntity(class_1937 world, class_1309 owner) {
        this(owner.method_23317(), owner.method_23320() - (double)0.1f, owner.method_23321(), world);
        this.method_7432((class_1297)owner);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(ITEM, (Object)class_1799.field_8037);
        builder.method_56912(FUSE, (Object)-1);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("fuse", this.getFuse());
        class_1799 itemStack = this.getItem();
        if (!itemStack.method_7960()) {
            nbt.method_10566("Item", itemStack.method_57358((class_7225.class_7874)this.method_56673()));
        }
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setFuse(nbt.method_10550("fuse"));
        if (nbt.method_10573("Item", 10)) {
            this.setItem(class_1799.method_57360((class_7225.class_7874)this.method_56673(), (class_2520)nbt.method_10562("Item")).orElseGet(() -> new class_1799((class_1935)this.getDefaultItem())));
        } else {
            this.setItem(new class_1799((class_1935)this.getDefaultItem()));
        }
    }

    public class_1799 method_7495() {
        class_1799 itemStack = this.getItem();
        return itemStack.method_7960() ? new class_1799((class_1935)this.getDefaultItem()) : itemStack;
    }

    protected class_1792 getDefaultItem() {
        return BwtItems.dynamiteItem;
    }

    public int getFuse() {
        return (Integer)this.field_6011.method_12789(FUSE);
    }

    public void setFuse(int value) {
        this.field_6011.method_12778(FUSE, (Object)value);
    }

    protected class_1799 getItem() {
        return (class_1799)this.method_5841().method_12789(ITEM);
    }

    public void setItem(class_1799 item) {
        this.method_5841().method_12778(ITEM, (Object)item.method_46651(1));
    }

    public void ignite() {
        this.field_6011.method_12778(FUSE, (Object)100);
        this.method_5783(BwtSoundEvents.DYNAMITE_IGNITE, 0.5f, 1.0f);
    }

    public boolean method_5753() {
        return true;
    }

    public boolean method_5640(double distance) {
        double d;
        double d2 = this.method_5829().method_995() * 4.0;
        if (Double.isNaN(d2)) {
            d2 = 4.0;
        }
        return distance < d * (d2 *= 64.0);
    }

    public void method_5773() {
        int fuse;
        super.method_5773();
        if (!this.method_5740()) {
            this.method_5762(0.0, -0.04, 0.0);
        }
        this.method_5784(class_1313.field_6308, this.method_18798());
        if (this.method_24828()) {
            this.method_18799(this.method_18798().method_18805(0.7, -0.5, 0.7));
        }
        if ((fuse = this.getFuse()) > 0) {
            this.setFuse(fuse - 1);
            --fuse;
            if (this.method_37908().field_9236) {
                this.method_37908().method_8406((class_2394)class_2398.field_11251, this.method_23317(), this.method_23318() + 0.5, this.method_23321(), this.method_18798().method_10216() * 0.1, this.method_18798().method_10214() * 0.1, this.method_18798().method_10215() * 0.1);
            }
        }
        if (fuse == 0) {
            this.method_31472();
            if (!this.method_37908().field_9236) {
                this.explode();
            }
            return;
        }
        if (fuse < 0) {
            if (this.method_5771()) {
                this.ignite();
                this.method_31472();
                if (!this.method_37908().field_9236) {
                    this.explode();
                }
                return;
            }
            if (this.method_24828() && this.method_18798().method_1033() < 0.01 && !this.method_37908().field_9236) {
                this.convertToItem();
                return;
            }
        }
    }

    public void explode() {
        this.method_37908().method_8437((class_1297)this, this.method_23317(), this.method_23323(0.0625), this.method_23321(), 1.5f, class_1937.class_7867.field_40891);
        if (this.method_5869()) {
            this.redneckFish();
        }
    }

    private void redneckFish() {
        for (int i = this.method_31477() - 2; i <= this.method_31477() + 2; ++i) {
            for (int j = this.method_31478() - 2; j <= this.method_31478() + 4; ++j) {
                for (int k = this.method_31479() - 2; k <= this.method_31479() + 2; ++k) {
                    class_2338 offsetPos = new class_2338(i, j, k);
                    if (!this.isValidBlockForRedneckFishing(offsetPos) || this.field_5974.method_43048(25) != 0) continue;
                    this.spawnRedneckFish(offsetPos);
                }
            }
        }
    }

    private boolean isValidBlockForRedneckFishing(class_2338 pos) {
        return Arrays.stream(class_2350.values()).filter(direction -> direction != class_2350.field_11036).map(arg_0 -> ((class_2338)pos).method_10093(arg_0)).map(offsetPos -> this.method_37908().method_8316(offsetPos)).allMatch(fluidState -> fluidState.method_15767(class_3486.field_15517));
    }

    private void spawnRedneckFish(class_2338 pos) {
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        class_8567 lootContextParameterSet = new class_8567.class_8568(serverWorld).method_51874(class_181.field_24424, (Object)this.method_19538()).method_51874(class_181.field_1226, (Object)this).method_51874(class_181.field_1231, (Object)BwtDamageTypes.of((class_1937)serverWorld, (class_5321<class_8110>)class_8111.field_42331)).method_51875(class_173.field_1173);
        class_52 lootTable = serverWorld.method_8503().method_58576().method_58295(class_39.field_795);
        ObjectArrayList list = lootTable.method_51878(lootContextParameterSet);
        if (list.isEmpty()) {
            return;
        }
        class_1799 itemStack = (class_1799)list.get(this.field_5974.method_43048(list.size()));
        if (!itemStack.method_31573(class_3489.field_15527)) {
            return;
        }
        class_1542 itemEntity = new class_1542((class_1937)serverWorld, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, itemStack);
        this.method_37908().method_8649((class_1297)itemEntity);
    }

    private void convertToItem() {
        class_1264.method_5449((class_1937)this.method_37908(), (double)this.method_23317(), (double)this.method_23318(), (double)this.method_23321(), (class_1799)this.method_7495());
        this.method_31472();
    }
}

