/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.entities;

import com.bwt.blocks.AxleBlock;
import com.bwt.blocks.BwtBlocks;
import com.bwt.blocks.GearBoxBlock;
import com.bwt.entities.BwtEntities;
import com.bwt.entities.HorizontalMechPowerSourceEntity;
import com.bwt.items.BwtItems;
import com.bwt.utils.rectangular_entity.EntityRectDimensions;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3481;

public class WindmillEntity
extends HorizontalMechPowerSourceEntity {
    public static final int NUM_SAILS = 4;
    public static final float height = 12.8f;
    public static final float width = 12.8f;
    public static final float length = 0.8f;
    private static final float rotationPerTick = -0.12f;
    private static final float rotationPerTickInStorm = -2.0f;
    private static final float rotationPerTickInNether = -0.07f;
    private static final int secondsInStormBeforeOverpower = 30;
    protected static final class_2940<Integer> dyeIndex = class_2945.method_12791(WindmillEntity.class, (class_2941)class_2943.field_13327);
    protected static final List<class_2940<Integer>> sailColors = IntStream.range(0, 4).mapToObj(i -> class_2945.method_12791(WindmillEntity.class, (class_2941)class_2943.field_13327)).collect(Collectors.toList());
    protected int overpowerTimer = 0;

    public WindmillEntity(class_1299<? extends WindmillEntity> entityType, class_1937 world) {
        super((class_1299<? extends HorizontalMechPowerSourceEntity>)entityType, world);
    }

    public WindmillEntity(class_1937 world, class_243 pos, class_2350 facing) {
        super(BwtEntities.windmillEntity, world, pos, facing);
    }

    @Override
    public EntityRectDimensions getRectDimensions() {
        return EntityRectDimensions.fixed(12.8f, 12.8f, 0.8f);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(dyeIndex, (Object)0);
        sailColors.forEach(bladeColor -> builder.method_56912(bladeColor, (Object)class_1767.field_7952.method_7789()));
    }

    public class_1767 getSailColor(int index) {
        return class_1767.method_7791((int)((Integer)this.field_6011.method_12789(sailColors.get(index))));
    }

    public void setSailColor(int index, class_1767 dyeColor) {
        this.field_6011.method_12778(sailColors.get(index), (Object)dyeColor.method_7789());
    }

    @Override
    public boolean tryToSpawn(class_1657 player) {
        return super.tryToSpawn(player, class_2561.method_30163((String)"Not enough room to place Wind Mill (They are friggin HUGE!)"), class_2561.method_30163((String)"Wind Mill placement is obstructed by something, or by you"));
    }

    public boolean method_5640(double distance) {
        double d = 128.0 * WindmillEntity.method_5824();
        return distance < d * d;
    }

    @Override
    public Predicate<class_2338> getBlockInterferencePredicate() {
        return blockPos -> !this.method_37908().method_8320(blockPos).method_26164(class_3481.field_51989);
    }

    @Override
    float getSpeedToPowerThreshold() {
        return 0.01f;
    }

    @Override
    public float computeRotation() {
        class_1937 world = this.method_37908();
        if (world.method_8597().comp_644()) {
            return -0.07f;
        }
        if (!world.method_8597().comp_645()) {
            return 0.0f;
        }
        if (!world.method_8311(this.method_24515())) {
            return 0.0f;
        }
        if (world.method_8419() && world.method_8546()) {
            return -2.0f;
        }
        return -0.12f;
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        class_1799 stackInHand = player.method_5998(hand);
        class_1792 class_17922 = stackInHand.method_7909();
        if (!(class_17922 instanceof class_1769)) {
            return super.method_5688(player, hand);
        }
        class_1769 dyeItem = (class_1769)class_17922;
        class_1767 dyeColor = dyeItem.method_7802();
        int dyeIdx = (Integer)this.method_5841().method_12789(dyeIndex);
        if (dyeColor.equals((Object)this.getSailColor(dyeIdx))) {
            this.method_5841().method_12778(dyeIndex, (Object)((dyeIdx + 1) % 4));
            return class_1269.field_5812;
        }
        this.setSailColor(dyeIdx, dyeColor);
        this.method_5841().method_12778(dyeIndex, (Object)((dyeIdx + 1) % 4));
        if (!player.method_31549().field_7477) {
            stackInHand.method_7934(1);
        }
        return class_1269.field_5812;
    }

    @Override
    protected void fullUpdate() {
        super.fullUpdate();
        if (Math.abs(this.getRotationSpeed()) < Math.abs(-2.0f)) {
            this.overpowerTimer = 0;
            return;
        }
        ++this.overpowerTimer;
        if (this.overpowerTimer >= 30) {
            this.breakConnectedGearBoxes();
        }
    }

    protected void breakConnectedGearBoxes() {
        class_2338 hostAxlePos = this.method_24515();
        class_2680 hostAxleState = this.method_37908().method_8320(hostAxlePos);
        if (!hostAxleState.method_27852(BwtBlocks.axleBlock) && !hostAxleState.method_27852(BwtBlocks.axlePowerSourceBlock)) {
            return;
        }
        class_2350.class_2351 hostAxleAxis = (class_2350.class_2351)hostAxleState.method_11654((class_2769)AxleBlock.field_11459);
        block0: for (class_2350.class_2352 axisDirection : class_2350.class_2352.values()) {
            for (int i = 1; i <= 4; ++i) {
                class_2350 direction = class_2350.method_10169((class_2350.class_2351)hostAxleAxis, (class_2350.class_2352)axisDirection);
                class_2338 connectedPos = hostAxlePos.method_10079(direction, i);
                class_2680 connectedState = this.method_37908().method_8320(connectedPos);
                class_2248 class_22482 = connectedState.method_26204();
                if (class_22482 instanceof GearBoxBlock) {
                    GearBoxBlock gearBoxBlock = (GearBoxBlock)class_22482;
                    if (((class_2350)connectedState.method_11654((class_2769)GearBoxBlock.field_10927)).equals((Object)direction.method_10153()) && gearBoxBlock.isMechPowered(connectedState)) {
                        GearBoxBlock.breakGearBox(this.method_37908(), connectedPos);
                        continue block0;
                    }
                }
                if (!connectedState.method_27852(BwtBlocks.axleBlock) && !connectedState.method_27852(BwtBlocks.axlePowerSourceBlock) || !((class_2350.class_2351)connectedState.method_11654((class_2769)AxleBlock.field_11459)).equals((Object)hostAxleAxis)) continue block0;
            }
        }
    }

    @Override
    protected void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("dyeIndex", ((Integer)this.field_6011.method_12789(dyeIndex)).intValue());
        for (int i = 0; i < 4; ++i) {
            nbt.method_10569("sail" + i + "Color", ((Integer)this.field_6011.method_12789(sailColors.get(i))).intValue());
        }
        nbt.method_10569("overpowerTimer", this.overpowerTimer);
    }

    @Override
    protected void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.field_6011.method_12778(dyeIndex, (Object)nbt.method_10550("dyeIndex"));
        for (int i = 0; i < 4; ++i) {
            if (!nbt.method_10573("sail" + i + "Color", 3)) continue;
            this.field_6011.method_12778(sailColors.get(i), (Object)nbt.method_10550("sail" + i + "Color"));
        }
        this.overpowerTimer = nbt.method_10550("overpowerTimer");
    }

    public class_1799 method_31480() {
        return new class_1799((class_1935)BwtItems.windmillItem);
    }
}

