/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.generation;

import com.bwt.blocks.BwtBlocks;
import com.bwt.blocks.ColumnBlock;
import com.bwt.blocks.CornerBlock;
import com.bwt.blocks.MouldingBlock;
import com.bwt.blocks.PedestalBlock;
import com.bwt.blocks.SidingBlock;
import com.bwt.blocks.TableBlock;
import com.bwt.blocks.VaseBlock;
import com.bwt.generation.EmiDefaultsGenerator;
import com.bwt.items.BwtItems;
import com.bwt.tags.BwtItemTags;
import com.bwt.utils.DyeUtils;
import com.bwt.utils.Id;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2446;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_5793;
import net.minecraft.class_5794;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7696;
import net.minecraft.class_7699;
import net.minecraft.class_7701;
import net.minecraft.class_7800;
import net.minecraft.class_7923;
import net.minecraft.class_8790;
import org.jetbrains.annotations.Nullable;

public class CraftingRecipeGenerator
extends FabricRecipeProvider {
    public CraftingRecipeGenerator(FabricDataOutput generator, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(generator, registryLookup);
    }

    public void method_10419(class_8790 exporter) {
        this.generateCraftingRecipes(exporter);
        this.generateHighEfficiencyRecipes(exporter);
    }

    public void generateCraftingRecipes(class_8790 exporter) {
        this.generateTier1Recipes(exporter);
        this.generateTier2Recipes(exporter);
        this.generateTier3Recipes(exporter);
        this.generateTier4Recipes(exporter);
        this.generateTier5Recipes(exporter);
        this.generateTier6Recipes(exporter);
        this.generateTier7Recipes(exporter);
        this.generateVaseDyeingRecipes(exporter);
        this.generateWoolSlabRecipes(exporter);
        this.generateDungDyeingRecipes(exporter);
        this.generateCompactingRecipes(exporter);
        this.generateBloodWoodRecipes(exporter);
        class_2447.method_10436((class_7800)class_7800.field_40636, (class_1935)BwtBlocks.stoneDetectorRailBlock, (int)6).method_10439("i i").method_10439("ipi").method_10439("iri").method_10434(Character.valueOf('i'), (class_1935)class_1802.field_8620).method_10434(Character.valueOf('p'), (class_1935)class_1802.field_8667).method_10434(Character.valueOf('r'), (class_1935)class_1802.field_8725).method_10429(CraftingRecipeGenerator.method_32807((class_1935)class_1802.field_8667), CraftingRecipeGenerator.method_10426((class_1935)class_1802.field_8667)).method_10431(exporter);
        class_2447.method_10436((class_7800)class_7800.field_40636, (class_1935)BwtBlocks.obsidianDetectorRailBlock, (int)6).method_10439("i i").method_10439("ipi").method_10439("iri").method_10434(Character.valueOf('i'), (class_1935)class_1802.field_8620).method_10434(Character.valueOf('p'), (class_1935)BwtBlocks.obsidianPressurePlateBlock).method_10434(Character.valueOf('r'), (class_1935)class_1802.field_8725).method_10429(CraftingRecipeGenerator.method_32807((class_1935)BwtBlocks.obsidianPressurePlateBlock), CraftingRecipeGenerator.method_10426((class_1935)BwtBlocks.obsidianPressurePlateBlock)).method_10431(exporter);
        class_2447.method_10437((class_7800)class_7800.field_40635, (class_1935)BwtBlocks.vineTrapBlock).method_10439("vvv").method_10434(Character.valueOf('v'), (class_1935)class_1802.field_17523).method_10429(CraftingRecipeGenerator.method_32807((class_1935)class_1802.field_17523), CraftingRecipeGenerator.method_10426((class_1935)class_1802.field_17523)).method_10431(exporter);
        CraftingRecipeGenerator.offer2x1SlabRecipes(exporter, class_7800.field_40634, (class_1935)class_2246.field_10566, (class_1935)BwtBlocks.dirtSlabBlock, "dirt");
        CraftingRecipeGenerator.offer2x1SlabRecipes(exporter, class_7800.field_40634, (class_1935)class_2246.field_10219, (class_1935)BwtBlocks.grassSlabBlock, "grass");
        CraftingRecipeGenerator.offer2x1SlabRecipes(exporter, class_7800.field_40634, (class_1935)class_2246.field_10402, (class_1935)BwtBlocks.myceliumSlabBlock, "mycelium");
        CraftingRecipeGenerator.offer2x1SlabRecipes(exporter, class_7800.field_40634, (class_1935)class_2246.field_10520, (class_1935)BwtBlocks.podzolSlabBlock, "podzol");
    }

    private void generateBloodWoodRecipes(class_8790 exporter) {
        CraftingRecipeGenerator.method_33535((class_8790)exporter, (class_5794)BwtBlocks.bloodWoodBlocks.blockFamily, (class_7699)class_7699.method_45398((class_7696)class_7701.field_40177));
        CraftingRecipeGenerator.method_24475((class_8790)exporter, (class_1935)BwtBlocks.bloodWoodBlocks.planksBlock, BwtItemTags.BLOOD_WOOD_LOGS, (int)4);
        CraftingRecipeGenerator.method_24476((class_8790)exporter, (class_1935)BwtBlocks.bloodWoodBlocks.woodBlock, (class_1935)BwtBlocks.bloodWoodBlocks.logBlock);
        CraftingRecipeGenerator.method_24476((class_8790)exporter, (class_1935)BwtBlocks.bloodWoodBlocks.strippedWoodBlock, (class_1935)BwtBlocks.bloodWoodBlocks.strippedLogBlock);
    }

    private void generateCompactingRecipes(class_8790 exporter) {
        CraftingRecipeGenerator.method_36449((class_8790)exporter, (class_7800)class_7800.field_40642, (class_1935)BwtItems.soapItem, (class_7800)class_7800.field_40635, (class_1935)BwtBlocks.soapBlock, (String)"soap_from_block", (String)"soap");
        CraftingRecipeGenerator.method_36449((class_8790)exporter, (class_7800)class_7800.field_40642, (class_1935)BwtItems.dungItem, (class_7800)class_7800.field_40635, (class_1935)BwtBlocks.dungBlock, (String)"dung_from_block", (String)"dung");
        CraftingRecipeGenerator.method_36449((class_8790)exporter, (class_7800)class_7800.field_40642, (class_1935)BwtItems.concentratedHellfireItem, (class_7800)class_7800.field_40635, (class_1935)BwtBlocks.concentratedHellfireBlock, (String)"concentrated_hellfire_from_block", (String)"concentrated_hellfire");
        CraftingRecipeGenerator.method_36449((class_8790)exporter, (class_7800)class_7800.field_40642, (class_1935)BwtItems.paddingItem, (class_7800)class_7800.field_40635, (class_1935)BwtBlocks.paddingBlock, (String)"padding_from_block", (String)"padding");
        CraftingRecipeGenerator.method_36449((class_8790)exporter, (class_7800)class_7800.field_40642, (class_1935)BwtItems.ropeItem, (class_7800)class_7800.field_40635, (class_1935)BwtBlocks.ropeCoilBlock, (String)"rope_from_block", (String)"rope");
        CraftingRecipeGenerator.offer2x2BlockSlabFamily(exporter, (class_1935)BwtBlocks.wickerPaneBlock, (class_1935)BwtBlocks.wickerBlock, (class_1935)BwtBlocks.wickerSlabBlock, "wicker");
    }

    public static void offerCompacting2x2(class_8790 exporter, class_1935 inputItem, class_1935 outputBlock, class_7800 category, @Nullable String group, @Nullable String recipeId) {
        class_2447.method_10437((class_7800)category, (class_1935)outputBlock).method_10434(Character.valueOf('#'), inputItem).method_10439("##").method_10439("##").method_10429(CraftingRecipeGenerator.method_32807((class_1935)inputItem), CraftingRecipeGenerator.method_10426((class_1935)inputItem)).method_10435(group).method_17972(exporter, recipeId != null ? Id.of(recipeId) : Id.of(class_2446.method_36450((class_1935)outputBlock)));
    }

    public static void offerUncompacting2x2(class_8790 exporter, class_1935 inputBlock, class_1935 outputItem, class_7800 category, @Nullable String group, @Nullable String recipeId) {
        class_2450.method_10448((class_7800)category, (class_1935)outputItem, (int)4).method_10454(inputBlock).method_10452(group).method_10442(CraftingRecipeGenerator.method_32807((class_1935)inputBlock), CraftingRecipeGenerator.method_10426((class_1935)inputBlock)).method_17972(exporter, recipeId != null ? Id.of(recipeId) : Id.of(class_2446.method_36450((class_1935)outputItem)));
    }

    public static void offer2x1SlabCreating(class_8790 exporter, class_1935 inputBlock, class_1935 outputSlab, class_7800 category, @Nullable String group, @Nullable String recipeId) {
        class_2447.method_10436((class_7800)category, (class_1935)outputSlab, (int)4).method_10434(Character.valueOf('#'), inputBlock).method_10439("##").method_10429(CraftingRecipeGenerator.method_32807((class_1935)inputBlock), CraftingRecipeGenerator.method_10426((class_1935)inputBlock)).method_10435(group).method_17972(exporter, recipeId != null ? Id.of(recipeId) : Id.of(class_2446.method_36450((class_1935)outputSlab)));
    }

    public static void offer2x1SlabRecombining(class_8790 exporter, class_1935 inputSlab, class_1935 outputBlock, class_7800 category, @Nullable String group, @Nullable String recipeId) {
        class_2447.method_10437((class_7800)category, (class_1935)outputBlock).method_10434(Character.valueOf('#'), inputSlab).method_10439("#").method_10439("#").method_10429(CraftingRecipeGenerator.method_32807((class_1935)inputSlab), CraftingRecipeGenerator.method_10426((class_1935)inputSlab)).method_10435(group).method_17972(exporter, recipeId != null ? Id.of(recipeId) : Id.of(class_2446.method_36450((class_1935)outputBlock)));
    }

    public static void offer2x1SlabUncompacting(class_8790 exporter, class_1935 inputSlab, class_1935 outputItem, class_7800 category, @Nullable String group, @Nullable String recipeId) {
        class_2450.method_10448((class_7800)category, (class_1935)outputItem, (int)2).method_10454(inputSlab).method_10452(group).method_10442(CraftingRecipeGenerator.method_32807((class_1935)inputSlab), CraftingRecipeGenerator.method_10426((class_1935)inputSlab)).method_17972(exporter, recipeId != null ? Id.of(recipeId) : Id.of(class_2446.method_36450((class_1935)outputItem)));
    }

    public static void offer2x1SlabRecipes(class_8790 exporter, class_7800 category, class_1935 block, class_1935 slab, String itemGroup) {
        CraftingRecipeGenerator.offer2x1SlabCreating(exporter, block, slab, category, itemGroup + "_slab", itemGroup + "_slab_from_block");
        CraftingRecipeGenerator.offer2x1SlabRecombining(exporter, slab, block, category, itemGroup + "_block", itemGroup + "_block_from_slab");
    }

    public static void offer2x2BlockSlabFamily(class_8790 exporter, class_1935 baseItem, class_1935 block, class_1935 slab, String itemGroup) {
        CraftingRecipeGenerator.offerCompacting2x2(exporter, baseItem, block, class_7800.field_40635, itemGroup + "_block", null);
        CraftingRecipeGenerator.offerUncompacting2x2(exporter, block, baseItem, class_7800.field_40642, itemGroup, itemGroup + "_from_block");
        CraftingRecipeGenerator.offer2x1SlabRecipes(exporter, class_7800.field_40635, block, slab, itemGroup);
        CraftingRecipeGenerator.offer2x1SlabUncompacting(exporter, slab, baseItem, class_7800.field_40642, itemGroup, itemGroup + "_from_slab");
    }

    private void generateDungDyeingRecipes(class_8790 exporter) {
        class_1769 dung = BwtItems.dungItem;
        VaseBlock brownVase = BwtBlocks.vaseBlocks.get(BwtItems.dungItem.method_7802());
        class_2248 brownBed = class_2246.field_10288;
        class_2248 brownWool = class_2246.field_10113;
        class_2248 brownCarpet = class_2246.field_10473;
        class_2248 brownTerracotta = class_2246.field_10123;
        class_2248 brownConcretePowder = class_2246.field_10023;
        class_2248 brownStainedGlass = class_2246.field_10073;
        class_2248 brownStainedGlassPane = class_2246.field_10163;
        class_2248 brownCandle = class_2246.field_27112;
        class_2450.method_10447((class_7800)class_7800.field_40635, (class_1935)brownVase).method_10454((class_1935)dung).method_10451(class_1856.method_26964(DyeUtils.streamColorItemsSorted(BwtBlocks.vaseBlocks).filter(dyeable -> !((Object)dyeable).equals((Object)brownVase)).map(class_1799::new))).method_10452("vases").method_10442("has_needed_dye", class_2446.method_10426((class_1935)dung)).method_17972(exporter, Id.of("dye_" + class_2446.method_33716((class_1935)brownVase) + "_from_dung"));
        class_2450.method_10447((class_7800)class_7800.field_40635, (class_1935)brownCandle).method_10454((class_1935)class_2246.field_27099).method_10454((class_1935)dung).method_10452("dyed_candle").method_10442(class_2446.method_32807((class_1935)dung), class_2446.method_10426((class_1935)dung)).method_36443(exporter, String.valueOf(class_5797.method_36442((class_1935)class_2246.field_27112)) + "_from_dung");
        class_2450.method_10447((class_7800)class_7800.field_40634, (class_1935)brownBed).method_10454((class_1935)dung).method_10451(class_1856.method_26964(Stream.of(class_1802.field_8112, class_1802.field_8893, class_1802.field_8390, class_1802.field_8754, class_1802.field_8368, class_1802.field_8286, class_1802.field_8146, class_1802.field_8679, class_1802.field_8349, class_1802.field_8059, class_1802.field_8417, class_1802.field_8262, class_1802.field_8789, class_1802.field_8863, class_1802.field_8258).map(class_1799::new))).method_10452("bed").method_10442(class_2446.method_32807((class_1935)dung), class_2446.method_10426((class_1935)dung)).method_17972(exporter, Id.of("dye_" + class_2446.method_33716((class_1935)brownBed) + "_from_dung"));
        class_2450.method_10447((class_7800)class_7800.field_40634, (class_1935)brownWool).method_10454((class_1935)dung).method_10451(class_1856.method_26964(Stream.of(class_1802.field_19059, class_1802.field_19055, class_1802.field_19053, class_1802.field_19051, class_1802.field_19057, class_1802.field_19047, class_1802.field_19052, class_1802.field_19049, class_1802.field_19046, class_1802.field_19045, class_1802.field_19050, class_1802.field_19054, class_1802.field_19058, class_1802.field_19048, class_1802.field_19044).map(class_1799::new))).method_10452("wool").method_10442(class_2446.method_32807((class_1935)dung), class_2446.method_10426((class_1935)dung)).method_17972(exporter, Id.of("dye_" + class_2446.method_33716((class_1935)brownWool) + "_from_dung"));
        class_2450.method_10447((class_7800)class_7800.field_40634, (class_1935)brownCarpet).method_10454((class_1935)dung).method_10451(class_1856.method_26964(Stream.of(class_1802.field_8611, class_1802.field_8115, class_1802.field_8290, class_1802.field_8875, class_1802.field_8664, class_1802.field_8078, class_1802.field_8654, class_1802.field_8253, class_1802.field_8384, class_1802.field_8683, class_1802.field_8580, class_1802.field_8098, class_1802.field_8482, class_1802.field_8142, class_1802.field_8850).map(class_1799::new))).method_10452("carpet").method_10442(class_2446.method_32807((class_1935)dung), class_2446.method_10426((class_1935)dung)).method_17972(exporter, Id.of("dye_" + class_2446.method_33716((class_1935)brownCarpet) + "_from_dung"));
        class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)brownTerracotta, (int)8).method_10434(Character.valueOf('#'), (class_1935)class_2246.field_10415).method_10434(Character.valueOf('X'), (class_1935)dung).method_10439("###").method_10439("#X#").method_10439("###").method_10435("stained_terracotta").method_10429("has_terracotta", CraftingRecipeGenerator.method_10426((class_1935)class_2246.field_10415)).method_10429(CraftingRecipeGenerator.method_32807((class_1935)dung), CraftingRecipeGenerator.method_10426((class_1935)dung)).method_17972(exporter, Id.of("dye_" + CraftingRecipeGenerator.method_33716((class_1935)brownTerracotta) + "_from_dung"));
        class_2450.method_10448((class_7800)class_7800.field_40634, (class_1935)brownConcretePowder, (int)8).method_10454((class_1935)dung).method_10449((class_1935)class_2246.field_10102, 4).method_10449((class_1935)class_2246.field_10255, 4).method_10452("concrete_powder").method_10442("has_sand", CraftingRecipeGenerator.method_10426((class_1935)class_2246.field_10102)).method_10442("has_gravel", CraftingRecipeGenerator.method_10426((class_1935)class_2246.field_10255)).method_10442(CraftingRecipeGenerator.method_32807((class_1935)dung), CraftingRecipeGenerator.method_10426((class_1935)dung)).method_17972(exporter, Id.of("dye_" + CraftingRecipeGenerator.method_33716((class_1935)brownConcretePowder) + "_from_dung"));
        class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)brownStainedGlass, (int)8).method_10434(Character.valueOf('#'), (class_1935)class_2246.field_10033).method_10434(Character.valueOf('X'), (class_1935)dung).method_10439("###").method_10439("#X#").method_10439("###").method_10435("stained_glass").method_10429("has_glass", CraftingRecipeGenerator.method_10426((class_1935)class_2246.field_10033)).method_10429(CraftingRecipeGenerator.method_32807((class_1935)dung), CraftingRecipeGenerator.method_10426((class_1935)dung)).method_17972(exporter, Id.of("dye_" + CraftingRecipeGenerator.method_33716((class_1935)brownStainedGlass) + "_from_dung"));
        class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)brownStainedGlassPane, (int)8).method_10434(Character.valueOf('#'), (class_1935)class_2246.field_10285).method_10434(Character.valueOf('$'), (class_1935)dung).method_10439("###").method_10439("#$#").method_10439("###").method_10435("stained_glass_pane").method_10429("has_glass_pane", CraftingRecipeGenerator.method_10426((class_1935)class_2246.field_10285)).method_10429(CraftingRecipeGenerator.method_32807((class_1935)dung), CraftingRecipeGenerator.method_10426((class_1935)dung)).method_17972(exporter, Id.of("dye_" + CraftingRecipeGenerator.method_33716((class_1935)brownStainedGlassPane) + "_from_dung"));
    }

    private void generateVaseDyeingRecipes(class_8790 exporter) {
        List<class_1769> dyes = List.copyOf(DyeUtils.DYE_COLORS_ORDERED.stream().map(class_1769::method_7803).toList());
        List<class_1792> vases = DyeUtils.streamColorItemsSorted(BwtBlocks.vaseBlocks).map(class_2248::method_8389).toList();
        CraftingRecipeGenerator.method_51890((class_8790)exporter, dyes, vases, (String)"vases");
    }

    private void generateWoolSlabRecipes(class_8790 exporter) {
        List<class_1769> dyes = List.copyOf(DyeUtils.DYE_COLORS_ORDERED.stream().map(class_1769::method_7803).toList());
        List<class_1792> woolSlabs = DyeUtils.streamColorItemsSorted(BwtBlocks.woolSlabBlocks).map(class_2248::method_8389).toList();
        CraftingRecipeGenerator.method_51890((class_8790)exporter, dyes, woolSlabs, (String)"wool_slabs");
        BwtBlocks.woolSlabBlocks.forEach((dyeColor, woolSlab) -> {
            class_1792 woolBlockItem = DyeUtils.WOOL_COLORS.get(dyeColor).method_8389();
            CraftingRecipeGenerator.method_32804((class_7800)class_7800.field_40634, (class_1935)woolSlab, (class_1856)class_1856.method_8091((class_1935[])new class_1935[]{woolBlockItem})).method_33530(CraftingRecipeGenerator.method_32807((class_1935)woolBlockItem), CraftingRecipeGenerator.method_10426((class_1935)woolBlockItem)).method_33529("wool_slabs").method_10431(exporter);
            class_2450.method_10448((class_7800)class_7800.field_40634, (class_1935)woolBlockItem, (int)1).method_10449((class_1935)woolSlab, 2).method_10442(CraftingRecipeGenerator.method_32807((class_1935)woolSlab), CraftingRecipeGenerator.method_10426((class_1935)woolSlab)).method_10452("wool").method_17972(exporter, Id.of("recombine_" + class_7923.field_41175.method_10221(woolSlab).method_12832()));
        });
    }

    private void generateTier1Recipes(class_8790 exporter) {
        class_2447.method_10436((class_7800)class_7800.field_40642, (class_1935)BwtItems.gearItem, (int)2).method_10439(" s ").method_10439("sps").method_10439(" s ").method_10434(Character.valueOf('s'), (class_1935)class_1802.field_8600).method_10433(Character.valueOf('p'), class_3489.field_15537).method_10429(CraftingRecipeGenerator.method_32807((class_1935)class_1802.field_8600), CraftingRecipeGenerator.method_10426((class_1935)class_1802.field_8600)).method_10429("has_planks", CraftingRecipeGenerator.method_10420((class_6862)class_3489.field_15537)).method_10431(exporter);
        class_2447.method_10437((class_7800)class_7800.field_40642, (class_1935)BwtBlocks.handCrankBlock).method_10439("  s").method_10439(" s ").method_10439("cgc").method_10434(Character.valueOf('s'), (class_1935)class_1802.field_8600).method_10433(Character.valueOf('c'), class_3489.field_25808).method_10434(Character.valueOf('g'), (class_1935)BwtItems.gearItem).method_10429(CraftingRecipeGenerator.method_32807((class_1935)BwtItems.gearItem), CraftingRecipeGenerator.method_10426((class_1935)BwtItems.gearItem)).method_10431(exporter);
        class_2447.method_10437((class_7800)class_7800.field_40642, (class_1935)BwtBlocks.millStoneBlock).method_10439("sss").method_10439("sss").method_10439("sgs").method_10434(Character.valueOf('s'), (class_1935)class_1802.field_20391).method_10434(Character.valueOf('g'), (class_1935)BwtItems.gearItem).method_10429(CraftingRecipeGenerator.method_32807((class_1935)BwtItems.gearItem), CraftingRecipeGenerator.method_10426((class_1935)BwtItems.gearItem)).method_10431(exporter);
        class_2447.method_10437((class_7800)class_7800.field_40642, (class_1935)BwtBlocks.cauldronBlock).method_10439("ibi").method_10439("iwi").method_10439("iii").method_10434(Character.valueOf('i'), (class_1935)class_1802.field_8620).method_10434(Character.valueOf('b'), (class_1935)class_1802.field_8606).method_10434(Character.valueOf('w'), (class_1935)class_1802.field_8705).method_10429(CraftingRecipeGenerator.method_32807((class_1935)class_1802.field_8606), CraftingRecipeGenerator.method_10426((class_1935)class_1802.field_8606)).method_10431(exporter);
        class_2450.method_10447((class_7800)class_7800.field_40642, (class_1935)BwtBlocks.cauldronBlock).method_10454((class_1935)class_2246.field_10593).method_10454((class_1935)class_1802.field_8606).method_10454((class_1935)class_1802.field_8705).method_10442(CraftingRecipeGenerator.method_32807((class_1935)class_1802.field_8606), CraftingRecipeGenerator.method_10426((class_1935)class_1802.field_8606)).method_17972(exporter, Id.of("cauldron_from_vanilla"));
        class_2447.method_10437((class_7800)class_7800.field_40642, (class_1935)BwtBlocks.lightBlockBlock).method_10439(" p ").method_10439("pfp").method_10439(" r ").method_10433(Character.valueOf('p'), ConventionalItemTags.GLASS_PANES).method_10434(Character.valueOf('f'), (class_1935)BwtItems.filamentItem).method_10434(Character.valueOf('r'), (class_1935)class_1802.field_8725).method_10429(CraftingRecipeGenerator.method_32807((class_1935)BwtItems.filamentItem), CraftingRecipeGenerator.method_10426((class_1935)BwtItems.filamentItem)).method_10431(exporter);
        class_2447.method_10437((class_7800)class_7800.field_40642, (class_1935)BwtItems.fabricItem).method_10439("fff").method_10439("fff").method_10439("fff").method_10434(Character.valueOf('f'), (class_1935)BwtItems.hempFiberItem).method_10429(CraftingRecipeGenerator.method_32807((class_1935)BwtItems.hempFiberItem), CraftingRecipeGenerator.method_10426((class_1935)BwtItems.hempFiberItem)).method_10431(exporter);
        class_2447.method_10437((class_7800)class_7800.field_40642, (class_1935)BwtItems.sailItem).method_10439("fff").method_10439("fff").method_10439("ppp").method_10434(Character.valueOf('f'), (class_1935)BwtItems.fabricItem).method_10433(Character.valueOf('p'), class_3489.field_15537).method_10429(CraftingRecipeGenerator.method_32807((class_1935)BwtItems.fabricItem), CraftingRecipeGenerator.method_10426((class_1935)BwtItems.fabricItem)).method_10431(exporter);
        class_2447.method_10437((class_7800)class_7800.field_40642, (class_1935)BwtItems.windmillItem).method_10439(" s ").method_10439("s s").method_10439(" s ").method_10434(Character.valueOf('s'), (class_1935)BwtItems.sailItem).method_10429(CraftingRecipeGenerator.method_32807((class_1935)BwtItems.sailItem), CraftingRecipeGenerator.method_10426((class_1935)BwtItems.sailItem)).method_10431(exporter);
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)BwtBlocks.gearBoxBlock).method_10439("pgp").method_10439("g g").method_10439("pgp").method_10433(Character.valueOf('p'), class_3489.field_15537).method_10434(Character.valueOf('g'), (class_1935)BwtItems.gearItem).method_10435("gear_box").method_10429(CraftingRecipeGenerator.method_32807((class_1935)BwtItems.gearItem), CraftingRecipeGenerator.method_10426((class_1935)BwtItems.gearItem)).method_10431(exporter);
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)BwtBlocks.redstoneClutchBlock).method_10439("pgp").method_10439("grg").method_10439("pgp").method_10433(Character.valueOf('p'), class_3489.field_15537).method_10434(Character.valueOf('g'), (class_1935)BwtItems.gearItem).method_10434(Character.valueOf('r'), (class_1935)class_1802.field_8725).method_10435("redstone_clutch").method_10429(CraftingRecipeGenerator.method_32807((class_1935)BwtItems.gearItem), CraftingRecipeGenerator.method_10426((class_1935)BwtItems.gearItem)).method_10431(exporter);
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)BwtItems.ropeItem).method_10439("fff").method_10439("fff").method_10434(Character.valueOf('f'), (class_1935)BwtItems.hempFiberItem).method_10429(CraftingRecipeGenerator.method_32807((class_1935)BwtItems.hempFiberItem), CraftingRecipeGenerator.method_10426((class_1935)BwtItems.hempFiberItem)).method_10435("rope").method_10431(exporter);
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)BwtItems.ropeItem).method_10439("ff").method_10439("ff").method_10439("ff").method_10434(Character.valueOf('f'), (class_1935)BwtItems.hempFiberItem).method_10429(CraftingRecipeGenerator.method_32807((class_1935)BwtItems.hempFiberItem), CraftingRecipeGenerator.method_10426((class_1935)BwtItems.hempFiberItem)).method_10435("rope").method_17972(exporter, Id.of("rope_vertical"));
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)BwtBlocks.axleBlock).method_10439("prp").method_10433(Character.valueOf('p'), class_3489.field_15537).method_10434(Character.valueOf('r'), (class_1935)BwtItems.ropeItem).method_10429(CraftingRecipeGenerator.method_32807((class_1935)BwtItems.ropeItem), CraftingRecipeGenerator.method_10426((class_1935)BwtItems.ropeItem)).method_10431(exporter);
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)BwtBlocks.anchorBlock).method_10439(" i ").method_10439("sss").method_10434(Character.valueOf('i'), (class_1935)class_1802.field_8620).method_10434(Character.valueOf('s'), (class_1935)class_1802.field_20389).method_10429(CraftingRecipeGenerator.method_32807((class_1935)class_1802.field_20389), CraftingRecipeGenerator.method_10426((class_1935)class_1802.field_20389)).method_10431(exporter);
        class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)class_2246.field_10336, (int)4).method_10439("X").method_10439("S").method_10434(Character.valueOf('X'), (class_1935)BwtItems.nethercoalItem).method_10434(Character.valueOf('S'), (class_1935)class_1802.field_8600).method_10429("has_nether_coal", CraftingRecipeGenerator.method_10426((class_1935)BwtItems.nethercoalItem)).method_17972(exporter, Id.of("torch_from_nether_coal"));
        class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)class_2246.field_22092, (int)4).method_10439("X").method_10439("#").method_10439("S").method_10434(Character.valueOf('X'), (class_1935)BwtItems.nethercoalItem).method_10434(Character.valueOf('#'), (class_1935)class_1802.field_8600).method_10433(Character.valueOf('S'), class_3489.field_23801).method_10429("has_nether_coal", CraftingRecipeGenerator.method_10426((class_1935)BwtItems.nethercoalItem)).method_17972(exporter, Id.of("soul_torch_from_nether_coal"));
    }

    private void generateTier2Recipes(class_8790 exporter) {
        class_2450.method_10448((class_7800)class_7800.field_40642, (class_1935)BwtItems.strapItem, (int)8).method_10454((class_1935)BwtItems.tannedLeatherItem).method_10442(CraftingRecipeGenerator.method_32807((class_1935)BwtItems.tannedLeatherItem), CraftingRecipeGenerator.method_10426((class_1935)BwtItems.tannedLeatherItem)).method_10431(exporter);
        class_2447.method_10437((class_7800)class_7800.field_40642, (class_1935)BwtItems.beltItem).method_10439(" s ").method_10439("s s").method_10439(" s ").method_10434(Character.valueOf('s'), (class_1935)BwtItems.strapItem).method_10429(CraftingRecipeGenerator.method_32807((class_1935)BwtItems.strapItem), CraftingRecipeGenerator.method_10426((class_1935)BwtItems.strapItem)).method_10431(exporter);
        class_2447.method_10437((class_7800)class_7800.field_40642, (class_1935)BwtBlocks.sawBlock).method_10439("iii").method_10439("gbg").method_10439("pgp").method_10434(Character.valueOf('i'), (class_1935)class_1802.field_8620).method_10434(Character.valueOf('g'), (class_1935)BwtItems.gearItem).method_10433(Character.valueOf('p'), class_3489.field_15537).method_10434(Character.valueOf('b'), (class_1935)BwtItems.beltItem).method_10429(CraftingRecipeGenerator.method_32807((class_1935)BwtItems.beltItem), CraftingRecipeGenerator.method_10426((class_1935)BwtItems.beltItem)).method_10431(exporter);
        class_2447.method_10437((class_7800)class_7800.field_40642, (class_1935)BwtBlocks.grateBlock).method_10439("ss").method_10439("ss").method_10434(Character.valueOf('s'), (class_1935)class_1802.field_8600).method_10429(CraftingRecipeGenerator.method_32807((class_1935)class_1802.field_8600), CraftingRecipeGenerator.method_10426((class_1935)class_1802.field_8600)).method_10431(exporter);
        class_2447.method_10437((class_7800)class_7800.field_40642, (class_1935)BwtBlocks.wickerPaneBlock).method_10439("ss").method_10439("ss").method_10434(Character.valueOf('s'), (class_1935)class_1802.field_17531).method_10429(CraftingRecipeGenerator.method_32807((class_1935)class_1802.field_17531), CraftingRecipeGenerator.method_10426((class_1935)class_1802.field_17531)).method_10435("wicker").method_10431(exporter);
        class_2447.method_10437((class_7800)class_7800.field_40642, (class_1935)BwtBlocks.slatsBlock).method_10439("mm").method_10439("mm").method_10433(Character.valueOf('m'), BwtItemTags.WOODEN_MOULDING_BLOCKS).method_10429("has_wooden_moulding", CraftingRecipeGenerator.method_10420(BwtItemTags.WOODEN_MOULDING_BLOCKS)).method_10431(exporter);
        class_2447.method_10437((class_7800)class_7800.field_40642, (class_1935)BwtBlocks.pulleyBlock).method_10439("pip").method_10439("grg").method_10439("pip").method_10433(Character.valueOf('p'), class_3489.field_15537).method_10434(Character.valueOf('i'), (class_1935)class_1802.field_8620).method_10434(Character.valueOf('g'), (class_1935)BwtItems.gearItem).method_10434(Character.valueOf('r'), (class_1935)class_1802.field_8725).method_10429(CraftingRecipeGenerator.method_32807((class_1935)BwtItems.gearItem), CraftingRecipeGenerator.method_10426((class_1935)BwtItems.gearItem)).method_10431(exporter);
        class_2447.method_10437((class_7800)class_7800.field_40642, (class_1935)BwtBlocks.platformBlock).method_10439("pwp").method_10439(" p ").method_10439("pwp").method_10433(Character.valueOf('p'), class_3489.field_15537).method_10434(Character.valueOf('w'), (class_1935)BwtBlocks.wickerPaneBlock).method_10429(CraftingRecipeGenerator.method_32807((class_1935)BwtBlocks.wickerPaneBlock), CraftingRecipeGenerator.method_10426((class_1935)BwtBlocks.wickerPaneBlock)).method_10431(exporter);
    }

    private void generateTier3Recipes(class_8790 exporter) {
        for (int i = 0; i < BwtBlocks.sidingBlocks.size(); ++i) {
            SidingBlock sidingBlock = BwtBlocks.sidingBlocks.get(i);
            MouldingBlock mouldingBlock = BwtBlocks.mouldingBlocks.get(i);
            CornerBlock cornerBlock = BwtBlocks.cornerBlocks.get(i);
            ColumnBlock columnBlock = BwtBlocks.columnBlocks.get(i);
            PedestalBlock pedestalBlock = BwtBlocks.pedestalBlocks.get(i);
            TableBlock tableBlock = BwtBlocks.tableBlocks.get(i);
            if (!sidingBlock.isWood()) continue;
            class_2450.method_10447((class_7800)class_7800.field_40634, (class_1935)sidingBlock.fullBlock).method_10449((class_1935)sidingBlock, 2).method_10452("planks").method_10442(CraftingRecipeGenerator.method_32807((class_1935)sidingBlock), CraftingRecipeGenerator.method_10426((class_1935)sidingBlock)).method_17972(exporter, Id.of("recombine_" + class_7923.field_41175.method_10221((Object)sidingBlock).method_12832()));
            class_2450.method_10447((class_7800)class_7800.field_40634, (class_1935)sidingBlock).method_10449((class_1935)mouldingBlock, 2).method_10452("siding").method_10442(CraftingRecipeGenerator.method_32807((class_1935)mouldingBlock), CraftingRecipeGenerator.method_10426((class_1935)mouldingBlock)).method_17972(exporter, Id.of("recombine_" + class_7923.field_41175.method_10221((Object)mouldingBlock).method_12832()));
            class_2450.method_10447((class_7800)class_7800.field_40634, (class_1935)mouldingBlock).method_10449((class_1935)cornerBlock, 2).method_10452("moulding").method_10442(CraftingRecipeGenerator.method_32807((class_1935)sidingBlock), CraftingRecipeGenerator.method_10426((class_1935)sidingBlock)).method_17972(exporter, Id.of("recombine_" + class_7923.field_41175.method_10221((Object)cornerBlock).method_12832()));
            class_2447.method_10437((class_7800)class_7800.field_40634, (class_1935)columnBlock).method_10439("#").method_10439("#").method_10439("#").method_10434(Character.valueOf('#'), (class_1935)mouldingBlock).method_10435("column").method_10429(CraftingRecipeGenerator.method_32807((class_1935)mouldingBlock), CraftingRecipeGenerator.method_10426((class_1935)mouldingBlock)).method_10431(exporter);
            EmiDefaultsGenerator.addDefaultRecipe(new class_1935[]{columnBlock});
            class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)pedestalBlock, (int)6).method_10439(" s ").method_10439("###").method_10439("###").method_10434(Character.valueOf('#'), (class_1935)sidingBlock.fullBlock).method_10434(Character.valueOf('s'), (class_1935)sidingBlock).method_10435("pedestal").method_10429(CraftingRecipeGenerator.method_32807((class_1935)sidingBlock), CraftingRecipeGenerator.method_10426((class_1935)sidingBlock)).method_10431(exporter);
            EmiDefaultsGenerator.addDefaultRecipe(new class_1935[]{pedestalBlock});
            class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)tableBlock, (int)4).method_10439("sss").method_10439(" m ").method_10439(" m ").method_10434(Character.valueOf('s'), (class_1935)sidingBlock).method_10434(Character.valueOf('m'), (class_1935)mouldingBlock).method_10435("table").method_10429(CraftingRecipeGenerator.method_32807((class_1935)mouldingBlock), CraftingRecipeGenerator.method_10426((class_1935)mouldingBlock)).method_10431(exporter);
            EmiDefaultsGenerator.addDefaultRecipe(new class_1935[]{tableBlock});
        }
        class_2447.method_10437((class_7800)class_7800.field_40642, (class_1935)BwtBlocks.hopperBlock).method_10439("s s").method_10439("gpg").method_10439(" c ").method_10433(Character.valueOf('s'), BwtItemTags.WOODEN_SIDING_BLOCKS).method_10434(Character.valueOf('g'), (class_1935)BwtItems.gearItem).method_10433(Character.valueOf('p'), class_3489.field_15540).method_10433(Character.valueOf('c'), BwtItemTags.WOODEN_CORNER_BLOCKS).method_10429("has_wooden_corner", CraftingRecipeGenerator.method_10420(BwtItemTags.WOODEN_CORNER_BLOCKS)).method_36443(exporter, "mech_hopper");
        EmiDefaultsGenerator.addDefaultRecipe(new class_1935[]{BwtBlocks.hopperBlock});
    }

    private void generateTier4Recipes(class_8790 exporter) {
        class_2447.method_10437((class_7800)class_7800.field_40642, (class_1935)BwtBlocks.hibachiBlock).method_10439("hhh").method_10439("sfs").method_10439("srs").method_10434(Character.valueOf('h'), (class_1935)BwtItems.concentratedHellfireItem).method_10434(Character.valueOf('s'), (class_1935)class_1802.field_20391).method_10434(Character.valueOf('f'), (class_1935)BwtItems.filamentItem).method_10434(Character.valueOf('r'), (class_1935)class_1802.field_8725).method_10429(CraftingRecipeGenerator.method_32807((class_1935)BwtItems.filamentItem), CraftingRecipeGenerator.method_10426((class_1935)BwtItems.filamentItem)).method_10431(exporter);
        class_2447.method_10437((class_7800)class_7800.field_40642, (class_1935)BwtBlocks.bellowsBlock).method_10439("sss").method_10439("lll").method_10439("gbg").method_10433(Character.valueOf('s'), BwtItemTags.WOODEN_SIDING_BLOCKS).method_10434(Character.valueOf('l'), (class_1935)BwtItems.tannedLeatherItem).method_10434(Character.valueOf('g'), (class_1935)BwtItems.gearItem).method_10434(Character.valueOf('b'), (class_1935)BwtItems.beltItem).method_10429("has_wooden_siding", CraftingRecipeGenerator.method_10420(BwtItemTags.WOODEN_SIDING_BLOCKS)).method_10431(exporter);
    }

    private void generateTier5Recipes(class_8790 exporter) {
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)class_2246.field_10615).method_10439("G").method_10439("P").method_10434(Character.valueOf('G'), (class_1935)BwtItems.glueItem).method_10434(Character.valueOf('P'), (class_1935)class_2246.field_10560).method_10429(CraftingRecipeGenerator.method_32807((class_1935)BwtItems.glueItem), CraftingRecipeGenerator.method_10426((class_1935)BwtItems.glueItem)).method_36443(exporter, "glued_sticky_piston");
        class_2447.method_10437((class_7800)class_7800.field_40642, (class_1935)BwtItems.woodBladeItem).method_10439("s  ").method_10439("sgs").method_10439("s  ").method_10433(Character.valueOf('s'), BwtItemTags.WOODEN_SIDING_BLOCKS).method_10434(Character.valueOf('g'), (class_1935)BwtItems.glueItem).method_10429(CraftingRecipeGenerator.method_32807((class_1935)BwtItems.glueItem), CraftingRecipeGenerator.method_10426((class_1935)BwtItems.glueItem)).method_10431(exporter);
        class_2447.method_10437((class_7800)class_7800.field_40642, (class_1935)BwtItems.waterWheelItem).method_10439("bbb").method_10439("b b").method_10439("bbb").method_10434(Character.valueOf('b'), (class_1935)BwtItems.woodBladeItem).method_10429(CraftingRecipeGenerator.method_32807((class_1935)BwtItems.woodBladeItem), CraftingRecipeGenerator.method_10426((class_1935)BwtItems.woodBladeItem)).method_10431(exporter);
        class_2447.method_10437((class_7800)class_7800.field_40642, (class_1935)BwtBlocks.turntableBlock).method_10439("www").method_10439("srs").method_10439("sgs").method_10433(Character.valueOf('w'), BwtItemTags.WOODEN_SIDING_BLOCKS).method_10434(Character.valueOf('s'), (class_1935)class_1802.field_20391).method_10434(Character.valueOf('r'), (class_1935)class_1802.field_8725).method_10434(Character.valueOf('g'), (class_1935)BwtItems.gearItem).method_10429("has_wooden_siding", CraftingRecipeGenerator.method_10420(BwtItemTags.WOODEN_SIDING_BLOCKS)).method_10431(exporter);
        class_2447.method_10437((class_7800)class_7800.field_40642, (class_1935)BwtItems.dynamiteItem).method_10439("ph").method_10439("pt").method_10439("ps").method_10434(Character.valueOf('p'), (class_1935)class_1802.field_8407).method_10434(Character.valueOf('h'), (class_1935)BwtItems.hellfireDustItem).method_10434(Character.valueOf('t'), (class_1935)BwtItems.tallowItem).method_10433(Character.valueOf('s'), BwtItemTags.SAW_DUSTS).method_10429("has_tallow", CraftingRecipeGenerator.method_10426((class_1935)BwtItems.tallowItem)).method_10431(exporter);
        class_2447.method_10437((class_7800)class_7800.field_40642, (class_1935)BwtBlocks.miningChargeBlock).method_10439("rgr").method_10439("ddd").method_10439("ddd").method_10434(Character.valueOf('r'), (class_1935)BwtItems.ropeItem).method_10434(Character.valueOf('g'), (class_1935)BwtItems.glueItem).method_10434(Character.valueOf('d'), (class_1935)BwtItems.dynamiteItem).method_10429("has_dynamite", CraftingRecipeGenerator.method_10426((class_1935)BwtItems.dynamiteItem)).method_17972(exporter, Id.of("mining_charge_with_glue"));
        class_2447.method_10437((class_7800)class_7800.field_40642, (class_1935)BwtBlocks.miningChargeBlock).method_10439("rsr").method_10439("ddd").method_10439("ddd").method_10434(Character.valueOf('r'), (class_1935)BwtItems.ropeItem).method_10434(Character.valueOf('s'), (class_1935)class_1802.field_8777).method_10434(Character.valueOf('d'), (class_1935)BwtItems.dynamiteItem).method_10429("has_dynamite", CraftingRecipeGenerator.method_10426((class_1935)BwtItems.dynamiteItem)).method_17972(exporter, Id.of("mining_charge_with_slime"));
        class_2447.method_10437((class_7800)class_7800.field_40642, (class_1935)BwtBlocks.screwPumpBlock).method_10439("gGg").method_10439("sSs").method_10439("sXs").method_10434(Character.valueOf('g'), (class_1935)BwtItems.glueItem).method_10434(Character.valueOf('G'), (class_1935)BwtBlocks.grateBlock).method_10433(Character.valueOf('s'), BwtItemTags.WOODEN_SIDING_BLOCKS).method_10434(Character.valueOf('S'), (class_1935)BwtItems.screwItem).method_10434(Character.valueOf('X'), (class_1935)BwtItems.gearItem).method_10429(CraftingRecipeGenerator.method_32807((class_1935)BwtItems.screwItem), CraftingRecipeGenerator.method_10426((class_1935)BwtItems.screwItem)).method_10431(exporter);
    }

    private void generateTier6Recipes(class_8790 exporter) {
        class_2447.method_10437((class_7800)class_7800.field_40635, (class_1935)BwtBlocks.soilPlanterBlock).method_10439("d").method_10439("b").method_10439("p").method_10434(Character.valueOf('d'), (class_1935)class_1802.field_8831).method_10434(Character.valueOf('b'), (class_1935)class_1802.field_8324).method_10434(Character.valueOf('p'), (class_1935)BwtBlocks.planterBlock).method_10429(CraftingRecipeGenerator.method_32807((class_1935)BwtBlocks.planterBlock), CraftingRecipeGenerator.method_10426((class_1935)BwtBlocks.planterBlock)).method_10431(exporter);
        class_2447.method_10437((class_7800)class_7800.field_40635, (class_1935)BwtBlocks.soulSandPlanterBlock).method_10439("s").method_10439("p").method_10434(Character.valueOf('s'), (class_1935)class_1802.field_8067).method_10434(Character.valueOf('p'), (class_1935)BwtBlocks.planterBlock).method_10429(CraftingRecipeGenerator.method_32807((class_1935)BwtBlocks.planterBlock), CraftingRecipeGenerator.method_10426((class_1935)BwtBlocks.planterBlock)).method_10431(exporter);
        class_2447.method_10437((class_7800)class_7800.field_40635, (class_1935)BwtBlocks.grassPlanterBlock).method_10439("g").method_10439("b").method_10439("p").method_10434(Character.valueOf('g'), (class_1935)class_1802.field_8270).method_10434(Character.valueOf('b'), (class_1935)class_1802.field_8324).method_10434(Character.valueOf('p'), (class_1935)BwtBlocks.planterBlock).method_10429(CraftingRecipeGenerator.method_32807((class_1935)BwtBlocks.planterBlock), CraftingRecipeGenerator.method_10426((class_1935)BwtBlocks.planterBlock)).method_10431(exporter);
    }

    private void generateTier7Recipes(class_8790 exporter) {
        class_2447.method_10437((class_7800)class_7800.field_40642, (class_1935)BwtItems.haftItem).method_10439("s").method_10439("g").method_10439("m").method_10434(Character.valueOf('s'), (class_1935)BwtItems.strapItem).method_10434(Character.valueOf('g'), (class_1935)BwtItems.glueItem).method_10433(Character.valueOf('m'), BwtItemTags.WOODEN_MOULDING_BLOCKS).method_10429(CraftingRecipeGenerator.method_32807((class_1935)BwtItems.glueItem), CraftingRecipeGenerator.method_10426((class_1935)BwtItems.glueItem)).method_10431(exporter);
        class_2447.method_10437((class_7800)class_7800.field_40642, (class_1935)BwtItems.paddingItem).method_10439(" F ").method_10439("fff").method_10439(" F ").method_10434(Character.valueOf('F'), (class_1935)BwtItems.fabricItem).method_10434(Character.valueOf('f'), (class_1935)class_1802.field_8153).method_10429(CraftingRecipeGenerator.method_32807((class_1935)BwtItems.fabricItem), CraftingRecipeGenerator.method_10426((class_1935)BwtItems.fabricItem)).method_10435("padding").method_10431(exporter);
        class_2447.method_10436((class_7800)class_7800.field_40642, (class_1935)BwtItems.broadheadArrowItem, (int)4).method_10439("b").method_10439("m").method_10439("f").method_10434(Character.valueOf('b'), (class_1935)BwtItems.broadheadItem).method_10433(Character.valueOf('m'), BwtItemTags.WOODEN_MOULDING_BLOCKS).method_10434(Character.valueOf('f'), (class_1935)class_1802.field_8153).method_10429(CraftingRecipeGenerator.method_32807((class_1935)BwtItems.broadheadItem), CraftingRecipeGenerator.method_10426((class_1935)BwtItems.broadheadItem)).method_10431(exporter);
        class_2447.method_10437((class_7800)class_7800.field_40642, (class_1935)BwtItems.compositeBowItem).method_10439(" mb").method_10439("mbs").method_10439(" mb").method_10433(Character.valueOf('m'), BwtItemTags.WOODEN_MOULDING_BLOCKS).method_10434(Character.valueOf('b'), (class_1935)class_1802.field_8606).method_10434(Character.valueOf('s'), (class_1935)class_1802.field_8276).method_10429("has_wooden_moulding", CraftingRecipeGenerator.method_10420(BwtItemTags.WOODEN_MOULDING_BLOCKS)).method_10431(exporter);
        class_2447.method_10437((class_7800)class_7800.field_40642, (class_1935)BwtBlocks.soulForgeBlock).method_10439("nnn").method_10439(" n ").method_10439("nnn").method_10434(Character.valueOf('n'), (class_1935)class_1802.field_22020).method_10429(CraftingRecipeGenerator.method_32807((class_1935)class_1802.field_22020), CraftingRecipeGenerator.method_10426((class_1935)class_1802.field_22020)).method_10431(exporter);
    }

    private class_2960 highEfficiencyId(class_1935 itemConvertible) {
        return Id.of(class_7923.field_41178.method_10221((Object)itemConvertible.method_8389()).method_45138("he_").method_12832());
    }

    private void generateHighEfficiencyRecipes(class_8790 exporter) {
        Optional<SidingBlock> stoneSiding = BwtBlocks.sidingBlocks.stream().filter(sidingBlock -> sidingBlock.fullBlock == class_2246.field_10340).findAny();
        class_2447.method_10437((class_7800)class_7800.field_40642, (class_1935)BwtItems.sailItem).method_10439("fff").method_10439("fff").method_10439("mmm").method_10434(Character.valueOf('f'), (class_1935)BwtItems.fabricItem).method_10433(Character.valueOf('m'), BwtItemTags.WOODEN_MOULDING_BLOCKS).method_10429(CraftingRecipeGenerator.method_32807((class_1935)BwtItems.fabricItem), CraftingRecipeGenerator.method_10426((class_1935)BwtItems.fabricItem)).method_17972(exporter, this.highEfficiencyId((class_1935)BwtItems.sailItem));
        class_2447.method_10437((class_7800)class_7800.field_40642, (class_1935)BwtBlocks.sawBlock).method_10439("iii").method_10439("gbg").method_10439("sgs").method_10434(Character.valueOf('i'), (class_1935)class_1802.field_8620).method_10434(Character.valueOf('g'), (class_1935)BwtItems.gearItem).method_10433(Character.valueOf('s'), BwtItemTags.WOODEN_SIDING_BLOCKS).method_10434(Character.valueOf('b'), (class_1935)BwtItems.beltItem).method_10429(CraftingRecipeGenerator.method_32807((class_1935)BwtItems.beltItem), CraftingRecipeGenerator.method_10426((class_1935)BwtItems.beltItem)).method_17972(exporter, this.highEfficiencyId((class_1935)BwtBlocks.sawBlock));
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)BwtBlocks.gearBoxBlock).method_10439("sgs").method_10439("g g").method_10439("sgs").method_10433(Character.valueOf('s'), BwtItemTags.WOODEN_SIDING_BLOCKS).method_10434(Character.valueOf('g'), (class_1935)BwtItems.gearItem).method_10435("gear_box").method_10429("has_wooden_siding", CraftingRecipeGenerator.method_10420(BwtItemTags.WOODEN_SIDING_BLOCKS)).method_17972(exporter, this.highEfficiencyId((class_1935)BwtBlocks.gearBoxBlock));
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)BwtBlocks.redstoneClutchBlock).method_10439("sgs").method_10439("grg").method_10439("sgs").method_10433(Character.valueOf('s'), BwtItemTags.WOODEN_SIDING_BLOCKS).method_10434(Character.valueOf('g'), (class_1935)BwtItems.gearItem).method_10434(Character.valueOf('r'), (class_1935)class_1802.field_8725).method_10435("redstone_clutch").method_10429("has_wooden_siding", CraftingRecipeGenerator.method_10420(BwtItemTags.WOODEN_SIDING_BLOCKS)).method_17972(exporter, this.highEfficiencyId((class_1935)BwtBlocks.redstoneClutchBlock));
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)class_2246.field_10560).method_10439("sss").method_10439("cic").method_10439("crc").method_10433(Character.valueOf('s'), BwtItemTags.WOODEN_SIDING_BLOCKS).method_10434(Character.valueOf('i'), (class_1935)class_1802.field_8620).method_10434(Character.valueOf('r'), (class_1935)class_1802.field_8725).method_10434(Character.valueOf('c'), (class_1935)class_1802.field_20412).method_10429("has_wooden_siding", CraftingRecipeGenerator.method_10420(BwtItemTags.WOODEN_SIDING_BLOCKS)).method_17972(exporter, this.highEfficiencyId((class_1935)class_1802.field_8249));
        class_2447.method_10437((class_7800)class_7800.field_40634, (class_1935)class_2246.field_10504).method_10439("sss").method_10439("bbb").method_10439("sss").method_10433(Character.valueOf('s'), BwtItemTags.WOODEN_SIDING_BLOCKS).method_10434(Character.valueOf('b'), (class_1935)class_1802.field_8529).method_10429("has_wooden_siding", CraftingRecipeGenerator.method_10420(BwtItemTags.WOODEN_SIDING_BLOCKS)).method_17972(exporter, this.highEfficiencyId((class_1935)class_1802.field_8536));
        class_2447.method_10437((class_7800)class_7800.field_40642, (class_1935)class_2246.field_10034).method_10439("sss").method_10439("s s").method_10439("sss").method_10433(Character.valueOf('s'), BwtItemTags.WOODEN_SIDING_BLOCKS).method_10429("has_wooden_siding", CraftingRecipeGenerator.method_10420(BwtItemTags.WOODEN_SIDING_BLOCKS)).method_17972(exporter, this.highEfficiencyId((class_1935)class_2246.field_10034));
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)class_2246.field_10179).method_10439("sss").method_10439("srs").method_10439("sss").method_10433(Character.valueOf('s'), BwtItemTags.WOODEN_SIDING_BLOCKS).method_10434(Character.valueOf('r'), (class_1935)class_1802.field_8725).method_10429("has_wooden_siding", CraftingRecipeGenerator.method_10420(BwtItemTags.WOODEN_SIDING_BLOCKS)).method_17972(exporter, this.highEfficiencyId((class_1935)class_2246.field_10179));
        class_2447.method_10437((class_7800)class_7800.field_40635, (class_1935)class_2246.field_10223).method_10439("sss").method_10439("sds").method_10439("sss").method_10433(Character.valueOf('s'), BwtItemTags.WOODEN_SIDING_BLOCKS).method_10434(Character.valueOf('d'), (class_1935)class_1802.field_8477).method_10429("has_wooden_siding", CraftingRecipeGenerator.method_10420(BwtItemTags.WOODEN_SIDING_BLOCKS)).method_17972(exporter, this.highEfficiencyId((class_1935)class_2246.field_10223));
        class_2447.method_10436((class_7800)class_7800.field_40642, (class_1935)class_2246.field_9983, (int)3).method_10439("m m").method_10439("mmm").method_10439("m m").method_10433(Character.valueOf('m'), BwtItemTags.WOODEN_MOULDING_BLOCKS).method_10429("has_wooden_moulding", CraftingRecipeGenerator.method_10420(BwtItemTags.WOODEN_MOULDING_BLOCKS)).method_17972(exporter, this.highEfficiencyId((class_1935)class_2246.field_9983));
        class_2447.method_10437((class_7800)class_7800.field_40642, (class_1935)class_1802.field_8600).method_10435("sticks").method_10439("m").method_10433(Character.valueOf('m'), BwtItemTags.WOODEN_MOULDING_BLOCKS).method_10429("has_wooden_moulding", CraftingRecipeGenerator.method_10420(BwtItemTags.WOODEN_MOULDING_BLOCKS)).method_17972(exporter, this.highEfficiencyId((class_1935)class_1802.field_8600));
        stoneSiding.ifPresent(sidingBlock -> class_2447.method_10437((class_7800)class_7800.field_40642, (class_1935)class_2246.field_10450).method_10439("trt").method_10439("sss").method_10434(Character.valueOf('t'), (class_1935)class_1802.field_8530).method_10434(Character.valueOf('r'), (class_1935)class_1802.field_8725).method_10434(Character.valueOf('s'), (class_1935)sidingBlock).method_10429(CraftingRecipeGenerator.method_32807((class_1935)sidingBlock), CraftingRecipeGenerator.method_10426((class_1935)sidingBlock)).method_17972(exporter, this.highEfficiencyId((class_1935)class_2246.field_10450)));
        class_2450.method_10447((class_7800)class_7800.field_40642, (class_1935)class_1802.field_8529).method_10454((class_1935)BwtItems.tannedLeatherItem).method_10449((class_1935)class_1802.field_8407, 6).method_10442(CraftingRecipeGenerator.method_32807((class_1935)BwtItems.tannedLeatherItem), CraftingRecipeGenerator.method_10426((class_1935)BwtItems.tannedLeatherItem)).method_17972(exporter, this.highEfficiencyId((class_1935)class_1802.field_8529));
        class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)class_1802.field_8143, (int)2).method_10439("mmm").method_10439("mtm").method_10439("mmm").method_10433(Character.valueOf('m'), BwtItemTags.WOODEN_MOULDING_BLOCKS).method_10434(Character.valueOf('t'), (class_1935)BwtItems.tannedLeatherItem).method_10429("has_wooden_moulding", CraftingRecipeGenerator.method_10420(BwtItemTags.WOODEN_MOULDING_BLOCKS)).method_17972(exporter, this.highEfficiencyId((class_1935)class_1802.field_8143));
        class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)BwtBlocks.axleBlock).method_10439("prp").method_10433(Character.valueOf('p'), BwtItemTags.WOODEN_MOULDING_BLOCKS).method_10434(Character.valueOf('r'), (class_1935)BwtItems.ropeItem).method_10429(CraftingRecipeGenerator.method_32807((class_1935)BwtItems.ropeItem), CraftingRecipeGenerator.method_10426((class_1935)BwtItems.ropeItem)).method_17972(exporter, this.highEfficiencyId((class_1935)BwtBlocks.axleBlock));
        class_2447.method_10436((class_7800)class_7800.field_40642, (class_1935)class_1802.field_8428, (int)4).method_10433(Character.valueOf('c'), BwtItemTags.WOODEN_CORNER_BLOCKS).method_10439("c c").method_10439(" c ").method_10429("has_wooden_corner", CraftingRecipeGenerator.method_10420(BwtItemTags.WOODEN_CORNER_BLOCKS)).method_10431(exporter);
        class_5793.method_33467().filter(blockFamily -> blockFamily.method_33479().orElse("").equals("wooden")).forEach(blockFamily -> this.createHighEfficiencyBlockFamilyRecipes((class_5794)blockFamily, exporter));
    }

    private void createHighEfficiencyBlockFamilyRecipe(class_8790 exporter, class_5794 blockFamily, class_5794.class_5796 variant, Function<class_2248, class_5797> builder) {
        Optional.ofNullable(blockFamily.method_33470(variant)).ifPresent(result -> ((class_5797)builder.apply((class_2248)result)).method_33529((String)blockFamily.method_33479().map(group -> group + "_" + variant.method_33498()).orElse(null)).method_17972(exporter, this.highEfficiencyId((class_1935)result)));
    }

    private void createHighEfficiencyBlockFamilyRecipes(class_5794 blockFamily, class_8790 exporter) {
        class_2248 baseBlock = blockFamily.method_33469();
        Optional<SidingBlock> optionalSidingBlock = BwtBlocks.sidingBlocks.stream().filter(siding -> siding.fullBlock == baseBlock).findFirst();
        Optional<MouldingBlock> optionalMouldingBlock = BwtBlocks.mouldingBlocks.stream().filter(siding -> siding.fullBlock == baseBlock).findFirst();
        Optional<CornerBlock> optionalCornerBlock = BwtBlocks.cornerBlocks.stream().filter(siding -> siding.fullBlock == baseBlock).findFirst();
        if (optionalSidingBlock.isEmpty() || optionalMouldingBlock.isEmpty() || optionalCornerBlock.isEmpty()) {
            return;
        }
        SidingBlock sidingBlock = optionalSidingBlock.get();
        MouldingBlock mouldingBlock = optionalMouldingBlock.get();
        CornerBlock cornerBlock = optionalCornerBlock.get();
        this.createHighEfficiencyBlockFamilyRecipe(exporter, blockFamily, class_5794.class_5796.field_28535, door -> CraftingRecipeGenerator.method_33544((class_1935)door, (class_1856)class_1856.method_8091((class_1935[])new class_1935[]{sidingBlock})).method_33530("has_siding", CraftingRecipeGenerator.method_10426((class_1935)sidingBlock)));
        this.createHighEfficiencyBlockFamilyRecipe(exporter, blockFamily, class_5794.class_5796.field_28543, trapdoor -> CraftingRecipeGenerator.method_33553((class_1935)trapdoor, (class_1856)class_1856.method_8091((class_1935[])new class_1935[]{sidingBlock})).method_33530("has_siding", CraftingRecipeGenerator.method_10426((class_1935)sidingBlock)));
        this.createHighEfficiencyBlockFamilyRecipe(exporter, blockFamily, class_5794.class_5796.field_28541, pressurePlate -> class_2450.method_10447((class_7800)class_7800.field_40636, (class_1935)pressurePlate).method_10454((class_1935)sidingBlock).method_10442("has_siding", CraftingRecipeGenerator.method_10426((class_1935)sidingBlock)));
        this.createHighEfficiencyBlockFamilyRecipe(exporter, blockFamily, class_5794.class_5796.field_28536, fence -> class_2447.method_10436((class_7800)class_7800.field_40635, (class_1935)fence, (int)3).method_10439("sms").method_10439("sms").method_10434(Character.valueOf('s'), (class_1935)sidingBlock).method_10434(Character.valueOf('m'), (class_1935)mouldingBlock).method_10429("has_siding", CraftingRecipeGenerator.method_10426((class_1935)sidingBlock)));
        this.createHighEfficiencyBlockFamilyRecipe(exporter, blockFamily, class_5794.class_5796.field_28537, fenceGate -> class_2447.method_10437((class_7800)class_7800.field_40636, (class_1935)fenceGate).method_10439("msm").method_10439("msm").method_10434(Character.valueOf('s'), (class_1935)sidingBlock).method_10434(Character.valueOf('m'), (class_1935)mouldingBlock).method_10429("has_siding", CraftingRecipeGenerator.method_10426((class_1935)sidingBlock)));
        this.createHighEfficiencyBlockFamilyRecipe(exporter, blockFamily, class_5794.class_5796.field_28538, sign -> class_2447.method_10437((class_7800)class_7800.field_40635, (class_1935)sign).method_10439("s").method_10439("m").method_10434(Character.valueOf('s'), (class_1935)sidingBlock).method_10434(Character.valueOf('m'), (class_1935)mouldingBlock).method_10429("has_siding", CraftingRecipeGenerator.method_10426((class_1935)sidingBlock)));
        this.createHighEfficiencyBlockFamilyRecipe(exporter, blockFamily, class_5794.class_5796.field_28540, stair -> class_2447.method_10437((class_7800)class_7800.field_40634, (class_1935)stair).method_10439("m ").method_10439("mm").method_10434(Character.valueOf('m'), (class_1935)mouldingBlock).method_10429("has_moulding", CraftingRecipeGenerator.method_10426((class_1935)mouldingBlock)));
        this.createHighEfficiencyBlockFamilyRecipe(exporter, blockFamily, class_5794.class_5796.field_28533, button -> class_2450.method_10447((class_7800)class_7800.field_40636, (class_1935)button).method_10454((class_1935)cornerBlock).method_10442(CraftingRecipeGenerator.method_32807((class_1935)cornerBlock), CraftingRecipeGenerator.method_10426((class_1935)cornerBlock)));
    }
}

