/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.mixin.animals;

import com.bwt.entities.GoToAndPickUpBreedingItemGoal;
import com.bwt.entities.PickUpBreedingItemWhileSittingGoal;
import com.bwt.entities.WolfIsFedAccess;
import com.bwt.items.BwtItems;
import com.bwt.mixin.accessors.MobEntityAccessorMixin;
import com.bwt.sounds.BwtSoundEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1321;
import net.minecraft.class_1352;
import net.minecraft.class_1429;
import net.minecraft.class_1493;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_4174;
import net.minecraft.class_5819;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1493.class})
public abstract class WolfEntityMixin
extends class_1321
implements MobEntityAccessorMixin,
WolfIsFedAccess {
    @Unique
    private static final class_2940<Boolean> IS_FED = class_2945.method_12791(WolfEntityMixin.class, (class_2941)class_2943.field_13323);

    protected WolfEntityMixin(class_1299<? extends class_1321> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"initDataTracker"}, at={@At(value="TAIL")})
    public void initDataTracker(class_2945.class_9222 builder, CallbackInfo ci) {
        builder.method_56912(IS_FED, (Object)false);
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    public void bwt$writeCustomDataToNbt(class_2487 nbt, CallbackInfo ci) {
        nbt.method_10556("IsFed", this.bwt$isFed());
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    public void bwt$readCustomDataFromNbt(class_2487 nbt, CallbackInfo ci) {
        if (nbt.method_10545("IsFed")) {
            this.bwt$setIsFed(nbt.method_10577("IsFed"));
        }
    }

    @Inject(method={"initGoals"}, at={@At(value="TAIL")})
    public void addGoal(CallbackInfo ci) {
        this.getGoalSelector().method_6277(1, (class_1352)new PickUpBreedingItemWhileSittingGoal(this, 1.7, wolf -> (Boolean)wolf.method_5841().method_12789(IS_FED) == false || wolf.method_6032() < wolf.method_6063(), this::bwt$feed));
        this.getGoalSelector().method_6277(7, (class_1352)new GoToAndPickUpBreedingItemGoal((class_1429)this, 8.0, 1.8, 1.0, wolf -> (Boolean)wolf.method_5841().method_12789(IS_FED) == false || wolf.method_6032() < wolf.method_6063(), this::bwt$feed));
    }

    @Inject(method={"interactMob"}, at={@At(value="HEAD")}, cancellable=true)
    public void interactMob(class_1657 player, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        class_1799 itemStack = player.method_5998(hand);
        if (!this.method_6109() && this.method_6181() && this.method_6481(itemStack) && !this.bwt$isFed()) {
            if (this.method_37908().method_8608()) {
                cir.setReturnValue((Object)class_1269.field_21466);
                return;
            }
            if (!player.method_31549().field_7477) {
                itemStack.method_7934(1);
            }
            this.bwt$feed(itemStack);
            cir.setReturnValue((Object)class_1269.method_29236((boolean)this.method_37908().method_8608()));
        }
    }

    @Inject(method={"isBreedingItem"}, at={@At(value="HEAD")}, cancellable=true)
    public void isBreedingItem(class_1799 stack, CallbackInfoReturnable<Boolean> cir) {
        if (stack.method_31574(BwtItems.kibbleItem)) {
            cir.setReturnValue((Object)true);
            return;
        }
        if (stack.method_31574(class_1802.field_8511) || stack.method_31574(BwtItems.wolfChopItem) || stack.method_31574(BwtItems.cookedWolfChopItem)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick(CallbackInfo ci) {
        class_1937 world = this.method_37908();
        class_5819 random = world.method_8409();
        if (world.field_9236) {
            return;
        }
        if (this.method_6109() || !this.bwt$isFed()) {
            return;
        }
        if (random.method_43048(24000) >= 2) {
            return;
        }
        if (!this.bwt$isInTheDark() && !random.method_43056()) {
            return;
        }
        if (this.attemptProduceDung()) {
            this.bwt$setIsFed(false);
        }
    }

    @Unique
    public boolean attemptProduceDung() {
        double dungPosZ;
        double dungPosY;
        class_1937 world = this.method_37908();
        class_5819 random = this.method_59922();
        double dungVectorX = Math.sin(Math.toRadians(this.method_5791()));
        double dungVectorZ = -Math.cos(Math.toRadians(this.method_5791()));
        double dungPosX = this.method_23317() + dungVectorX;
        class_2338 dungBlockPos = class_2338.method_49637((double)dungPosX, (double)(dungPosY = this.method_23318() + 0.25), (double)(dungPosZ = this.method_23321() + dungVectorZ));
        if (!this.isPathToBlockOpenToDung(dungBlockPos)) {
            return false;
        }
        class_1542 itemEntity = new class_1542(world, dungPosX, dungPosY, dungPosZ, new class_1799((class_1935)BwtItems.dungItem));
        float velocityFactor = 0.05f;
        itemEntity.method_18800(dungVectorX * 10.0 * (double)velocityFactor, (double)((float)random.method_43059() * velocityFactor + 0.2f), dungVectorZ * 10.0 * (double)velocityFactor);
        itemEntity.method_6982(10);
        world.method_8649((class_1297)itemEntity);
        world.method_45445((class_1297)this, this.method_24515(), BwtSoundEvents.WOLF_DUNG_PRODUCTION, this.method_5634(), 0.2f, 1.25f);
        world.method_45445((class_1297)this, this.method_24515(), BwtSoundEvents.WOLF_DUNG_EFFORT, this.method_5634(), this.method_6107(), (random.method_43057() - random.method_43057()) * 0.2f + 1.0f);
        for (int counter = 0; counter < 5; ++counter) {
            double smokeX = this.method_23317() + dungVectorX * 0.5 + random.method_43058() * 0.25;
            double smokeY = this.method_23318() + random.method_43058() * 0.5 + 0.25;
            double smokeZ = this.method_23321() + dungVectorZ * 0.5 + random.method_43058() * 0.25;
            world.method_8406((class_2394)class_2398.field_11251, smokeX, smokeY, smokeZ, 0.0, 0.0, 0.0);
        }
        return true;
    }

    @Unique
    protected boolean isPathToBlockOpenToDung(class_2338 dungBlockPos) {
        if (!this.bwt$isBlockOpenToDung(dungBlockPos.method_10263(), dungBlockPos.method_10264(), dungBlockPos.method_10260())) {
            return false;
        }
        int wolfX = class_3532.method_15357((double)this.method_23317());
        int wolfZ = class_3532.method_15357((double)this.method_23321());
        int deltaX = dungBlockPos.method_10263() - wolfX;
        int deltaZ = dungBlockPos.method_10260() - wolfZ;
        if (deltaX != 0 && deltaZ != 0) {
            return this.bwt$isBlockOpenToDung(wolfX, dungBlockPos.method_10264(), dungBlockPos.method_10260()) || this.bwt$isBlockOpenToDung(dungBlockPos.method_10263(), dungBlockPos.method_10264(), wolfZ);
        }
        return true;
    }

    @Unique
    protected boolean bwt$isBlockOpenToDung(int x, int y, int z) {
        class_1937 world = this.method_37908();
        class_2680 blockState = world.method_8320(new class_2338(x, y, z));
        class_3610 fluidState = world.method_8316(new class_2338(x, y, z));
        return !fluidState.method_15769() || blockState.method_26164(class_3481.field_21952) || blockState.method_45474();
    }

    @Override
    public boolean bwt$isFed() {
        return (Boolean)this.method_5841().method_12789(IS_FED);
    }

    @Unique
    public void bwt$setIsFed(boolean value) {
        this.method_5841().method_12778(IS_FED, (Object)value);
    }

    @Unique
    public void bwt$feed(int hungerValue) {
        this.bwt$setIsFed(this.bwt$isFed() || hungerValue > 0);
    }

    @Unique
    public void bwt$feed(class_1799 itemStack) {
        int nutrition = itemStack.method_31574(BwtItems.kibbleItem) ? 2 : ((class_4174)itemStack.method_57825(class_9334.field_50075, (Object)new class_4174.class_4175().method_19242())).comp_2491();
        this.method_6025(nutrition * 2);
        this.bwt$feed(nutrition);
    }

    @Unique
    public boolean bwt$isInTheDark() {
        return this.method_37908().method_22339(this.method_24515()) < 5;
    }
}

