/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.models;

import com.bwt.entities.WindmillEntity;
import com.bwt.models.HorizontalMechPowerSourceEntityModel;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1767;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5253;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;

@Environment(value=EnvType.CLIENT)
public class WindmillEntityModel
extends HorizontalMechPowerSourceEntityModel<WindmillEntity> {
    private static final float bladeOffsetFromCenter = 15.0f;
    private static final int bladeLength = 84;
    private static final int bladeWidth = 16;
    private static final float shaftOffsetFromCenter = 2.5f;
    private static final int shaftLength = 97;
    private static final int shaftWidth = 4;
    private final List<class_630> sails;
    private final List<class_630> shafts = IntStream.range(0, 4).mapToObj(i -> modelPart.method_32086("shaft" + i)).collect(Collectors.toList());

    public WindmillEntityModel(class_630 modelPart) {
        this.sails = IntStream.range(0, 4).mapToObj(i -> modelPart.method_32086("sail" + i)).collect(Collectors.toList());
    }

    public static class_5607 getTexturedModelData() {
        int i;
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        float localPi = 3.141593f;
        for (i = 0; i < 4; ++i) {
            modelPartData.method_32117("shaft" + i, class_5606.method_32108().method_32101(0, 0).method_32097(2.5f, -2.0f, -2.0f, 97.0f, 4.0f, 4.0f), class_5603.method_32092((float)0.0f, (float)0.0f, (float)(2.0f * localPi * ((float)i / 4.0f))));
        }
        for (i = 0; i < 4; ++i) {
            modelPartData.method_32117("sail" + i, class_5606.method_32108().method_32101(0, 15).method_32097(15.0f, 1.75f, 1.0f, 84.0f, 16.0f, 1.0f), class_5603.method_32092((float)(-localPi / 12.0f), (float)0.0f, (float)(2.0f * localPi * ((float)i / 4.0f))));
        }
        return class_5607.method_32110((class_5609)modelData, (int)64, (int)32);
    }

    @Override
    public void render(WindmillEntity entity, class_4587 matrices, class_4588 vertices, int light, int overlay, int color) {
        this.shafts.forEach(shaft -> shaft.method_22698(matrices, vertices, light, overlay));
        for (int i = 0; i < 4; ++i) {
            class_630 sail = this.sails.get(i);
            class_1767 sailColor = entity.getSailColor(i);
            sail.method_22699(matrices, vertices, light, overlay, class_5253.class_5254.method_27763((int)color, (int)sailColor.method_7787()));
        }
    }
}

