/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.recipes;

import com.bwt.utils.Id;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record IngredientWithCount(class_1856 ingredient, int count) implements CustomIngredient
{
    public static final Serializer SERIALIZER = new Serializer();
    public static final IngredientWithCount EMPTY = new IngredientWithCount(class_1856.field_9017, 0);

    public static IngredientWithCount fromStack(class_1799 stack) {
        return new IngredientWithCount(class_1856.method_8101((class_1799[])new class_1799[]{stack}), stack.method_7947());
    }

    public static IngredientWithCount fromTag(class_6862<class_1792> itemTag, int count) {
        return new IngredientWithCount(class_1856.method_8106(itemTag), count);
    }

    public static IngredientWithCount fromTag(class_6862<class_1792> itemTag) {
        return new IngredientWithCount(class_1856.method_8106(itemTag), 1);
    }

    public boolean test(class_1799 stack) {
        if (!this.ingredient.method_8093(stack)) {
            return false;
        }
        return stack.method_7947() >= this.count;
    }

    public boolean test(ItemVariant itemVariant) {
        return this.ingredient.method_8093(itemVariant.toStack());
    }

    public List<class_1799> getMatchingStacks() {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>(List.of(this.ingredient.method_8105()));
        stacks.replaceAll(stack -> stack.method_46651(this.count));
        stacks.removeIf(stack -> !this.ingredient.method_8093(stack));
        return stacks;
    }

    public boolean requiresTesting() {
        return true;
    }

    public CustomIngredientSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public static class Serializer
    implements CustomIngredientSerializer<IngredientWithCount> {
        private static final class_2960 ID = Id.of("ingredient_with_count");
        public static final MapCodec<IngredientWithCount> ALLOW_EMPTY_CODEC = Serializer.createCodec((Codec<class_1856>)class_1856.field_46095);
        public static final MapCodec<IngredientWithCount> DISALLOW_EMPTY_CODEC = Serializer.createCodec((Codec<class_1856>)class_1856.field_46096);
        public static final class_9139<class_9129, IngredientWithCount> PACKET_CODEC = class_9139.method_56437(Serializer::write, Serializer::read);

        public static MapCodec<IngredientWithCount> createCodec(Codec<class_1856> ingredientCodec) {
            return RecordCodecBuilder.mapCodec(instance -> instance.group((App)ingredientCodec.fieldOf("ingredient").forGetter(IngredientWithCount::ingredient), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(IngredientWithCount::count)).apply((Applicative)instance, IngredientWithCount::new));
        }

        public class_2960 getIdentifier() {
            return ID;
        }

        public MapCodec<IngredientWithCount> getCodec(boolean allowEmpty) {
            return allowEmpty ? ALLOW_EMPTY_CODEC : DISALLOW_EMPTY_CODEC;
        }

        public class_9139<class_9129, IngredientWithCount> getPacketCodec() {
            return PACKET_CODEC;
        }

        public static IngredientWithCount read(class_9129 buf) {
            class_1856 base = (class_1856)class_1856.field_48355.decode((Object)buf);
            int count = buf.readInt();
            return new IngredientWithCount(base, count);
        }

        public static void write(class_9129 buf, IngredientWithCount ingredient) {
            class_1856.field_48355.encode((Object)buf, (Object)ingredient.ingredient);
            buf.method_53002(ingredient.count);
        }
    }
}

