/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.recipes.cooking_pots;

import com.bwt.generation.EmiDefaultsGenerator;
import com.bwt.recipes.IngredientWithCount;
import com.bwt.recipes.cooking_pots.AbstractCookingPotRecipeType;
import com.bwt.recipes.cooking_pots.CookingPotRecipeInput;
import com.bwt.utils.Id;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1747;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2119;
import net.minecraft.class_2371;
import net.minecraft.class_2446;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_3956;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7800;
import net.minecraft.class_8782;
import net.minecraft.class_8790;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCookingPotRecipe
implements class_1860<CookingPotRecipeInput> {
    protected final AbstractCookingPotRecipeType type;
    protected final String group;
    protected final CookingPotRecipeCategory category;
    final class_2371<IngredientWithCount> ingredients;
    protected final class_2371<class_1799> results;

    public AbstractCookingPotRecipe(AbstractCookingPotRecipeType type, String group, CookingPotRecipeCategory category, List<IngredientWithCount> ingredients, List<class_1799> results) {
        this.type = type;
        this.group = group;
        this.category = category;
        this.ingredients = class_2371.method_10212((Object)IngredientWithCount.EMPTY, (Object[])ingredients.toArray(new IngredientWithCount[0]));
        this.results = class_2371.method_10212((Object)class_1799.field_8037, (Object[])results.toArray(new class_1799[0]));
    }

    public boolean matches(CookingPotRecipeInput input, class_1937 world) {
        return this.ingredients.stream().allMatch(input::matches);
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_2371<class_1856> method_8117() {
        class_2371 defaultedList = class_2371.method_10211();
        defaultedList.addAll(this.ingredients.stream().map(CustomIngredient::toVanilla).toList());
        return defaultedList;
    }

    public class_2371<IngredientWithCount> getIngredientsWithCount() {
        return this.ingredients;
    }

    public List<class_1799> getResults() {
        return this.results.stream().map(class_1799::method_7972).collect(Collectors.toList());
    }

    public String method_8112() {
        return this.group;
    }

    public class_3956<?> method_17716() {
        return this.type;
    }

    public CookingPotRecipeCategory getCategory() {
        return this.category;
    }

    public boolean method_8118() {
        return true;
    }

    public boolean method_49188() {
        return false;
    }

    public class_1799 craft(CookingPotRecipeInput input, class_7225.class_7874 lookup) {
        return this.method_8110(lookup);
    }

    public class_1799 method_8110(class_7225.class_7874 registriesLookup) {
        return (class_1799)this.results.get(0);
    }

    public static enum CookingPotRecipeCategory implements class_3542
    {
        FOOD("food"),
        BLOCKS("blocks"),
        MISC("misc"),
        RECLAIM("reclaim");

        public static final class_3542.class_7292<CookingPotRecipeCategory> CODEC;
        private final String id;

        private CookingPotRecipeCategory(String id) {
            this.id = id;
        }

        public String method_15434() {
            return this.id;
        }

        static {
            CODEC = class_3542.method_28140(CookingPotRecipeCategory::values);
        }
    }

    public static abstract class JsonBuilder<T extends AbstractCookingPotRecipe>
    implements class_5797 {
        protected class_7800 category;
        protected CookingPotRecipeCategory cookingCategory;
        protected class_2371<IngredientWithCount> ingredients = class_2371.method_10211();
        protected class_2371<class_1799> results = class_2371.method_10211();
        protected final Map<String, class_175<?>> criteria = new LinkedHashMap();
        @Nullable
        protected String group;
        protected boolean isDefaultRecipe;

        protected abstract RecipeFactory<T> getRecipeFactory();

        public JsonBuilder<T> category(class_7800 category) {
            this.category = category;
            return this;
        }

        public JsonBuilder<T> cookingCategory(CookingPotRecipeCategory cookingCategory) {
            this.cookingCategory = cookingCategory;
            return this;
        }

        public JsonBuilder<T> ingredients(IngredientWithCount ... ingredients) {
            for (IngredientWithCount ingredient : ingredients) {
                this.ingredient(ingredient);
            }
            return this;
        }

        public JsonBuilder<T> ingredient(IngredientWithCount ingredient) {
            this.ingredients.add((Object)ingredient);
            return this;
        }

        public JsonBuilder<T> ingredient(class_1799 itemStack) {
            this.criterion(class_2446.method_32807((class_1935)itemStack.method_7909()), class_2446.method_10426((class_1935)itemStack.method_7909()));
            return this.ingredient(IngredientWithCount.fromStack(itemStack));
        }

        public JsonBuilder<T> ingredient(class_1792 item, int count) {
            return this.ingredient(new class_1799((class_1935)item, count));
        }

        public JsonBuilder<T> ingredient(class_1792 item) {
            return this.ingredient(item, 1);
        }

        public JsonBuilder<T> ingredient(class_6862<class_1792> itemTag, int count) {
            this.criterion("has_" + itemTag.comp_327().method_12832(), class_2446.method_10420(itemTag));
            return this.ingredient(IngredientWithCount.fromTag(itemTag, count));
        }

        public JsonBuilder<T> ingredient(class_6862<class_1792> itemTag) {
            return this.ingredient(itemTag, 1);
        }

        public JsonBuilder<T> results(class_1799 ... itemStacks) {
            this.results.addAll(Arrays.asList(itemStacks));
            return this;
        }

        public JsonBuilder<T> result(class_1799 itemStack) {
            this.results.add((Object)itemStack);
            return this;
        }

        public JsonBuilder<T> result(class_1792 item, int count) {
            this.results.add((Object)new class_1799((class_1935)item, count));
            return this;
        }

        public JsonBuilder<T> result(class_1792 item) {
            return this.result(item, 1);
        }

        public JsonBuilder<T> criterion(String string, class_175<?> advancementCriterion) {
            this.criteria.put(string, advancementCriterion);
            return this;
        }

        public JsonBuilder<T> group(@Nullable String string) {
            this.group = string;
            return this;
        }

        public JsonBuilder<T> markDefault() {
            this.isDefaultRecipe = true;
            return this;
        }

        public void addToDefaults(class_2960 recipeId) {
            if (this.isDefaultRecipe) {
                EmiDefaultsGenerator.addBwtRecipe(recipeId.method_45138("/"));
            }
        }

        public class_1792 method_36441() {
            return ((class_1799)this.results.get(0)).method_7909();
        }

        public void method_36443(class_8790 exporter, String recipePath) {
            this.method_17972(exporter, Id.of(recipePath));
        }

        public void method_17972(class_8790 exporter, class_2960 recipeId) {
            this.validate(recipeId);
            this.addToDefaults(recipeId);
            if (this.cookingCategory == null) {
                this.cookingCategory(JsonBuilder.getCookingPotRecipeCategory(this.results));
            }
            class_161.class_162 advancementBuilder = exporter.method_53818().method_705("has_the_recipe", class_2119.method_27847((class_2960)recipeId)).method_703(class_170.class_171.method_753((class_2960)recipeId)).method_704(class_8782.class_8797.field_1257);
            this.criteria.forEach((arg_0, arg_1) -> ((class_161.class_162)advancementBuilder).method_705(arg_0, arg_1));
            T cookingPotRecipe = this.getRecipeFactory().create(Objects.requireNonNullElse(this.group, ""), this.cookingCategory, (List<IngredientWithCount>)this.ingredients, (List<class_1799>)this.results);
            exporter.method_53819(recipeId, cookingPotRecipe, advancementBuilder.method_695(recipeId.method_45138("recipes/" + this.category.method_46203() + "/")));
        }

        private static CookingPotRecipeCategory getCookingPotRecipeCategory(class_2371<class_1799> results) {
            if (results.stream().anyMatch(result -> result.method_7909() instanceof class_1747)) {
                return CookingPotRecipeCategory.BLOCKS;
            }
            return CookingPotRecipeCategory.MISC;
        }

        private void validate(class_2960 recipeId) {
            if (this.criteria.isEmpty()) {
                throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(recipeId));
            }
        }
    }

    public static interface RecipeFactory<T extends AbstractCookingPotRecipe> {
        public T create(String var1, CookingPotRecipeCategory var2, List<IngredientWithCount> var3, List<class_1799> var4);
    }

    public static class Serializer
    implements class_1865<AbstractCookingPotRecipe> {
        private final RecipeFactory<AbstractCookingPotRecipe> recipeFactory;
        public final MapCodec<AbstractCookingPotRecipe> CODEC;
        public final class_9139<class_9129, AbstractCookingPotRecipe> PACKET_CODEC;

        public Serializer(RecipeFactory<AbstractCookingPotRecipe> recipeFactory) {
            this.recipeFactory = recipeFactory;
            this.CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("group").forGetter(recipe -> recipe.group), (App)CookingPotRecipeCategory.CODEC.fieldOf("category").orElse((Object)CookingPotRecipeCategory.MISC).forGetter(recipe -> recipe.category), (App)IngredientWithCount.Serializer.DISALLOW_EMPTY_CODEC.codec().listOf().fieldOf("ingredients").forGetter(recipe -> recipe.ingredients), (App)class_1799.field_24671.listOf().fieldOf("results").forGetter(AbstractCookingPotRecipe::getResults)).apply((Applicative)instance, recipeFactory::create));
            this.PACKET_CODEC = class_9139.method_56437(this::write, this::read);
        }

        public MapCodec<AbstractCookingPotRecipe> method_53736() {
            return this.CODEC;
        }

        public class_9139<class_9129, AbstractCookingPotRecipe> method_56104() {
            return this.PACKET_CODEC;
        }

        protected AbstractCookingPotRecipe read(class_9129 buf) {
            String group = buf.method_19772();
            CookingPotRecipeCategory category = (CookingPotRecipeCategory)buf.method_10818(CookingPotRecipeCategory.class);
            int ingredientsSize = buf.method_10816();
            class_2371 ingredients = class_2371.method_10213((int)ingredientsSize, (Object)IngredientWithCount.EMPTY);
            ingredients.replaceAll(ignored -> IngredientWithCount.Serializer.read(buf));
            List results = (List)class_1799.field_48350.decode((Object)buf);
            return this.recipeFactory.create(group, category, (List<IngredientWithCount>)ingredients, results);
        }

        protected void write(class_9129 buf, AbstractCookingPotRecipe recipe) {
            buf.method_10814(recipe.group);
            buf.method_10817((Enum)recipe.category);
            buf.method_10804(recipe.ingredients.size());
            for (IngredientWithCount ingredient : recipe.ingredients) {
                IngredientWithCount.Serializer.write(buf, ingredient);
            }
            class_1799.field_48350.encode((Object)buf, recipe.getResults());
        }
    }
}

