/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.recipes.mob_spawner_conversion;

import com.bwt.generation.EmiDefaultsGenerator;
import com.bwt.recipes.BlockIngredient;
import com.bwt.recipes.BwtRecipes;
import com.bwt.recipes.mob_spawner_conversion.MobSpawnerConversionRecipeInput;
import com.bwt.utils.Id;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_7923;
import net.minecraft.class_8790;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class MobSpawnerConversionRecipe
implements class_1860<MobSpawnerConversionRecipeInput> {
    protected final String group;
    protected final class_7710 category;
    protected final BlockIngredient ingredient;
    protected final class_2248 result;

    public MobSpawnerConversionRecipe(String group, class_7710 category, BlockIngredient ingredient, class_2248 result) {
        this.group = group;
        this.category = category;
        this.ingredient = ingredient;
        this.result = result;
    }

    public class_1799 method_17447() {
        return new class_1799((class_1935)class_2246.field_10260);
    }

    public class_1865<?> method_8119() {
        return BwtRecipes.MOB_SPAWNER_CONVERSION_RECIPE_SERIALIZER;
    }

    public boolean matches(MobSpawnerConversionRecipeInput input, class_1937 world) {
        return this.ingredient.test(input.block());
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public BlockIngredient getIngredient() {
        return this.ingredient;
    }

    public class_2248 getResult() {
        return this.result;
    }

    public String method_8112() {
        return this.group;
    }

    public class_3956<?> method_17716() {
        return BwtRecipes.MOB_SPAWNER_CONVERSION_RECIPE_TYPE;
    }

    public class_7710 getCategory() {
        return this.category;
    }

    public boolean method_8118() {
        return super.method_8118();
    }

    public boolean method_49188() {
        return false;
    }

    public class_1799 craft(MobSpawnerConversionRecipeInput input, class_7225.class_7874 lookup) {
        return this.method_8110(lookup);
    }

    public class_1799 method_8110(class_7225.class_7874 registriesLookup) {
        return this.result.method_8389().method_7854();
    }

    public static class Serializer
    implements class_1865<MobSpawnerConversionRecipe> {
        protected static final MapCodec<MobSpawnerConversionRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)class_7710.field_40252.fieldOf("category").orElse((Object)class_7710.field_40251).forGetter(recipe -> recipe.category), (App)BlockIngredient.Serializer.CODEC.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)class_7923.field_41175.method_39673().fieldOf("result").forGetter(MobSpawnerConversionRecipe::getResult)).apply((Applicative)instance, MobSpawnerConversionRecipe::new));
        public static final class_9139<class_9129, MobSpawnerConversionRecipe> PACKET_CODEC = class_9139.method_56437(Serializer::write, Serializer::read);

        public MapCodec<MobSpawnerConversionRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, MobSpawnerConversionRecipe> method_56104() {
            return PACKET_CODEC;
        }

        protected static MobSpawnerConversionRecipe read(class_9129 buf) {
            String group = buf.method_19772();
            class_7710 category = (class_7710)buf.method_10818(class_7710.class);
            BlockIngredient ingredient = BlockIngredient.Serializer.read(buf);
            class_2248 result = (class_2248)class_9135.method_56896((Codec)class_7923.field_41175.method_39673()).decode((Object)buf);
            return new MobSpawnerConversionRecipe(group, category, ingredient, result);
        }

        protected static void write(class_9129 buf, MobSpawnerConversionRecipe recipe) {
            buf.method_10814(recipe.group);
            buf.method_10817((Enum)recipe.category);
            BlockIngredient.Serializer.write(buf, recipe.ingredient);
            class_9135.method_56896((Codec)class_7923.field_41175.method_39673()).encode((Object)buf, (Object)recipe.result);
        }
    }

    public static class JsonBuilder
    implements class_5797 {
        protected class_7710 category = class_7710.field_40251;
        protected BlockIngredient ingredient;
        protected class_2248 result;
        protected String fromBlockName;
        @Nullable
        protected String group;
        protected boolean isDefaultRecipe;

        public static JsonBuilder create(class_2248 input) {
            JsonBuilder obj = new JsonBuilder();
            obj.ingredient = BlockIngredient.fromBlock(input);
            obj.fromBlockName = class_7923.field_41175.method_10221((Object)input).method_12832();
            return obj;
        }

        public static JsonBuilder create(class_6862<class_2248> inputTag) {
            JsonBuilder obj = new JsonBuilder();
            obj.ingredient = BlockIngredient.fromTag(inputTag);
            obj.fromBlockName = inputTag.comp_327().method_12832();
            return obj;
        }

        public JsonBuilder category(class_7710 category) {
            this.category = category;
            return this;
        }

        public JsonBuilder convertsTo(class_2248 block) {
            this.result = block;
            return this;
        }

        public JsonBuilder criterion(String string, class_175<?> advancementCriterion) {
            return this;
        }

        public JsonBuilder group(@Nullable String string) {
            this.group = string;
            return this;
        }

        public JsonBuilder markDefault() {
            this.isDefaultRecipe = true;
            return this;
        }

        public void addToDefaults(class_2960 recipeId) {
            if (this.isDefaultRecipe) {
                EmiDefaultsGenerator.addBwtRecipe(recipeId);
            }
        }

        public class_1792 method_36441() {
            return this.ingredient.getMatchingStacks().get(0).method_7909();
        }

        public void method_10431(class_8790 exporter) {
            this.method_17972(exporter, Id.of("mob_spawner_conversion_from_" + this.fromBlockName + "_to_" + class_7923.field_41175.method_10221((Object)this.result).method_12832()));
        }

        public void method_36443(class_8790 exporter, String recipePath) {
            this.method_17972(exporter, Id.of(recipePath));
        }

        public void method_17972(class_8790 exporter, class_2960 recipeId) {
            this.addToDefaults(recipeId);
            MobSpawnerConversionRecipe mobSpawnerConversionRecipe = new MobSpawnerConversionRecipe(Objects.requireNonNullElse(this.group, ""), this.category, this.ingredient, this.result);
            exporter.method_53819(recipeId, (class_1860)mobSpawnerConversionRecipe, null);
        }
    }
}

