/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.recipes.turntable;

import com.bwt.blocks.BwtBlocks;
import com.bwt.generation.EmiDefaultsGenerator;
import com.bwt.recipes.BlockIngredient;
import com.bwt.recipes.BwtRecipes;
import com.bwt.recipes.turntable.TurntableRecipeInput;
import com.bwt.utils.Id;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2119;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_7923;
import net.minecraft.class_8782;
import net.minecraft.class_8790;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class TurntableRecipe
implements class_1860<TurntableRecipeInput> {
    protected final String group;
    protected final class_7710 category;
    final BlockIngredient ingredient;
    final class_2248 output;
    protected final class_2371<class_1799> drops;

    public TurntableRecipe(String group, class_7710 category, BlockIngredient ingredient, class_2248 output, List<class_1799> drops) {
        this.group = group;
        this.category = category;
        this.ingredient = ingredient;
        this.output = output;
        this.drops = class_2371.method_10212((Object)class_1799.field_8037, (Object[])drops.toArray(new class_1799[0]));
    }

    public class_1799 method_17447() {
        return new class_1799((class_1935)BwtBlocks.turntableBlock);
    }

    public class_1865<?> method_8119() {
        return BwtRecipes.TURNTABLE_RECIPE_SERIALIZER;
    }

    public boolean matches(TurntableRecipeInput input, class_1937 world) {
        return this.ingredient.test(input.block());
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public BlockIngredient getIngredient() {
        return this.ingredient;
    }

    public class_2248 getOutput() {
        return this.output;
    }

    public class_2371<class_1799> getDrops() {
        return class_2371.method_10212((Object)class_1799.field_8037, (Object[])this.drops.stream().map(class_1799::method_7972).toList().toArray(new class_1799[0]));
    }

    public String method_8112() {
        return this.group;
    }

    public class_3956<?> method_17716() {
        return BwtRecipes.TURNTABLE_RECIPE_TYPE;
    }

    public class_7710 getCategory() {
        return this.category;
    }

    public boolean method_8118() {
        return super.method_8118();
    }

    public boolean method_49188() {
        return false;
    }

    public class_1799 craft(TurntableRecipeInput input, class_7225.class_7874 lookup) {
        return this.method_8110(lookup);
    }

    public class_1799 method_8110(class_7225.class_7874 registriesLookup) {
        return this.output.method_8389().method_7854();
    }

    public static class Serializer
    implements class_1865<TurntableRecipe> {
        protected static final MapCodec<TurntableRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)class_7710.field_40252.fieldOf("category").orElse((Object)class_7710.field_40251).forGetter(recipe -> recipe.category), (App)BlockIngredient.Serializer.CODEC.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)class_2960.field_25139.fieldOf("output").forGetter(recipe -> class_7923.field_41175.method_10221((Object)recipe.output)), (App)class_1799.field_51397.listOf().fieldOf("drops").forGetter(TurntableRecipe::getDrops)).apply((Applicative)instance, (group, category, ingredient, outputId, drops) -> new TurntableRecipe((String)group, (class_7710)category, (BlockIngredient)ingredient, (class_2248)class_7923.field_41175.method_10223(outputId), (List<class_1799>)drops)));
        public static final class_9139<class_9129, TurntableRecipe> PACKET_CODEC = class_9139.method_56437(Serializer::write, Serializer::read);

        public MapCodec<TurntableRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, TurntableRecipe> method_56104() {
            return PACKET_CODEC;
        }

        public static TurntableRecipe read(class_9129 buf) {
            String group = buf.method_19772();
            class_7710 category = (class_7710)buf.method_10818(class_7710.class);
            BlockIngredient ingredient = BlockIngredient.Serializer.read(buf);
            class_2248 output = (class_2248)class_7923.field_41175.method_10223(buf.method_10810());
            List drops = (List)class_1799.field_48350.decode((Object)buf);
            return new TurntableRecipe(group, category, ingredient, output, drops);
        }

        public static void write(class_9129 buf, TurntableRecipe recipe) {
            buf.method_10814(recipe.group);
            buf.method_10817((Enum)recipe.category);
            BlockIngredient.Serializer.write(buf, recipe.ingredient);
            buf.method_10812(class_7923.field_41175.method_10221((Object)recipe.output));
            class_1799.field_48350.encode((Object)buf, recipe.getDrops());
        }
    }

    public static class JsonBuilder
    implements class_5797 {
        protected class_7710 category = class_7710.field_40251;
        protected BlockIngredient ingredient;
        protected class_2248 output;
        protected String fromBlockName;
        protected class_2371<class_1799> drops = class_2371.method_10211();
        @Nullable
        protected String group;
        protected boolean isDefaultRecipe;

        public static JsonBuilder create(class_2248 input, class_2248 output) {
            JsonBuilder obj = new JsonBuilder();
            obj.ingredient = BlockIngredient.fromBlock(input);
            obj.fromBlockName = class_7923.field_41175.method_10221((Object)input).method_12832();
            obj.output = output;
            return obj;
        }

        public static JsonBuilder create(class_6862<class_2248> inputTag, class_2248 output) {
            JsonBuilder obj = new JsonBuilder();
            obj.ingredient = BlockIngredient.fromTag(inputTag);
            obj.fromBlockName = inputTag.comp_327().method_12832();
            obj.output = output;
            return obj;
        }

        public JsonBuilder category(class_7710 category) {
            this.category = category;
            return this;
        }

        public JsonBuilder drops(class_1799 ... itemStacks) {
            this.drops.addAll(Arrays.asList(itemStacks));
            return this;
        }

        public JsonBuilder drops(class_1792 item, int count) {
            return this.drops(new class_1799((class_1935)item, count));
        }

        public JsonBuilder drops(class_1792 item) {
            return this.drops(item, 1);
        }

        public JsonBuilder result(class_1799 itemStack) {
            this.drops.add((Object)itemStack);
            return this;
        }

        public JsonBuilder result(class_1792 item, int count) {
            this.drops.add((Object)new class_1799((class_1935)item, count));
            return this;
        }

        public JsonBuilder result(class_1792 item) {
            return this.result(item, 1);
        }

        public JsonBuilder criterion(String string, class_175<?> advancementCriterion) {
            return this;
        }

        public JsonBuilder group(@Nullable String string) {
            this.group = string;
            return this;
        }

        public JsonBuilder markDefault() {
            this.isDefaultRecipe = true;
            return this;
        }

        public void addToDefaults(class_2960 recipeId) {
            if (this.isDefaultRecipe) {
                EmiDefaultsGenerator.addBwtRecipe(recipeId.method_45138("/"));
            }
        }

        public class_1792 method_36441() {
            return this.output.method_8389();
        }

        public void method_10431(class_8790 exporter) {
            this.method_17972(exporter, Id.of("turntable_" + this.fromBlockName));
        }

        public void method_36443(class_8790 exporter, String recipePath) {
            this.method_17972(exporter, Id.of(recipePath));
        }

        public void method_17972(class_8790 exporter, class_2960 recipeId) {
            this.addToDefaults(recipeId);
            class_161.class_162 advancementBuilder = exporter.method_53818().method_705("has_the_recipe", class_2119.method_27847((class_2960)recipeId)).method_703(class_170.class_171.method_753((class_2960)recipeId)).method_704(class_8782.class_8797.field_1257);
            TurntableRecipe turntableRecipe = new TurntableRecipe(Objects.requireNonNullElse(this.group, ""), this.category, this.ingredient, this.output, (List<class_1799>)this.drops);
            exporter.method_53819(recipeId, (class_1860)turntableRecipe, advancementBuilder.method_695(recipeId.method_45138("recipes/" + this.category.method_15434() + "/")));
        }
    }
}

