/*
 * Decompiled with CFR 0.152.
 */
package com.bwt.utils;

import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_2338;
import net.minecraft.class_2382;

public class RadiusAroundBlockStream {
    protected static class_2382 oneDimensionalIndexTo3DCoord(int idx, int xRadius, int yRadius, int zRadius) {
        int yMax = 2 * yRadius + 1;
        int zMax = 2 * zRadius + 1;
        int x = idx / (yMax * zMax);
        int y = (idx -= x * yMax * zMax) / zMax;
        int z = idx % zMax;
        return new class_2382(x -= xRadius, y -= yRadius, z -= zRadius);
    }

    public static Stream<class_2338> radiusAroundBlock3D(class_2338 centerPos, int xRadius, int yRadius, int zRadius, boolean includeSelf) {
        int oneDRange = (2 * xRadius + 1) * (2 * yRadius + 1) * (2 * zRadius + 1);
        Stream<class_2338> stream = IntStream.range(0, oneDRange).mapToObj(idx -> RadiusAroundBlockStream.oneDimensionalIndexTo3DCoord(idx, xRadius, yRadius, zRadius)).map(arg_0 -> ((class_2338)centerPos).method_10081(arg_0));
        if (!includeSelf) {
            stream = stream.filter(pos -> !pos.equals((Object)centerPos));
        }
        return stream;
    }

    public static Stream<class_2338> radiusAroundBlock2D(class_2338 centerPos, int xRadius, int zRadius, boolean includeSelf) {
        return RadiusAroundBlockStream.radiusAroundBlock3D(centerPos, xRadius, 0, zRadius, includeSelf);
    }

    public static Stream<class_2338> allBlocksInRadius(class_2338 centerPos, int radius) {
        return RadiusAroundBlockStream.radiusAroundBlock3D(centerPos, radius, radius, radius, true);
    }

    public static Stream<class_2338> neighboringBlocksInRadius(class_2338 centerPos, int radius) {
        return RadiusAroundBlockStream.radiusAroundBlock3D(centerPos, radius, radius, radius, false);
    }

    public static Stream<class_2338> allBlocksInHorizontalRadius(class_2338 centerPos, int radius) {
        return RadiusAroundBlockStream.radiusAroundBlock2D(centerPos, radius, radius, true);
    }

    public static Stream<class_2338> neighboringBlocksInHorizontalRadius(class_2338 centerPos, int radius) {
        return RadiusAroundBlockStream.radiusAroundBlock2D(centerPos, radius, radius, false);
    }

    public static Stream<class_2338> allNeighbors(class_2338 centerPos) {
        return RadiusAroundBlockStream.neighboringBlocksInRadius(centerPos, 1);
    }

    public static Stream<class_2338> allHorizontalNeighbors(class_2338 centerPos) {
        return RadiusAroundBlockStream.neighboringBlocksInHorizontalRadius(centerPos, 1);
    }
}

