package com.bwt.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.block.*;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public class CornerBlock extends MiniBlock {
    public static final class_2758 ORIENTATION = class_2758.method_11867("orientation", 0, 7);

    private final List<class_265> COLLISION_SHAPES = List.of(
            // bottom - south-west, north-west, north-east, south-east
            class_2248.method_9541(0, 0, 0, 8, 8, 8),
            class_2248.method_9541(8, 0, 0, 16, 8, 8),
            class_2248.method_9541(8, 0, 8, 16, 8, 16),
            class_2248.method_9541(0, 0, 8, 8, 8, 16),
            // top - south-west, north-west, north-east, south-east
            class_2248.method_9541(0, 8, 0, 8, 16, 8),
            class_2248.method_9541(8, 8, 0, 16, 16, 8),
            class_2248.method_9541(8, 8, 8, 16, 16, 16),
            class_2248.method_9541(0, 8, 8, 8, 16, 16)
    );

    public static final MapCodec<CornerBlock> CODEC = CornerBlock.method_54094(s -> new CornerBlock(s, class_2246.field_10340));

    public CornerBlock(class_2251 settings, class_2248 fullBlock) {
        super(settings, fullBlock);
        this.method_9590(this.method_9564().method_11657(ORIENTATION, 0));
    }

    public static CornerBlock ofBlock(class_2248 fullBlock) {
        return new CornerBlock(class_2251.method_9630(fullBlock), fullBlock);
    }

    public static CornerBlock ofWoodBlock(class_2248 woodBlock) {
        CornerBlock cornerBlock = ofBlock(woodBlock);
        cornerBlock.isWood = true;
        return cornerBlock;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(ORIENTATION);
    }

    public MapCodec<? extends CornerBlock> method_53969() {
        return field_46280;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return COLLISION_SHAPES.get(state.method_11654(ORIENTATION));
    }

    @Override
    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2680 state = method_9564().method_11657(WATERLOGGED, ctx.method_8045().method_8316(ctx.method_8037()).method_15772() == class_3612.field_15910);
        class_2338 hitBlockPos = ctx.method_8037();
        class_243 hitPos = ctx.method_17698().method_1023(hitBlockPos.method_10263(), hitBlockPos.method_10264(), hitBlockPos.method_10260());
        double xDistFromCenter = hitPos.method_10216() - 0.5;
        double yDistFromCenter = hitPos.method_10214() - 0.5;
        double zDistFromCenter = hitPos.method_10215() - 0.5;

        int orientation = (yDistFromCenter > 0 ? 4 : 0) +
                (xDistFromCenter > 0
                    ? zDistFromCenter > 0 ? 2 : 1
                    : zDistFromCenter > 0 ? 3 : 0);

        return state.method_11657(ORIENTATION, orientation);
    }

    @Override
    public class_2680 getNextOrientation(class_2680 state) {
        return state.method_11657(ORIENTATION, (state.method_11654(ORIENTATION) + 1) % 8);
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        int orientation = state.method_11654(ORIENTATION);
        int category = orientation / 4;
        int newOrientation = (orientation + 1) % 4 + (4 * category);
        return state.method_11657(ORIENTATION, newOrientation);
    }

    @Override
    protected class_2680 method_9569(class_2680 state, class_2415 mirror) {
        int orientation = state.method_11654(ORIENTATION);
        int newOrientation = switch (mirror) {
            // Invert Z
            case field_11300 -> switch (orientation) {
                case 0 -> 1;
                case 1 -> 0;
                case 2 -> 3;
                case 3 -> 2;
                case 4 -> 5;
                case 5 -> 4;
                case 6 -> 7;
                case 7 -> 6;
                default -> orientation;
            };
            // Invert X
            case field_11301 -> switch (orientation) {
                case 0 -> 3;
                case 1 -> 2;
                case 2 -> 1;
                case 3 -> 0;
                case 4 -> 7;
                case 5 -> 6;
                case 6 -> 5;
                case 7 -> 4;
                default -> orientation;
            };
            default -> orientation;
        };
        return state.method_11657(ORIENTATION, newOrientation);
    }
}
