package com.bwt.blocks;

import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;

public class RedstoneClutchBlock extends GearBoxBlock {
    public static final class_2746 POWERED = class_2741.field_12484;

    public RedstoneClutchBlock(class_2251 settings) {
        super(settings);
        method_9590(method_9564().method_11657(POWERED, false));
    }

    @Override
    public void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(POWERED);
    }

    @Override
    public boolean isMechPowered(class_2680 blockState) {
        return super.isMechPowered(blockState) && !blockState.method_11654(POWERED);
    }

    @Override
    public class_2680 getPowerStates(class_2680 state, class_1937 world, class_2338 pos) {
        return super.getPowerStates(state, world, pos).method_11657(POWERED, world.method_49803(pos));
    }

    @Override
    public void schedulePowerUpdate(class_2680 state, class_1937 world, class_2338 pos) {
        // Compute new state but don't update yet
        class_2680 newState = getPowerStates(state, world, pos);
        boolean isRedstonePowered = newState.method_11654(POWERED);
        boolean wasRedstonePowered = state.method_11654(POWERED);
        boolean isReceivingMechPower = super.isMechPowered(newState);
        boolean wasReceivingMechPower = super.isMechPowered(state);
        // If block just turned on
        if ((!isRedstonePowered && wasRedstonePowered) || (isReceivingMechPower && !wasReceivingMechPower)) {
            world.method_39279(pos, this, turnOnTickRate);
        }
        // If block just turned off
        else if ((isRedstonePowered && !wasRedstonePowered) || (!isReceivingMechPower && wasReceivingMechPower)) {
            world.method_39279(pos, this, turnOffTickRate);
        }
    }
}
