package com.bwt.blocks;

import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1829;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class RopeBlock extends class_2248 {
    public static final class_265 SHAPE = class_2248.method_9541(7, 0, 7, 9, 16, 9);
    public static final class_265 ANCHORED_ABOVE_SHAPE = class_2248.method_9541(7, 16, 7, 9, 26, 9);
    public static final class_265 ANCHORED_BELOW_SHAPE = class_2248.method_9541(7, -10, 7, 9, 0, 9);

    public static final class_2746 ANCHORED_ABOVE = class_2746.method_11825("anchored_above");
    public static final class_2746 ANCHORED_BELOW = class_2746.method_11825("anchored_below");

    public RopeBlock(class_2251 settings) {
        super(settings);
        method_9590(method_9564().method_11657(ANCHORED_BELOW, false).method_11657(ANCHORED_ABOVE, false));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(ANCHORED_ABOVE, ANCHORED_BELOW);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return class_259.method_17786(
                SHAPE,
                state.method_11654(ANCHORED_ABOVE) ? ANCHORED_ABOVE_SHAPE : class_259.method_1073(),
                state.method_11654(ANCHORED_BELOW) ? ANCHORED_BELOW_SHAPE : class_259.method_1073()
        );
    }

    @Override
    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
        if (!fluidState.method_15769()) {
            return null;
        }
        class_2680 upState = ctx.method_8045().method_8320(ctx.method_8037().method_10084());
        class_2680 downState = ctx.method_8045().method_8320(ctx.method_8037().method_10074());
        if (stateValid(upState)) {
            return method_9564()
                    .method_11657(ANCHORED_ABOVE, upState.method_27852(BwtBlocks.anchorBlock) && upState.method_11654(AnchorBlock.field_10927) != class_2350.field_11036)
                    .method_11657(ANCHORED_BELOW, downState.method_27852(BwtBlocks.anchorBlock) && downState.method_11654(AnchorBlock.field_10927) != class_2350.field_11033);
        }
        return null;
    }

    @Override
    public float method_9594(class_2680 state, class_1657 player, class_1922 world, class_2338 pos) {
        if (player.method_6047().method_7909() instanceof class_1829) {
            return 1.0f;
        }
        return super.method_9594(state, player, world, pos);
    }

    @Override
    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (!state.method_26184(world, pos)) {
            world.method_22352(pos, true);
        }
    }

    @Override
    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return stateValid(world.method_8320(pos.method_10084()));
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (!state.method_26184(world, pos)) {
            world.method_39279(pos, this, 1);
        }
        return switch (direction) {
            case field_11036 -> state.method_11657(ANCHORED_ABOVE, neighborState.method_27852(BwtBlocks.anchorBlock) && neighborState.method_11654(AnchorBlock.field_10927) != class_2350.field_11036);
            case field_11033 -> state.method_11657(ANCHORED_BELOW, neighborState.method_27852(BwtBlocks.anchorBlock) && neighborState.method_11654(AnchorBlock.field_10927) != class_2350.field_11033);
            default -> state;
        };
    }

    public boolean stateValid(class_2680 upState) {
        return upState.method_27852(BwtBlocks.ropeBlock)
                || (upState.method_27852(BwtBlocks.anchorBlock) && !upState.method_11654(AnchorBlock.field_10927).equals(class_2350.field_11036)
                || upState.method_27852(BwtBlocks.pulleyBlock));
    }

    public static class_2338 getBottomRopePos(class_1937 world, class_2338 attachmentPos) {
        class_2338.class_2339 mutablePos = attachmentPos.method_25503();
        while (world.method_8320(mutablePos.method_10074()).method_27852(BwtBlocks.ropeBlock)) {
            mutablePos.method_10098(class_2350.field_11033);
        }
        return mutablePos.method_10062();
    }
}
