package com.bwt.blocks;

import com.bwt.utils.BlockUtils;
import com.mojang.serialization.MapCodec;
import net.minecraft.block.*;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import org.jetbrains.annotations.Nullable;

import java.util.Arrays;
import java.util.List;

public class SidingBlock extends MiniBlock {
    public static final class_2753 FACING = class_2741.field_12525;
    protected static final class_238 BOTTOM_SHAPE = new class_238(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);

    protected static final List<class_265> COLLISION_SHAPES = Arrays.stream(class_2350.values())
            .map(direction -> BlockUtils.rotateCuboidFromUp(direction, BOTTOM_SHAPE))
            .toList();
    public static final MapCodec<SidingBlock> field_46280 = SidingBlock.method_54094(s -> new SidingBlock(s, class_2246.field_10340));

    public SidingBlock(class_2251 settings, class_2248 fullBlock) {
        super(settings, fullBlock);
        this.method_9590(this.method_9564().method_11657(FACING, class_2350.field_11043).method_11657(WATERLOGGED, false));
    }

    public static SidingBlock ofBlock(class_2248 fullBlock) {
        return new SidingBlock(class_2251.method_9630(fullBlock), fullBlock);
    }

    public static SidingBlock ofWoodBlock(class_2248 woodBlock) {
        SidingBlock sidingBlock = ofBlock(woodBlock);
        sidingBlock.isWood = true;
        return sidingBlock;
    }

    public MapCodec<? extends SidingBlock> method_53969() {
        return field_46280;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(FACING);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return COLLISION_SHAPES.get(state.method_11654(FACING).method_10146());
    }

    @Override
    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return this.method_9564().method_11657(FACING, ctx.method_7715().method_10153())
                .method_11657(WATERLOGGED, ctx.method_8045().method_8316(ctx.method_8037()).method_15772() == class_3612.field_15910);
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return state.method_11657(FACING, rotation.method_10503(state.method_11654(FACING)));
    }

    @Override
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_11657(FACING, mirror.method_10343(state.method_11654(FACING)));
    }

    public static boolean isHorizontal(class_2680 state) {
        return state.method_11654(FACING).method_10166().method_10179();
    }
}
