package com.bwt.blocks;

import org.jetbrains.annotations.Nullable;

import java.util.Arrays;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_3726;

public class TableBlock extends DecorativeBlock {
    public static final class_2746 SUPPORT = class_2746.method_11825("support");

    class_265 BASE_SHAPE = class_2248.method_9541(0, 15, 0, 16, 16, 16);
    class_265 SUPPORT_SHAPE = class_2248.method_9541(6, 0, 6, 10, 15, 10);

    public TableBlock(class_2251 settings, class_2248 fullBlock) {
        super(settings, fullBlock);
        method_9590(method_9564().method_11657(SUPPORT, true));
    }

    public static TableBlock ofBlock(class_2248 fullBlock) {
        return new TableBlock(class_2251.method_9630(fullBlock), fullBlock);
    }

    public static TableBlock ofWoodBlock(class_2248 woodBlock) {
        TableBlock tableBlock = ofBlock(woodBlock);
        tableBlock.isWood = true;
        return tableBlock;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(SUPPORT);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 view, class_2338 pos, class_3726 context) {
        return state.method_11654(SUPPORT) ? class_259.method_1084(BASE_SHAPE, SUPPORT_SHAPE) : BASE_SHAPE;
    }

    @Nullable
    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return method_9564().method_11657(SUPPORT,
                Arrays.stream(class_2350.class_2351.values())
                        .filter(class_2350.class_2351::method_10179)
                        .noneMatch(axis -> ctx.method_8045().method_8320(ctx.method_8037().method_30513(axis, 1)).method_27852(this) && ctx.method_8045().method_8320(ctx.method_8037().method_30513(axis, -1)).method_27852(this))
        );
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos).method_11657(SUPPORT,
            Arrays.stream(class_2350.class_2351.values())
                    .filter(class_2350.class_2351::method_10179)
                    .noneMatch(axis -> world.method_8320(pos.method_30513(axis, 1)).method_27852(this) && world.method_8320(pos.method_30513(axis, -1)).method_27852(this))
        );
    }
}
