package com.bwt.blocks.axles;

import com.bwt.blocks.BwtBlocks;
import com.bwt.blocks.GearBoxBlock;
import com.bwt.items.BwtItems;
import com.bwt.sounds.BwtSoundEvents;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2465;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class AxleBlock extends class_2465 implements AxlePowerLevelGetter {
    public static final class_2758 MECH_POWER = class_2758.method_11867("mech_power", 0, 3);

    protected static final class_265 X_SHAPE = class_2248.method_9541(0f, 6f, 6f, 16f, 10f, 10f);
    protected static final class_265 Y_SHAPE = class_2248.method_9541(6f, 0f, 6f, 10f, 16f, 10f);
    protected static final class_265 Z_SHAPE = class_2248.method_9541(6f, 6f, 0f, 10f, 10f, 16f);

    public AxleBlock(class_2251 settings) {
        super(settings);
        this.method_9590(this.method_9564().method_11657(field_11459, class_2350.class_2351.field_11051).method_11657(MECH_POWER, 0));
    }

    @Override
    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        updatePowerStates(state, world, pos);
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        world.method_39279(pos, this, 1);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(MECH_POWER);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
        class_2350.class_2351 axis = state.method_11654(field_11459);
        return switch (axis) {
            case field_11048 -> X_SHAPE;
            case field_11052 -> Y_SHAPE;
            case field_11051 -> Z_SHAPE;
        };
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return super.method_9549(state, world, pos, context);
    }

    public class_2680 getNextOrientation(class_2680 blockState) {
        return blockState.method_11657(field_11459, switch (blockState.method_11654(field_11459)) {
            case field_11048 -> class_2350.class_2351.field_11051;
            case field_11051 -> class_2350.class_2351.field_11052;
            case field_11052 -> class_2350.class_2351.field_11048;
        });
    }

    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (!player.method_6047().method_7960()) {
            return class_1269.field_5811;
        }
        class_2680 updatedState = getNextOrientation(state);
        world.method_8501(pos, updatedState);
        world.method_8396(null, pos, updatedState.method_26231().method_10598(),
                class_3419.field_15245, 0.25f, world.field_9229.method_43057() * 0.25F + 0.25F);
        updatePowerStates(updatedState, world, pos);
        return class_1269.field_5812;
    }

    public void breakAxle(class_1937 world, class_2338 pos) {
        world.method_8650(pos, false);
        world.method_8396(null, pos, BwtSoundEvents.MECH_EXPLODE, class_3419.field_15245, 0.5f, 1);
        method_9577(world, pos, class_1802.field_8600.method_7854());
        method_9577(world, pos, BwtItems.hempFiberItem.method_7854());
    }

    public void updatePowerStates(class_2680 state, class_1937 world, class_2338 pos) {
        int currentPower = state.method_11654(MECH_POWER);
        class_2350.class_2351 axis = state.method_11654(field_11459);

        int maxPowerNeighbor = 0;
        int greaterPowerNeighbors = 0;
        for (int i: new int[]{-1, 1}) {
            class_2338 neighborPos = pos.method_30513(axis, i);
            class_2680 neighborState = world.method_8320(neighborPos);

            int neighborPower = 0;
            if (
                    // Gear Box
                    neighborState.method_26204() instanceof GearBoxBlock gearBoxBlock
                    // Powered
                    && gearBoxBlock.isMechPowered(neighborState)
                    // Not getting power from this axle
                    && !neighborPos.method_10093(neighborState.method_11654(GearBoxBlock.field_10927)).equals(pos)
            ) {
                neighborPower = 4;
            }
            else if (neighborState.method_26204() instanceof AxlePowerLevelGetter axlePowerLevelGetter) {
                neighborPower = axlePowerLevelGetter.getMechPowerForNeighbor(neighborState, axis);
            }

            if (neighborPower > maxPowerNeighbor) {
                maxPowerNeighbor = neighborPower;
            }

            if (neighborPower > currentPower) {
                greaterPowerNeighbors++;
            }
        }

        if (greaterPowerNeighbors >= 2) {
            // We're getting power from multiple directions at once
            breakAxle(world, pos);
            return;
        }

        int newPower;

        if (maxPowerNeighbor > currentPower) {
            if (maxPowerNeighbor == 1) {
                // Power has overextended
                breakAxle(world, pos);
                return;
            }
            newPower = maxPowerNeighbor - 1;
        }
        else {
            newPower = 0;
        }

        if (newPower != currentPower) {
            world.method_8501(pos, state.method_11657(MECH_POWER, newPower));
        }
    }

    @Override
    public int getMechPowerForNeighbor(class_2680 state, class_2350.class_2351 axis) {
        return state.method_11654(field_11459).equals(axis) ? state.method_11654(MECH_POWER) : 0;
    }


    @Override
    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        if (world.field_9236) {
            return;
        }
        updatePowerStates(state, world, pos);
    }
}
