package com.bwt.blocks.block_dispenser;

import com.bwt.block_entities.BwtBlockEntities;
import com.bwt.blocks.BwtBlocks;
import com.bwt.blocks.block_dispenser.behavior.dispense.*;
import com.bwt.blocks.block_dispenser.behavior.inhale.BlockInhaleBehavior;
import com.bwt.blocks.block_dispenser.behavior.inhale.EntityInhaleBehavior;
import com.bwt.blocks.block_dispenser.behavior.inhale.VoidInhaleBehavior;
import com.bwt.blocks.mining_charge.MiningChargeBlock;
import com.bwt.blocks.unfired_pottery.UnfiredDecoratedPotBlockEntity;
import com.bwt.entities.MiningChargeEntity;
import com.bwt.items.BwtItems;
import com.bwt.mixin.accessors.DecoratedPotPatternsAccessorMixin;
import com.bwt.recipes.block_dispenser_clump.BlockDispenserClumpRecipe;
import com.bwt.recipes.block_dispenser_clump.BlockDispenserClumpRecipeInput;
import com.bwt.recipes.BwtRecipes;
import com.bwt.sounds.BwtSoundEvents;
import com.bwt.tags.BwtBlockTags;
import com.bwt.tags.BwtEntityTags;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.minecraft.block.*;
import net.minecraft.class_1264;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2347;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_238;
import net.minecraft.class_2415;
import net.minecraft.class_2426;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2965;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3965;
import net.minecraft.class_5575;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_8786;
import net.minecraft.item.*;
import net.minecraft.util.*;
import net.minecraft.util.math.*;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class BlockDispenserBlock extends class_2315 {
    public static final int tickRate = 4;

    private static final Map<Class<? extends class_2248>, class_2357> BLOCK_BEHAVIORS = class_156.method_654(new Object2ObjectOpenHashMap<>(), map -> map.defaultReturnValue(BlockDispenserBehavior.DEFAULT));
    private static final Map<class_1792, class_2357> ITEM_BEHAVIORS = class_156.method_654(new Object2ObjectOpenHashMap<>(), map -> map.defaultReturnValue(new DefaultItemDispenserBehavior()));
    private static final Map<Class<? extends class_2248>, BlockInhaleBehavior> BLOCK_INHALE_BEHAVIORS = class_156.method_654(new Object2ObjectOpenHashMap<>(), map -> map.defaultReturnValue(BlockInhaleBehavior.DEFAULT));
    private static final Map<class_1299<? extends class_1297>, EntityInhaleBehavior> ENTITY_INHALE_BEHAVIORS = class_156.method_654(new Object2ObjectOpenHashMap<>(), map -> map.defaultReturnValue(EntityInhaleBehavior.NOOP));

    public BlockDispenserBlock(class_2251 settings) {
        super(settings);
    }

    protected void inheritItemBehavior(class_1792... items) {
        for (class_1792 item : items) {
            ITEM_BEHAVIORS.put(item, invertStackResult(class_2315.field_10919.get(item)));
        }
    }

    protected static class_2357 invertStackResult(class_2357 behavior) {
        return (pointer, stack) -> {
            int originalCount = stack.method_7947();
            class_1799 overwriteStack = behavior.dispense(pointer, stack);
            int newCount = overwriteStack.method_7947();
            stack.method_7939(originalCount);
            return overwriteStack.method_46651(originalCount - newCount);
        };
    }

    public void registerItemDispenseBehaviors() {
        inheritItemBehavior(
                class_1802.field_8694,

                class_1802.field_8107,
                class_1802.field_8236,
                class_1802.field_8087,
                class_1802.field_8803,

                class_1802.field_8436,
                class_1802.field_8150
        );

        BoatDispenserBehavior boatDispenserBehavior = new BoatDispenserBehavior();
        Stream.of(
                class_1802.field_8533,
                class_1802.field_8486,
                class_1802.field_8442,
                class_1802.field_8730,
                class_1802.field_8138,
                class_1802.field_8094,
                class_1802.field_42706,
                class_1802.field_37531,
                class_1802.field_40224,
                class_1802.field_38216,
                class_1802.field_38217,
                class_1802.field_38218,
                class_1802.field_38212,
                class_1802.field_38214,
                class_1802.field_38213,
                class_1802.field_42707,
                class_1802.field_38215,
                class_1802.field_40225
        ).forEach(item -> registerItemDispenseBehavior(item, boatDispenserBehavior));

        MinecartDispenserBehavior minecartDispenserBehavior = new MinecartDispenserBehavior();
        Stream.of(
                class_1802.field_8045,
                class_1802.field_8388,
                class_1802.field_8220,
                class_1802.field_8220,
                class_1802.field_8063,
                class_1802.field_8836,
                class_1802.field_8069
        ).forEach(item -> registerItemDispenseBehavior(item, minecartDispenserBehavior));

        registerVanillaAndBDProjectileBehaviors(
                BwtItems.dynamiteItem,
                BwtItems.broadheadArrowItem,
                BwtItems.rottedArrowItem,
                BwtItems.soulUrnItem
        );

        class_2347 miningChargeBehavior = new class_2347(){
            @Override
            protected class_1799 method_10135(class_2342 pointer, class_1799 stack) {
                class_3218 world = pointer.comp_1967();
                class_2338 blockPos = pointer.comp_1968().method_10093(pointer.comp_1969().method_11654(class_2315.field_10918));
                class_2350 direction = pointer.comp_1969().method_11654(class_2315.field_10918);
                class_2680 placementState = BwtBlocks.miningChargeBlock.getDispenserPlacmentState(
                        new BlockDispenserPlacementContext(pointer.comp_1967(), blockPos, direction, stack, direction)
                );
                MiningChargeEntity miningChargeEntity = new MiningChargeEntity(world, blockPos.method_46558().method_1023(0, 0.5, 0), placementState, null);
                world.method_8649(miningChargeEntity);
                world.method_43128(null, miningChargeEntity.method_23317(), miningChargeEntity.method_23318(), miningChargeEntity.method_23321(), BwtSoundEvents.MINING_CHARGE_PRIME, class_3419.field_15245, 1.0f, 1.0f);
                world.method_33596(null, class_5712.field_28738, blockPos);
                stack.method_7934(1);
                return stack;
            }
        };
        registerBlockDispenseBehavior(MiningChargeBlock.class, invertStackResult(miningChargeBehavior));
        class_2315.method_10009(BwtBlocks.miningChargeBlock, miningChargeBehavior);

        registerBlockDispenseBehavior(class_2426.class, new BlockDispenserBehavior() {
            @Override
            protected class_1799 method_10135(class_2342 pointer, class_1799 stack) {
                class_1799 result = super.method_10135(pointer, stack);
                if (method_27954()) {
                    class_2350 direction = pointer.comp_1969().method_11654(class_2315.field_10918);
                    class_2338 blockPos = pointer.comp_1968().method_10093(direction);
                    pointer.comp_1967().method_42308(
                            direction.method_10153(),
                            pointer.comp_1969(),
                            blockPos,
                            pointer.comp_1968(),
                            class_2248.field_31036 & ~(class_2248.field_31027 | class_2248.field_31032),
                            511
                    );
                }
                return result;
            }
        });

        registerSherdBehaviors();
    }

    private void registerSherdBehaviors() {
        class_2347 sherdBehavior = new class_2347() {
            @Override
            protected class_1799 method_10135(class_2342 pointer, class_1799 stack) {
                class_3218 world = pointer.comp_1967();
                class_2350 direction = pointer.comp_1969().method_11654(class_2315.field_10918);
                class_2338 blockPos = pointer.comp_1968().method_10093(direction);
                class_2680 blockState = world.method_8320(blockPos);
                if (!blockState.method_27852(BwtBlocks.unfiredDecoratedPotBlock) && !blockState.method_27852(BwtBlocks.unfiredDecoratedPotBlockWithSherds)) {
                    return super.method_10135(pointer, stack);
                }
                if (blockState.method_27852(BwtBlocks.unfiredDecoratedPotBlock)) {
                    blockState = BwtBlocks.unfiredDecoratedPotBlockWithSherds.method_9564();
                    world.method_30092(blockPos, blockState, class_2248.field_31028, 0);
                }
                class_2350 side = direction.method_10153();
                if (side.method_10166().method_10178()) {
                    return stack;
                }
                class_2586 blockEntity = world.method_8321(blockPos);
                if (!(blockEntity instanceof UnfiredDecoratedPotBlockEntity unfiredDecoratedPotBlockEntity)) {
                    return stack;
                }
                if (!world.field_9236 && unfiredDecoratedPotBlockEntity.tryAddSherd(side, stack.method_7909())) {
                    stack.method_7934(1);
                }
                return stack;
            }
        };
        ArrayList<class_1792> sherds = new ArrayList<>(DecoratedPotPatternsAccessorMixin.getSHERD_TO_PATTERN().keySet());
        sherds.forEach(sherd -> class_2315.method_10009(sherd, sherdBehavior));
        inheritItemBehavior(sherds.toArray(class_1792[]::new));
    }

    public static void registerEntityInhaleBehavior(class_1299<?> entityType, EntityInhaleBehavior behavior) {
        ENTITY_INHALE_BEHAVIORS.put(entityType, behavior);
    }

    public static void registerBlockInhaleBehavior(Class<? extends class_2248> blockClass, BlockInhaleBehavior behavior) {
        BLOCK_INHALE_BEHAVIORS.put(blockClass, behavior);
    }

    public static void registerItemDispenseBehavior(class_1935 item, class_2357 behavior) {
        ITEM_BEHAVIORS.put(item.method_8389(), behavior);
    }

    public static void registerBlockDispenseBehavior(Class<? extends class_2248> blockClass, class_2357 behavior) {
        BLOCK_BEHAVIORS.put(blockClass, behavior);
    }

    public static void registerVanillaAndBDProjectileBehaviors(class_1792... items) {
        for (class_1792 item : items) {
            class_2357 projectileBehavior = new class_2965(item);
            registerItemDispenseBehavior(item, invertStackResult(projectileBehavior));
            class_2315.method_10009(item, projectileBehavior);
        }
    }

    public void registerBehaviors() {
        EntityInhaleBehavior.registerBehaviors();
        BlockInhaleBehavior.registerBehaviors();
        BlockDispenserBehavior.registerBehaviors();
    }

    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new BlockDispenserBlockEntity(pos, state);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return this.method_9564().method_11657(field_10918, ctx.method_7715().method_10153()).method_11657(field_10920, false);
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        if (isReceivingPower(world, pos, state.method_11654(field_10918))) {
            world.method_39279(pos, this, tickRate);
        }
    }

    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        class_1264.method_54291(state, newState, world, pos);
        super.method_9536(state, world, pos, newState, moved);
    }

    @Override
    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        if (world.field_9236) {
            return;
        }
        if (state.method_11654(field_10920) != isReceivingPower(world, pos, state.method_11654(field_10918))) {
            world.method_39279(pos, this, tickRate);
        }
    }

    @Override
    protected class_1269 method_55766(class_2680 blockState, class_1937 world, class_2338 blockPos, class_1657 player, class_3965 hit) {
        if (world.field_9236) return class_1269.field_5812;
        world.method_35230(blockPos, BwtBlockEntities.blockDispenserBlockEntity).ifPresent(player::method_17355);
        return class_1269.field_21466;
    }

    public boolean isReceivingPower(class_1937 world, class_2338 pos, class_2350 facing) {
        return Arrays.stream(class_2350.values())
                .filter(direction -> direction != facing)
                .anyMatch(direction -> world.method_49807(pos.method_10093(direction), direction));
    }

    @Override
    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        boolean powered = isReceivingPower(world, pos, state.method_11654(field_10918));
        if (powered) {
            world.method_8501(pos, state.method_11657(field_10920, true));
            dispenseBlockOrItem(world, state, pos);
        }
        else {
            world.method_8501(pos, state.method_11657(field_10920, false));
            consumeBlockOrEntity(world, state, pos);
        }
    }

    public void dispenseBlockOrItem(class_3218 world, class_2680 state, class_2338 pos) {
        BlockDispenserBlockEntity blockEntity = ((BlockDispenserBlockEntity) world.method_8321(pos));
        if (blockEntity == null) {
            return;
        }

        class_2338 targetPos = pos.method_10093(state.method_11654(field_10918));
        class_2680 targetState = world.method_8320(targetPos);

        class_1799 stackToPlace = blockEntity.getCurrentItemToDispense();
        if (stackToPlace.method_7960()) {
            return;
        }

        class_2342 blockPointer = new class_2342(world, pos, state, blockEntity);
        class_2357 dispenserBehavior = this.getDispenseBehaviorForItem(world, targetState, blockEntity, stackToPlace);
        if (dispenserBehavior != class_2357.field_16902) {
            class_1799 takenOut = dispenserBehavior.dispense(blockPointer, stackToPlace);
            blockEntity.take(takenOut.method_7909(), takenOut.method_7947());
        }
        blockEntity.advanceSelectedSlot();
    }

    public void consumeBlockOrEntity(class_3218 world, class_2680 state, class_2338 pos) {
        BlockDispenserBlockEntity blockEntity = ((BlockDispenserBlockEntity) world.method_8321(pos));
        if (blockEntity == null) {
            return;
        }

        class_2338 targetPos = pos.method_10093(state.method_11654(field_10918));
        class_2680 targetState = world.method_8320(targetPos);
        Optional<? extends class_1297> optionalEntity = this.getInhaleableEntity(world, targetPos);
        if (optionalEntity.isPresent()) {
            class_1297 entity = optionalEntity.get();
            inhaleEntity(blockEntity, entity);
            return;
        }

        class_2342 blockPointer = new class_2342(world, pos, state, blockEntity);
        BlockInhaleBehavior inhaleBehavior = this.getInhaleBehaviorForItem(targetState);
        if (inhaleBehavior == BlockInhaleBehavior.NOOP) {
            return;
        }
        class_1799 inhaledItems = inhaleBehavior.getInhaledItems(blockPointer);
        if (!blockEntity.hasRoomFor(inhaledItems)) {
            return;
        }
        inhaleBehavior.inhale(blockPointer);
        blockEntity.insert(inhaledItems.method_7972());
    }

    protected class_2357 getDispenseBehaviorForItem(class_1937 world, class_2680 targetState, BlockDispenserBlockEntity entity, class_1799 stack) {
        // Block Behavior. Block items will not clump
        if (stack.method_7909() instanceof class_1747 blockItem) {
            if (!targetState.method_26164(class_3481.field_44471)) {
                return BlockDispenserBehavior.field_16902;
            }
            return BLOCK_BEHAVIORS.entrySet().stream()
                    .filter(entry -> entry.getKey().isInstance(blockItem.method_7711()))
                    .findAny()
                    .map(Map.Entry::getValue)
                    .orElse(BlockDispenserBehavior.DEFAULT);
        }

        BlockDispenserClumpRecipeInput recipeInput = new BlockDispenserClumpRecipeInput(entity.getItems());
        Optional<BlockDispenserClumpRecipe> match = world.method_8433().method_8132(
                BwtRecipes.BLOCK_DISPENSER_CLUMP_RECIPE_TYPE,
                recipeInput,
                world
        ).map(class_8786::comp_1933);

        if (match.isEmpty()) {
            return ITEM_BEHAVIORS.get(stack.method_7909());
        }

        // Proceeding with clump recipe behavior
        BlockDispenserClumpRecipe recipe = match.get();
        if (recipe.canAfford(entity) && targetState.method_26164(class_3481.field_44471)) {
            return new ItemClumpDispenserBehavior(recipe, stack.method_7909());
        }
        else {
            return BlockDispenserBehavior.field_16902;
        }
    }

    protected Optional<class_1297> getInhaleableEntity(class_1937 world, class_2338 targetPos) {
        ArrayList<class_1297> entities = Lists.newArrayList();
        world.method_47574(
                class_5575.method_31795(class_1297.class),
                new class_238(targetPos),
                class_1301.field_6155.and(entity ->
                        entity.method_5864().method_20210(BwtEntityTags.BLOCK_DISPENSER_INHALE_ENTITIES)
                        && ENTITY_INHALE_BEHAVIORS.getOrDefault(entity.method_5864(), EntityInhaleBehavior.NOOP).canInhale(entity)
                ),
                entities
        );
        return entities.stream().findAny();
    }

    protected <T extends class_1297> void inhaleEntity(BlockDispenserBlockEntity blockEntity, T entity) {
        EntityInhaleBehavior entityInhaleBehavior = ENTITY_INHALE_BEHAVIORS.get(entity.method_5864());
        class_1799 inhaledItems = entityInhaleBehavior.getInhaledItems(entity).method_7972();
        if (!blockEntity.hasRoomFor(inhaledItems)) {
            return;
        }
        entityInhaleBehavior.inhale(entity);
        blockEntity.insert(inhaledItems);
        entityInhaleBehavior.getDroppedItems(entity).forEach(entity::method_5775);
    }

    protected BlockInhaleBehavior getInhaleBehaviorForItem(class_2680 targetState) {
        if (targetState.method_26164(BwtBlockTags.BLOCK_DISPENSER_INHALE_NOOP)) {
            return BlockInhaleBehavior.NOOP;
        }
        if (targetState.method_26164(BwtBlockTags.BLOCK_DISPENSER_INHALE_VOID)) {
            return BlockInhaleBehavior.VOID;
        }
        return BLOCK_INHALE_BEHAVIORS.entrySet().stream()
                .filter(entry -> entry.getKey().isInstance(targetState.method_26204()))
                .findAny()
                .map(Map.Entry::getValue)
                .orElse(BlockInhaleBehavior.DEFAULT);
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return state.method_11657(field_10918, rotation.method_10503(state.method_11654(field_10918)));
    }

    @Override
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_11657(field_10918, mirror.method_10343(state.method_11654(field_10918)));
    }
}
