package com.bwt.blocks.block_dispenser;

import com.bwt.BetterWithTime;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3913;
import net.minecraft.class_3919;

public class BlockDispenserScreenHandler extends class_1703 {
    private final class_1263 inventory;

    private static final int SIZE = 16;

    private final class_3913 propertyDelegate;

    public BlockDispenserScreenHandler(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, new class_1277(SIZE), new class_3919(1));
    }

    //This constructor gets called from the BlockEntity on the server without calling the other constructor first, the server knows the inventory of the container
    //and can therefore directly provide it as an argument. This inventory will then be synced to the client.
    public BlockDispenserScreenHandler(int syncId, class_1661 playerInventory, class_1263 inventory, class_3913 propertyDelegate) {
        super(BetterWithTime.blockDispenserScreenHandler, syncId);
        method_17359(inventory, SIZE);
        this.inventory = inventory;
        this.propertyDelegate = propertyDelegate;
        inventory.method_5435(playerInventory.field_7546);
        this.method_17360(propertyDelegate);

        int m;
        int l;
        // BD inventory
        for (m = 0; m < 4; ++m) {
            for (l = 0; l < 4; ++l) {
                this.method_7621(new class_1735(inventory, l + m * 4, 53 + l * 18, 17 + m * 18));
            }
        }
        // Player inventory
        for (m = 0; m < 3; ++m) {
            for (l = 0; l < 9; ++l) {
                this.method_7621(new class_1735(playerInventory, l + m * 9 + 9, 8 + l * 18, 102 + m * 18));
            }
        }
        // Player hotbar
        for (m = 0; m < 9; ++m) {
            this.method_7621(new class_1735(playerInventory, m, 8 + m * 18, 160));
        }
    }

    @Override
    public boolean method_7597(class_1657 player) {
        return this.inventory.method_5443(player);
    }

    // Shift + Player Inv Slot
    @Override
    public class_1799 method_7601(class_1657 player, int slot) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slot2 = this.field_7761.get(slot);
        if (slot2.method_7681()) {
            class_1799 itemStack2 = slot2.method_7677();
            itemStack = itemStack2.method_7972();
            if (slot < SIZE ? !this.method_7616(itemStack2, SIZE, 36 + SIZE, true) : !this.method_7616(itemStack2, 0, SIZE, false)) {
                return class_1799.field_8037;
            }
            if (itemStack2.method_7960()) {
                slot2.method_53512(class_1799.field_8037);
            } else {
                slot2.method_7668();
            }
            if (itemStack2.method_7947() == itemStack.method_7947()) {
                return class_1799.field_8037;
            }
            slot2.method_7667(player, itemStack2);
        }
        return itemStack;
    }

    @Override
    public void method_7593(int slotIndex, int button, class_1713 actionType, class_1657 player) {
        super.method_7593(slotIndex, button, actionType, player);
        setSelectedSlot(0);
    }

    public int getSelectedSlot() {
        return this.propertyDelegate.method_17390(0);
    }

    public void setSelectedSlot(int slotToSelect) {
        this.propertyDelegate.method_17391(0, slotToSelect);
    }
}


