package com.bwt.blocks.block_dispenser.behavior.dispense;

import com.bwt.blocks.block_dispenser.BlockDispenserPlacementContext;
import com.mojang.logging.LogUtils;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2350;
import net.minecraft.class_2970;
import org.slf4j.Logger;

public class BlockDispenserBehavior extends class_2970 {
    protected static final Logger LOGGER = LogUtils.getLogger();

    public static BlockDispenserBehavior DEFAULT = new BlockDispenserBehavior();

    boolean dropIfPlacementFails;
    public BlockDispenserBehavior(boolean dropIfPlacementFails) {
        super();
        this.dropIfPlacementFails = dropIfPlacementFails;
    }

    public BlockDispenserBehavior() {
        this(false);
    }

    @Override
    protected class_1799 method_10135(class_2342 pointer, class_1799 stack) {
        this.method_27955(false);
        class_1792 item = stack.method_7909();
        class_1799 placementStack = stack.method_46651(1);
        class_1799 returnStack = stack.method_46651(1);
        if (item instanceof class_1747 blockItem) {
            class_2350 direction = pointer.comp_1969().method_11654(class_2315.field_10918);
            class_2338 blockPos = pointer.comp_1968().method_10093(direction);

            try {
                BlockDispenserPlacementContext context = new BlockDispenserPlacementContext(pointer.comp_1967(), blockPos, direction, placementStack, direction);
                boolean accepted = blockItem.method_7712(context).method_23665();
                method_27955(accepted);
                if (!accepted && dropIfPlacementFails) {
                    new DefaultItemDispenserBehavior().method_10135(pointer, returnStack);
                    method_27955(true);
                }
            } catch (Exception exception) {
                field_34020.error("Error trying to place block at {}", blockPos, exception);
            }
        }
        if (method_27954()) {
            return returnStack;
        }
        else {
            return class_1799.field_8037;
        }
    }

    public static void registerBehaviors() {
    }
}
