package com.bwt.blocks.block_dispenser.behavior.inhale;

import com.bwt.blocks.BwtBlocks;
import com.bwt.blocks.block_dispenser.BlockDispenserBlock;
import com.bwt.blocks.block_dispenser.BlockDispenserBlockEntity;
import net.minecraft.block.*;
import net.minecraft.class_1799;
import net.minecraft.class_2244;
import net.minecraft.class_2282;
import net.minecraft.class_2302;
import net.minecraft.class_2320;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_5542;
import net.minecraft.class_5712;

public interface BlockInhaleBehavior {
    BlockInhaleBehavior NOOP = new BlockInhaleBehavior() {
        @Override
        public class_1799 getInhaledItems(class_2342 blockPointer) {
            return class_1799.field_8037;
        }
        @Override
        public void inhale(class_2342 blockPointer) {}
    };
    BlockInhaleBehavior VOID = new VoidInhaleBehavior();

    BlockInhaleBehavior DEFAULT = new DefaultBlockInhaleBehavior();

    class_1799 getInhaledItems(class_2342 blockPointer);

    void inhale(class_2342 blockPointer);

    default void breakBlockNoItems(class_3218 world, class_2680 state, class_2338 pos) {
        if (state.method_26164(class_3481.field_51989)) {
            return;
        }
        world.method_8650(pos, false);
        world.method_43276(class_5712.field_28165, pos, class_5712.class_7397.method_43286(null, state));
        class_2498 soundGroup = state.method_26231();
        world.method_8396(null, pos, soundGroup.method_10595(), class_3419.field_15245, (soundGroup.method_10597() + 1.0f) / 2.0f, soundGroup.method_10599() * 0.8f);
    }

    default void breakBlockNoItems(class_3218 world, class_2338 pos) {
        breakBlockNoItems(world, world.method_8320(pos), pos);
    }

    default void breakBlockNoItems(class_2342 blockPointer) {
        class_2338 facingPos = blockPointer.comp_1968().method_10093(blockPointer.comp_1969().method_11654(BlockDispenserBlock.field_10918));
        class_2680 facingState = blockPointer.comp_1967().method_8320(facingPos);
        breakBlockNoItems(blockPointer.comp_1967(), facingState, facingPos);
    }

    static void registerBehaviors() {
        BlockDispenserBlock.registerBlockInhaleBehavior(class_2302.class, new CropInhaleBehavior());
        BlockDispenserBlock.registerBlockInhaleBehavior(class_2282.class, new CocoaBeanInhaleBehavior());
        BlockDispenserBlock.registerBlockInhaleBehavior(class_5542.class, new AmethystInhaleBehavior());
        BlockDispenserBlock.registerBlockInhaleBehavior(class_2323.class, new DoubleTallBlockInhaleBehavior());
        BlockDispenserBlock.registerBlockInhaleBehavior(class_2320.class, new DoubleTallBlockInhaleBehavior());
        BlockDispenserBlock.registerBlockInhaleBehavior(class_2244.class, new BedBlockInhaleBehavior());
        BlockDispenserBlock.registerBlockInhaleBehavior(BlockDispenserBlock.class, new BlockInhaleBehavior() {
            @Override
            public class_1799 getInhaledItems(class_2342 blockPointer) {
                return BwtBlocks.blockDispenserBlock.method_8389().method_7854();
            }

            @Override
            public void inhale(class_2342 blockPointer) {
                class_2338 blockDispenserPos = blockPointer.comp_1968().method_10093(blockPointer.comp_1969().method_11654(BlockDispenserBlock.field_10918));
                class_2586 blockEntity = blockPointer.comp_1967().method_8321(blockDispenserPos);
                if (blockEntity instanceof BlockDispenserBlockEntity blockDispenserBlockEntity) {
                    blockDispenserBlockEntity.method_5448();
                }
                breakBlockNoItems(blockPointer.comp_1967(), blockDispenserPos);
            }
        });
    }
}
