package com.bwt.blocks.block_dispenser.behavior.inhale;

import com.bwt.blocks.BwtBlocks;
import com.bwt.blocks.block_dispenser.BlockDispenserBlock;
import com.bwt.mixin.accessors.ArmorStandAccessorMixin;
import com.bwt.utils.DyeUtils;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1428;
import net.minecraft.class_1472;
import net.minecraft.class_1493;
import net.minecraft.class_1531;
import net.minecraft.class_1533;
import net.minecraft.class_1534;
import net.minecraft.class_1688;
import net.minecraft.class_1690;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2371;
import net.minecraft.class_3417;
import net.minecraft.class_5915;
import net.minecraft.class_9334;

public interface EntityInhaleBehavior {
    default class_1799 getInhaledItems(class_1297 entity) {
        return class_1799.field_8037;
    }
    default class_2371<class_1799> getDroppedItems(class_1297 entity) {
        return class_2371.method_10211();
    }

    default boolean canInhale(class_1297 entity) {
        return true;
    }
    void inhale(class_1297 entity);

    EntityInhaleBehavior NOOP = new EntityInhaleBehavior() {
        @Override
        public boolean canInhale(class_1297 entity) {return false;}
        @Override
        public void inhale(class_1297 entity) {}
    };

    static void registerBehaviors() {
        BlockDispenserBlock.registerEntityInhaleBehavior(class_1299.field_6055, new EntityInhaleBehavior() {
            @Override
            public boolean canInhale(class_1297 entity) {
                return (entity instanceof class_1493 wolf) && !wolf.method_6109();
            }

            @Override
            public void inhale(class_1297 entity) {
                class_1493 wolf = ((class_1493) entity);
                wolf.method_5650(class_1297.class_5529.field_26998);
                wolf.method_5783(class_3417.field_14659, 0.4f, wolf.method_6017());
            }

            @Override
            public class_1799 getInhaledItems(class_1297 entity) {
                class_1799 itemStack = new class_1799(BwtBlocks.companionCubeBlock);
                itemStack.method_57379(class_9334.field_49631, entity.method_5797());
                return itemStack;
            }

            @Override
            public class_2371<class_1799> getDroppedItems(class_1297 entity) {
                return class_2371.method_10212(class_1799.field_8037, new class_1799(class_1802.field_8276), new class_1799(class_1802.field_8276));
            }
        });
        BlockDispenserBlock.registerEntityInhaleBehavior(class_1299.field_6132, new EntityInhaleBehavior() {
            @Override
            public boolean canInhale(class_1297 entity) {
                return (entity instanceof class_1428 chicken) && !chicken.method_6109();
            }

            @Override
            public void inhale(class_1297 entity) {
                if (!(entity instanceof class_1428 chicken)) {
                    return;
                }
                chicken.method_5650(class_1297.class_5529.field_26998);
                chicken.method_5783(class_3417.field_15140, 0.4f, chicken.method_6017());
            }

            @Override
            public class_1799 getInhaledItems(class_1297 entity) {
                class_1799 itemStack = new class_1799(class_1802.field_8803);
                itemStack.method_57379(class_9334.field_49631, entity.method_5797());
                return itemStack;
            }

            @Override
            public class_2371<class_1799> getDroppedItems(class_1297 entity) {
                return class_2371.method_10212(class_1799.field_8037, new class_1799(class_1802.field_8153));
            }
        });

        BlockDispenserBlock.registerEntityInhaleBehavior(class_1299.field_6115, new EntityInhaleBehavior() {
            @Override
            public boolean canInhale(class_1297 entity) {
                return (entity instanceof class_1472 sheep) && sheep.method_27072();
            }

            @Override
            public void inhale(class_1297 entity) {
                class_1472 sheep = ((class_1472) entity);
                sheep.method_5783(class_3417.field_14730, 0.4f, sheep.method_6017());
            }

            @Override
            public class_1799 getInhaledItems(class_1297 entity) {
                return new class_1799(DyeUtils.WOOL_COLORS.get(((class_1472) entity).method_6633()).method_8389());
            }

            @Override
            public class_2371<class_1799> getDroppedItems(class_1297 entity) {
                ((class_1472) entity).method_6635(true);
                return class_2371.method_10212(class_1799.field_8037, new class_1799(class_1802.field_8276));
            }
        });

        EntityInhaleBehavior minecartBehavior = new EntityInhaleBehavior() {
            @Override
            public boolean canInhale(class_1297 entity) {
                return (entity instanceof class_1688 minecart) && minecart.method_5805();
            }

            @Override
            public void inhale(class_1297 entity) {
                if (!(entity instanceof class_1688 minecart)) {
                    return;
                }
                minecart.method_5768();
            }

            @Override
            public class_1799 getInhaledItems(class_1297 entity) {
                class_1799 itemStack = (itemStack = entity.method_31480()) == null ? class_1799.field_8037 : itemStack;
                itemStack.method_57379(class_9334.field_49631, entity.method_5797());
                return itemStack;
            }
        };
        Stream.of(
                class_1299.field_6096,
                class_1299.field_6126,
                class_1299.field_6136,
                class_1299.field_6136,
                class_1299.field_6080,
                class_1299.field_6058,
                class_1299.field_6053
        ).forEach(minecart -> BlockDispenserBlock.registerEntityInhaleBehavior(minecart, minecartBehavior));


        EntityInhaleBehavior boatBehavior = new EntityInhaleBehavior() {
            @Override
            public boolean canInhale(class_1297 entity) {
                return (entity instanceof class_1690 boat) && boat.method_5805();
            }

            @Override
            public void inhale(class_1297 entity) {
                if (!(entity instanceof class_1690 boat)) {
                    return;
                }
                boat.method_5768();
            }

            @Override
            public class_1799 getInhaledItems(class_1297 entity) {
                class_1799 itemStack = (itemStack = entity.method_31480()) == null ? class_1799.field_8037 : itemStack;
                itemStack.method_57379(class_9334.field_49631, entity.method_5797());
                return itemStack;
            }
        };
        Stream.of(class_1299.field_6121, class_1299.field_38096).forEach(boat -> BlockDispenserBlock.registerEntityInhaleBehavior(boat, boatBehavior));

        BlockDispenserBlock.registerEntityInhaleBehavior(class_1299.field_6131, new EntityInhaleBehavior() {
            @Override
            public void inhale(class_1297 entity) {
                if (!(entity instanceof class_1531 armorStand)) {
                    return;
                }
                armorStand.method_5768();
            }

            @Override
            public class_1799 getInhaledItems(class_1297 entity) {
                class_1799 itemStack = (itemStack = entity.method_31480()) == null ? class_1799.field_8037 : itemStack;
                itemStack.method_57379(class_9334.field_49631, entity.method_5797());
                return itemStack;
            }

            @Override
            public class_2371<class_1799> getDroppedItems(class_1297 entity) {
                if (!(entity instanceof class_1531 armorStand)) {
                    return class_2371.method_10211();
                }
                class_2371<class_1799> heldItems = ((ArmorStandAccessorMixin) armorStand).getHeldItems();
                class_2371<class_1799> armorItems = ((ArmorStandAccessorMixin) armorStand).getArmorItems();
                class_2371<class_1799> returnItems = class_2371.method_10211();
                returnItems.addAll(heldItems);
                returnItems.addAll(armorItems);
                return returnItems;
            }
        });

        BlockDispenserBlock.registerEntityInhaleBehavior(class_1299.field_6043, new EntityInhaleBehavior() {
            @Override
            public void inhale(class_1297 entity) {
                if (!(entity instanceof class_1533 itemFrame)) {
                    return;
                }
                itemFrame.method_5768();
            }

            @Override
            public class_1799 getInhaledItems(class_1297 entity) {
                class_1799 itemStack = (itemStack = entity.method_31480()) == null ? class_1799.field_8037 : itemStack;
                itemStack.method_57379(class_9334.field_49631, entity.method_5797());
                return itemStack;
            }

            @Override
            public class_2371<class_1799> getDroppedItems(class_1297 entity) {
                if (!(entity instanceof class_1533 itemFrame)) {
                    return class_2371.method_10211();
                }
                class_2371<class_1799> returnItems = class_2371.method_10211();
                returnItems.add(itemFrame.method_6940());
                return returnItems;
            }
        });

        BlockDispenserBlock.registerEntityInhaleBehavior(class_1299.field_28401, new EntityInhaleBehavior() {
            @Override
            public void inhale(class_1297 entity) {
                if (!(entity instanceof class_5915 itemFrame)) {
                    return;
                }
                itemFrame.method_5768();
            }

            @Override
            public class_1799 getInhaledItems(class_1297 entity) {
                class_1799 itemStack = (itemStack = entity.method_31480()) == null ? class_1799.field_8037 : itemStack;
                itemStack.method_57379(class_9334.field_49631, entity.method_5797());
                return itemStack;
            }

            @Override
            public class_2371<class_1799> getDroppedItems(class_1297 entity) {
                if (!(entity instanceof class_5915 itemFrame)) {
                    return class_2371.method_10211();
                }
                class_2371<class_1799> returnItems = class_2371.method_10211();
                returnItems.add(itemFrame.method_6940());
                return returnItems;
            }
        });

        BlockDispenserBlock.registerEntityInhaleBehavior(class_1299.field_6120, new EntityInhaleBehavior() {
            @Override
            public void inhale(class_1297 entity) {
                if (!(entity instanceof class_1534 painting)) {
                    return;
                }
                painting.method_5768();
            }

            @Override
            public class_1799 getInhaledItems(class_1297 entity) {
                class_1799 itemStack = (itemStack = entity.method_31480()) == null ? class_1799.field_8037 : itemStack;
                itemStack.method_57379(class_9334.field_49631, entity.method_5797());
                return itemStack;
            }
        });
    }
}
