package com.bwt.blocks.blood_wood;

import com.bwt.features.BwtConfiguredFeatures;
import com.bwt.utils.Id;
import net.fabricmc.fabric.api.object.builder.v1.block.type.BlockSetTypeBuilder;
import net.fabricmc.fabric.api.object.builder.v1.block.type.WoodTypeBuilder;
import net.minecraft.block.*;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2354;
import net.minecraft.class_2378;
import net.minecraft.class_2440;
import net.minecraft.class_2465;
import net.minecraft.class_2482;
import net.minecraft.class_2498;
import net.minecraft.class_2510;
import net.minecraft.class_2533;
import net.minecraft.class_2766;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_4719;
import net.minecraft.class_4970;
import net.minecraft.class_5793;
import net.minecraft.class_5794;
import net.minecraft.class_7923;
import net.minecraft.class_8177;
import net.minecraft.class_8813;
import java.util.Optional;

public class BloodWoodBlocks {
    public class_8177 blockSetType;
    public class_4719 woodType;
    public class_5794 blockFamily;

    public class_2248 logBlock;
    public class_2248 strippedLogBlock;
    public class_2248 woodBlock;
    public class_2248 strippedWoodBlock;
    public class_2248 leavesBlock;
    public class_2248 saplingBlock;
    public class_1747 saplingItem;
    public class_2248 pottedSaplingBlock;

    public class_2248 planksBlock;
    public class_2248 buttonBlock;
    public class_2248 fenceBlock;
    public class_2248 fenceGateBlock;
    public class_2248 pressurePlateBlock;
    public class_2248 slabBlock;
    public class_2248 stairsBlock;
    public class_2248 doorBlock;
    public class_2248 trapdoorBlock;


    public BloodWoodBlocks initialize() {
        blockSetType = BlockSetTypeBuilder.copyOf(class_8177.field_42830).register(Id.of("blood_wood"));
        woodType = WoodTypeBuilder.copyOf(class_4719.field_22183).register(Id.of("blood_wood"), blockSetType);

        logBlock = new BloodWoodLogBlock(class_4970.class_2251.method_9637().method_51520(state -> state.method_11654(BloodWoodLogBlock.field_11459) == class_2350.class_2351.field_11052 ? class_3620.field_25704 : class_3620.field_16025).method_51368(class_2766.field_12651).method_9632(2.0f).method_9626(class_2498.field_22152).method_50013());
        strippedLogBlock = class_2246.method_47375(class_3620.field_25704, class_3620.field_16025, class_2498.field_22152);
        woodBlock = new class_2465(class_4970.class_2251.method_9630(class_2246.field_22505));
        strippedWoodBlock = new class_2465(class_4970.class_2251.method_9630(class_2246.field_22505));

        leavesBlock = new BloodWoodLeavesBlock(
                class_4970.class_2251.method_9637()
                        .method_31710(class_3620.field_16004)
                        .method_9632(0.2F)
                        .method_9640()
                        .method_9626(class_2498.field_11535)
                        .method_22488()
                        .method_26235(class_2246::method_26126)
                        .method_26243(class_2246::method_26122)
                        .method_26245(class_2246::method_26122)
                        .method_50013()
                        .method_50012(class_3619.field_15971)
                        .method_26236(class_2246::method_26122)
        );
        saplingBlock = new BloodWoodSaplingBlock(
                new class_8813(
                        Id.of("blood_wood").toString(),
                        Optional.empty(),
                        Optional.of(BwtConfiguredFeatures.BLOOD_WOOD_KEY),
                        Optional.empty()
                ),
                class_4970.class_2251.method_9630(class_2246.field_10394).method_31710(class_3620.field_16020)
        );
        saplingItem = new class_1747(saplingBlock, new class_1792.class_1793());
        pottedSaplingBlock = class_2246.method_50000(saplingBlock);

        planksBlock = new class_2248(class_4970.class_2251.method_9630(class_2246.field_22126));
        buttonBlock = class_2246.method_45451(blockSetType);
        fenceBlock = new class_2354(class_4970.class_2251.method_9630(class_2246.field_22132));
        fenceGateBlock = new class_2349(woodType, class_4970.class_2251.method_9630(class_2246.field_22096));
        pressurePlateBlock = new class_2440(blockSetType, class_4970.class_2251.method_9630(class_2246.field_22130));
        slabBlock = new class_2482(class_4970.class_2251.method_9630(class_2246.field_22128));
        stairsBlock = new class_2510(planksBlock.method_9564(), class_4970.class_2251.method_9630(class_2246.field_22098));
        doorBlock = new class_2323(blockSetType, class_4970.class_2251.method_9630(class_2246.field_22102));
        trapdoorBlock = new class_2533(blockSetType, class_4970.class_2251.method_9630(class_2246.field_22094));

        blockFamily = class_5793.method_33468(planksBlock)
                .method_33482(buttonBlock)
                .method_33490(fenceBlock)
                .method_33491(fenceGateBlock)
                .method_33494(pressurePlateBlock)
                .method_33492(slabBlock)
                .method_33493(stairsBlock)
                .method_33489(doorBlock)
                .method_33496(trapdoorBlock)
                .method_33484("wooden")
                .method_33487("has_planks")
                .method_33481();
        return this;
    }

    public void register() {
        class_2378.method_10230(class_7923.field_41175, Id.of("blood_wood_log"), logBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("blood_wood_log"), new class_1747(logBlock, new class_1792.class_1793()));
        class_2378.method_10230(class_7923.field_41175, Id.of("stripped_blood_wood_log"), strippedLogBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("stripped_blood_wood_log"), new class_1747(strippedLogBlock, new class_1792.class_1793()));
        class_2378.method_10230(class_7923.field_41175, Id.of("blood_wood_wood"), woodBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("blood_wood_wood"), new class_1747(woodBlock, new class_1792.class_1793()));
        class_2378.method_10230(class_7923.field_41175, Id.of("stripped_blood_wood"), strippedWoodBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("stripped_blood_wood"), new class_1747(strippedWoodBlock, new class_1792.class_1793()));
        class_2378.method_10230(class_7923.field_41175, Id.of("blood_wood_leaves"), leavesBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("blood_wood_leaves"), new class_1747(leavesBlock, new class_1792.class_1793()));
        class_2378.method_10230(class_7923.field_41175, Id.of("blood_wood_sapling"), saplingBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("blood_wood_sapling"), saplingItem);
        class_2378.method_10230(class_7923.field_41175, Id.of("potted_blood_wood_sapling"), pottedSaplingBlock);
        class_2378.method_10230(class_7923.field_41175, Id.of("blood_wood_planks"), planksBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("blood_wood_planks"), new class_1747(planksBlock, new class_1792.class_1793()));
        class_2378.method_10230(class_7923.field_41175, Id.of("blood_wood_button"), buttonBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("blood_wood_button"), new class_1747(buttonBlock, new class_1792.class_1793()));
        class_2378.method_10230(class_7923.field_41175, Id.of("blood_wood_fence"), fenceBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("blood_wood_fence"), new class_1747(fenceBlock, new class_1792.class_1793()));
        class_2378.method_10230(class_7923.field_41175, Id.of("blood_wood_fence_gate"), fenceGateBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("blood_wood_fence_gate"), new class_1747(fenceGateBlock, new class_1792.class_1793()));
        class_2378.method_10230(class_7923.field_41175, Id.of("blood_wood_pressure_plate"), pressurePlateBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("blood_wood_pressure_plate"), new class_1747(pressurePlateBlock, new class_1792.class_1793()));
        class_2378.method_10230(class_7923.field_41175, Id.of("blood_wood_slab"), slabBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("blood_wood_slab"), new class_1747(slabBlock, new class_1792.class_1793()));
        class_2378.method_10230(class_7923.field_41175, Id.of("blood_wood_stairs"), stairsBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("blood_wood_stairs"), new class_1747(stairsBlock, new class_1792.class_1793()));
        class_2378.method_10230(class_7923.field_41175, Id.of("blood_wood_door"), doorBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("blood_wood_door"), new class_1747(doorBlock, new class_1792.class_1793()));
        class_2378.method_10230(class_7923.field_41175, Id.of("blood_wood_trapdoor"), trapdoorBlock);
        class_2378.method_10230(class_7923.field_41178, Id.of("blood_wood_trapdoor"), new class_1747(trapdoorBlock, new class_1792.class_1793()));
    }
}
