package com.bwt.blocks.detector;

import com.bwt.blocks.BwtBlocks;
import com.bwt.blocks.SimpleFacingBlock;
import com.bwt.blocks.lens.LensBlock;
import com.bwt.sounds.BwtSoundEvents;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2390;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DetectorBlock extends SimpleFacingBlock {
    public static final class_2746 POWERED = class_2741.field_12484;
    private static final int tickRate = 4;

    public DetectorBlock(class_2251 settings) {
        super(settings);
        method_9590(method_9564().method_11657(POWERED, false));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(POWERED);
    }

    @NotNull
    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return super.method_9605(ctx).method_11657(POWERED, false);
    }

    @Override
    protected void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        super.method_9615(state, world, pos, oldState, notify);
        world.method_39279(pos, this, tickRate);
    }

    @Override
    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        super.method_9612(state, world, pos, sourceBlock, sourcePos, notify);
        boolean detected = checkForDetection(world, pos, state);
        boolean wasDetected = state.method_11654(POWERED);
        if (detected != wasDetected) {
            world.method_39279(pos, this, tickRate);
        }
    }

    @Override
    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        super.method_9588(state, world, pos, random);
        boolean placedLogic = placeDetectorLogicIfNecessary(world, pos, state);
        boolean detected = checkForDetection(world, pos, state);
        boolean wasDetected = state.method_11654(POWERED);

        if (state.method_11654(field_10927).equals(class_2350.field_11036)) {
            // facing upwards...check for rain or snow
            detected |= world.method_8311(pos.method_10084()) && world.method_8520(pos.method_10084());

            // upward facing blocks have to periodically poll for weather changes
            // or they risk missing them.
            world.method_39279(pos, this, tickRate);
        }

        if (detected) {
            if (!wasDetected) {
                world.method_8652(pos, state.method_11657(POWERED, true), class_2248.field_31036);
                world.method_8396(
                        null,
                        pos,
                        BwtSoundEvents.DETECTOR_CLICK,
                        class_3419.field_15245,
                        1.0f,
                        2f
                );
            }
        }
        else {
            if (wasDetected) {
                if (!placedLogic) {
                    world.method_8652(pos, state.method_11657(POWERED, false), class_2248.field_31036);
                    world.method_8396(
                            null,
                            pos,
                            BwtSoundEvents.DETECTOR_CLICK,
                            class_3419.field_15245,
                            1.0f,
                            2f
                    );
                }
                else {
                    // if we just placed the logic block, then wait a tick until we turn off
                    // to give it a chance to detect anything that might be there
                    world.method_39279(pos, this, tickRate);
                }
            }
        }
    }

    @Override
    public boolean method_9506(class_2680 state) {
        return true;
    }

    @Override
    public int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        return state.method_11654(POWERED) ? 15 : 0;
    }

    /*
     * returns true if a new logic block needed to be placed
     */
    public boolean placeDetectorLogicIfNecessary(class_1937 world, class_2338 pos, class_2680 state) {
        class_2350 facing = state.method_11654(field_10927);
        class_2338 targetPos = pos.method_10093(facing);
        class_2680 targetState = world.method_8320(targetPos);

        if (targetState.method_26164(class_3481.field_51989) && !targetState.method_27852(BwtBlocks.detectorLogicBlock) && !targetState.method_27852(BwtBlocks.lensBeamBlock)) {
            world.method_30092(targetPos, BwtBlocks.detectorLogicBlock.method_9564(), class_2248.field_31036, 0);
            return true;
        }
        return false;
    }

    public void removeDetectorLogicIfNecessary(class_1937 world, class_2338 pos, class_2680 state) {
        class_2350 facing = state.method_11654(field_10927);
        class_2338 targetPos = pos.method_10093(facing);
        class_2680 targetState = world.method_8320(targetPos);

        if (targetState.method_27852(BwtBlocks.detectorLogicBlock) && !DetectorLogicBlock.anyNeighborDetectors(world, targetPos)) {
            world.method_30092(targetPos, class_2246.field_10124.method_9564(), class_2248.field_31036, 0);
        }
    }


    public boolean checkForDetection(class_1937 world, class_2338 pos, class_2680 state) {
        class_2350 facing = state.method_11654(field_10927);
        class_2338 targetPos = pos.method_10093(facing);
        class_2680 targetState = world.method_8320(targetPos);

        if (targetState.method_26164(class_3481.field_51989) && !targetState.method_27852(BwtBlocks.detectorLogicBlock) && !targetState.method_27852(BwtBlocks.lensBeamBlock)) {
            // We haven't placed the logic block yet, return false for now
            return false;
        }
        if (targetState.method_27852(BwtBlocks.lensBlock) && targetState.method_11654(LensBlock.field_10927).equals(facing.method_10153())) {
            return targetState.method_11654(LensBlock.LIT);
        }
        if (!targetState.method_27852(BwtBlocks.detectorLogicBlock)) {
            // Logic block was replaced with something else
            return true;
        }
        // facing upwards...check for rain or snow
        if (state.method_11654(field_10927).equals(class_2350.field_11036)
                && world.method_8311(pos.method_10084()) && world.method_8520(pos.method_10084())) {
            return true;
        }
        return DetectorLogicBlock.isEnabled(targetState);
    }

    @Override
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        if (!state.method_11654(POWERED)) {
            return;
        }
        class_2350 facing = state.method_11654(field_10927);
        class_2338 blockPos = pos.method_10093(facing);
        if (world.method_8320(blockPos).method_26216(world, blockPos)) return;
        class_2350.class_2351 axis = facing.method_10166();
        double e = axis == class_2350.class_2351.field_11048 ? 0.5 + 0.5625 * (double)facing.method_10148() : (double)random.method_43057();
        double f = axis == class_2350.class_2351.field_11052 ? 0.5 + 0.5625 * (double)facing.method_10164() : (double)random.method_43057();
        double g = axis == class_2350.class_2351.field_11051 ? 0.5 + 0.5625 * (double)facing.method_10165() : (double)random.method_43057();
        world.method_8406(class_2390.field_11188, (double)pos.method_10263() + e, (double)pos.method_10264() + f, (double)pos.method_10260() + g, 0.0, 0.0, 0.0);
    }

    @Override
    protected void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        super.method_9536(state, world, pos, newState, moved);
        if (!newState.method_27852(this)) {
            removeDetectorLogicIfNecessary(world, pos, state);
        }
    }
}
