package com.bwt.blocks.detector;

import com.bwt.blocks.BwtBlocks;
import com.bwt.tags.BwtBlockTags;
import com.google.common.collect.Lists;
import net.minecraft.block.*;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2189;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_3218;
import net.minecraft.class_5575;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;

public class DetectorLogicBlock extends class_2189 {
    private static final int tickRate = 4;
    public static final class_2746 ENTITY_INTERSECT = class_2746.method_11825("entity_intersect");
    public static final class_2746 BLOCK_INTERSECT = class_2746.method_11825("block_intersect");

    public DetectorLogicBlock(class_2251 settings) {
        super(settings);
        method_9590(method_9564().method_11657(ENTITY_INTERSECT, false).method_11657(BLOCK_INTERSECT, false));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(ENTITY_INTERSECT);
        builder.method_11667(BLOCK_INTERSECT);
    }

    public static boolean isEnabled(class_2680 state) {
        return state.method_11654(ENTITY_INTERSECT) || state.method_11654(BLOCK_INTERSECT);
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        world.method_39279(pos, this, tickRate);
        return state;
    }

    @Override
    protected void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        if (!world.method_8608() && !state.method_27852(oldState.method_26204())) {
            world.method_39279(pos, this, tickRate);
        }
    }

    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!newState.method_27852(this)) {
            notifyNeighborDetectors(newState, world, pos);
        }
    }

    @Override
    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        super.method_9548(state, world, pos, entity);
        boolean updated = updateIntersectStates(state, world, pos, true, null);
        if (updated) {
            world.method_39279(pos, this, tickRate);
        }
    }

    @Override
    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        super.method_9588(state, world, pos, random);
        boolean blockIntersect = anyBlocksIntersecting(world.method_8320(pos.method_10074()));
        boolean entityIntersect = anyEntitiesIntersecting(world, pos);
        if (entityIntersect) {
            // Need to keep checking for the entity leaving
            world.method_39279(pos, this, tickRate);
        }
        if (!updateIntersectStates(state, world, pos, entityIntersect, blockIntersect)) {
            // Detector block is gone, and the logic block is now destroyed
            return;
        }
    }

    protected boolean anyBlocksIntersecting(class_2680 neighborState) {
        return neighborState.method_26164(BwtBlockTags.DETECTABLE_SMALL_CROPS)
                && neighborState.method_28500(class_2302.field_10835).orElse(0)
                >= ((class_2302) neighborState.method_26204()).method_9827();
    }

    protected boolean anyEntitiesIntersecting(class_1937 world, class_2338 pos) {
        ArrayList<class_1297> list = Lists.newArrayList();
        world.method_47575(
                class_5575.method_31795(class_1297.class),
                new class_238(pos),
                class_1301.field_6155,
                list,
                1
        );
        return !list.isEmpty();
    }

    protected boolean updateIntersectStates(class_2680 state, class_1937 world, class_2338 pos, @Nullable Boolean entityIntersect, @Nullable Boolean blockIntersect) {
        if ((entityIntersect == null || entityIntersect == state.method_11654(ENTITY_INTERSECT))
            && (blockIntersect == null || blockIntersect == state.method_11654(BLOCK_INTERSECT))
        ) {
            return false;
        }
        if (entityIntersect != null) {
            state = state.method_11657(ENTITY_INTERSECT, entityIntersect);
        }
        if (blockIntersect != null) {
            state = state.method_11657(BLOCK_INTERSECT, blockIntersect);
        }
        world.method_30092(pos, state, class_2248.field_31036, 0);
        int detectorsUpdated = notifyNeighborDetectors(state, world, pos);
        if (detectorsUpdated == 0) {
            world.method_30092(pos, class_2246.field_10124.method_9564(), class_2248.field_31036, 0);
            return false;
        }
        return true;
    }

    public static boolean anyNeighborDetectors(class_1936 world, class_2338 pos) {
        for (class_2350 direction : class_2350.values()) {
            class_2338 targetPos = pos.method_10093(direction);
            class_2680 neighborState = world.method_8320(targetPos);
            if (neighborState.method_27852(BwtBlocks.detectorBlock) && neighborState.method_11654(DetectorBlock.field_10927).equals(direction.method_10153())) {
                return true;
            }
        }
        return false;
    }

    public int notifyNeighborDetectors(class_2680 state, class_1937 world, class_2338 pos) {
        int numDetectorsUpdated = 0;
        for (class_2350 direction : class_2350.values()) {
            class_2338 targetPos = pos.method_10093(direction);
            class_2680 neighborState = world.method_8320(targetPos);
            if (neighborState.method_27852(BwtBlocks.detectorBlock) && neighborState.method_11654(DetectorBlock.field_10927).equals(direction.method_10153())) {
                numDetectorsUpdated += 1;
                world.method_42308(direction.method_10153(), state, targetPos, pos, class_2248.field_31036 & ~(class_2248.field_31027 | class_2248.field_31032), 512);
                world.method_41410(neighborState, targetPos, state.method_26204(), pos, false);
            }
        }
        return numDetectorsUpdated;
    }
}
