package com.bwt.blocks.lens;

import com.mojang.serialization.MapCodec;
import net.minecraft.block.*;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_3726;
import net.minecraft.class_8567;
import java.util.List;
import java.util.Map;

public class LensBeamGlassBlock extends LensBeamBlock {
    public static final MapCodec<LensBeamGlassBlock> CODEC = method_54094(s -> new LensBeamGlassBlock(class_2246.field_10033, s));

    public final class_2248 glassBlock;
    protected final class_2680 glassState;

    public LensBeamGlassBlock(class_2248 glassBlock, class_2251 settings) {
        super(settings);
        this.glassBlock = glassBlock;
        this.glassState = glassBlock.method_9564();
    }

    @Override
    protected MapCodec<LensBeamGlassBlock> method_53969() {
        return field_46280;
    }

    @Override
    protected void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        super.method_9615(state, world, pos, oldState, notify);
        if (!(state.method_26204() instanceof LensBeamBlock lensBeamBlock) || state.equals(oldState)) {
            return;
        }
        for (Map.Entry<class_2350, class_2746> entry : FACING_PROPERTIES.entrySet()) {
            class_2350 direction = entry.getKey();
            class_2746 facingProperty = entry.getValue();
            class_2680 neighborState = world.method_8320(pos.method_10093(direction.method_10153()));
            if (!LensBeamHelper.isValidInputBeamOrLens(neighborState, direction)) {
                state = state.method_11657(facingProperty, false);
            }
            else {
                int range = LensBeamHelper.getRemainingRange(world, pos, direction);
                LensBeamHelper.propagateBeam(world, pos, state, direction, range);
            }
        }
        if (LensBeamHelper.streamFacingDirections(state).findAny().isEmpty()) {
            world.method_8501(pos, lensBeamBlock.getStateLeftOverWhenEmpty(world, pos));
        }
    }

    @Override
    protected class_265 method_26159(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return class_259.method_1073();
    }

    @Override
    protected float method_9575(class_2680 state, class_1922 world, class_2338 pos) {
        return 1.0F;
    }

    @Override
    protected boolean method_9579(class_2680 state, class_1922 world, class_2338 pos) {
        return true;
    }

    @Override
    protected class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Override
    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return glassState.method_26172(world, pos, context);
    }

    @Override
    protected boolean method_9522(class_2680 state, class_2680 stateFrom, class_2350 direction) {
        return stateFrom.method_27852(this)
                || stateFrom.method_27852(this.glassBlock)
                || super.method_9522(state, stateFrom, direction);
    }

    @Override
    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        glassState.method_26178(world, pos, entity);
    }

    @Override
    protected List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        return glassState.method_26189(builder);
    }

    @Override
    public class_2680 getStateLeftOverWhenEmpty(class_1936 world, class_2338 pos) {
        return glassState;
    }
}
