package com.bwt.blocks.lens;

import com.bwt.blocks.BwtBlocks;
import com.bwt.blocks.detector.DetectorBlock;
import com.bwt.gamerules.BwtGameRules;
import com.bwt.utils.BlockPosAndState;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_3481;
import net.minecraft.class_5575;
import net.minecraft.class_7165;

public class LensBeamHelper {
    protected static boolean anyEntitiesIntersecting(class_1937 world, class_2338 pos) {
        ArrayList<class_1297> list = Lists.newArrayList();
        world.method_47575(
                class_5575.method_31795(class_1297.class),
                new class_238(pos),
                class_1301.field_6155,
                list,
                1
        );
        return !list.isEmpty();
    }

    protected static int getRemainingRange(class_1937 world, class_2338 pos, class_2350 direction) {
        class_2338.class_2339 mutable = pos.method_25503();
        int distanceFromLens = 0;
        int maxRange = world.method_8450().method_8356(BwtGameRules.LENS_BEAM_RANGE);
        while (distanceFromLens < maxRange) {
            mutable.method_10098(direction.method_10153());
            distanceFromLens++;
            class_2680 possibleLensBlockState = world.method_8320(mutable);
            if (possibleLensBlockState.method_27852(BwtBlocks.lensBeamBlock)) {
                if (possibleLensBlockState.method_11654(LensBeamBlock.FACING_PROPERTIES.get(direction))) {
                    continue;
                }
                break;
            }
            if (possibleLensBlockState.method_27852(BwtBlocks.lensBlock)) {
                break;
            }
        }
        return maxRange - distanceFromLens;
    }

    public static void fireBeam(class_1937 world, class_2338 lensPos, class_2680 lensState) {
        propagateBeam(world, lensPos, lensState, lensState.method_11654(LensBlock.field_10927), world.method_8450().method_8356(BwtGameRules.LENS_BEAM_RANGE));
    }

    public static void killBeam(class_1937 world, class_2338 originPos, class_2350 facing) {
        class_2338 targetPos = originPos;
        class_2680 targetState;
        while (true) {
            targetPos = targetPos.method_10093(facing);
            targetState = world.method_8320(targetPos);
            if (!(targetState.method_26204() instanceof LensBeamBlock) || !targetState.method_11654(LensBeamBlock.FACING_PROPERTIES.get(facing))) {
                break;
            }
            removeBeam(world, targetPos, targetState, facing);
        }
    }

    public static void propagateBeam(class_1937 world, class_2338 originBeamPos, class_2680 originBeamState, class_2350 facing, int range) {
        if (range <= 0) {
            return;
        }
        if (!(originBeamState.method_26204() instanceof LensBeamBlock) && !originBeamState.method_27852(BwtBlocks.lensBlock)) {
            return;
        }

        class_2338 targetPos = originBeamPos.method_10093(facing);
        class_2680 targetState = world.method_8320(targetPos);
        class_2248 targetBlock = targetState.method_26204();
        LensBeamBlock lensBeamBlock = targetBlock instanceof LensBeamBlock beamBlock ? beamBlock : null;
        boolean targetBlockIsBeamPermeable = targetState.method_26164(class_3481.field_51989)
                || targetState.method_27852(BwtBlocks.lensBeamGlassBlock)
                || targetState.method_27852(BwtBlocks.lensBeamGlassBlock.glassBlock);
        boolean targetBlockIsForwardFacingBeam = lensBeamBlock != null && targetState.method_11654(LensBeamBlock.FACING_PROPERTIES.get(facing));
        // if the first block is solid, or if it's a beam already being fired in the correct direction,
        // do nothing.
        if (!targetBlockIsBeamPermeable || targetBlockIsForwardFacingBeam) {
            if (!targetBlockIsBeamPermeable && originBeamState.method_26204() instanceof LensBeamBlock) {
                setTerminus(world, originBeamPos, originBeamState, true);
            }
            return;
        }
        boolean entitiesIntersecting = anyEntitiesIntersecting(world, targetPos);
        targetState = addBeam(world, targetPos, targetState, facing, entitiesIntersecting);

        if (entitiesIntersecting) {
            return;
        }

        propagateBeam(world, targetPos, targetState, facing, range - 1);

    }

    public static class_2680 addBeam(class_1937 world, class_2338 targetPos, class_2680 targetState, class_2350 facingToAdd, boolean entitiesIntersecting) {
        class_2680 newState = targetState;
        if (!(newState.method_26204() instanceof LensBeamBlock)) {
            if (newState.method_26164(class_3481.field_51989)) {
                newState = BwtBlocks.lensBeamBlock.method_9564();
            }
            else if (newState.method_27852(BwtBlocks.lensBeamGlassBlock.glassBlock)) {
                newState = BwtBlocks.lensBeamGlassBlock.method_9564();
            }
        }
        newState = newState.method_11657(LensBeamBlock.FACING_PROPERTIES.get(facingToAdd), true)
                .method_11657(LensBeamBlock.TERMINUS, entitiesIntersecting || newState.method_11654(LensBeamBlock.TERMINUS));
        world.method_8652(targetPos, newState, class_2248.field_31028 | class_2248.field_31031);
        return newState;
    }

    public static void removeBeam(class_1937 world, class_2338 targetPos, class_2680 targetState, class_2350 facingToRemove) {
        class_2680 newState = targetState.method_11657(LensBeamBlock.FACING_PROPERTIES.get(facingToRemove), false);
        boolean replacedWithAir = false;
        boolean terminusModified;
        if (streamFacingDirections(newState).findAny().isEmpty()) {
            newState = newState.method_26204() instanceof LensBeamBlock beamBlock
                    ? beamBlock.getStateLeftOverWhenEmpty(world, targetPos)
                    : class_2246.field_10124.method_9564();
            terminusModified = targetState.method_11654(LensBeamBlock.TERMINUS);
            replacedWithAir = newState.method_26164(class_3481.field_51989);
        }
        else {
            newState = newState.method_11657(LensBeamBlock.TERMINUS, anyNeighborNotPropagable(world, targetPos, newState));
            terminusModified = targetState.method_11654(LensBeamBlock.TERMINUS) != newState.method_11654(LensBeamBlock.TERMINUS);
        }
        world.method_8652(targetPos, newState, class_2248.field_31028 | (terminusModified ? 0 : class_2248.field_31031));
        if (replacedWithAir || terminusModified) {
            for (class_2350 direction : class_7165.field_37839) {
                BlockPosAndState neighborPosAndState = BlockPosAndState.of(world, targetPos.method_10093(direction));
                boolean facingIntoNeighbor = targetState.method_11654(LensBeamBlock.FACING_PROPERTIES.get(direction)) && !neighborPosAndState.state().method_26164(class_3481.field_51989);
                boolean detectorFacingIntoBeam = neighborPosAndState.state().method_27852(BwtBlocks.detectorBlock) && neighborPosAndState.state().method_11654(DetectorBlock.field_10927).equals(direction.method_10153());
                if (detectorFacingIntoBeam || (facingIntoNeighbor && terminusModified)) {
                    world.method_41410(neighborPosAndState.state(), neighborPosAndState.pos(), newState.method_26204(), targetPos, false);
                }
                if (facingIntoNeighbor && terminusModified) {
                    world.method_42308(direction.method_10153(), newState, neighborPosAndState.pos(), targetPos, class_2248.field_31028, 512);
                }
            }
        }
    }

    public static boolean anyNeighborNotPropagable(class_1936 world, class_2338 pos, class_2680 state) {
        return streamFacingDirections(state).map(Map.Entry::getKey)
                .map(pos::method_10093)
                .map(world::method_8320)
                .anyMatch(blockState -> !blockState.method_26164(class_3481.field_51989)
                        && !blockState.method_27852(BwtBlocks.lensBeamGlassBlock)
                        && !blockState.method_27852(BwtBlocks.lensBeamGlassBlock.glassBlock));
    }

    public static class_2680 setTerminus(class_1937 world, class_2338 pos, class_2680 state, boolean terminus) {
        if (state.method_11654(LensBeamBlock.TERMINUS) != terminus) {
            state = state.method_11657(LensBeamBlock.TERMINUS, terminus);
            world.method_8652(pos, state, class_2248.field_31036);
        }
        return state;
    }

    public static boolean isValidInputBeamOrLens(class_2680 neighborState, class_2350 directionToThisBlock) {
        return (neighborState.method_27852(BwtBlocks.lensBlock) && neighborState.method_11654(LensBlock.field_10927).equals(directionToThisBlock) && neighborState.method_11654(LensBlock.LIT))
                || (neighborState.method_26204() instanceof LensBeamBlock && neighborState.method_11654(LensBeamBlock.FACING_PROPERTIES.get(directionToThisBlock)));
    }

    public static Stream<Map.Entry<class_2350, class_2746>> streamFacingDirections(class_2680 state) {
        return LensBeamBlock.FACING_PROPERTIES.entrySet().stream()
                .filter(entry -> state.method_11654(entry.getValue()));
    }
}
