package com.bwt.blocks.lens;

import com.bwt.blocks.BwtBlocks;
import com.bwt.blocks.RotateWithEmptyHand;
import com.bwt.blocks.SimpleFacingBlock;
import com.bwt.blocks.detector.DetectorBlock;
import com.bwt.utils.BlockPosAndState;
import net.minecraft.class_1750;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class LensBlock extends SimpleFacingBlock implements RotateWithEmptyHand {
    public static class_2746 LIT = class_2741.field_12548;

    private final static int lensTickRate = 1;
    private final static float minTriggerLightValue = 12;


    public LensBlock(class_2251 settings) {
        super(settings);
        method_9590(method_9564().method_11657(field_10927, class_2350.field_11043).method_11657(LIT, false));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(LIT);
    }

    @Override
    public @NotNull class_2680 method_9605(class_1750 ctx) {
        return super.method_9605(ctx).method_11657(field_10927, ctx.method_7715().method_10153());
    }

    @Override
    protected void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        super.method_9615(state, world, pos, oldState, notify);
        world.method_39279(pos, this, lensTickRate);
    }

    @Override
    protected void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        super.method_9536(state, world, pos, newState, moved);
        if (!newState.method_27852(this) || !newState.method_11654(field_10927).equals(state.method_11654(field_10927))) {
            LensBeamHelper.killBeam(world, pos, state.method_11654(field_10927));
        }
    }

    @Override
    protected class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (!world.method_8397().method_8677(pos, this)) {
            world.method_39279(pos, this, lensTickRate);
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        class_2350 facing = state.method_11654(field_10927);
        boolean isLightDetector = isDirectlyFacingBlockDetector(world, pos, state);

        if (isLightDetector) {
            class_2338 sourcePos = pos.method_10093(facing.method_10153());

            int sourceLightValue = world.method_22339(sourcePos);

            boolean shouldBeOn =  sourceLightValue >= 8;

            if (state.method_11654(LIT) != shouldBeOn ) {
                setBlockState(world, pos, state.method_11657(LIT, shouldBeOn));
            }

            // schedule another update immediately to check for light changes
            world.method_39279(pos, this, lensTickRate);
        }
        else {
            boolean lightOn = hasEnoughDirectInputLight(world, pos, state);
            if (state.method_11654(LIT) != lightOn) {
                setBlockState(world, pos, state.method_11657(LIT, lightOn));
            }
            if (lightOn) {
                LensBeamHelper.fireBeam(world, pos, state);
            }
            else {
                LensBeamHelper.killBeam(world, pos, facing);
            }
        }
    }


    private boolean hasEnoughDirectInputLight(class_1937 world, class_2338 pos, class_2680 state) {
        class_2350 facing = state.method_11654(field_10927);
        class_2350 targetFacing = facing.method_10153();

        class_2680 targetState = world.method_8320(pos.method_10093(targetFacing));

        if (targetState.method_26164(class_3481.field_51989) && !targetState.method_27852(BwtBlocks.lensBeamBlock)) {
            return false;
        }
        if (targetState.method_27852(this)) {
            // Lenses can feed directly into each other
            return targetState.method_11654(LIT) && targetState.method_11654(field_10927) == facing;
        }
        if (targetState.method_26213() > minTriggerLightValue) {
            // only power the lens with a terminus lens beam if it is facing directly into it.
            return !(targetState.method_26204() instanceof LensBeamBlock)
                    || targetState.method_11654(LensBeamBlock.FACING_PROPERTIES.get(facing));
        }

        return false;
    }

    private boolean isDirectlyFacingBlockDetector(class_1937 world, class_2338 pos, class_2680 state) {
        class_2350 facing = state.method_11654(field_10927);
        BlockPosAndState targetPosAndState = BlockPosAndState.of(world, pos.method_10093(facing));
        if (!targetPosAndState.state().method_27852(BwtBlocks.detectorBlock)) {
            return false;
        }
        return targetPosAndState.state().method_11654(DetectorBlock.field_10927) == facing.method_10153();
    }

    public static void setBlockState(class_1937 world, class_2338 pos, class_2680 state) {
        world.method_8652(pos, state, class_2248.field_31028 | class_2248.field_31031);
        for (class_2350 direction : class_2350.values()) {
            if (direction.equals(state.method_11654(field_10927).method_10153())) {
                continue;
            }
            class_2338 targetPos = pos.method_10093(direction);
            class_2680 neighborState = world.method_8320(targetPos);
            world.method_42308(direction.method_10153(), state, targetPos, pos, class_2248.field_31036 & ~(class_2248.field_31027 | class_2248.field_31032), 511);
            world.method_41410(neighborState, targetPos, state.method_26204(), pos, false);
        }
    }
}
