package com.bwt.blocks.mining_charge;

import com.bwt.entities.BwtEntities;
import com.bwt.entities.MiningChargeEntity;
import com.bwt.utils.RadiusAroundBlockStream;
import net.minecraft.class_1282;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2048;
import net.minecraft.class_215;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_47;
import net.minecraft.class_5341;
import net.minecraft.class_5361;
import net.minecraft.class_5362;
import net.minecraft.class_6880;
import net.minecraft.loot.condition.*;
import org.jetbrains.annotations.NotNull;

import java.util.List;

public class MiningChargeExplosion extends class_1927 {
    public static final class_5341 LOOT_CONDITION = class_215.method_917(
            class_47.class_50.field_935,
            class_2048.class_2049.method_8916().method_8921(BwtEntities.miningChargeEntity)
    ).build();

    protected final class_1937 world;
    protected final class_5362 behavior;
    protected final MiningChargeEntity miningChargeEntity;
    protected final class_1282 damageSource;

    public MiningChargeExplosion(class_1937 world, @NotNull MiningChargeEntity entity, class_243 pos, class_1282 damageSource, float power, boolean createFire, class_4179 destructionType, class_2394 particle, class_2394 emitterParticle, class_6880<class_3414> soundEvent) {
        super(world, entity, damageSource, null, pos.field_1352, pos.field_1351, pos.field_1350, power, createFire, destructionType, particle, emitterParticle, soundEvent);
        this.world = world;
        this.behavior = new class_5361(entity);
        this.miningChargeEntity = entity;
        this.damageSource = damageSource;
    }

    public void method_8348() {
        super.method_8348();
        method_8346().clear();
        damageBlocks();
    }

    protected void damageBlocks() {
        class_2338 entityBlockPos = class_2338.method_49638(method_55109());

        if (!canDestroyBlock(entityBlockPos)) {
            // we are in a block that's too tough to destroy.  Abort.
            return;
        }

        // offset the blast so that it is centered on the block to which we are attached
        class_2338 targetPos = entityBlockPos.method_10093(miningChargeEntity.method_58149().method_10153());

        if (canDestroyBlock(targetPos)) {
            // we are attached to a block that's too tough to destroy.  Center the blast on the charge's
            // position
            targetPos = class_2338.method_49638(method_55109());
        }

        List<class_2338> affectedBlocks = method_8346();
        RadiusAroundBlockStream
                .allBlocksInRadius(targetPos, 1)
                .filter(this::canDestroyBlock)
                .forEach(affectedBlocks::add);

        // resolve the extra block of penetration towards our facing.

        targetPos = targetPos.method_10093(miningChargeEntity.method_58149().method_10153());

        if (!canDestroyBlock(targetPos)) {
            // the block between the source and extra block is too tough, abort
            return;
        }

        targetPos = targetPos.method_10093(miningChargeEntity.method_58149().method_10153());

        if (canDestroyBlock(targetPos)) {
            // the block between the source and extra block is too tough, abort
            method_8346().add(targetPos);
        }
    }

    protected boolean canDestroyBlock(class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        float power = method_55107() - behavior.method_29555(this, world, pos, state, state.method_26227())
                .map(val -> (val + 0.3f) * 0.3f)
                .orElse(0f);
        return power > 0.0f && this.behavior.method_29554(this, this.world, pos, state, power);
    }
}

