package com.bwt.blocks.pulley;

import com.bwt.block_entities.BwtBlockEntities;
import com.bwt.blocks.MechPowerBlockBase;
import com.bwt.sounds.BwtSoundEvents;
import com.mojang.serialization.MapCodec;
import org.jetbrains.annotations.Nullable;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1264;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_5558;
import net.minecraft.class_5819;

public class PulleyBlock extends class_2237 implements MechPowerBlockBase {
    public static final class_2746 POWERED = class_2741.field_12484;

    public static final int pulleyTickRate = 10;

    public PulleyBlock(class_2251 settings) {
        super(settings);
        method_9590(method_9564().method_11657(MECH_POWERED, false).method_11657(POWERED, false));
    }

    @Override
    public void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        MechPowerBlockBase.super.appendProperties(builder);
        builder.method_11667(POWERED);
    }

    @Override
    public Predicate<class_2350> getValidAxleInputFaces(class_2680 blockState, class_2338 pos) {
        return direction -> !direction.equals(class_2350.field_11033);
    }

    @Override
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        super.method_9496(state, world, pos, random);
//        if (!isMechPowered(state) || state.get(POWERED)) {
//            return;
//        }
//        emitParticles(world, pos, random);
    }

    @Override
    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        schedulePowerUpdate(state, world, pos);
    }

    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        class_1264.method_54291(state, newState, world, pos);
        super.method_9536(state, world, pos, newState, moved);
    }

    @Override
    protected MapCodec<? extends class_2237> method_53969() {
        return null;
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new PulleyBlockEntity(pos, state);
    }

    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (world.field_9236) return class_1269.field_5812;
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof PulleyBlockEntity pulleyBlockEntity) {
            player.method_17355(pulleyBlockEntity);
        }
        return class_1269.field_21466;
    }

    @Nullable
    protected static <A extends class_2586> class_5558<A> validateTicker(class_1937 world, class_2591<A> givenType) {
        return world.field_9236 ? null : class_2237.method_31618(givenType, BwtBlockEntities.pulleyBlockEntity, PulleyBlockEntity::tick);
    }

    @Nullable
    @Override
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> givenType) {
        return PulleyBlock.validateTicker(world, givenType);
    }

    public class_2680 getPowerStates(class_2680 state, class_1937 world, class_2338 pos) {
        return state.method_11657(POWERED, world.method_49803(pos))
                .method_11657(MECH_POWERED, isReceivingMechPower(world, state, pos));
    }

    public void schedulePowerUpdate(class_2680 state, class_1937 world, class_2338 pos) {
        // Compute new state but don't update yet
        class_2680 newState = getPowerStates(state, world, pos);
        if (newState.method_11654(POWERED) != state.method_11654(POWERED) || newState.method_11654(MECH_POWERED) != state.method_11654(MECH_POWERED)) {
            world.method_39279(pos, this, pulleyTickRate);
        }
    }



    @Override
    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        if (world.field_9236) {
            return;
        }
        schedulePowerUpdate(state, world, pos);
    }

    public void updatePowerTransfer(class_1937 world, class_2680 blockState, class_2338 pos) {
        class_2680 updatedState = getPowerStates(blockState, world, pos);
        world.method_35230(pos, BwtBlockEntities.pulleyBlockEntity).ifPresent(pulleyBlockEntity -> pulleyBlockEntity.mechPower = updatedState.method_11654(MECH_POWERED) ? 1 : 0);
        world.method_8501(pos, updatedState);
    }

    @Override
    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        this.updatePowerTransfer(world, state, pos);
    }

    private void playMechSound(class_1937 world, class_2338 pos) {
        world.method_45446(pos, BwtSoundEvents.MECH_BANG, class_3419.field_15245, 0.125f,  1.25F, false);
    }

    private void emitParticles(class_1937 world, class_2338 pos, class_5819 random) {
        for (int i = 0; i < 5; i++) {
            float smokeX = (float)pos.method_10263() + random.method_43057();
            float smokeY = (float)pos.method_10264() + random.method_43057() * 0.5F + 1.0F;
            float smokeZ = (float)pos.method_10260() + random.method_43057();
            world.method_8406(class_2398.field_11251, smokeX, smokeY, smokeZ, 0D, 0D, 0D );
        }
    }

    @Override
    public boolean method_9498(class_2680 state) {
        return true;
    }

    @Override
    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return class_1703.method_7608(world.method_8321(pos));
    }
}
