package com.bwt.blocks.turntable;

import net.minecraft.block.*;
import net.minecraft.class_2222;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2341;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_2399;
import net.minecraft.class_2429;
import net.minecraft.class_2458;
import net.minecraft.class_2537;
import net.minecraft.class_2546;
import net.minecraft.class_2551;
import net.minecraft.class_2555;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_3709;
import net.minecraft.class_5542;
import net.minecraft.class_5777;
import net.minecraft.class_7715;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public interface HorizontalBlockAttachmentHelper {
    interface IsAttachedPredicate {
        IsAttachedPredicate FALSE = (attachedToPos, attachedToState, thisPos, thisState) -> false;
        boolean test(class_2338 attachedToPos, class_2680 attachedToState, class_2338 thisPos, class_2680 thisState);

        static IsAttachedPredicate directional(DirectionalIsAttachedPredicate directionalIsAttachedPredicate) {
            return (attachedToPos, attachedToState, thisPos, thisState) -> {
                class_2382 directionVector = thisPos.method_10059(attachedToPos);
                class_2350 direction = class_2350.method_50026(directionVector.method_10263(), 0, directionVector.method_10260());
                return directionalIsAttachedPredicate.test(attachedToState, thisState, direction);
            };
        }
    }

    interface DirectionalIsAttachedPredicate {
        boolean test(class_2680 attachedToState, class_2680 thisState, class_2350 directionBetween);
    }

    HashMap<Class<? extends class_2248>, IsAttachedPredicate> isAttachedPredicates = new HashMap<>();

    static void register(Class<? extends class_2248> blockClass, IsAttachedPredicate isAttachedPredicate) {
        isAttachedPredicates.put(blockClass, isAttachedPredicate);
    }

    static boolean isAttached(class_2338 attachedToPos, class_2680 attachedToState, class_2338 thisPos, class_2680 thisState) {
        class_2248 block = thisState.method_26204();
        return isAttachedPredicates.entrySet().stream()
                .filter(entry -> entry.getKey().isInstance(block))
                .findAny()
                .map(Map.Entry::getValue)
                .orElse(IsAttachedPredicate.FALSE)
                .test(attachedToPos, attachedToState, thisPos, thisState);
    }

    static void registerDefaults() {
        IsAttachedPredicate facingBlockPredicate = IsAttachedPredicate.directional((attachedToState, thisState, direction) -> direction == thisState.method_11654(class_2318.field_10927));
        IsAttachedPredicate horizontalFacingBlockPredicate = IsAttachedPredicate.directional((attachedToState, thisState, direction) -> direction == thisState.method_11654(class_2383.field_11177));
        IsAttachedPredicate wallHangingSignPredicate = IsAttachedPredicate.directional((attachedToState, thisState, direction) -> direction.method_10170().method_10166() == thisState.method_11654(class_2383.field_11177).method_10166());
        IsAttachedPredicate wallMountedBlockPredicate = IsAttachedPredicate.directional((attachedToState, thisState, direction) -> {
            if (!thisState.method_11654(class_2341.field_11007).equals(class_2738.field_12471)) {
                return false;
            }
            return direction == thisState.method_11654(class_2341.field_11177);
        });
        IsAttachedPredicate connectingBlockPredicate = IsAttachedPredicate.directional((attachedToState, thisState, direction) -> thisState.method_11654(class_2429.field_11329.get(Objects.requireNonNull(direction).method_10153())));
        IsAttachedPredicate bellPredicate = IsAttachedPredicate.directional((attachedToState, thisState, direction) -> switch (thisState.method_11654(class_3709.field_16326)) {
            case field_17098, field_17099 -> false;
            case field_17100, field_17101 -> thisState.method_11654(class_3709.field_16324).method_10153().equals(direction);
        });

        register(class_2555.class, horizontalFacingBlockPredicate);
        register(class_2458.class, horizontalFacingBlockPredicate);
        register(class_2551.class, horizontalFacingBlockPredicate);
        register(class_2222.class, horizontalFacingBlockPredicate);
        register(class_2546.class, horizontalFacingBlockPredicate);
        register(class_2537.class, horizontalFacingBlockPredicate);
        register(class_2399.class, horizontalFacingBlockPredicate);
        register(class_5777.class, connectingBlockPredicate);
        register(class_5542.class, facingBlockPredicate);
        register(class_3709.class, bellPredicate);
        register(class_7715.class, wallHangingSignPredicate);
        register(class_2341.class, wallMountedBlockPredicate);
    }
}
