package com.bwt.blocks.turntable;

import com.bwt.block_entities.BwtBlockEntities;
import com.bwt.blocks.MechPowerBlockBase;
import com.bwt.sounds.BwtSoundEvents;
import com.mojang.serialization.MapCodec;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_5558;
import net.minecraft.class_5819;

public class TurntableBlock extends class_2237 implements MechPowerBlockBase {
    public static final int turntableTickRate = 10;

    public static final class_2758 TICK_SETTING = class_2758.method_11867("tick_setting", 0, 3);
    public static final class_2746 POWERED = class_2741.field_12484;

    public TurntableBlock(class_2251 settings) {
        super(settings);
        method_9590(method_9564().method_11657(MECH_POWERED, false).method_11657(POWERED, false).method_11657(TICK_SETTING, 0));
    }

    @Override
    public void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(TICK_SETTING, MECH_POWERED, POWERED);
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Override
    protected MapCodec<? extends class_2237> method_53969() {
        return null;
    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new TurntableBlockEntity(pos, state);
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        schedulePowerUpdate(state, world, pos);
    }

    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (!player.method_6047().method_7960()) {
            return class_1269.field_5811;
        }
        world.method_8501(pos, state.method_11657(TICK_SETTING, (state.method_11654(TICK_SETTING) + 1) % 4));
        world.method_8396(null, pos, BwtSoundEvents.TURNTABLE_SETTING_CLICK,
                class_3419.field_15245, 0.25f, 1);
        return class_1269.field_5812;
    }

    @Override
    public Predicate<class_2350> getValidAxleInputFaces(class_2680 blockState, class_2338 pos) {
        return direction -> direction == class_2350.field_11033;
    }

    @Override
    public Predicate<class_2350> getValidHandCrankFaces(class_2680 blockState, class_2338 pos) {
        return direction -> false;
    }

    public class_2680 getPowerStates(class_2680 state, class_1937 world, class_2338 pos) {
        boolean redstonePowered = world.method_49803(pos);
        boolean mechPowered = isReceivingMechPower(world, state, pos);
        class_2680 updatedState = state;
        updatedState = updatedState.method_11657(POWERED, redstonePowered);
        updatedState = updatedState.method_11657(MECH_POWERED, mechPowered);
        return updatedState;
    }

    public void schedulePowerUpdate(class_2680 state, class_1937 world, class_2338 pos) {
        // Compute new state but don't update yet
        class_2680 newState = getPowerStates(state, world, pos);
        // If block just turned on
        if (newState.method_11654(POWERED) != state.method_11654(POWERED) || newState.method_11654(MECH_POWERED) != state.method_11654(MECH_POWERED)) {
            world.method_39279(pos, this, turntableTickRate);
        }
    }

    @Override
    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        if (world.field_9236) {
            return;
        }
        schedulePowerUpdate(state, world, pos);
    }

    @Override
    public void method_9588(class_2680 blockState, class_3218 world, class_2338 pos, class_5819 random) {
        class_2680 updatedState = getPowerStates(blockState, world, pos);
        world.method_8501(pos, updatedState);
    }

    @Nullable
    protected static <A extends class_2586> class_5558<A> validateTicker(class_1937 world, class_2591<A> givenType) {
        return world.field_9236 ? null : class_2237.method_31618(givenType, BwtBlockEntities.turntableBlockEntity, TurntableBlockEntity::tick);
    }

    @Nullable
    @Override
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return TurntableBlock.validateTicker(world, type);
    }
}
