package com.bwt.emi.recipehandlers;

import com.bwt.blocks.abstract_cooking_pot.AbstractCookingPotScreenHandler;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import java.util.List;
import net.minecraft.class_1735;

public class EmiCookingPotRecipeHandler<T extends AbstractCookingPotScreenHandler> implements StandardRecipeHandler<T> {

    private final List<EmiRecipeCategory> unstokedCategories;
    private final List<EmiRecipeCategory> stokedCategories;

    public EmiCookingPotRecipeHandler(EmiRecipeCategory unstokedCategory, EmiRecipeCategory... stokedCategories) {
        this.unstokedCategories = List.of(unstokedCategory);
        this.stokedCategories = List.of(stokedCategories);
    }

    @Override
    public List<class_1735> getInputSources(T handler) {
        return handler.field_7761.stream().filter(slot -> slot.field_7874 >= AbstractCookingPotScreenHandler.SIZE).toList();
    }

    @Override
    public List<class_1735> getCraftingSlots(T handler) {
        return handler.field_7761.stream().filter(slot -> slot.field_7874 < AbstractCookingPotScreenHandler.SIZE).filter(slot -> slot.method_7677().method_7960()).toList();
    }

    @Override
    public boolean supportsRecipe(EmiRecipe recipe) {
        EmiRecipeCategory category = recipe.getCategory();
        return this.unstokedCategories.contains(category) || this.stokedCategories.contains(category);
    }

    @Override
    public boolean canCraft(EmiRecipe recipe, EmiCraftContext<T> context) {
        EmiRecipeCategory category = recipe.getCategory();
        boolean isStoked = context.getScreenHandler().isStoked();
        if ((this.unstokedCategories.contains(category) && !isStoked)
                || (this.stokedCategories.contains(category) && isStoked)) {
            return canFit(context.getScreenHandler(), recipe.getInputs());
        }
        return false;
    }

    public boolean canFit(T handler, List<EmiIngredient> ingredients) {
        return this.getCraftingSlots(handler).size() >= ingredients.size();
//        List<Slot> slots = this.getCraftingSlots(handler);
//        List<Slot> nonEmptySlots = slots.stream().filter(slot -> !slot.getStack().isEmpty()).toList();
//        ArrayList<ItemStack> stacksToInsert = ingredients.stream()
//                .map(EmiIngredient::copy)
//                .flatMap(emiIngredient -> emiIngredient.getEmiStacks().stream())
//                .map(EmiStack::getItemStack)
//                .filter(itemStack -> !itemStack.isEmpty())
//                .collect(Collectors.toCollection(ArrayList::new));
//        for (Slot slot : nonEmptySlots) {
//            ItemStack slotStack = slot.getStack();
//            ItemVariant itemVariant = ItemVariant.of(slotStack);
//            for (ItemStack stack : stacksToInsert) {
//                if (itemVariant.matches(stack)) {
//                    int spaceAvailable = slotStack.getMaxCount() - slotStack.getCount();
//                    stack.setCount(stack.getCount() - spaceAvailable);
//                }
//            }
//            stacksToInsert.removeIf(ItemStack::isEmpty);
//            if (stacksToInsert.isEmpty()) {
//                return true;
//            }
//        }
//        List<Slot> emptySlots = slots.stream().filter(slot -> slot.getStack().isEmpty()).toList();
//        return stacksToInsert.size() <= emptySlots.size();
    }
}