package com.bwt.entities;

import org.jetbrains.annotations.Nullable;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1321;
import net.minecraft.class_1352;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_1799;

public class GoToAndPickUpBreedingItemGoal extends class_1352 {
    protected final class_1429 animal;
    protected final double searchRadius;
    protected final double pickupRadius;
    protected final double speed;
    @Nullable
    protected class_1542 targetBreedingItem;

    @Nullable
    protected final Predicate<class_1429> wantsFoodCondition;
    @Nullable
    protected final Consumer<class_1799> foodConsumer;

    public GoToAndPickUpBreedingItemGoal(class_1429 animal, double searchRadius, double pickupRadius, double speed, @Nullable Predicate<class_1429> wantsFoodCondition, @Nullable Consumer<class_1799> foodConsumer) {
        this.animal = animal;
        this.searchRadius = searchRadius;
        this.pickupRadius = pickupRadius;
        this.speed = speed;
        this.wantsFoodCondition = wantsFoodCondition;
        this.foodConsumer = foodConsumer;
        this.method_6265(EnumSet.of(class_4134.field_18405, class_4134.field_18406));
    }

    public GoToAndPickUpBreedingItemGoal(class_1429 animal, double searchRadius, double pickupRadius, double speed) {
        this(animal, searchRadius, pickupRadius, speed, null, null);
    }

    protected boolean wantsFood() {
        if (wantsFoodCondition != null && wantsFoodCondition.test(animal)) {
            return true;
        }
        return animal.method_5618() == 0 && animal.method_6482();
    }


    protected boolean isTargetValid() {
        return targetBreedingItem != null && targetBreedingItem.method_5805() && !targetBreedingItem.method_6983().method_7960();
    }

    @Nullable
    protected class_1542 findClosestBreedingItem() {
        return animal.method_37908()
                .method_8390(
                        class_1542.class,
                        animal.method_5829().method_1014(searchRadius),
                        itemEntity -> animal.method_6481(itemEntity.method_6983())
                )
                .stream()
                .min(Comparator.comparingDouble(animal::method_5858))
                .filter(itemEntity -> animal.method_5739(itemEntity) < searchRadius)
                .orElse(null);
    }

    @Override
    public boolean method_6264() {
        if (!wantsFood()) {
            return false;
        }
        targetBreedingItem = findClosestBreedingItem();
        return isTargetValid();
    }

    @Override
    public boolean method_6266() {
        return isTargetValid() && wantsFood();
    }

    @Override
    public void method_6268() {
        if (targetBreedingItem == null || !isTargetValid() || !wantsFood() || !animal.method_6034()) {
            return;
        }
        animal.method_5988().method_6226(targetBreedingItem, animal.method_20240(), animal.method_5978());
        if (!(animal instanceof class_1321 tameableEntity) || !tameableEntity.method_24345()) {
            animal.method_5942().method_6335(targetBreedingItem, speed);
        }
        if (animal.method_5739(targetBreedingItem) <= pickupRadius) {
            animal.method_5942().method_6340();
            if (foodConsumer != null) {
                foodConsumer.accept(targetBreedingItem.method_6983().method_46651(1));
            }
            targetBreedingItem.method_6983().method_7934(1);
            animal.method_6480(null);
        }
    }
}
