package com.bwt.entities;

import com.bwt.blocks.axles.AxleBlock;
import com.bwt.blocks.BwtBlocks;
import com.bwt.utils.rectangular_entity.RectangularEntity;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_3619;
import net.minecraft.class_5575;
import net.minecraft.class_5712;
import net.minecraft.entity.*;
import net.minecraft.util.math.*;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;

public abstract class HorizontalMechPowerSourceEntity extends RectangularEntity {
    protected float rotation = 0;
    protected float prevRotation = 0;

    protected int ticksBeforeNextFullUpdate = 20;

    protected static final class_2940<Float> rotationSpeed = class_2945.method_12791(HorizontalMechPowerSourceEntity.class, class_2943.field_13320);
    protected static final class_2940<Integer> DAMAGE_WOBBLE_TICKS = class_2945.method_12791(HorizontalMechPowerSourceEntity.class, class_2943.field_13327);
    protected static final class_2940<Integer> DAMAGE_WOBBLE_SIDE = class_2945.method_12791(HorizontalMechPowerSourceEntity.class, class_2943.field_13327);
    protected static final class_2940<Float> DAMAGE_WOBBLE_STRENGTH = class_2945.method_12791(HorizontalMechPowerSourceEntity.class, class_2943.field_13320);

    public HorizontalMechPowerSourceEntity(class_1299<? extends HorizontalMechPowerSourceEntity> type, class_1937 world) {
        super(type, world);
        this.field_23807 = true;
    }

    public HorizontalMechPowerSourceEntity(class_1299<? extends HorizontalMechPowerSourceEntity> type, class_1937 world, class_243 pos, class_2350 facing) {
        this(type, world);
        method_33574(pos);
        method_36456(facing.method_10144());
    }

    public interface Factory {
        HorizontalMechPowerSourceEntity create(class_1937 world, class_243 pos, class_2350 facing);
    }


    abstract public boolean tryToSpawn(class_1657 player);
    abstract public Predicate<class_2338> getBlockInterferencePredicate();
    abstract float computeRotation();
    abstract float getSpeedToPowerThreshold();

    @Override
    public double method_23320() {
        return this.method_17682() / 2;
    }

    @Override
    protected class_5799 method_33570() {
        return class_5799.field_28630;
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(rotationSpeed, 0f);
        builder.method_56912(DAMAGE_WOBBLE_TICKS, 0);
        builder.method_56912(DAMAGE_WOBBLE_SIDE, 1);
        builder.method_56912(DAMAGE_WOBBLE_STRENGTH, 0.0f);
    }

    public float getRotation() {
        return rotation;
    }

    protected void setRotation(float rotation) {
        rotation = (rotation + 360f) % 360f;
        this.prevRotation = this.rotation;
        this.rotation = rotation;
    }

    public float getPrevRotation() {
        return prevRotation;
    }

    public float getRotationSpeed() {
        return method_5841().method_12789(rotationSpeed);
    }

    public void setRotationSpeed(float speed) {
        method_5841().method_12778(rotationSpeed, speed);
    }

    public void setDamageWobbleTicks(int damageWobbleTicks) {
        this.field_6011.method_12778(DAMAGE_WOBBLE_TICKS, damageWobbleTicks);
    }

    public void setDamageWobbleSide(int damageWobbleSide) {
        this.field_6011.method_12778(DAMAGE_WOBBLE_SIDE, damageWobbleSide);
    }

    public void setDamageWobbleStrength(float damageWobbleStrength) {
        this.field_6011.method_12778(DAMAGE_WOBBLE_STRENGTH, damageWobbleStrength);
    }

    public float getDamageWobbleStrength() {
        return this.field_6011.method_12789(DAMAGE_WOBBLE_STRENGTH);
    }

    public int getDamageWobbleTicks() {
        return this.field_6011.method_12789(DAMAGE_WOBBLE_TICKS);
    }

    public int getDamageWobbleSide() {
        return this.field_6011.method_12789(DAMAGE_WOBBLE_SIDE);
    }

    @Override
    public boolean method_5863() {
        return true;
    }

    @Override
    public boolean method_30948() {
        return true;
    }

    @Override
    public boolean method_5675() {
        return false;
    }

    @Override
    public class_3619 method_5657() {
        return class_3619.field_15971;
    }

    public boolean tryToSpawn(class_1657 player, class_2561 blockBlockedErrorMessage, class_2561 entityBlockedErrorMessage) {
        if (player instanceof class_3222) {
            player = null;
        }

        if (placementBlockedByBlock()) {
            if(player != null) {
                player.method_43496(blockBlockedErrorMessage);
            }
            return false;
        }
        if (placementBlockedByEntity()) {
            if(player != null) {
                player.method_43496(entityBlockedErrorMessage);
            }
            return false;
        }

        if (placementHasBadAxleState()) {
            return false;
        }

        setRotationSpeed(computeRotation());
        class_1937 world = method_37908();
        world.method_8649(this);
        return true;
    }

    public boolean placementBlockedByBlock() {
        Predicate<class_2338> blockInterferencePredicate = getBlockInterferencePredicate();
        return class_2338.method_29715(method_5829())
                // Ignore the axle we're on
                .filter(blockPos -> !blockPos.equals(this.method_24515()))
                .anyMatch(blockInterferencePredicate);
    }

    @Override
    protected void method_5622(class_2680 state) {
        destroyWithDrop();
    }

    public boolean placementBlockedByEntity() {
        ArrayList<class_1297> anyEntities = new ArrayList<>();
        method_37908().method_47575(
                class_5575.method_31795(class_1297.class),
                method_5829(),
                entity -> entity != this && class_1301.field_6155.test(entity) && !(entity instanceof class_1542),
                anyEntities, 1);
        return !anyEntities.isEmpty();
    }

    public boolean placementHasBadAxleState() {
        class_1937 world = method_37908();

        class_2680 axleBlock = world.method_8320(method_24515());

        // Bad block type
        if (!axleBlock.method_27852(BwtBlocks.axleBlock) && !axleBlock.method_27852(BwtBlocks.axlePowerSourceBlock)) {
            return true;
        }
        class_2350.class_2351 axleAxis = axleBlock.method_11654(AxleBlock.field_11459);
        float yaw = method_36454();

        // Misaligned
        return class_2350.method_10169(axleAxis, class_2350.class_2352.field_11060).method_10144() != yaw
                && class_2350.method_10169(axleAxis, class_2350.class_2352.field_11056).method_10144() != yaw;
    }

    @Override
    public void method_5773() {
        super.method_5773();

        if (method_31481()) {
            return;
        }
        if (this.getDamageWobbleTicks() > 0) {
            this.setDamageWobbleTicks(this.getDamageWobbleTicks() - 1);
        }
        if (this.getDamageWobbleStrength() > 0.0f) {
            this.setDamageWobbleStrength(this.getDamageWobbleStrength() - 1.0f);
        }

        if (method_37908().field_9236) {
            updateRotation();
        }
        else {
            ticksBeforeNextFullUpdate--;
            if (ticksBeforeNextFullUpdate <= 0) {
                ticksBeforeNextFullUpdate = 20;
                fullUpdate();
            }
        }
        method_37908()
                .method_8333(this, this.method_5829().method_1009(0.01f, 0.01f, 0.01f), class_1301.method_5911(this))
                .forEach(this::method_5697);
    }

    @Override
    public void method_5697(class_1297 entity) {
        if (entity.field_5960 || this.field_5960) {
            return;
        }
        class_238 thisBox = this.method_5829().method_1009(0.01f, 0.01f, 0.01f);
        class_238 entityBox = entity.method_5829();
        List<class_3545<class_2350, Double>> intersections = new ArrayList<>();
        for (class_2350.class_2351 axis : class_2350.class_2351.values()) {
            double thisMin = thisBox.method_1001(axis);
            double thisMax = thisBox.method_990(axis);
            double entityMin = entityBox.method_1001(axis);
            double entityMax = entityBox.method_990(axis);
            if (thisMax - entityMin > 0) {
                class_2350 intersectDirection = class_2350.method_10169(axis, class_2350.class_2352.field_11056);
                intersections.add(new class_3545<>(intersectDirection, thisMax - entityMin));
            }
            if (entityMax - thisMin > 0) {
                class_2350 intersectDirection = class_2350.method_10169(axis, class_2350.class_2352.field_11060);
                intersections.add(new class_3545<>(intersectDirection, entityMax - thisMin));
            }
        }
        intersections.stream()
                .min(Comparator.comparingDouble(pair -> Math.abs(pair.method_15441())))
                .filter(pair -> pair.method_15441() > 0.01f)
                .ifPresent(pair -> entity.method_60491(
                        new class_243(pair.method_15442().method_23955().mul(pair.method_15441().floatValue() / 2)))
                );
    }

    protected void updateRotation() {
        setRotation(rotation + this.method_5841().method_12789(rotationSpeed));
    }

    protected void fullUpdate() {
        if (placementBlockedByBlock() || placementHasBadAxleState()) {
            destroyWithDrop();
            return;
        }

        setRotationSpeed(computeRotation());

        setHostAxlePower(Math.abs(getRotationSpeed()) > getSpeedToPowerThreshold());
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_37908().field_9236 || this.method_31481()) {
            return true;
        }
        if (this.method_5679(source)) {
            return false;
        }
        this.setDamageWobbleSide(-this.getDamageWobbleSide());
        this.setDamageWobbleTicks(10);
        this.method_5785();
        this.setDamageWobbleStrength(this.getDamageWobbleStrength() + amount * 10.0f);
        this.method_32875(class_5712.field_28736, source.method_5529());
        boolean instantKill = source.method_5529() instanceof class_1657 && ((class_1657)source.method_5529()).method_31549().field_7477;
        if (instantKill) {
            method_31472();
            return true;
        }
        if (this.getDamageWobbleStrength() > 40.0f) {
            destroyWithDrop();
        }
        return true;
    }

    public void destroyWithDrop() {
        if (method_31481()) return;
        method_5699(method_31480(), 0.5f);
        method_5768();
    }

    @Override
    public void method_5650(class_5529 reason) {
        super.method_5650(reason);
        setHostAxlePower(false);
    }

    protected void setHostAxlePower(boolean powered) {
        class_1937 world = method_37908();
        class_2338 pos = method_24515();
        class_2680 hostBlockState = world.method_8320(pos);
        if (!powered && hostBlockState.method_27852(BwtBlocks.axlePowerSourceBlock)) {
            world.method_8650(pos, false);
            world.method_8501(pos, BwtBlocks.axleBlock.method_9564()
                    .method_11657(AxleBlock.field_11459, hostBlockState.method_11654(AxleBlock.field_11459)));
        }
        if (powered && hostBlockState.method_27852(BwtBlocks.axleBlock)) {
            world.method_8501(pos, BwtBlocks.axlePowerSourceBlock.method_9564()
                    .method_11657(AxleBlock.field_11459, hostBlockState.method_11654(AxleBlock.field_11459)));
        }
    }

    @Override
    protected void method_5652(class_2487 nbt) {
        nbt.method_10548("rotationSpeed", field_6011.method_12789(rotationSpeed));
    }

    @Override
    protected void method_5749(class_2487 nbt) {
        this.field_6011.method_12778(rotationSpeed, nbt.method_10583("rotationSpeed"));
    }
}
