package com.bwt.entities;

import com.bwt.blocks.BwtBlocks;
import com.bwt.blocks.mining_charge.MiningChargeBlock;
import com.bwt.blocks.mining_charge.MiningChargeExplosion;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1927;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2664;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_7924;
import net.minecraft.class_8046;
import net.minecraft.entity.*;
import org.jetbrains.annotations.Nullable;

public class MiningChargeEntity extends class_1297 implements class_8046 {
    private static final class_2940<Integer> FUSE = class_2945.method_12791(MiningChargeEntity.class, class_2943.field_13327);
    private static final class_2940<class_2680> BLOCK_STATE = class_2945.method_12791(MiningChargeEntity.class, class_2943.field_13312);
    private static final int DEFAULT_FUSE = 80;

    @Nullable
    private class_1309 causingEntity;
    public boolean attachedToBlock;

    public MiningChargeEntity(class_1299<? extends MiningChargeEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.field_23807 = true;
        this.attachedToBlock = true;
    }

    public MiningChargeEntity(class_1937 world, class_243 position, class_2680 state, @Nullable class_1309 igniter) {
        this(BwtEntities.miningChargeEntity, world);
        this.setFuse(DEFAULT_FUSE);
        this.setBlockState(state);
        this.field_6014 = position.field_1352;
        this.field_6036 = position.field_1351;
        this.field_5969 = position.field_1350;
        this.method_33574(position);
//        setYaw(getYaw());
        this.causingEntity = igniter;
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(FUSE, 80);
        builder.method_56912(BLOCK_STATE, BwtBlocks.miningChargeBlock.method_9564());
    }

    protected void setFacing(class_2350 direction) {
        setBlockState(MiningChargeBlock.withSurfaceOrientation(getBlockState(), direction));
    }

    public class_2350 method_58149() {
        return MiningChargeBlock.getSurfaceOrientation(getBlockState());
    }

    public void setFuse(int fuse) {
        this.field_6011.method_12778(FUSE, fuse);
    }

    public int getFuse() {
        return this.field_6011.method_12789(FUSE);
    }

    public void setBlockState(class_2680 state) {
        this.field_6011.method_12778(BLOCK_STATE, state);
    }

    public class_2680 getBlockState() {
        return this.field_6011.method_12789(BLOCK_STATE);
    }

    @Override
    protected class_5799 method_33570() {
        return class_5799.field_28630;
    }

    @Override
    public boolean method_5863() {
        return !this.method_31481();
    }

    @Override
    public void method_5773() {
        if (attachedToBlock) {
            // make sure we're still attached
            class_2338 attachedBlockPos = method_24515().method_10093(method_58149().method_10153());
            attachedToBlock = method_37908().method_8320(attachedBlockPos).method_26206(method_37908(), attachedBlockPos, method_58149());
        }
        if (!attachedToBlock) {
            if (method_58149() == class_2350.field_11033) {
                setFacing(class_2350.field_11036);
            }
            tickMovement();
        }
        int i = this.getFuse() - 1;
        this.setFuse(i);
        if (i <= 0) {
            this.method_31472();
            if (!this.method_37908().field_9236) {
                this.explode();
            }
        } else {
            this.method_5876();
            if (this.method_37908().field_9236) {
                this.method_37908().method_8406(class_2398.field_11251, this.method_23317(), this.method_23318() + 0.5, this.method_23321(), 0.0, 0.0, 0.0);
            }
        }
    }

    private void tickMovement() {
        if (!this.method_5740()) {
            this.method_18799(this.method_18798().method_1031(0.0, -0.04, 0.0));
        }
        this.method_5784(class_1313.field_6308, this.method_18798());
        this.method_18799(this.method_18798().method_1021(0.98));
        if (this.method_24828()) {
            this.method_18799(this.method_18798().method_18805(0.7, -0.5, 0.7));
        }
    }

    private void explode() {
//        this.getWorld().createExplosion(this, this.getX(), this.getY(), this.getZ(), 6.0f, World.ExplosionSourceType.NONE);
        createMiningChargeExplosion(6.0f);
    }

    public void createMiningChargeExplosion(float power) {
        class_1927.class_4179 destructionType = method_37908().method_8450().method_8355(class_1928.field_40882) ? class_1927.class_4179.field_40879 : class_1927.class_4179.field_18687;
        class_243 offsetPos = this.method_24515().method_10093(method_58149().method_10153()).method_46558();
        class_1927 explosion = new MiningChargeExplosion(
                method_37908(),
                this,
                offsetPos,
                class_1927.method_55108(method_37908(), this),
                power,
                false,
                destructionType,
                class_2398.field_11236,
                class_2398.field_11221,
                class_3417.field_15152
        );
        explosion.method_8348();
        explosion.method_8350(true);
        if (method_37908() instanceof class_3218 serverWorld) {
            if (!explosion.method_46667()) {
                explosion.method_8352();
            }
            for (class_3222 serverPlayerEntity : serverWorld.method_18456()) {
                if (!(serverPlayerEntity.method_5649(method_23317(), method_23318(), method_23321()) < 4096.0)) continue;
                serverPlayerEntity.field_13987.method_14364(new class_2664(method_23317(), method_23318(), method_23321(), power, explosion.method_8346(), explosion.method_8351().get(serverPlayerEntity), explosion.method_55111(), explosion.method_55112(), explosion.method_55113(), explosion.method_55114()));
            }
        }
    }

    @Override
    protected void method_5652(class_2487 nbt) {
        nbt.method_10575("fuse", (short)this.getFuse());
        nbt.method_10566("block_state", class_2512.method_10686(this.getBlockState()));
        nbt.method_10569("facing", method_58149().method_10146());
    }

    @Override
    protected void method_5749(class_2487 nbt) {
        setFuse(nbt.method_10568("fuse"));
        if (nbt.method_10573("block_state", class_2520.field_33260)) {
            this.setBlockState(class_2512.method_10681(this.method_37908().method_45448(class_7924.field_41254), nbt.method_10562("block_state")));
        }
        setFacing(class_2350.method_10143(nbt.method_10550("facing")));
    }

    @Override
    @Nullable
    public class_1309 method_24921() {
        return this.causingEntity;
    }

    @Override
    public void method_5878(class_1297 original) {
        super.method_5878(original);
        if (original instanceof MiningChargeEntity miningChargeEntity) {
            this.causingEntity = miningChargeEntity.causingEntity;
        }
    }

    @Override
    public double method_23320() {
        return 0.15f;
    }
}
