package com.bwt.entities;

import org.jetbrains.annotations.Nullable;

import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1321;
import net.minecraft.class_1352;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_1799;

public class PickUpBreedingItemWhileSittingGoal extends class_1352 {
    protected final class_1321 animal;
    protected final double searchRadius;
    @Nullable
    protected class_1542 targetBreedingItem;

    @Nullable
    protected final Predicate<class_1429> wantsFoodCondition;
    @Nullable
    protected final Consumer<class_1799> foodConsumer;

    public PickUpBreedingItemWhileSittingGoal(class_1321 animal, double searchRadius, @Nullable Predicate<class_1429> wantsFoodCondition, @Nullable Consumer<class_1799> foodConsumer) {
        this.animal = animal;
        this.searchRadius = searchRadius;
        this.wantsFoodCondition = wantsFoodCondition;
        this.foodConsumer = foodConsumer;
    }

    protected boolean wantsFood() {
        return wantsFoodCondition != null && wantsFoodCondition.test(animal);
    }


    protected boolean isTargetValid() {
        return targetBreedingItem != null && targetBreedingItem.method_5805() && !targetBreedingItem.method_6983().method_7960();
    }

    @Nullable
    protected class_1542 findClosestBreedingItem() {
        return animal.method_37908()
                .method_8390(
                        class_1542.class,
                        animal.method_5829().method_1014(searchRadius),
                        itemEntity -> animal.method_6481(itemEntity.method_6983())
                )
                .stream()
                .min(Comparator.comparingDouble(animal::method_5858))
                .filter(itemEntity -> animal.method_5739(itemEntity) < searchRadius)
                .orElse(null);
    }

    @Override
    public boolean method_6264() {
        if (!animal.method_24345() && !animal.method_6172()) {
            return false;
        }
        if (!wantsFood()) {
            return false;
        }
        targetBreedingItem = findClosestBreedingItem();
        return isTargetValid();
    }

    @Override
    public boolean method_6266() {
        return isTargetValid() && wantsFood();
    }

    @Override
    public void method_6268() {
        if (targetBreedingItem == null || !isTargetValid() || !wantsFood() || !animal.method_6034()) {
            return;
        }
        if (animal.method_5739(targetBreedingItem) <= searchRadius) {
            if (foodConsumer != null) {
                foodConsumer.accept(targetBreedingItem.method_6983().method_46651(1));
            }
            targetBreedingItem.method_6983().method_7934(1);
        }
    }
}
