package com.bwt.generation;

import com.bwt.blocks.BwtBlocks;
import com.bwt.blocks.HempCropBlock;
import com.bwt.items.BwtItems;
import com.bwt.utils.DyeUtils;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricBlockLootTableProvider;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_212;
import net.minecraft.class_219;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_44;
import net.minecraft.class_4559;
import net.minecraft.class_52;
import net.minecraft.class_55;
import net.minecraft.class_7225;
import net.minecraft.class_77;
import net.minecraft.class_7924;
import net.minecraft.class_9317;
import net.minecraft.class_9334;
import net.minecraft.class_94;
import java.util.concurrent.CompletableFuture;

public class BlockLootTableGenerator extends FabricBlockLootTableProvider {
    public BlockLootTableGenerator(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(dataOutput, registryLookup);
    }

    @Override
    public void method_10379() {
        method_46025(BwtBlocks.aqueductBlock);
        method_46025(BwtBlocks.anchorBlock);
//        addDrop(BwtBlocks.anvilBlock);
        method_46025(BwtBlocks.axleBlock);
        method_46006(BwtBlocks.axlePowerSourceBlock, BwtBlocks.axleBlock);
//        addDrop(BwtBlocks.barrelBlock);
        method_46025(BwtBlocks.bellowsBlock);
        method_46025(BwtBlocks.blockDispenserBlock);

        method_46025(BwtBlocks.bloodWoodBlocks.logBlock);
        method_46025(BwtBlocks.bloodWoodBlocks.strippedLogBlock);
        method_46025(BwtBlocks.bloodWoodBlocks.woodBlock);
        method_46025(BwtBlocks.bloodWoodBlocks.strippedWoodBlock);

        method_45994(BwtBlocks.bloodWoodBlocks.leavesBlock, block -> method_45986(block, BwtBlocks.bloodWoodBlocks.saplingBlock, field_40605));
        method_46025(BwtBlocks.bloodWoodBlocks.saplingBlock);
        method_46023(BwtBlocks.bloodWoodBlocks.pottedSaplingBlock);
        method_46025(BwtBlocks.bloodWoodBlocks.planksBlock);
        method_46025(BwtBlocks.bloodWoodBlocks.buttonBlock);
        method_46025(BwtBlocks.bloodWoodBlocks.fenceBlock);
        method_46025(BwtBlocks.bloodWoodBlocks.fenceGateBlock);
        method_46025(BwtBlocks.bloodWoodBlocks.pressurePlateBlock);
        method_45994(BwtBlocks.bloodWoodBlocks.slabBlock, this::method_45980);
        method_46025(BwtBlocks.bloodWoodBlocks.stairsBlock);
        method_46025(BwtBlocks.bloodWoodBlocks.doorBlock);
        method_46025(BwtBlocks.bloodWoodBlocks.trapdoorBlock);

        method_46025(BwtBlocks.buddyBlock);
        method_46025(BwtBlocks.cauldronBlock);
//        addDrop(BwtBlocks.canvasBlock);
        method_46025(BwtBlocks.companionCubeBlock);
        method_46025(BwtBlocks.companionSlabBlock);
        method_46025(BwtBlocks.crucibleBlock);
        method_46025(BwtBlocks.detectorBlock);
        method_46025(BwtBlocks.gearBoxBlock);
        method_46025(BwtBlocks.redstoneClutchBlock);
        method_46025(BwtBlocks.grateBlock);
        method_46025(BwtBlocks.handCrankBlock);
        addHempDrop();
        method_46025(BwtBlocks.hibachiBlock);
        method_46025(BwtBlocks.hopperBlock);
//        addDrop(BwtBlocks.infernalEnchanterBlock);
        method_46006(BwtBlocks.kilnBlock, class_2246.field_10104);
        method_46025(BwtBlocks.lensBlock);
        method_46025(BwtBlocks.lightBlockBlock);
        method_46025(BwtBlocks.millStoneBlock);
        method_46025(BwtBlocks.miningChargeBlock);
//        addDrop(BwtBlocks.netherGrothBlock);
        method_46025(BwtBlocks.obsidianDetectorRailBlock);
        method_46025(BwtBlocks.obsidianPressurePlateBlock);
        method_46025(BwtBlocks.obsidianDetectorRailBlock);
        method_46025(BwtBlocks.planterBlock);
        method_46025(BwtBlocks.soulForgeBlock);
        method_46025(BwtBlocks.soilPlanterBlock);
        method_46025(BwtBlocks.soulSandPlanterBlock);
        method_46025(BwtBlocks.grassPlanterBlock);
        method_46025(BwtBlocks.platformBlock);
        method_46025(BwtBlocks.pulleyBlock);
        method_46025(BwtBlocks.ropeBlock);
        method_46025(BwtBlocks.ropeCoilBlock);
        method_46025(BwtBlocks.sawBlock);
        method_46025(BwtBlocks.screwPumpBlock);
        method_46025(BwtBlocks.slatsBlock);
//        addDrop(BwtBlocks.stakeBlock);
        method_46025(BwtBlocks.stokedFireBlock);
        method_46025(BwtBlocks.stoneDetectorRailBlock);
        method_46025(BwtBlocks.turntableBlock);
        method_46025(BwtBlocks.unfiredCrucibleBlock);
        method_46025(BwtBlocks.unfiredPlanterBlock);
        method_46025(BwtBlocks.unfiredVaseBlock);
        method_46025(BwtBlocks.unfiredUrnBlock);
        method_46025(BwtBlocks.unfiredFlowerPotBlock);
        method_46025(BwtBlocks.unfiredDecoratedPotBlock);
        method_45994(BwtBlocks.unfiredDecoratedPotBlockWithSherds, this::unfiredDecoratedPotBlockWithSherdsDrops);
        method_46025(BwtBlocks.urnBlock);
        method_46025(BwtBlocks.wickerPaneBlock);
        method_46025(BwtBlocks.wickerBlock);
        method_45994(BwtBlocks.wickerSlabBlock, this::method_45980);
        method_46025(BwtBlocks.vineTrapBlock);
        DyeUtils.streamColorItemsSorted(BwtBlocks.woolSlabBlocks).forEach(block -> method_45994(block, this::method_45980));
        DyeUtils.streamColorItemsSorted(BwtBlocks.vaseBlocks).forEach(this::method_46024);
        BwtBlocks.sidingBlocks.forEach(this::method_46025);
        BwtBlocks.mouldingBlocks.forEach(this::method_46025);
        BwtBlocks.cornerBlocks.forEach(this::method_46025);
        BwtBlocks.columnBlocks.forEach(this::method_46025);
        BwtBlocks.pedestalBlocks.forEach(this::method_46025);
        BwtBlocks.tableBlocks.forEach(this::method_46025);
        method_46025(BwtBlocks.dirtSlabBlock);
        method_46006(BwtBlocks.dirtPathSlabBlock, BwtBlocks.dirtSlabBlock);
        method_45988(BwtBlocks.grassSlabBlock, method_45983(BwtBlocks.grassSlabBlock, BwtBlocks.dirtSlabBlock));
        method_45988(BwtBlocks.myceliumSlabBlock, method_45983(BwtBlocks.myceliumSlabBlock, BwtBlocks.dirtSlabBlock));
        method_45988(BwtBlocks.podzolSlabBlock, method_45983(BwtBlocks.podzolSlabBlock, BwtBlocks.dirtSlabBlock));
    }

    private void addHempDrop() {
        class_7225.class_7226<class_1887> enchantmentRegistry = this.field_51845.method_46762(class_7924.field_41265);
        method_45988(
                BwtBlocks.hempCropBlock,
                method_45977(
                        BwtBlocks.hempCropBlock,
                        class_52.method_324()
                                .method_336(class_55.method_347()
                                        // If fully grown, drop hemp item
                                        .method_356(class_212.method_900(BwtBlocks.hempCropBlock)
                                                .method_22584(class_4559.class_4560.method_22523().method_22524(HempCropBlock.field_10835, HempCropBlock.field_31079))
                                        ).method_351(class_77.method_411(BwtItems.hempItem))
                                ).method_336(class_55.method_347()
                                        // Regardless of growth, drop some seeds
                                        .method_351(class_77.method_411(BwtItems.hempSeedsItem)
                                                .method_421(class_219.method_932(0.5f))
                                                .method_438(class_94.method_463(enchantmentRegistry.method_46747(class_1893.field_9130), 0.5f, 0))
                                        )
                                )
                )
        );
    }

    private class_52.class_53 unfiredDecoratedPotBlockWithSherdsDrops(class_2248 block) {
        return class_52.method_324()
                .method_336(
                        class_55.method_347()
                                .method_352(class_44.method_32448(1.0F))
                                .method_351(
                                        class_77.method_411(block)
                                                .method_438(class_9317.method_57637(class_9317.class_9319.field_49436)
                                                        .method_58730(class_9334.field_49621)
                                                )
                                )
                );
    }

}
