package com.bwt.generation;

import com.bwt.blocks.*;
import com.bwt.items.BwtItems;
import com.bwt.tags.BwtItemTags;
import com.bwt.utils.DyeUtils;
import com.bwt.utils.Id;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2446;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_2482;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_5793;
import net.minecraft.class_5794;
import net.minecraft.class_5797;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_7701;
import net.minecraft.class_7800;
import net.minecraft.class_7923;
import net.minecraft.class_8790;
import net.minecraft.data.server.recipe.*;
import net.minecraft.item.*;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;

public class CraftingRecipeGenerator extends FabricRecipeProvider {
    public CraftingRecipeGenerator(FabricDataOutput generator, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(generator, registryLookup);
    }

    @Override
    public void method_10419(class_8790 exporter) {
        generateCraftingRecipes(exporter);
        generateHighEfficiencyRecipes(exporter);
    }

    public void generateCraftingRecipes(class_8790 exporter) {
        generateTier1Recipes(exporter);
        generateTier2Recipes(exporter);
        generateTier3Recipes(exporter);
        generateTier4Recipes(exporter);
        generateTier5Recipes(exporter);
        generateTier6Recipes(exporter);
        generateTier7Recipes(exporter);

        generateVaseDyeingRecipes(exporter);
        generateWoolSlabRecipes(exporter);
        generateDungDyeingRecipes(exporter);
        generateCompactingRecipes(exporter);
        generateBloodWoodRecipes(exporter);

        class_2447.method_10436(class_7800.field_40636, BwtBlocks.stoneDetectorRailBlock, 6)
                .method_10439("i i")
                .method_10439("ipi")
                .method_10439("iri")
                .method_10434('i', class_1802.field_8620)
                .method_10434('p', class_1802.field_8667)
                .method_10434('r', class_1802.field_8725)
                .method_10429(method_32807(class_1802.field_8667), method_10426(class_1802.field_8667))
                .method_10431(exporter);
        class_2447.method_10436(class_7800.field_40636, BwtBlocks.obsidianDetectorRailBlock, 6)
                .method_10439("i i")
                .method_10439("ipi")
                .method_10439("iri")
                .method_10434('i', class_1802.field_8620)
                .method_10434('p', BwtBlocks.obsidianPressurePlateBlock)
                .method_10434('r', class_1802.field_8725)
                .method_10429(method_32807(BwtBlocks.obsidianPressurePlateBlock), method_10426(BwtBlocks.obsidianPressurePlateBlock))
                .method_10431(exporter);
        class_2447.method_10437(class_7800.field_40635, BwtBlocks.vineTrapBlock)
                .method_10439("vvv")
                .method_10434('v', class_1802.field_17523)
                .method_10429(method_32807(class_1802.field_17523), method_10426(class_1802.field_17523))
                .method_10431(exporter);
        offer2x1SlabRecipes(exporter, class_7800.field_40634, class_2246.field_10566, BwtBlocks.dirtSlabBlock, "dirt");
        offer2x1SlabRecipes(exporter, class_7800.field_40634, class_2246.field_10219, BwtBlocks.grassSlabBlock, "grass");
        offer2x1SlabRecipes(exporter, class_7800.field_40634, class_2246.field_10402, BwtBlocks.myceliumSlabBlock, "mycelium");
        offer2x1SlabRecipes(exporter, class_7800.field_40634, class_2246.field_10520, BwtBlocks.podzolSlabBlock, "podzol");
    }

    private void generateBloodWoodRecipes(class_8790 exporter) {
        method_33535(exporter, BwtBlocks.bloodWoodBlocks.blockFamily, class_7699.method_45398(class_7701.field_40177));
        method_24475(exporter, BwtBlocks.bloodWoodBlocks.planksBlock, BwtItemTags.BLOOD_WOOD_LOGS, 4);
        method_24476(exporter, BwtBlocks.bloodWoodBlocks.woodBlock, BwtBlocks.bloodWoodBlocks.logBlock);
        method_24476(exporter, BwtBlocks.bloodWoodBlocks.strippedWoodBlock, BwtBlocks.bloodWoodBlocks.strippedLogBlock);
    }

    private void generateCompactingRecipes(class_8790 exporter) {
        method_36449(exporter, class_7800.field_40642, BwtItems.soapItem, class_7800.field_40635, BwtBlocks.soapBlock, "soap_from_block", "soap");
        method_36449(exporter, class_7800.field_40642, BwtItems.dungItem, class_7800.field_40635, BwtBlocks.dungBlock, "dung_from_block", "dung");
        method_36449(exporter, class_7800.field_40642, BwtItems.concentratedHellfireItem, class_7800.field_40635, BwtBlocks.concentratedHellfireBlock, "concentrated_hellfire_from_block", "concentrated_hellfire");
        method_36449(exporter, class_7800.field_40642, BwtItems.paddingItem, class_7800.field_40635, BwtBlocks.paddingBlock, "padding_from_block", "padding");
        method_36449(exporter, class_7800.field_40642, BwtItems.ropeItem, class_7800.field_40635, BwtBlocks.ropeCoilBlock, "rope_from_block", "rope");
        offer2x2BlockSlabFamily(exporter, BwtBlocks.wickerPaneBlock, BwtBlocks.wickerBlock, BwtBlocks.wickerSlabBlock, "wicker");
    }

    public static void offerCompacting2x2(class_8790 exporter, class_1935 inputItem, class_1935 outputBlock, class_7800 category, @Nullable String group, @Nullable String recipeId) {
        class_2447.method_10437(category, outputBlock).method_10434('#', inputItem).method_10439("##").method_10439("##").method_10429(method_32807(inputItem), method_10426(inputItem)).method_10435(group).method_17972(exporter, recipeId != null ? Id.of(recipeId) : Id.of(class_2446.method_36450(outputBlock)));
    }

    public static void offerUncompacting2x2(class_8790 exporter, class_1935 inputBlock, class_1935 outputItem, class_7800 category, @Nullable String group, @Nullable String recipeId) {
        class_2450.method_10448(category, outputItem, 4).method_10454(inputBlock).method_10452(group).method_10442(method_32807(inputBlock), method_10426(inputBlock)).method_17972(exporter, recipeId != null ? Id.of(recipeId) : Id.of(class_2446.method_36450(outputItem)));
    }

    public static void offer2x1SlabCreating(class_8790 exporter, class_1935 inputBlock, class_1935 outputSlab, class_7800 category, @Nullable String group, @Nullable String recipeId) {
        class_2447.method_10436(category, outputSlab, 4).method_10434('#', inputBlock).method_10439("##").method_10429(method_32807(inputBlock), method_10426(inputBlock)).method_10435(group).method_17972(exporter, recipeId != null ? Id.of(recipeId) : Id.of(class_2446.method_36450(outputSlab)));
    }

    public static void offer2x1SlabRecombining(class_8790 exporter, class_1935 inputSlab, class_1935 outputBlock, class_7800 category, @Nullable String group, @Nullable String recipeId) {
        class_2447.method_10437(category, outputBlock).method_10434('#', inputSlab).method_10439("#").method_10439("#").method_10429(method_32807(inputSlab), method_10426(inputSlab)).method_10435(group).method_17972(exporter, recipeId != null ? Id.of(recipeId) : Id.of(class_2446.method_36450(outputBlock)));
    }

    public static void offer2x1SlabUncompacting(class_8790 exporter, class_1935 inputSlab, class_1935 outputItem, class_7800 category, @Nullable String group, @Nullable String recipeId) {
        class_2450.method_10448(category, outputItem, 2).method_10454(inputSlab).method_10452(group).method_10442(method_32807(inputSlab), method_10426(inputSlab)).method_17972(exporter, recipeId != null ? Id.of(recipeId) : Id.of(class_2446.method_36450(outputItem)));
    }

    public static void offer2x1SlabRecipes(class_8790 exporter, class_7800 category, class_1935 block, class_1935 slab, String itemGroup) {
        offer2x1SlabCreating(exporter, block, slab, category, itemGroup + "_slab", itemGroup + "_slab_from_block");
        offer2x1SlabRecombining(exporter, slab, block, category, itemGroup + "_block", itemGroup + "_block_from_slab");
    }

    public static void offer2x2BlockSlabFamily(class_8790 exporter, class_1935 baseItem, class_1935 block, class_1935 slab, String itemGroup) {
        offerCompacting2x2(exporter, baseItem, block, class_7800.field_40635, itemGroup + "_block", null);
        offerUncompacting2x2(exporter, block, baseItem, class_7800.field_40642, itemGroup, itemGroup + "_from_block");
        offer2x1SlabRecipes(exporter, class_7800.field_40635, block, slab, itemGroup);
        offer2x1SlabUncompacting(exporter, slab, baseItem, class_7800.field_40642, itemGroup, itemGroup + "_from_slab");
    }

    private void generateDungDyeingRecipes(class_8790 exporter) {
        class_1769 dung = BwtItems.dungItem;

        // This is a little unnecessary to declare separately, but it helps keep track of what we're doing
        VaseBlock brownVase = BwtBlocks.vaseBlocks.get(BwtItems.dungItem.method_7802());
        class_2248 brownBed = class_2246.field_10288;
        class_2248 brownWool = class_2246.field_10113;
        class_2248 brownCarpet = class_2246.field_10473;
        class_2248 brownTerracotta = class_2246.field_10123;
        class_2248 brownConcretePowder = class_2246.field_10023;
        class_2248 brownStainedGlass = class_2246.field_10073;
        class_2248 brownStainedGlassPane = class_2246.field_10163;
        class_2248 brownCandle = class_2246.field_27112;

        class_2450.method_10447(class_7800.field_40635, brownVase)
                .method_10454(dung)
                .method_10451(class_1856.method_26964(
                        DyeUtils.streamColorItemsSorted(BwtBlocks.vaseBlocks).filter(dyeable -> !dyeable.equals(brownVase)).map(class_1799::new)
                ))
                .method_10452("vases")
                .method_10442("has_needed_dye", class_2446.method_10426(dung))
                .method_17972(exporter, Id.of("dye_" + class_2446.method_33716(brownVase) + "_from_dung"));
        class_2450.method_10447(class_7800.field_40635, brownCandle)
                .method_10454(class_2246.field_27099)
                .method_10454(dung)
                .method_10452("dyed_candle")
                .method_10442(class_2446.method_32807(dung), class_2446.method_10426(dung))
                .method_36443(exporter, class_5797.method_36442(class_2246.field_27112) + "_from_dung");
        class_2450.method_10447(class_7800.field_40634, brownBed)
                .method_10454(dung)
                .method_10451(class_1856.method_26964(Stream.of(class_1802.field_8112, class_1802.field_8893, class_1802.field_8390, class_1802.field_8754, class_1802.field_8368, class_1802.field_8286, class_1802.field_8146, class_1802.field_8679, class_1802.field_8349, class_1802.field_8059, class_1802.field_8417, class_1802.field_8262, class_1802.field_8789, class_1802.field_8863, class_1802.field_8258).map(class_1799::new)))
                .method_10452("bed")
                .method_10442(class_2446.method_32807(dung), class_2446.method_10426(dung))
                .method_17972(exporter, Id.of("dye_" + class_2446.method_33716(brownBed) + "_from_dung"));
        class_2450.method_10447(class_7800.field_40634, brownWool)
                .method_10454(dung)
                .method_10451(class_1856.method_26964(Stream.of(class_1802.field_19059, class_1802.field_19055, class_1802.field_19053, class_1802.field_19051, class_1802.field_19057, class_1802.field_19047, class_1802.field_19052, class_1802.field_19049, class_1802.field_19046, class_1802.field_19045, class_1802.field_19050, class_1802.field_19054, class_1802.field_19058, class_1802.field_19048, class_1802.field_19044).map(class_1799::new)))
                .method_10452("wool")
                .method_10442(class_2446.method_32807(dung), class_2446.method_10426(dung))
                .method_17972(exporter, Id.of("dye_" + class_2446.method_33716(brownWool) + "_from_dung"));
        class_2450.method_10447(class_7800.field_40634, brownCarpet)
                .method_10454(dung)
                .method_10451(class_1856.method_26964(Stream.of(class_1802.field_8611, class_1802.field_8115, class_1802.field_8290, class_1802.field_8875, class_1802.field_8664, class_1802.field_8078, class_1802.field_8654, class_1802.field_8253, class_1802.field_8384, class_1802.field_8683, class_1802.field_8580, class_1802.field_8098, class_1802.field_8482, class_1802.field_8142, class_1802.field_8850).map(class_1799::new)))
                .method_10452("carpet")
                .method_10442(class_2446.method_32807(dung), class_2446.method_10426(dung))
                .method_17972(exporter, Id.of("dye_" + class_2446.method_33716(brownCarpet) + "_from_dung"));
        class_2447.method_10436(class_7800.field_40634, brownTerracotta, 8)
                .method_10434('#', class_2246.field_10415)
                .method_10434('X', dung)
                .method_10439("###")
                .method_10439("#X#")
                .method_10439("###")
                .method_10435("stained_terracotta")
                .method_10429("has_terracotta", method_10426(class_2246.field_10415))
                .method_10429(method_32807(dung), method_10426(dung))
                .method_17972(exporter, Id.of("dye_" + method_33716(brownTerracotta) + "_from_dung"));
        class_2450.method_10448(class_7800.field_40634, brownConcretePowder, 8)
                .method_10454(dung)
                .method_10449(class_2246.field_10102, 4)
                .method_10449(class_2246.field_10255, 4)
                .method_10452("concrete_powder")
                .method_10442("has_sand", method_10426(class_2246.field_10102))
                .method_10442("has_gravel", method_10426(class_2246.field_10255))
                .method_10442(method_32807(dung), method_10426(dung))
                .method_17972(exporter, Id.of("dye_" + method_33716(brownConcretePowder) + "_from_dung"));
        class_2447.method_10436(class_7800.field_40634, brownStainedGlass, 8)
                .method_10434('#', class_2246.field_10033)
                .method_10434('X', dung)
                .method_10439("###")
                .method_10439("#X#")
                .method_10439("###")
                .method_10435("stained_glass")
                .method_10429("has_glass", method_10426(class_2246.field_10033))
                .method_10429(method_32807(dung), method_10426(dung))
                .method_17972(exporter, Id.of("dye_" + method_33716(brownStainedGlass) + "_from_dung"));
        class_2447.method_10436(class_7800.field_40635, brownStainedGlassPane, 8)
                .method_10434('#', class_2246.field_10285)
                .method_10434('$', dung)
                .method_10439("###")
                .method_10439("#$#")
                .method_10439("###")
                .method_10435("stained_glass_pane")
                .method_10429("has_glass_pane", method_10426(class_2246.field_10285))
                .method_10429(method_32807(dung), method_10426(dung))
                .method_17972(exporter, Id.of("dye_" + method_33716(brownStainedGlassPane) + "_from_dung"));
    }

    private void generateVaseDyeingRecipes(class_8790 exporter) {
        List<class_1792> dyes = List.copyOf(DyeUtils.DYE_COLORS_ORDERED.stream().map(class_1769::method_7803).toList());
        List<class_1792> vases = DyeUtils.streamColorItemsSorted(BwtBlocks.vaseBlocks).map(VaseBlock::method_8389).toList();
        method_51890(exporter, dyes, vases, "vases");
    }

    private void generateWoolSlabRecipes(class_8790 exporter) {
        List<class_1792> dyes = List.copyOf(DyeUtils.DYE_COLORS_ORDERED.stream().map(class_1769::method_7803).toList());
        List<class_1792> woolSlabs = DyeUtils.streamColorItemsSorted(BwtBlocks.woolSlabBlocks).map(class_2482::method_8389).toList();
        method_51890(exporter, dyes, woolSlabs, "wool_slabs");
        BwtBlocks.woolSlabBlocks.forEach((dyeColor, woolSlab) -> {
            class_1792 woolBlockItem = DyeUtils.WOOL_COLORS.get(dyeColor).method_8389();
            method_32804(class_7800.field_40634, woolSlab, class_1856.method_8091(woolBlockItem)).method_33530(method_32807(woolBlockItem), method_10426(woolBlockItem)).method_33529("wool_slabs").method_10431(exporter);
            class_2450.method_10448(class_7800.field_40634, woolBlockItem, 1).method_10449(woolSlab, 2).method_10442(method_32807(woolSlab), method_10426(woolSlab)).method_10452("wool").method_17972(exporter, Id.of("recombine_" + class_7923.field_41175.method_10221(woolSlab).method_12832()));
        });
    }

    private void generateTier1Recipes(class_8790 exporter) {
        class_2447.method_10436(class_7800.field_40642, BwtItems.gearItem, 2)
                .method_10439(" s ")
                .method_10439("sps")
                .method_10439(" s ")
                .method_10434('s', class_1802.field_8600)
                .method_10433('p', class_3489.field_15537)
                .method_10429(method_32807(class_1802.field_8600), method_10426(class_1802.field_8600))
                .method_10429("has_planks", method_10420(class_3489.field_15537))
                .method_10431(exporter);
        class_2447.method_10437(class_7800.field_40642, BwtBlocks.handCrankBlock)
                .method_10439("  s")
                .method_10439(" s ")
                .method_10439("cgc")
                .method_10434('s', class_1802.field_8600)
                .method_10433('c', class_3489.field_25808)
                .method_10434('g', BwtItems.gearItem)
                .method_10429(method_32807(BwtItems.gearItem), method_10426(BwtItems.gearItem))
                .method_10431(exporter);
        class_2447.method_10437(class_7800.field_40642, BwtBlocks.millStoneBlock)
                .method_10439("sss")
                .method_10439("sss")
                .method_10439("sgs")
                .method_10434('s', class_1802.field_20391)
                .method_10434('g', BwtItems.gearItem)
                .method_10429(method_32807(BwtItems.gearItem), method_10426(BwtItems.gearItem))
                .method_10431(exporter);
        class_2447.method_10437(class_7800.field_40642, BwtBlocks.cauldronBlock)
                .method_10439("ibi")
                .method_10439("iwi")
                .method_10439("iii")
                .method_10434('i', class_1802.field_8620)
                .method_10434('b', class_1802.field_8606)
                .method_10434('w', class_1802.field_8705)
                .method_10429(method_32807(class_1802.field_8606), method_10426(class_1802.field_8606))
                .method_10431(exporter);
        class_2450.method_10447(class_7800.field_40642, BwtBlocks.cauldronBlock)
                .method_10454(class_2246.field_10593)
                .method_10454(class_1802.field_8606)
                .method_10454(class_1802.field_8705)
                .method_10442(method_32807(class_1802.field_8606), method_10426(class_1802.field_8606))
                .method_17972(exporter, Id.of("cauldron_from_vanilla"));
        class_2447.method_10437(class_7800.field_40642, BwtBlocks.lightBlockBlock)
                .method_10439(" p ")
                .method_10439("pfp")
                .method_10439(" r ")
                .method_10433('p', ConventionalItemTags.GLASS_PANES)
                .method_10434('f', BwtItems.filamentItem)
                .method_10434('r', class_1802.field_8725)
                .method_10429(method_32807(BwtItems.filamentItem), method_10426(BwtItems.filamentItem))
                .method_10431(exporter);
        class_2447.method_10437(class_7800.field_40642, BwtItems.fabricItem)
                .method_10439("fff")
                .method_10439("fff")
                .method_10439("fff")
                .method_10434('f', BwtItems.hempFiberItem)
                .method_10429(method_32807(BwtItems.hempFiberItem), method_10426(BwtItems.hempFiberItem))
                .method_10431(exporter);
        class_2447.method_10437(class_7800.field_40642, BwtItems.sailItem)
                .method_10439("fff")
                .method_10439("fff")
                .method_10439("ppp")
                .method_10434('f', BwtItems.fabricItem)
                .method_10433('p', class_3489.field_15537)
                .method_10429(method_32807(BwtItems.fabricItem), method_10426(BwtItems.fabricItem))
                .method_10431(exporter);
        class_2447.method_10437(class_7800.field_40642, BwtItems.windmillItem)
                .method_10439(" s ")
                .method_10439("s s")
                .method_10439(" s ")
                .method_10434('s', BwtItems.sailItem)
                .method_10429(method_32807(BwtItems.sailItem), method_10426(BwtItems.sailItem))
                .method_10431(exporter);
        class_2447.method_10437(class_7800.field_40636, BwtBlocks.gearBoxBlock)
                .method_10439("pgp")
                .method_10439("g g")
                .method_10439("pgp")
                .method_10433('p', class_3489.field_15537)
                .method_10434('g', BwtItems.gearItem)
                .method_10435("gear_box")
                .method_10429(method_32807(BwtItems.gearItem), method_10426(BwtItems.gearItem))
                .method_10431(exporter);
        class_2447.method_10437(class_7800.field_40636, BwtBlocks.redstoneClutchBlock)
                .method_10439("pgp")
                .method_10439("grg")
                .method_10439("pgp")
                .method_10433('p', class_3489.field_15537)
                .method_10434('g', BwtItems.gearItem)
                .method_10434('r', class_1802.field_8725)
                .method_10435("redstone_clutch")
                .method_10429(method_32807(BwtItems.gearItem), method_10426(BwtItems.gearItem))
                .method_10431(exporter);
        class_2447.method_10437(class_7800.field_40636, BwtItems.ropeItem)
                .method_10439("fff")
                .method_10439("fff")
                .method_10434('f', BwtItems.hempFiberItem)
                .method_10429(method_32807(BwtItems.hempFiberItem), method_10426(BwtItems.hempFiberItem))
                .method_10435("rope")
                .method_10431(exporter);
        class_2447.method_10437(class_7800.field_40636, BwtItems.ropeItem)
                .method_10439("ff")
                .method_10439("ff")
                .method_10439("ff")
                .method_10434('f', BwtItems.hempFiberItem)
                .method_10429(method_32807(BwtItems.hempFiberItem), method_10426(BwtItems.hempFiberItem))
                .method_10435("rope")
                .method_17972(exporter, Id.of("rope_vertical"));
        class_2447.method_10437(class_7800.field_40636, BwtBlocks.axleBlock)
                .method_10439("prp")
                .method_10433('p', class_3489.field_15537)
                .method_10434('r', BwtItems.ropeItem)
                .method_10429(method_32807(BwtItems.ropeItem), method_10426(BwtItems.ropeItem))
                .method_10431(exporter);
        class_2447.method_10437(class_7800.field_40636, BwtBlocks.anchorBlock)
                .method_10439(" i ")
                .method_10439("sss")
                .method_10434('i', class_1802.field_8620)
                .method_10434('s', class_1802.field_20389)
                .method_10429(method_32807(class_1802.field_20389), method_10426(class_1802.field_20389))
                .method_10431(exporter);
        class_2447.method_10436(class_7800.field_40635, class_2246.field_10336, 4)
                .method_10439("X")
                .method_10439("S")
                .method_10434('X', BwtItems.nethercoalItem)
                .method_10434('S', class_1802.field_8600)
                .method_10429("has_nether_coal", method_10426(BwtItems.nethercoalItem))
                .method_17972(exporter, Id.of("torch_from_nether_coal"));
        class_2447.method_10436(class_7800.field_40635, class_2246.field_22092, 4)
                .method_10439("X")
                .method_10439("#")
                .method_10439("S")
                .method_10434('X', BwtItems.nethercoalItem)
                .method_10434('#', class_1802.field_8600)
                .method_10433('S', class_3489.field_23801)
                .method_10429("has_nether_coal", method_10426(BwtItems.nethercoalItem))
                .method_17972(exporter, Id.of("soul_torch_from_nether_coal"));
    }

    private void generateTier2Recipes(class_8790 exporter) {
        class_2450.method_10448(class_7800.field_40642, BwtItems.strapItem, 8)
                .method_10454(BwtItems.tannedLeatherItem)
                .method_10442(method_32807(BwtItems.tannedLeatherItem), method_10426(BwtItems.tannedLeatherItem))
                .method_10431(exporter);
        class_2447.method_10437(class_7800.field_40642, BwtItems.beltItem)
                .method_10439(" s ")
                .method_10439("s s")
                .method_10439(" s ")
                .method_10434('s', BwtItems.strapItem)
                .method_10429(method_32807(BwtItems.strapItem), method_10426(BwtItems.strapItem))
                .method_10431(exporter);
        class_2447.method_10437(class_7800.field_40642, BwtBlocks.sawBlock)
                .method_10439("iii")
                .method_10439("gbg")
                .method_10439("pgp")
                .method_10434('i', class_1802.field_8620)
                .method_10434('g', BwtItems.gearItem)
                .method_10433('p', class_3489.field_15537)
                .method_10434('b', BwtItems.beltItem)
                .method_10429(method_32807(BwtItems.beltItem), method_10426(BwtItems.beltItem))
                .method_10431(exporter);
        class_2447.method_10437(class_7800.field_40642, BwtBlocks.grateBlock)
                .method_10439("ss")
                .method_10439("ss")
                .method_10434('s', class_1802.field_8600)
                .method_10429(method_32807(class_1802.field_8600), method_10426(class_1802.field_8600))
                .method_10431(exporter);
        class_2447.method_10437(class_7800.field_40642, BwtBlocks.wickerPaneBlock)
                .method_10439("ss")
                .method_10439("ss")
                .method_10434('s', class_1802.field_17531)
                .method_10429(method_32807(class_1802.field_17531), method_10426(class_1802.field_17531))
                .method_10435("wicker")
                .method_10431(exporter);
        class_2447.method_10437(class_7800.field_40642, BwtBlocks.slatsBlock)
                .method_10439("mm")
                .method_10439("mm")
                .method_10433('m', BwtItemTags.WOODEN_MOULDING_BLOCKS)
                .method_10429("has_wooden_moulding", method_10420(BwtItemTags.WOODEN_MOULDING_BLOCKS))
                .method_10431(exporter);
        class_2447.method_10437(class_7800.field_40642, BwtBlocks.pulleyBlock)
                .method_10439("pip")
                .method_10439("grg")
                .method_10439("pip")
                .method_10433('p', class_3489.field_15537)
                .method_10434('i', class_1802.field_8620)
                .method_10434('g', BwtItems.gearItem)
                .method_10434('r', class_1802.field_8725)
                .method_10429(method_32807(BwtItems.gearItem), method_10426(BwtItems.gearItem))
                .method_10431(exporter);
        class_2447.method_10437(class_7800.field_40642, BwtBlocks.platformBlock)
                .method_10439("pwp")
                .method_10439(" p ")
                .method_10439("pwp")
                .method_10433('p', class_3489.field_15537)
                .method_10434('w', BwtBlocks.wickerPaneBlock)
                .method_10429(method_32807(BwtBlocks.wickerPaneBlock), method_10426(BwtBlocks.wickerPaneBlock))
                .method_10431(exporter);
    }

    private void generateTier3Recipes(class_8790 exporter) {
        for (int i = 0; i < BwtBlocks.sidingBlocks.size(); i++) {
            SidingBlock sidingBlock = BwtBlocks.sidingBlocks.get(i);
            MouldingBlock mouldingBlock = BwtBlocks.mouldingBlocks.get(i);
            CornerBlock cornerBlock = BwtBlocks.cornerBlocks.get(i);
            ColumnBlock columnBlock = BwtBlocks.columnBlocks.get(i);
            PedestalBlock pedestalBlock = BwtBlocks.pedestalBlocks.get(i);
            TableBlock tableBlock = BwtBlocks.tableBlocks.get(i);
            if (!sidingBlock.isWood()) {
                continue;
            }
            // Wooden Mini block recombining recipes
            class_2450.method_10447(class_7800.field_40634, sidingBlock.fullBlock)
                    .method_10449(sidingBlock, 2)
                    .method_10452("planks")
                    .method_10442(method_32807(sidingBlock), method_10426(sidingBlock))
                    .method_17972(exporter, Id.of("recombine_" + class_7923.field_41175.method_10221(sidingBlock).method_12832()));
            class_2450.method_10447(class_7800.field_40634, sidingBlock)
                    .method_10449(mouldingBlock, 2)
                    .method_10452("siding")
                    .method_10442(method_32807(mouldingBlock), method_10426(mouldingBlock))
                    .method_17972(exporter, Id.of("recombine_" + class_7923.field_41175.method_10221(mouldingBlock).method_12832()));
            class_2450.method_10447(class_7800.field_40634, mouldingBlock)
                    .method_10449(cornerBlock, 2)
                    .method_10452("moulding")
                    .method_10442(method_32807(sidingBlock), method_10426(sidingBlock))
                    .method_17972(exporter, Id.of("recombine_" + class_7923.field_41175.method_10221(cornerBlock).method_12832()));
            // Decorative blocks
            class_2447.method_10437(class_7800.field_40634, columnBlock)
                    .method_10439("#")
                    .method_10439("#")
                    .method_10439("#")
                    .method_10434('#', mouldingBlock)
                    .method_10435("column")
                    .method_10429(method_32807(mouldingBlock), method_10426(mouldingBlock))
                    .method_10431(exporter);
            EmiDefaultsGenerator.addDefaultRecipe(columnBlock);

            class_2447.method_10436(class_7800.field_40634, pedestalBlock, 6)
                    .method_10439(" s ")
                    .method_10439("###")
                    .method_10439("###")
                    .method_10434('#', sidingBlock.fullBlock)
                    .method_10434('s', sidingBlock)
                    .method_10435("pedestal")
                    .method_10429(method_32807(sidingBlock), method_10426(sidingBlock))
                    .method_10431(exporter);
            EmiDefaultsGenerator.addDefaultRecipe(pedestalBlock);

            class_2447.method_10436(class_7800.field_40634, tableBlock, 4)
                    .method_10439("sss")
                    .method_10439(" m ")
                    .method_10439(" m ")
                    .method_10434('s', sidingBlock)
                    .method_10434('m', mouldingBlock)
                    .method_10435("table")
                    .method_10429(method_32807(mouldingBlock), method_10426(mouldingBlock))
                    .method_10431(exporter);
            EmiDefaultsGenerator.addDefaultRecipe(tableBlock);
        }

        class_2447.method_10437(class_7800.field_40642, BwtBlocks.hopperBlock)
                .method_10439("s s")
                .method_10439("gpg")
                .method_10439(" c ")
                .method_10433('s', BwtItemTags.WOODEN_SIDING_BLOCKS)
                .method_10434('g', BwtItems.gearItem)
                .method_10433('p', class_3489.field_15540)
                .method_10433('c', BwtItemTags.WOODEN_CORNER_BLOCKS)
                .method_10429("has_wooden_corner", method_10420(BwtItemTags.WOODEN_CORNER_BLOCKS))
                .method_36443(exporter, "mech_hopper");
        EmiDefaultsGenerator.addDefaultRecipe(BwtBlocks.hopperBlock);
    }

    private void generateTier4Recipes(class_8790 exporter) {
        class_2447.method_10437(class_7800.field_40642, BwtBlocks.hibachiBlock)
                .method_10439("hhh")
                .method_10439("sfs")
                .method_10439("srs")
                .method_10434('h', BwtItems.concentratedHellfireItem)
                .method_10434('s', class_1802.field_20391)
                .method_10434('f', BwtItems.filamentItem)
                .method_10434('r', class_1802.field_8725)
                .method_10429(method_32807(BwtItems.filamentItem), method_10426(BwtItems.filamentItem))
                .method_10431(exporter);
        class_2447.method_10437(class_7800.field_40642, BwtBlocks.bellowsBlock)
                .method_10439("sss")
                .method_10439("lll")
                .method_10439("gbg")
                .method_10433('s', BwtItemTags.WOODEN_SIDING_BLOCKS)
                .method_10434('l', BwtItems.tannedLeatherItem)
                .method_10434('g', BwtItems.gearItem)
                .method_10434('b', BwtItems.beltItem)
                .method_10429("has_wooden_siding", method_10420(BwtItemTags.WOODEN_SIDING_BLOCKS))
                .method_10431(exporter);
    }

    private void generateTier5Recipes(class_8790 exporter) {
        class_2447.method_10437(class_7800.field_40636, class_2246.field_10615)
                .method_10439("G")
                .method_10439("P")
                .method_10434('G', BwtItems.glueItem)
                .method_10434('P', class_2246.field_10560)
                .method_10429(method_32807(BwtItems.glueItem), method_10426(BwtItems.glueItem))
                .method_36443(exporter, "glued_sticky_piston");
        class_2447.method_10437(class_7800.field_40642, BwtItems.woodBladeItem)
                .method_10439("s  ")
                .method_10439("sgs")
                .method_10439("s  ")
                .method_10433('s', BwtItemTags.WOODEN_SIDING_BLOCKS)
                .method_10434('g', BwtItems.glueItem)
                .method_10429(method_32807(BwtItems.glueItem), method_10426(BwtItems.glueItem))
                .method_10431(exporter);
        class_2447.method_10437(class_7800.field_40642, BwtItems.waterWheelItem)
                .method_10439("bbb")
                .method_10439("b b")
                .method_10439("bbb")
                .method_10434('b', BwtItems.woodBladeItem)
                .method_10429(method_32807(BwtItems.woodBladeItem), method_10426(BwtItems.woodBladeItem))
                .method_10431(exporter);
        class_2447.method_10437(class_7800.field_40642, BwtBlocks.turntableBlock)
                .method_10439("www")
                .method_10439("srs")
                .method_10439("sgs")
                .method_10433('w', BwtItemTags.WOODEN_SIDING_BLOCKS)
                .method_10434('s', class_1802.field_20391)
                .method_10434('r', class_1802.field_8725)
                .method_10434('g', BwtItems.gearItem)
                .method_10429("has_wooden_siding", method_10420(BwtItemTags.WOODEN_SIDING_BLOCKS))
                .method_10431(exporter);
        class_2447.method_10437(class_7800.field_40642, BwtItems.dynamiteItem)
                .method_10439("ph")
                .method_10439("pt")
                .method_10439("ps")
                .method_10434('p', class_1802.field_8407)
                .method_10434('h', BwtItems.hellfireDustItem)
                .method_10434('t', BwtItems.tallowItem)
                .method_10433('s', BwtItemTags.SAW_DUSTS)
                .method_10429("has_tallow", method_10426(BwtItems.tallowItem))
                .method_10431(exporter);
        class_2447.method_10437(class_7800.field_40642, BwtBlocks.miningChargeBlock)
                .method_10439("rgr")
                .method_10439("ddd")
                .method_10439("ddd")
                .method_10434('r', BwtItems.ropeItem)
                .method_10434('g', BwtItems.glueItem)
                .method_10434('d', BwtItems.dynamiteItem)
                .method_10429("has_dynamite", method_10426(BwtItems.dynamiteItem))
                .method_17972(exporter, Id.of("mining_charge_with_glue"));
        class_2447.method_10437(class_7800.field_40642, BwtBlocks.miningChargeBlock)
                .method_10439("rsr")
                .method_10439("ddd")
                .method_10439("ddd")
                .method_10434('r', BwtItems.ropeItem)
                .method_10434('s', class_1802.field_8777)
                .method_10434('d', BwtItems.dynamiteItem)
                .method_10429("has_dynamite", method_10426(BwtItems.dynamiteItem))
                .method_17972(exporter, Id.of("mining_charge_with_slime"));
        class_2447.method_10437(class_7800.field_40642, BwtBlocks.screwPumpBlock)
                .method_10439("gGg")
                .method_10439("sSs")
                .method_10439("sXs")
                .method_10434('g', BwtItems.glueItem)
                .method_10434('G', BwtBlocks.grateBlock)
                .method_10433('s', BwtItemTags.WOODEN_SIDING_BLOCKS)
                .method_10434('S', BwtItems.screwItem)
                .method_10434('X', BwtItems.gearItem)
                .method_10429(method_32807(BwtItems.screwItem), method_10426(BwtItems.screwItem))
                .method_10431(exporter);
    }

    private void generateTier6Recipes(class_8790 exporter) {
        class_2447.method_10437(class_7800.field_40635, BwtBlocks.soilPlanterBlock)
                .method_10439("d")
                .method_10439("b")
                .method_10439("p")
                .method_10434('d', class_1802.field_8831)
                .method_10434('b', class_1802.field_8324)
                .method_10434('p', BwtBlocks.planterBlock)
                .method_10429(method_32807(BwtBlocks.planterBlock), method_10426(BwtBlocks.planterBlock))
                .method_10431(exporter);
        class_2447.method_10437(class_7800.field_40635, BwtBlocks.soulSandPlanterBlock)
                .method_10439("s")
                .method_10439("p")
                .method_10434('s', class_1802.field_8067)
                .method_10434('p', BwtBlocks.planterBlock)
                .method_10429(method_32807(BwtBlocks.planterBlock), method_10426(BwtBlocks.planterBlock))
                .method_10431(exporter);
        class_2447.method_10437(class_7800.field_40635, BwtBlocks.grassPlanterBlock)
                .method_10439("g")
                .method_10439("b")
                .method_10439("p")
                .method_10434('g', class_1802.field_8270)
                .method_10434('b', class_1802.field_8324)
                .method_10434('p', BwtBlocks.planterBlock)
                .method_10429(method_32807(BwtBlocks.planterBlock), method_10426(BwtBlocks.planterBlock))
                .method_10431(exporter);
    }

    private void generateTier7Recipes(class_8790 exporter) {
        class_2447.method_10437(class_7800.field_40642, BwtItems.haftItem)
                .method_10439("s")
                .method_10439("g")
                .method_10439("m")
                .method_10434('s', BwtItems.strapItem)
                .method_10434('g', BwtItems.glueItem)
                .method_10433('m', BwtItemTags.WOODEN_MOULDING_BLOCKS)
                .method_10429(method_32807(BwtItems.glueItem), method_10426(BwtItems.glueItem))
                .method_10431(exporter);
        class_2447.method_10437(class_7800.field_40642, BwtItems.paddingItem)
                .method_10439(" F ")
                .method_10439("fff")
                .method_10439(" F ")
                .method_10434('F', BwtItems.fabricItem)
                .method_10434('f', class_1802.field_8153)
                .method_10429(method_32807(BwtItems.fabricItem), method_10426(BwtItems.fabricItem))
                .method_10435("padding")
                .method_10431(exporter);
        class_2447.method_10436(class_7800.field_40642, BwtItems.broadheadArrowItem, 4)
                .method_10439("b")
                .method_10439("m")
                .method_10439("f")
                .method_10434('b', BwtItems.broadheadItem)
                .method_10433('m', BwtItemTags.WOODEN_MOULDING_BLOCKS)
                .method_10434('f', class_1802.field_8153)
                .method_10429(method_32807(BwtItems.broadheadItem), method_10426(BwtItems.broadheadItem))
                .method_10431(exporter);
        class_2447.method_10437(class_7800.field_40642, BwtItems.compositeBowItem)
                .method_10439(" mb")
                .method_10439("mbs")
                .method_10439(" mb")
                .method_10433('m', BwtItemTags.WOODEN_MOULDING_BLOCKS)
                .method_10434('b', class_1802.field_8606)
                .method_10434('s', class_1802.field_8276)
                .method_10429("has_wooden_moulding", method_10420(BwtItemTags.WOODEN_MOULDING_BLOCKS))
                .method_10431(exporter);
        class_2447.method_10437(class_7800.field_40642, BwtBlocks.soulForgeBlock)
                .method_10439("nnn")
                .method_10439(" n ")
                .method_10439("nnn")
                .method_10434('n', class_1802.field_22020)
                .method_10429(method_32807(class_1802.field_22020), method_10426(class_1802.field_22020))
                .method_10431(exporter);
    }

    private class_2960 highEfficiencyId(class_1935 itemConvertible) {
        return Id.of(class_7923.field_41178.method_10221(itemConvertible.method_8389()).method_45138("he_").method_12832());
    }

    private void generateHighEfficiencyRecipes(class_8790 exporter) {
        Optional<SidingBlock> stoneSiding = BwtBlocks.sidingBlocks.stream().filter(sidingBlock -> sidingBlock.fullBlock == class_2246.field_10340).findAny();

        class_2447.method_10437(class_7800.field_40642, BwtItems.sailItem)
                .method_10439("fff")
                .method_10439("fff")
                .method_10439("mmm")
                .method_10434('f', BwtItems.fabricItem)
                .method_10433('m', BwtItemTags.WOODEN_MOULDING_BLOCKS)
                .method_10429(method_32807(BwtItems.fabricItem), method_10426(BwtItems.fabricItem))
                .method_17972(exporter, highEfficiencyId(BwtItems.sailItem));
        class_2447.method_10437(class_7800.field_40642, BwtBlocks.sawBlock)
                .method_10439("iii")
                .method_10439("gbg")
                .method_10439("sgs")
                .method_10434('i', class_1802.field_8620)
                .method_10434('g', BwtItems.gearItem)
                .method_10433('s', BwtItemTags.WOODEN_SIDING_BLOCKS)
                .method_10434('b', BwtItems.beltItem)
                .method_10429(method_32807(BwtItems.beltItem), method_10426(BwtItems.beltItem))
                .method_17972(exporter, highEfficiencyId(BwtBlocks.sawBlock));
        class_2447.method_10437(class_7800.field_40636, BwtBlocks.gearBoxBlock)
                .method_10439("sgs")
                .method_10439("g g")
                .method_10439("sgs")
                .method_10433('s', BwtItemTags.WOODEN_SIDING_BLOCKS)
                .method_10434('g', BwtItems.gearItem)
                .method_10435("gear_box")
                .method_10429("has_wooden_siding", method_10420(BwtItemTags.WOODEN_SIDING_BLOCKS))
                .method_17972(exporter, highEfficiencyId(BwtBlocks.gearBoxBlock));
        class_2447.method_10437(class_7800.field_40636, BwtBlocks.redstoneClutchBlock)
                .method_10439("sgs")
                .method_10439("grg")
                .method_10439("sgs")
                .method_10433('s', BwtItemTags.WOODEN_SIDING_BLOCKS)
                .method_10434('g', BwtItems.gearItem)
                .method_10434('r', class_1802.field_8725)
                .method_10435("redstone_clutch")
                .method_10429("has_wooden_siding", method_10420(BwtItemTags.WOODEN_SIDING_BLOCKS))
                .method_17972(exporter, highEfficiencyId(BwtBlocks.redstoneClutchBlock));
        class_2447.method_10437(class_7800.field_40636, class_2246.field_10560)
                .method_10439("sss")
                .method_10439("cic")
                .method_10439("crc")
                .method_10433('s', BwtItemTags.WOODEN_SIDING_BLOCKS)
                .method_10434('i', class_1802.field_8620)
                .method_10434('r', class_1802.field_8725)
                .method_10434('c', class_1802.field_20412)
                .method_10429("has_wooden_siding", method_10420(BwtItemTags.WOODEN_SIDING_BLOCKS))
                .method_17972(exporter, highEfficiencyId(class_1802.field_8249));
        class_2447.method_10437(class_7800.field_40634, class_2246.field_10504)
                .method_10439("sss")
                .method_10439("bbb")
                .method_10439("sss")
                .method_10433('s', BwtItemTags.WOODEN_SIDING_BLOCKS)
                .method_10434('b', class_1802.field_8529)
                .method_10429("has_wooden_siding", method_10420(BwtItemTags.WOODEN_SIDING_BLOCKS))
                .method_17972(exporter, highEfficiencyId(class_1802.field_8536));
        class_2447.method_10437(class_7800.field_40642, class_2246.field_10034)
                .method_10439("sss")
                .method_10439("s s")
                .method_10439("sss")
                .method_10433('s', BwtItemTags.WOODEN_SIDING_BLOCKS)
                .method_10429("has_wooden_siding", method_10420(BwtItemTags.WOODEN_SIDING_BLOCKS))
                .method_17972(exporter, highEfficiencyId(class_2246.field_10034));
        class_2447.method_10437(class_7800.field_40636, class_2246.field_10179)
                .method_10439("sss")
                .method_10439("srs")
                .method_10439("sss")
                .method_10433('s', BwtItemTags.WOODEN_SIDING_BLOCKS)
                .method_10434('r', class_1802.field_8725)
                .method_10429("has_wooden_siding", method_10420(BwtItemTags.WOODEN_SIDING_BLOCKS))
                .method_17972(exporter, highEfficiencyId(class_2246.field_10179));
        class_2447.method_10437(class_7800.field_40635, class_2246.field_10223)
                .method_10439("sss")
                .method_10439("sds")
                .method_10439("sss")
                .method_10433('s', BwtItemTags.WOODEN_SIDING_BLOCKS)
                .method_10434('d', class_1802.field_8477)
                .method_10429("has_wooden_siding", method_10420(BwtItemTags.WOODEN_SIDING_BLOCKS))
                .method_17972(exporter, highEfficiencyId(class_2246.field_10223));
        class_2447.method_10436(class_7800.field_40642, class_2246.field_9983, 3)
                .method_10439("m m")
                .method_10439("mmm")
                .method_10439("m m")
                .method_10433('m', BwtItemTags.WOODEN_MOULDING_BLOCKS)
                .method_10429("has_wooden_moulding", method_10420(BwtItemTags.WOODEN_MOULDING_BLOCKS))
                .method_17972(exporter, highEfficiencyId(class_2246.field_9983));
        class_2447.method_10437(class_7800.field_40642, class_1802.field_8600)
                .method_10435("sticks")
                .method_10439("m")
                .method_10433('m', BwtItemTags.WOODEN_MOULDING_BLOCKS)
                .method_10429("has_wooden_moulding", method_10420(BwtItemTags.WOODEN_MOULDING_BLOCKS))
                .method_17972(exporter, highEfficiencyId(class_1802.field_8600));
        stoneSiding.ifPresent(sidingBlock -> class_2447.method_10437(class_7800.field_40642, class_2246.field_10450)
                .method_10439("trt")
                .method_10439("sss")
                .method_10434('t', class_1802.field_8530)
                .method_10434('r', class_1802.field_8725)
                .method_10434('s', sidingBlock)
                .method_10429(method_32807(sidingBlock), method_10426(sidingBlock))
                .method_17972(exporter, highEfficiencyId(class_2246.field_10450)));
        class_2450.method_10447(class_7800.field_40642, class_1802.field_8529)
                .method_10454(BwtItems.tannedLeatherItem)
                .method_10449(class_1802.field_8407, 6)
                .method_10442(method_32807(BwtItems.tannedLeatherItem), method_10426(BwtItems.tannedLeatherItem))
                .method_17972(exporter, highEfficiencyId(class_1802.field_8529));
        class_2447.method_10436(class_7800.field_40635, class_1802.field_8143, 2)
                .method_10439("mmm")
                .method_10439("mtm")
                .method_10439("mmm")
                .method_10433('m', BwtItemTags.WOODEN_MOULDING_BLOCKS)
                .method_10434('t', BwtItems.tannedLeatherItem)
                .method_10429("has_wooden_moulding", method_10420(BwtItemTags.WOODEN_MOULDING_BLOCKS))
                .method_17972(exporter, highEfficiencyId(class_1802.field_8143));
        class_2447.method_10437(class_7800.field_40636, BwtBlocks.axleBlock)
                .method_10439("prp")
                .method_10433('p', BwtItemTags.WOODEN_MOULDING_BLOCKS)
                .method_10434('r', BwtItems.ropeItem)
                .method_10429(method_32807(BwtItems.ropeItem), method_10426(BwtItems.ropeItem))
                .method_17972(exporter, highEfficiencyId(BwtBlocks.axleBlock));
        class_2447.method_10436(class_7800.field_40642, class_1802.field_8428, 4)
                .method_10433('c', BwtItemTags.WOODEN_CORNER_BLOCKS)
                .method_10439("c c")
                .method_10439(" c ")
                .method_10429("has_wooden_corner", method_10420(BwtItemTags.WOODEN_CORNER_BLOCKS))
                .method_10431(exporter);
        class_5793.method_33467()
                .filter(blockFamily -> blockFamily.method_33479().orElse("").equals("wooden"))
                .forEach(blockFamily -> createHighEfficiencyBlockFamilyRecipes(blockFamily, exporter));
    }

    private void createHighEfficiencyBlockFamilyRecipe(class_8790 exporter, class_5794 blockFamily, class_5794.class_5796 variant, Function<class_2248, class_5797> builder) {
        Optional.ofNullable(blockFamily.method_33470(variant))
                .ifPresent(result -> builder.apply(result)
                        .method_33529(blockFamily.method_33479().map(group -> group + "_" + variant.method_33498()).orElse(null))
                        .method_17972(exporter, highEfficiencyId(result))
                );
    }

    private void createHighEfficiencyBlockFamilyRecipes(class_5794 blockFamily, class_8790 exporter) {
        class_2248 baseBlock = blockFamily.method_33469();
        Optional<SidingBlock> optionalSidingBlock = BwtBlocks.sidingBlocks.stream().filter(siding -> siding.fullBlock == baseBlock).findFirst();
        Optional<MouldingBlock> optionalMouldingBlock = BwtBlocks.mouldingBlocks.stream().filter(siding -> siding.fullBlock == baseBlock).findFirst();
        Optional<CornerBlock> optionalCornerBlock = BwtBlocks.cornerBlocks.stream().filter(siding -> siding.fullBlock == baseBlock).findFirst();

        if (optionalSidingBlock.isEmpty() || optionalMouldingBlock.isEmpty() || optionalCornerBlock.isEmpty()) {
            return;
        }
        SidingBlock sidingBlock = optionalSidingBlock.get();
        MouldingBlock mouldingBlock = optionalMouldingBlock.get();
        CornerBlock cornerBlock = optionalCornerBlock.get();

        createHighEfficiencyBlockFamilyRecipe(exporter, blockFamily, class_5794.class_5796.field_28535,
                door -> method_33544(door, class_1856.method_8091(sidingBlock))
                        .method_33530("has_siding", method_10426(sidingBlock)));
        createHighEfficiencyBlockFamilyRecipe(exporter, blockFamily, class_5794.class_5796.field_28543,
                trapdoor -> method_33553(trapdoor, class_1856.method_8091(sidingBlock))
                        .method_33530("has_siding", method_10426(sidingBlock)));
        createHighEfficiencyBlockFamilyRecipe(exporter, blockFamily, class_5794.class_5796.field_28541,
                pressurePlate -> class_2450.method_10447(class_7800.field_40636, pressurePlate)
                        .method_10454(sidingBlock)
                        .method_10442("has_siding", method_10426(sidingBlock)));
        createHighEfficiencyBlockFamilyRecipe(exporter, blockFamily, class_5794.class_5796.field_28536,
                fence -> class_2447.method_10436(class_7800.field_40635, fence, 3)
                        .method_10439("sms")
                        .method_10439("sms")
                        .method_10434('s', sidingBlock)
                        .method_10434('m', mouldingBlock)
                        .method_10429("has_siding", method_10426(sidingBlock)));
        createHighEfficiencyBlockFamilyRecipe(exporter, blockFamily, class_5794.class_5796.field_28537,
                fenceGate -> class_2447.method_10437(class_7800.field_40636, fenceGate)
                        .method_10439("msm")
                        .method_10439("msm")
                        .method_10434('s', sidingBlock)
                        .method_10434('m', mouldingBlock)
                        .method_10429("has_siding", method_10426(sidingBlock)));
        createHighEfficiencyBlockFamilyRecipe(exporter, blockFamily, class_5794.class_5796.field_28538,
                sign -> class_2447.method_10437(class_7800.field_40635, sign)
                        .method_10439("s")
                        .method_10439("m")
                        .method_10434('s', sidingBlock)
                        .method_10434('m', mouldingBlock)
                        .method_10429("has_siding", method_10426(sidingBlock)));
        createHighEfficiencyBlockFamilyRecipe(exporter, blockFamily, class_5794.class_5796.field_28540,
                stair -> class_2447.method_10437(class_7800.field_40634, stair)
                        .method_10439("m ")
                        .method_10439("mm")
                        .method_10434('m', mouldingBlock)
                        .method_10429("has_moulding", method_10426(mouldingBlock)));
        createHighEfficiencyBlockFamilyRecipe(exporter, blockFamily, class_5794.class_5796.field_28533,
                button -> class_2450.method_10447(class_7800.field_40636, button)
                        .method_10454(cornerBlock)
                        .method_10442(method_32807(cornerBlock), method_10426(cornerBlock)));
    }

}
