package com.bwt.generation;

import com.bwt.blocks.BwtBlocks;
import com.bwt.items.BwtItems;
import com.bwt.recipes.hopper_filter.HopperFilterRecipe;
import com.bwt.recipes.soul_bottling.SoulBottlingRecipe;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.minecraft.class_1802;
import net.minecraft.class_7225;
import net.minecraft.class_8790;
import java.util.concurrent.CompletableFuture;

public class HopperRecipeGenerator extends FabricRecipeProvider {
    public HopperRecipeGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(output, registryLookup);
    }

    @Override
    public void method_10419(class_8790 exporter) {
        generateHopperFilterRecipes(exporter);
        generateSoulBottlingRecipes(exporter);
    }

    protected void generateHopperFilterRecipes(class_8790 exporter) {
        HopperFilterRecipe.JsonBuilder.create().filter(BwtBlocks.wickerPaneBlock.method_8389()).ingredient(class_1802.field_8110).result(class_1802.field_8858).byproduct(class_1802.field_8145).method_10431(exporter);
        HopperFilterRecipe.JsonBuilder.create().filter(class_1802.field_8067).ingredient(BwtItems.groundNetherrackItem).byproduct(BwtItems.hellfireDustItem).soulCount(1).markDefault().method_10431(exporter);
        HopperFilterRecipe.JsonBuilder.create().filter(class_1802.field_8067).ingredient(BwtItems.soulDustItem).byproduct(BwtItems.sawDustItem).soulCount(1).method_10431(exporter);
    }

    protected void generateSoulBottlingRecipes(class_8790 exporter) {
        SoulBottlingRecipe.JsonBuilder.create().bottle(BwtBlocks.urnBlock).soulCount(8).result(BwtItems.soulUrnItem).markDefault().method_10431(exporter);
    }
}
