package com.bwt.generation;

import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_8790;
import java.util.concurrent.CompletableFuture;

public class RecipeGenerator extends FabricRecipeProvider {
    protected BlockDispenserClumpRecipeGenerator blockDispenserClumpRecipeGenerator;
    protected CauldronRecipeGenerator cauldronRecipeGenerator;
    protected CrucibleRecipeGenerator crucibleRecipeGenerator;
    protected CraftingRecipeGenerator craftingRecipeGenerator;
    protected VanillaRecipeGenerator vanillaRecipeGenerator;
    protected DisabledVanilaRecipeGenerator disabledVanilaRecipeGenerator;
    protected HopperRecipeGenerator hopperRecipeGenerator;
    protected MillStoneRecipeGenerator millStoneRecipeGenerator;
    protected MobSpawnerConversionRecipeGenerator mobSpawnerConversionRecipeGenerator;
    protected SawRecipeGenerator sawRecipeGenerator;
    protected TurntableRecipeGenerator turntableRecipeGenerator;
    protected KilnRecipeGenerator kilnRecipeGenerator;
    protected SoulForgeRecipeGenerator soulForgeRecipeGenerator;
    protected EmiDefaultsGenerator emiDefaultsGenerator;

    public RecipeGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(output, registriesFuture);
        this.blockDispenserClumpRecipeGenerator = new BlockDispenserClumpRecipeGenerator(output, registriesFuture);
        this.cauldronRecipeGenerator = new CauldronRecipeGenerator(output, registriesFuture);
        this.crucibleRecipeGenerator = new CrucibleRecipeGenerator(output, registriesFuture);
        this.craftingRecipeGenerator = new CraftingRecipeGenerator(output, registriesFuture);
        this.vanillaRecipeGenerator = new VanillaRecipeGenerator(output, registriesFuture);
        this.disabledVanilaRecipeGenerator = new DisabledVanilaRecipeGenerator(output, registriesFuture);
        this.hopperRecipeGenerator = new HopperRecipeGenerator(output, registriesFuture);
        this.millStoneRecipeGenerator = new MillStoneRecipeGenerator(output, registriesFuture);
        this.mobSpawnerConversionRecipeGenerator = new MobSpawnerConversionRecipeGenerator(output, registriesFuture);
        this.sawRecipeGenerator = new SawRecipeGenerator(output, registriesFuture);
        this.turntableRecipeGenerator = new TurntableRecipeGenerator(output, registriesFuture);
        this.kilnRecipeGenerator = new KilnRecipeGenerator(output, registriesFuture);
        this.soulForgeRecipeGenerator = new SoulForgeRecipeGenerator(output, registriesFuture);
        this.emiDefaultsGenerator = new EmiDefaultsGenerator(output);
    }

    @Override
    public void method_10419(class_8790 exporter) {}

    @Override
    public CompletableFuture<?> method_56888(class_7403 writer, class_7225.class_7874 wrapperLookup) {
        return CompletableFuture.allOf(
                disabledVanilaRecipeGenerator.method_56888(writer, wrapperLookup),
                blockDispenserClumpRecipeGenerator.method_56888(writer, wrapperLookup),
                cauldronRecipeGenerator.method_56888(writer, wrapperLookup),
                crucibleRecipeGenerator.method_56888(writer, wrapperLookup),
                craftingRecipeGenerator.method_56888(writer, wrapperLookup),
                vanillaRecipeGenerator.method_56888(writer, wrapperLookup),
                hopperRecipeGenerator.method_56888(writer, wrapperLookup),
                millStoneRecipeGenerator.method_56888(writer, wrapperLookup),
                mobSpawnerConversionRecipeGenerator.method_56888(writer, wrapperLookup),
                sawRecipeGenerator.method_56888(writer, wrapperLookup),
                turntableRecipeGenerator.method_56888(writer, wrapperLookup),
                kilnRecipeGenerator.method_56888(writer, wrapperLookup),
                soulForgeRecipeGenerator.method_56888(writer, wrapperLookup),
                emiDefaultsGenerator.method_10319(writer)
        );
    }
}
