package com.bwt.generation;

import com.bwt.blocks.*;
import com.bwt.items.BwtItems;
import com.bwt.recipes.saw.SawRecipe;
import com.bwt.utils.Id;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8790;
import java.util.concurrent.CompletableFuture;

public class SawRecipeGenerator extends FabricRecipeProvider {
    public SawRecipeGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(output, registryLookup);
    }

    @Override
    public void method_10419(class_8790 exporter) {
        generateSawRecipes(exporter);
    }

    protected void generateSawRecipes(class_8790 exporter) {
        generateWoodFamilyRecipes(exporter);
        SawRecipe.JsonBuilder.create(BwtBlocks.companionCubeBlock).result(BwtBlocks.companionSlabBlock, 2).markDefault().method_10431(exporter);
        SawRecipe.JsonBuilder.create(BwtBlocks.companionSlabBlock).result(BwtBlocks.companionSlabBlock).method_10431(exporter);
        SawRecipe.JsonBuilder.create(BwtBlocks.wickerBlock).result(BwtBlocks.wickerSlabBlock, 2).method_10431(exporter);
        SawRecipe.JsonBuilder.dropsSelf(class_2246.field_10597, exporter);
        SawRecipe.JsonBuilder.dropsSelf(class_2246.field_10528, exporter);
        SawRecipe.JsonBuilder.create(class_2246.field_9983).result(class_1802.field_8600, 1).method_10431(exporter);
        SawRecipe.JsonBuilder.create(class_2246.field_10342).result(class_1802.field_8551, 6).method_10431(exporter);
        SawRecipe.JsonBuilder.create(class_2246.field_10359).result(class_1802.field_8861, 6).method_10431(exporter);
    }

    private void generateWoodFamilyRecipes(class_8790 exporter) {
        for (int i = 0; i < BwtBlocks.sidingBlocks.size(); i++) {
            SidingBlock sidingBlock = BwtBlocks.sidingBlocks.get(i);
            MouldingBlock mouldingBlock = BwtBlocks.mouldingBlocks.get(i);
            CornerBlock cornerBlock = BwtBlocks.cornerBlocks.get(i);
            ColumnBlock columnBlock = BwtBlocks.columnBlocks.get(i);
            PedestalBlock pedestalBlock = BwtBlocks.pedestalBlocks.get(i);
            TableBlock tableBlock = BwtBlocks.tableBlocks.get(i);
            if (!sidingBlock.isWood()) {
                continue;
            }
            class_2248 planksBlock = sidingBlock.fullBlock;
            class_2960 planksId = class_7923.field_41175.method_10221(planksBlock);
            class_2960 baseId = planksId.method_45136(planksId.method_12832().replace("_planks", ""));
            class_2960 logId = baseId.method_48331("_log");
            class_2960 woodId = baseId.method_48331("_wood");
            class_2960 hyphaeId = baseId.method_48331("_hyphae");
            class_2960 stemId = baseId.method_48331("_stem");

            class_1792 dustItem = planksBlock == BwtBlocks.bloodWoodBlocks.planksBlock ? BwtItems.soulDustItem : BwtItems.sawDustItem;
            // Logs/Stems/Hyphae -> planks
            for (class_2960 logIshId : new class_2960[]{logId, woodId, hyphaeId, stemId}) {
                class_2248 logBlock = class_7923.field_41175.method_10223(logIshId);
                if (!logBlock.equals(class_2246.field_10124)) {
                    SawRecipe.JsonBuilder.create(logBlock).result(planksBlock, 4).result(dustItem, 2).method_10431(exporter);
                }
                class_2248 strippedBlock = class_7923.field_41175.method_10223(Id.of(logIshId.method_12836(), "stripped_" + logIshId.method_12832()));
                if (!strippedBlock.equals(class_2246.field_10124)) {
                    SawRecipe.JsonBuilder.create(strippedBlock).result(planksBlock, 4).result(dustItem, 2).method_10431(exporter);
                }
            }
            // Planks -> siding -> moulding -> corner -> gear
            SawRecipe.JsonBuilder.create(planksBlock).result(sidingBlock, 2).markDefault().method_10431(exporter);
            SawRecipe.JsonBuilder.create(sidingBlock).result(mouldingBlock, 2).markDefault().method_10431(exporter);
            SawRecipe.JsonBuilder.create(mouldingBlock).result(cornerBlock, 2).markDefault().method_10431(exporter);
            SawRecipe.JsonBuilder.create(cornerBlock).result(BwtItems.gearItem, 2).markDefault().method_10431(exporter);
            // Recycling recipes
            class_7923.field_41175.method_17966(baseId.method_48331("_fence"))
                    .ifPresent(fence -> SawRecipe.JsonBuilder.create(fence).result(cornerBlock, 2).method_10431(exporter));
            class_7923.field_41175.method_17966(baseId.method_48331("_fence_gate"))
                    .ifPresent(fenceGate -> SawRecipe.JsonBuilder.create(fenceGate).result(cornerBlock).result(class_1802.field_8600).method_10431(exporter));
            class_7923.field_41175.method_17966(baseId.method_48331("_stairs"))
                    .ifPresent(stairs -> SawRecipe.JsonBuilder.create(stairs).result(sidingBlock).result(mouldingBlock).method_10431(exporter));
            class_7923.field_41175.method_17966(baseId.method_48331("_slab"))
                    .ifPresent(slab -> SawRecipe.JsonBuilder.create(slab).result(mouldingBlock, 2).method_10431(exporter));
            SawRecipe.JsonBuilder.create(columnBlock).result(sidingBlock).result(mouldingBlock).method_10431(exporter);
            SawRecipe.JsonBuilder.create(pedestalBlock).result(mouldingBlock, 2).method_10431(exporter);
            SawRecipe.JsonBuilder.create(tableBlock).result(mouldingBlock).method_10431(exporter);
        }

        // special case bamboo
        // no sawdust, only 2 planks
        SawRecipe.JsonBuilder.create(class_2246.field_41072).result(class_2246.field_40294, 2).method_10431(exporter);
        SawRecipe.JsonBuilder.create(class_2246.field_41073).result(class_2246.field_40294, 2).method_10431(exporter);
    }
}
