package com.bwt.generation;

import com.bwt.blocks.*;
import com.bwt.items.BwtItems;
import com.bwt.recipes.soul_forge.SoulForgeShapedRecipe;
import com.bwt.recipes.soul_forge.SoulForgeShapelessRecipe;
import com.bwt.tags.BwtItemTags;
import com.bwt.utils.Id;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_5793;
import net.minecraft.class_5794;
import net.minecraft.class_5797;
import net.minecraft.class_7225;
import net.minecraft.class_7800;
import net.minecraft.class_7923;
import net.minecraft.class_8790;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class SoulForgeRecipeGenerator extends FabricRecipeProvider {
    public SoulForgeRecipeGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(output, registryLookup);
    }

    private class_2960 highEfficiencyId(class_1935 itemConvertible) {
        return Id.of(class_7923.field_41178.method_10221(itemConvertible.method_8389()).method_45138("he_").method_12832());
    }

    private void createHighEfficiencyBlockFamilyRecipe(class_8790 exporter, class_5794 blockFamily, class_5794.class_5796 variant, Function<class_2248, class_5797> builder) {
        Optional.ofNullable(blockFamily.method_33470(variant))
                .ifPresent(result -> builder.apply(result)
                        .method_33529(blockFamily.method_33479().map(group -> group + "_" + variant.method_33498()).orElse(null))
                        .method_17972(exporter, highEfficiencyId(result))
                );
    }

    private void createHighEfficiencyBlockFamilyRecipes(class_5794 blockFamily, class_8790 exporter) {
        class_2248 baseBlock = blockFamily.method_33469();
        Optional<SidingBlock> optionalSidingBlock = BwtBlocks.sidingBlocks.stream().filter(siding -> siding.fullBlock == baseBlock).findFirst();
        Optional<MouldingBlock> optionalMouldingBlock = BwtBlocks.mouldingBlocks.stream().filter(siding -> siding.fullBlock == baseBlock).findFirst();
        Optional<CornerBlock> optionalCornerBlock = BwtBlocks.cornerBlocks.stream().filter(siding -> siding.fullBlock == baseBlock).findFirst();

        if (optionalSidingBlock.isEmpty() || optionalMouldingBlock.isEmpty() || optionalCornerBlock.isEmpty()) {
            return;
        }
        SidingBlock sidingBlock = optionalSidingBlock.get();
        MouldingBlock mouldingBlock = optionalMouldingBlock.get();
        CornerBlock cornerBlock = optionalCornerBlock.get();

        createHighEfficiencyBlockFamilyRecipe(exporter, blockFamily, class_5794.class_5796.field_28535,
                door -> SoulForgeShapedRecipe.JsonBuilder.method_10436(class_7800.field_40636, door, 3)
                        .method_10428('#', class_1856.method_8091(sidingBlock))
                        .method_10439("##")
                        .method_10439("##")
                        .method_10439("##")
                        .method_10429("has_siding", method_10426(sidingBlock)));
        createHighEfficiencyBlockFamilyRecipe(exporter, blockFamily, class_5794.class_5796.field_28543,
                trapdoor -> SoulForgeShapedRecipe.JsonBuilder.method_10436(class_7800.field_40636, trapdoor, 2)
                        .method_10428('#', class_1856.method_8091(sidingBlock))
                        .method_10439("###")
                        .method_10439("###")
                        .method_10429("has_siding", method_10426(sidingBlock)));
        createHighEfficiencyBlockFamilyRecipe(exporter, blockFamily, class_5794.class_5796.field_28541,
                pressurePlate -> SoulForgeShapelessRecipe.JsonBuilder.method_10447(class_7800.field_40636, pressurePlate)
                        .method_10454(sidingBlock)
                        .method_10442("has_siding", method_10426(sidingBlock)));
        createHighEfficiencyBlockFamilyRecipe(exporter, blockFamily, class_5794.class_5796.field_28536,
                fence -> SoulForgeShapedRecipe.JsonBuilder.method_10436(class_7800.field_40635, fence, 3)
                        .method_10439("sms")
                        .method_10439("sms")
                        .method_10434('s', sidingBlock)
                        .method_10434('m', mouldingBlock)
                        .method_10429("has_siding", method_10426(sidingBlock)));
        createHighEfficiencyBlockFamilyRecipe(exporter, blockFamily, class_5794.class_5796.field_28537,
                fenceGate -> SoulForgeShapedRecipe.JsonBuilder.method_10437(class_7800.field_40636, fenceGate)
                        .method_10439("msm")
                        .method_10439("msm")
                        .method_10434('s', sidingBlock)
                        .method_10434('m', mouldingBlock)
                        .method_10429("has_siding", method_10426(sidingBlock)));
        createHighEfficiencyBlockFamilyRecipe(exporter, blockFamily, class_5794.class_5796.field_28538,
                sign -> SoulForgeShapedRecipe.JsonBuilder.method_10437(class_7800.field_40635, sign)
                        .method_10439("s")
                        .method_10439("m")
                        .method_10434('s', sidingBlock)
                        .method_10434('m', mouldingBlock)
                        .method_10429("has_siding", method_10426(sidingBlock)));
        createHighEfficiencyBlockFamilyRecipe(exporter, blockFamily, class_5794.class_5796.field_28540,
                stair -> SoulForgeShapedRecipe.JsonBuilder.method_10437(class_7800.field_40634, stair)
                        .method_10439("m ")
                        .method_10439("mm")
                        .method_10434('m', mouldingBlock)
                        .method_10429("has_moulding", method_10426(mouldingBlock)));
        createHighEfficiencyBlockFamilyRecipe(exporter, blockFamily, class_5794.class_5796.field_28533,
                button -> SoulForgeShapelessRecipe.JsonBuilder.method_10447(class_7800.field_40636, button)
                        .method_10454(cornerBlock)
                        .method_10442(method_32807(cornerBlock), method_10426(cornerBlock)));
    }

    @Override
    public void method_10419(class_8790 exporter) {
        class_5793.method_33467()
                .filter(blockFamily -> !blockFamily.method_33479().orElse("").equals("wooden"))
                .forEach(blockFamily -> createHighEfficiencyBlockFamilyRecipes(blockFamily, exporter));

        for (int i = 0; i < BwtBlocks.sidingBlocks.size(); i++) {
            SidingBlock sidingBlock = BwtBlocks.sidingBlocks.get(i);
            MouldingBlock mouldingBlock = BwtBlocks.mouldingBlocks.get(i);
            CornerBlock cornerBlock = BwtBlocks.cornerBlocks.get(i);
            ColumnBlock columnBlock = BwtBlocks.columnBlocks.get(i);
            PedestalBlock pedestalBlock = BwtBlocks.pedestalBlocks.get(i);
            TableBlock tableBlock = BwtBlocks.tableBlocks.get(i);
            if (sidingBlock.isWood()) {
                continue;
            }
            SoulForgeShapedRecipe.JsonBuilder.method_10436(class_7800.field_40634, sidingBlock, 8)
                    .markDefault()
                    .method_10439("XXXX")
                    .method_10434('X', sidingBlock.fullBlock)
                    .method_10435("siding")
                    .method_10429(method_32807(sidingBlock.fullBlock), method_10426(sidingBlock.fullBlock))
                    .method_10431(exporter);
            SoulForgeShapedRecipe.JsonBuilder.method_10436(class_7800.field_40634, mouldingBlock, 8)
                    .markDefault()
                    .method_10439("XXXX")
                    .method_10434('X', sidingBlock)
                    .method_10435("moulding")
                    .method_10429(method_32807(sidingBlock), method_10426(sidingBlock))
                    .method_10431(exporter);
            SoulForgeShapedRecipe.JsonBuilder.method_10436(class_7800.field_40634, cornerBlock, 8)
                    .markDefault()
                    .method_10439("XXXX")
                    .method_10434('X', mouldingBlock)
                    .method_10435("corners")
                    .method_10429(method_32807(mouldingBlock), method_10426(mouldingBlock))
                    .method_10431(exporter);

            // Stone Mini block recombining recipes
            SoulForgeShapelessRecipe.JsonBuilder.method_10447(class_7800.field_40634, sidingBlock.fullBlock)
                    .method_10449(sidingBlock, 2)
                    .method_10442(method_32807(sidingBlock), method_10426(sidingBlock))
                    .method_17972(exporter, Id.of("recombine_" + class_7923.field_41175.method_10221(sidingBlock).method_12832()));
            SoulForgeShapelessRecipe.JsonBuilder.method_10447(class_7800.field_40634, sidingBlock)
                    .method_10449(mouldingBlock, 2)
                    .method_10452("siding")
                    .method_10442(method_32807(mouldingBlock), method_10426(mouldingBlock))
                    .method_17972(exporter, Id.of("recombine_" + class_7923.field_41175.method_10221(mouldingBlock).method_12832()));
            SoulForgeShapelessRecipe.JsonBuilder.method_10447(class_7800.field_40634, mouldingBlock)
                    .method_10449(cornerBlock, 2)
                    .method_10452("moulding")
                    .method_10442(method_32807(cornerBlock), method_10426(cornerBlock))
                    .method_17972(exporter, Id.of("recombine_" + class_7923.field_41175.method_10221(cornerBlock).method_12832()));

            // Decorative blocks
            SoulForgeShapedRecipe.JsonBuilder.method_10437(class_7800.field_40634, columnBlock)
                    .markDefault()
                    .method_10439("#")
                    .method_10439("#")
                    .method_10439("#")
                    .method_10434('#', mouldingBlock)
                    .method_10435("column")
                    .method_10429(method_32807(mouldingBlock), method_10426(mouldingBlock))
                    .method_10431(exporter);
            SoulForgeShapedRecipe.JsonBuilder.method_10436(class_7800.field_40634, pedestalBlock, 6)
                    .markDefault()
                    .method_10439(" s ")
                    .method_10439("###")
                    .method_10439("###")
                    .method_10434('#', sidingBlock.fullBlock)
                    .method_10434('s', sidingBlock)
                    .method_10435("pedestal")
                    .method_10429(method_32807(sidingBlock), method_10426(sidingBlock))
                    .method_10431(exporter);
            SoulForgeShapedRecipe.JsonBuilder.method_10436(class_7800.field_40634, tableBlock, 4)
                    .markDefault()
                    .method_10439("sss")
                    .method_10439(" m ")
                    .method_10439(" m ")
                    .method_10434('s', sidingBlock)
                    .method_10434('m', mouldingBlock)
                    .method_10435("table")
                    .method_10429(method_32807(mouldingBlock), method_10426(mouldingBlock))
                    .method_10431(exporter);
        }
        SoulForgeShapedRecipe.JsonBuilder.method_10437(class_7800.field_40635, BwtItems.canvasItem)
                .markDefault()
                .method_10439("mmmm")
                .method_10439("mffm")
                .method_10439("mffm")
                .method_10439("mmmm")
                .method_10433('m', BwtItemTags.WOODEN_MOULDING_BLOCKS)
                .method_10434('f', BwtItems.fabricItem)
                .method_10429("has_wooden_moulding", method_10420(BwtItemTags.WOODEN_MOULDING_BLOCKS))
                .method_10431(exporter);

        SoulForgeShapedRecipe.JsonBuilder.method_10437(class_7800.field_40638, class_1802.field_22018)
                .markDefault()
                .method_10439("ssss")
                .method_10439("ssss")
                .method_10439("ssss")
                .method_10439("ssss")
                .method_10434('s', class_1802.field_22020)
                .method_10429(method_32807(class_1802.field_22020), method_10426(class_1802.field_22020))
                .method_10431(exporter);

        // Netherite Tools
        SoulForgeShapedRecipe.JsonBuilder.method_10437(class_7800.field_40638, BwtItems.netheriteMattockItem)
                .markDefault()
                .method_10439("sss ")
                .method_10439(" h s")
                .method_10439(" h  ")
                .method_10439(" h  ")
                .method_10434('s', class_1802.field_22020)
                .method_10434('h', BwtItems.haftItem)
                .method_10429(method_32807(class_1802.field_22020), method_10426(class_1802.field_22020))
                .method_10431(exporter);
        SoulForgeShapedRecipe.JsonBuilder.method_10437(class_7800.field_40638, BwtItems.netheriteBattleAxeItem)
                .markDefault()
                .method_10439("sss")
                .method_10439("shs")
                .method_10439(" h ")
                .method_10439(" h ")
                .method_10434('s', class_1802.field_22020)
                .method_10434('h', BwtItems.haftItem)
                .method_10429(method_32807(class_1802.field_22020), method_10426(class_1802.field_22020))
                .method_10431(exporter);
        SoulForgeShapedRecipe.JsonBuilder.method_10437(class_7800.field_40638, class_1802.field_22024)
                .markDefault()
                .method_10439("sss")
                .method_10439(" h ")
                .method_10439(" h ")
                .method_10439(" h ")
                .method_10434('s', class_1802.field_22020)
                .method_10434('h', BwtItems.haftItem)
                .method_10429(method_32807(class_1802.field_22020), method_10426(class_1802.field_22020))
                .method_10431(exporter);
        SoulForgeShapedRecipe.JsonBuilder.method_10437(class_7800.field_40638, class_1802.field_22023)
                .markDefault()
                .method_10439("s")
                .method_10439("h")
                .method_10439("h")
                .method_10439("h")
                .method_10434('s', class_1802.field_22020)
                .method_10434('h', BwtItems.haftItem)
                .method_10429(method_32807(class_1802.field_22020), method_10426(class_1802.field_22020))
                .method_10431(exporter);
        SoulForgeShapedRecipe.JsonBuilder.method_10437(class_7800.field_40638, class_1802.field_22025)
                .markDefault()
                .method_10439("ss")
                .method_10439("sh")
                .method_10439(" h")
                .method_10439(" h")
                .method_10434('s', class_1802.field_22020)
                .method_10434('h', BwtItems.haftItem)
                .method_10429(method_32807(class_1802.field_22020), method_10426(class_1802.field_22020))
                .method_10431(exporter);
        SoulForgeShapedRecipe.JsonBuilder.method_10437(class_7800.field_40638, class_1802.field_22026)
                .markDefault()
                .method_10439("ss")
                .method_10439(" h")
                .method_10439(" h")
                .method_10439(" h")
                .method_10434('s', class_1802.field_22020)
                .method_10434('h', BwtItems.haftItem)
                .method_10429(method_32807(class_1802.field_22020), method_10426(class_1802.field_22020))
                .method_10431(exporter);
        SoulForgeShapedRecipe.JsonBuilder.method_10437(class_7800.field_40638, class_1802.field_22022)
                .markDefault()
                .method_10439("s")
                .method_10439("s")
                .method_10439("s")
                .method_10439("h")
                .method_10434('s', class_1802.field_22020)
                .method_10434('h', BwtItems.haftItem)
                .method_10429(method_32807(class_1802.field_22020), method_10426(class_1802.field_22020))
                .method_10431(exporter);

        // Netherite armor
        SoulForgeShapedRecipe.JsonBuilder.method_10437(class_7800.field_40638, BwtItems.armorPlateItem)
                .markDefault()
                .method_10439("SnpS")
                .method_10434('n', class_1802.field_22020)
                .method_10434('S', BwtItems.strapItem)
                .method_10434('p', BwtItems.paddingItem)
                .method_10429(method_32807(class_1802.field_22020), method_10426(class_1802.field_22020))
                .method_10431(exporter);
        SoulForgeShapedRecipe.JsonBuilder.method_10437(class_7800.field_40638, class_1802.field_22027)
                .markDefault()
                .method_10439("ssss")
                .method_10439("s  s")
                .method_10439("s  s")
                .method_10439(" pp ")
                .method_10434('s', class_1802.field_22020)
                .method_10434('p', BwtItems.armorPlateItem)
                .method_10429(method_32807(BwtItems.armorPlateItem), method_10426(BwtItems.armorPlateItem))
                .method_10431(exporter);
        SoulForgeShapedRecipe.JsonBuilder.method_10437(class_7800.field_40638, class_1802.field_22028)
                .markDefault()
                .method_10439("p  p")
                .method_10439("ssss")
                .method_10439("ssss")
                .method_10439("ssss")
                .method_10434('s', class_1802.field_22020)
                .method_10434('p', BwtItems.armorPlateItem)
                .method_10429(method_32807(BwtItems.armorPlateItem), method_10426(BwtItems.armorPlateItem))
                .method_10431(exporter);
        SoulForgeShapedRecipe.JsonBuilder.method_10437(class_7800.field_40638, class_1802.field_22029)
                .markDefault()
                .method_10439("ssss")
                .method_10439("pssp")
                .method_10439("p  p")
                .method_10439("p  p")
                .method_10434('s', class_1802.field_22020)
                .method_10434('p', BwtItems.armorPlateItem)
                .method_10429(method_32807(BwtItems.armorPlateItem), method_10426(BwtItems.armorPlateItem))
                .method_10431(exporter);
        SoulForgeShapedRecipe.JsonBuilder.method_10437(class_7800.field_40638, class_1802.field_22030)
                .markDefault()
                .method_10439(" ss ")
                .method_10439(" ss ")
                .method_10439("spps")
                .method_10434('s', class_1802.field_22020)
                .method_10434('p', BwtItems.armorPlateItem)
                .method_10429(method_32807(BwtItems.armorPlateItem), method_10426(BwtItems.armorPlateItem))
                .method_10431(exporter);

        SoulForgeShapedRecipe.JsonBuilder.method_10437(class_7800.field_40636, BwtBlocks.obsidianPressurePlateBlock)
                .markDefault()
                .method_10439("oooo")
                .method_10434('o', class_1802.field_8281)
                .method_10429(method_32807(class_1802.field_8281), method_10426(class_1802.field_8281))
                .method_10431(exporter);
        SoulForgeShapedRecipe.JsonBuilder.method_10436(class_7800.field_40638, BwtItems.broadheadItem, 16)
                .markDefault()
                .method_10439(" s ")
                .method_10439("sss")
                .method_10439(" s ")
                .method_10439(" s ")
                .method_10434('s', class_1802.field_22020)
                .method_10429(method_32807(class_1802.field_22020), method_10426(class_1802.field_22020))
                .method_10431(exporter);
        SoulForgeShapedRecipe.JsonBuilder.method_10437(class_7800.field_40638, BwtItems.redstoneEyeItem)
                .markDefault()
                .method_10439("lll")
                .method_10439("ggg")
                .method_10439(" r ")
                .method_10434('l', class_1802.field_8759)
                .method_10434('g', class_1802.field_8397)
                .method_10434('r', class_1802.field_8725)
                .method_10429(method_32807(class_1802.field_8759), method_10426(class_1802.field_8759))
                .method_10431(exporter);

        SoulForgeShapedRecipe.JsonBuilder.method_10437(class_7800.field_40636, BwtBlocks.detectorBlock)
                .markDefault()
                .method_10439("cccc")
                .method_10439("ette")
                .method_10439("srrs")
                .method_10439("srrs")
                .method_10434('c', class_1802.field_20412)
                .method_10434('e', BwtItems.redstoneEyeItem)
                .method_10434('s', class_1802.field_20391)
                .method_10434('t', class_1802.field_8530)
                .method_10434('r', class_1802.field_8725)
                .method_10429(method_32807(BwtItems.redstoneEyeItem), method_10426(BwtItems.redstoneEyeItem))
                .method_10431(exporter);
        SoulForgeShapedRecipe.JsonBuilder.method_10437(class_7800.field_40636, BwtBlocks.buddyBlock)
                .markDefault()
                .method_10439("sses")
                .method_10439("etts")
                .method_10439("stte")
                .method_10439("sess")
                .method_10434('s', class_1802.field_20391)
                .method_10434('e', BwtItems.redstoneEyeItem)
                .method_10434('t', class_1802.field_8530)
                .method_10429(method_32807(BwtItems.redstoneEyeItem), method_10426(BwtItems.redstoneEyeItem))
                .method_10431(exporter);

        SoulForgeShapedRecipe.JsonBuilder.method_10437(class_7800.field_40636, BwtBlocks.blockDispenserBlock)
                .markDefault()
                .method_10439("mmmm")
                .method_10439("muum")
                .method_10439("stts")
                .method_10439("srrs")
                .method_10434('m', class_1802.field_20392)
                .method_10434('u', BwtItems.soulUrnItem)
                .method_10434('s', class_1802.field_20391)
                .method_10434('t', class_1802.field_8530)
                .method_10434('r', class_1802.field_8725)
                .method_10429(method_32807(BwtItems.soulUrnItem), method_10426(BwtItems.soulUrnItem))
                .method_10431(exporter);

        SoulForgeShapedRecipe.JsonBuilder.method_10437(class_7800.field_40636, BwtBlocks.lensBlock)
                .markDefault()
                .method_10439("gddg")
                .method_10439("g  g")
                .method_10439("g  g")
                .method_10439("gppg")
                .method_10434('g', class_1802.field_8695)
                .method_10434('d', class_1802.field_8477)
                .method_10434('p', class_1802.field_8141)
                .method_10429(method_32807(class_1802.field_8477), method_10426(class_1802.field_8477))
                .method_10431(exporter);

        SoulForgeShapedRecipe.JsonBuilder.method_10437(class_7800.field_40642, BwtItems.screwItem)
                .markDefault()
                .method_10439("ii  ")
                .method_10439(" ii ")
                .method_10439("ii  ")
                .method_10439(" ii ")
                .method_10434('i', class_1802.field_8620)
                .method_10429(method_32807(class_1802.field_8675), method_10426(class_1802.field_8675))
                .method_10431(exporter);
    }
}
