package com.bwt.items;

import com.bwt.blocks.BwtBlocks;
import com.bwt.entities.WaterWheelEntity;
import com.bwt.entities.WindmillEntity;
import com.bwt.entities.CanvasEntity;
import com.bwt.tags.BwtPaintingVariantTags;
import com.bwt.utils.Id;
import com.bwt.utils.LockableItemSettings;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroupEntries;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1535;
import net.minecraft.class_1743;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1810;
import net.minecraft.class_1834;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_4174;
import net.minecraft.class_4176;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import net.minecraft.item.*;
import net.minecraft.registry.*;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;

public class BwtItems implements ModInitializer {
    public static final class_1792 cementBucketItem = class_2378.method_10230(class_7923.field_41178, Id.of("cement_bucket"), new CementBucketItem(new class_1792.class_1793()));
	public static final class_1792 armorPlateItem = class_2378.method_10230(class_7923.field_41178, Id.of("armor_plate"), new class_1792(new class_1792.class_1793()));
	public static final class_1792 beltItem = class_2378.method_10230(class_7923.field_41178, Id.of("belt"), new class_1792(new class_1792.class_1793()));
	public static final class_1792 breedingHarnessItem = class_2378.method_10230(class_7923.field_41178, Id.of("breeding_harness"), new class_1792(new class_1792.class_1793()));
	public static final class_1792 broadheadItem = class_2378.method_10230(class_7923.field_41178, Id.of("broadhead"), new class_1792(new class_1792.class_1793()));
	public static final class_1792 broadheadArrowItem = class_2378.method_10230(class_7923.field_41178, Id.of("broadhead_arrow"), new BroadheadArrowItem(new class_1792.class_1793()));
//	public static final Item candleItem = Registry.register(Registries.ITEM, Id.of("candle"), new CandleItem(new Item.Settings()));
	public static final class_1792 canvasItem = class_2378.method_10230(class_7923.field_41178, Id.of("canvas"), new CanvasItem(new class_1792.class_1793()));
	public static final class_1792 coalDustItem = class_2378.method_10230(class_7923.field_41178, Id.of("coal_dust"), new class_1792(new class_1792.class_1793()));
	public static final class_1792 compositeBowItem = class_2378.method_10230(class_7923.field_41178, Id.of("composite_bow"), new CompositeBowItem(new class_1792.class_1793().method_7895(576)));
	public static final class_1792 concentratedHellfireItem = class_2378.method_10230(class_7923.field_41178, Id.of("concentrated_hellfire"), new class_1792(new class_1792.class_1793()));
    public static final class_1792 cookedWolfChopItem = class_2378.method_10230(class_7923.field_41178, Id.of("cooked_wolf_chop"), new class_1792(
            new class_1792.class_1793()
                    .method_19265(class_4176.field_18652))
    );
	public static final class_1792 donutItem = class_2378.method_10230(class_7923.field_41178, Id.of("donut"), new class_1792(new class_1792.class_1793()
            .method_19265(new class_4174.class_4175()
                    .method_19238(1)
                    .method_19237(0.5f)
                    .method_19241()
                    .method_19240()
                    .method_19242())
    ));
	public static final class_1769 dungItem = class_2378.method_10230(class_7923.field_41178, Id.of("dung"), new DungItem(new class_1792.class_1793()));
	public static final class_1792 dynamiteItem = class_2378.method_10230(class_7923.field_41178, Id.of("dynamite"), new DynamiteItem(new class_1792.class_1793()));
//	public static final Item enderSpectaclesItem = Registry.register(Registries.ITEM, Id.of("ender_spectacles"), new EnderSpectaclesItem(new Item.Settings()));
	public static final class_1792 fabricItem = class_2378.method_10230(class_7923.field_41178, Id.of("fabric"), new class_1792(new class_1792.class_1793()));
	public static final class_1792 filamentItem = class_2378.method_10230(class_7923.field_41178, Id.of("filament"), new class_1792(new class_1792.class_1793()));
	public static final class_1792 flourItem = class_2378.method_10230(class_7923.field_41178, Id.of("flour"), new class_1792(new class_1792.class_1793()));
	public static final class_1792 foulFoodItem = class_2378.method_10230(class_7923.field_41178, Id.of("foul_food"), new class_1792(new class_1792.class_1793()
            .method_19265(new class_4174.class_4175()
                    .method_19238(1)
                    .method_19239(new class_1293(class_1294.field_5899, 20 * 30, 0), 0.8f)
                    .method_19242())
    ));
    public static final class_1792 friedEggItem = class_2378.method_10230(class_7923.field_41178, Id.of("fried_egg"), new class_1792(new class_1792.class_1793().method_19265(new class_4174.class_4175().method_19238(3).method_19237(0.25f).method_19242())));
//	public static final Item fuseItem = Registry.register(Registries.ITEM, Id.of("fuse"), new FuseItem(new Item.Settings()));
	public static final class_1792 gearItem = class_2378.method_10230(class_7923.field_41178, Id.of("gear"), new class_1792(new class_1792.class_1793()));
	public static final class_1792 glueItem = class_2378.method_10230(class_7923.field_41178, Id.of("glue"), new class_1792(new class_1792.class_1793()));
	public static final class_1792 groundNetherrackItem = class_2378.method_10230(class_7923.field_41178, Id.of("ground_netherrack"), new class_1792(new class_1792.class_1793()));
	public static final class_1792 haftItem = class_2378.method_10230(class_7923.field_41178, Id.of("haft"), new class_1792(new class_1792.class_1793()));
	public static final class_1792 hellfireDustItem = class_2378.method_10230(class_7923.field_41178, Id.of("hellfire_dust"), new class_1792(new class_1792.class_1793()));
	public static final class_1792 hempFiberItem = class_2378.method_10230(class_7923.field_41178, Id.of("hemp_fiber"), new class_1792(new class_1792.class_1793()));
	public static final class_1792 hempItem = class_2378.method_10230(class_7923.field_41178, Id.of("hemp"), new class_1792(new class_1792.class_1793()));
	public static final class_1792 hempSeedsItem = class_2378.method_10230(class_7923.field_41178, Id.of("hemp_seeds"), new HempSeedsItem(BwtBlocks.hempCropBlock, new class_1792.class_1793()));
	public static final class_1792 kibbleItem = class_2378.method_10230(class_7923.field_41178, Id.of("kibble"), new class_1792(new class_1792.class_1793()));
//	public static final Item netherBrickItem = Registry.register(Registries.ITEM, Id.of("nether_brick"), new NetherBrickItem(new Item.Settings()));
	public static final class_1792 nethercoalItem = class_2378.method_10230(class_7923.field_41178, Id.of("nethercoal"), new class_1792(new class_1792.class_1793()));
//	public static final Item nitreItem = Registry.register(Registries.ITEM, Id.of("nitre"), new NitreItem(new Item.Settings()));
	public static final class_1792 paddingItem = class_2378.method_10230(class_7923.field_41178, Id.of("padding"), new class_1792(new class_1792.class_1793()));
	public static final class_1792 poachedEggItem = class_2378.method_10230(class_7923.field_41178, Id.of("poached_egg"), new class_1792(new class_1792.class_1793().method_19265(new class_4174.class_4175().method_19238(3).method_19237(0.25f).method_19242())));
	public static final class_1792 potashItem = class_2378.method_10230(class_7923.field_41178, Id.of("potash"), new class_1792(new class_1792.class_1793()));
    public static final class_1792 rawEggItem = class_2378.method_10230(class_7923.field_41178, Id.of("raw_egg"), new class_1792(new class_1792.class_1793().method_19265(new class_4174.class_4175().method_19238(2).method_19237(0.25f).method_19242())));
    public static final class_1792 redstoneEyeItem = class_2378.method_10230(class_7923.field_41178, Id.of("redstone_eye"), new class_1792(new class_1792.class_1793()));
    public static final class_1792 netheriteMattockItem = class_2378.method_10230(class_7923.field_41178, Id.of("netherite_mattock"), new MattockItem(class_1834.field_22033, new class_1792.class_1793().method_24359().method_57348(class_1810.method_57346(class_1834.field_22033, 1, -3.0f))));
    public static final class_1792 netheriteBattleAxeItem = class_2378.method_10230(class_7923.field_41178, Id.of("netherite_battle_axe"), new BattleAxeItem(class_1834.field_22033, new LockableItemSettings().method_57348(class_1743.method_57346(class_1834.field_22033, 3, -2.4f))));
	public static final class_1792 ropeItem = class_2378.method_10230(class_7923.field_41178, Id.of("rope"), new RopeItem(new class_1792.class_1793()));
	public static final class_1792 rottedArrowItem = class_2378.method_10230(class_7923.field_41178, Id.of("rotted_arrow"), new RottedArrowItem(new class_1792.class_1793()));
	public static final class_1792 sailItem = class_2378.method_10230(class_7923.field_41178, Id.of("sail"), new class_1792(new class_1792.class_1793().method_7889(1)));
	public static final class_1792 sawDustItem = class_2378.method_10230(class_7923.field_41178, Id.of("saw_dust"), new class_1792(new class_1792.class_1793()));
	public static final class_1792 scouredLeatherItem = class_2378.method_10230(class_7923.field_41178, Id.of("scoured_leather"), new class_1792(new class_1792.class_1793()));
	public static final class_1792 screwItem = class_2378.method_10230(class_7923.field_41178, Id.of("screw"), new class_1792(new class_1792.class_1793()));
    public static final class_1792 soapItem = class_2378.method_10230(class_7923.field_41178, Id.of("soap"), new class_1792(new class_1792.class_1793()));
    public static final class_1792 soulDustItem = class_2378.method_10230(class_7923.field_41178, Id.of("soul_dust"), new class_1792(new class_1792.class_1793()));
	public static final class_1792 soulUrnItem = class_2378.method_10230(class_7923.field_41178, Id.of("soul_urn"), new SoulUrnItem(new class_1792.class_1793()));
	public static final class_1792 strapItem = class_2378.method_10230(class_7923.field_41178, Id.of("strap"), new class_1792(new class_1792.class_1793()));
	public static final class_1792 tallowItem = class_2378.method_10230(class_7923.field_41178, Id.of("tallow"), new class_1792(new class_1792.class_1793()));
	public static final class_1792 tannedLeatherItem = class_2378.method_10230(class_7923.field_41178, Id.of("tanned_leather"), new class_1792(new class_1792.class_1793()));
//	public static final Item tannedLeatherBootsItem = Registry.register(Registries.ITEM, Id.of("tanned_leather_boots"), new TannedLeatherBootsItem(new Item.Settings()));
//	public static final Item tannedLeatherCapItem = Registry.register(Registries.ITEM, Id.of("tanned_leather_cap"), new TannedLeatherCapItem(new Item.Settings()));
//	public static final Item tannedLeatherPantsItem = Registry.register(Registries.ITEM, Id.of("tanned_leather_pants"), new TannedLeatherPantsItem(new Item.Settings()));
//	public static final Item tannedLeatherTunicItem = Registry.register(Registries.ITEM, Id.of("tanned_leather_tunic"), new TannedLeatherTunicItem(new Item.Settings()));
    public static final class_1792 waterWheelItem = class_2378.method_10230(class_7923.field_41178, Id.of("water_wheel"), new HorizontalMechPowerSourceItem(
            WaterWheelEntity::new,
            new class_1792.class_1793().method_7889(1)
    ));
    public static final class_1792 windmillItem = class_2378.method_10230(class_7923.field_41178, Id.of("windmill"), new HorizontalMechPowerSourceItem(
            WindmillEntity::new,
            new class_1792.class_1793().method_7889(1)
    ));
	public static final class_1792 wolfChopItem = class_2378.method_10230(class_7923.field_41178, Id.of("wolf_chop"), new class_1792(
            new class_1792.class_1793().method_19265(class_4176.field_18626))
    );
	public static final class_1792 woodBladeItem = class_2378.method_10230(class_7923.field_41178, Id.of("wood_blade"), new class_1792(new class_1792.class_1793()));

    @Override
    public void onInitialize() {
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_41060).register(content -> {
            content.addAfter(class_1802.field_22024, BwtItems.netheriteMattockItem);
            content.addAfter(class_1802.field_22025, BwtItems.netheriteBattleAxeItem);
//            content.addAfter(Items.WATER_BUCKET, cementBucketItem);
//            content.add(breedingHarnessItem);
        });
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40202).register(content -> {
            content.addAfter(class_1802.field_22025, BwtItems.netheriteBattleAxeItem);

            content.addAfter(class_1802.field_8102, compositeBowItem);
            content.addAfter(class_1802.field_8107, broadheadArrowItem, rottedArrowItem);
        });
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40198).register(content -> {
            content.method_45421(windmillItem);
            content.method_45421(waterWheelItem);
        });
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_41061).register(content -> {
            content.addAfter(class_1802.field_8261, wolfChopItem);
            content.addAfter(wolfChopItem, cookedWolfChopItem);
            content.addAfter(class_1802.field_8229, donutItem);
            content.method_45421(kibbleItem);
            content.addAfter(class_1802.field_8551, rawEggItem, poachedEggItem, friedEggItem);
        });
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40743).register(content -> {
            content.addAfter(class_1802.field_8317, hempSeedsItem);
        });
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_41062).register(content -> {
            content.addAfter(class_1802.field_8861, hempItem);
            content.method_45421(hempFiberItem);
            content.method_45421(dungItem);
            content.method_45421(ropeItem);
            content.method_45421(gearItem);
            content.method_45421(flourItem);
            content.method_45421(scouredLeatherItem);
            content.method_45421(tannedLeatherItem);
            content.method_45421(filamentItem);
            content.method_45421(fabricItem);
            content.method_45421(sailItem);
            content.method_45421(groundNetherrackItem);
            content.method_45421(sawDustItem);
            content.method_45421(soulDustItem);
            content.method_45421(hellfireDustItem);
            content.method_45421(concentratedHellfireItem);
            content.method_45421(potashItem);
            content.method_45421(coalDustItem);
            content.method_45421(broadheadItem);
            content.method_45421(nethercoalItem);
            content.method_45421(redstoneEyeItem);
            content.method_45421(haftItem);
            content.method_45421(armorPlateItem);
            content.method_45421(dynamiteItem);
            content.method_45421(glueItem);
            content.method_45421(paddingItem);
            content.method_45421(screwItem);
            content.method_45421(strapItem);
            content.method_45421(beltItem);
            content.method_45421(soulUrnItem);
            content.method_45421(soapItem);
            content.method_45421(tallowItem);
            content.method_45421(woodBladeItem);
        });
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40197).register(content -> {
            content.addAfter(class_1802.field_28408, canvasItem);
            content.getContext().comp_1253()
                    .method_46759(class_7924.field_41209)
                    .ifPresent(
                            registryWrapper -> addCanvases(
                                    content,
                                    content.getContext().comp_1253(),
                                    registryWrapper,
                                    registryEntry -> registryEntry.method_40220(BwtPaintingVariantTags.CANVAS_PLACEABLE)
                            )
                    );
        });
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_41063).register(content -> {
            content.getContext().comp_1253()
                    .method_46759(class_7924.field_41209)
                    .ifPresent(
                            registryWrapper -> addCanvases(
                                    content,
                                    content.getContext().comp_1253(),
                                    registryWrapper,
                                    registryEntry -> !registryEntry.method_40220(BwtPaintingVariantTags.CANVAS_PLACEABLE)
                            )
                    );
        });
    }

    public void replaceItem(FabricItemGroupEntries content, class_1935 itemToReplace, class_1935 newItem) {
        class_1792 anchorItem = itemToReplace.method_8389();
        for (List<class_1799> addTo : List.of(content.getDisplayStacks(), content.getSearchTabStacks())) {
            for (int i = 0; i < addTo.size(); i++) {
                if (addTo.get(i).method_31574(anchorItem)) {
                    addTo.set(i, new class_1799(newItem));
                    break;
                }
            }
        }

        content.method_45421(newItem);
    }

    private static void addCanvases(
            FabricItemGroupEntries entries,
            class_7225.class_7874 registryLookup,
            class_7225.class_7226<class_1535> registryWrapper,
            Predicate<class_6880<class_1535>> filter
    ) {
        class_6903<class_2520> registryOps = registryLookup.method_57093(class_2509.field_11560);
        registryWrapper.method_42017()
                .filter(filter)
                .sorted(Comparator.comparing(
                        class_6880::comp_349,
                        Comparator.comparingInt(class_1535::method_59947).thenComparing(class_1535::comp_2670)
                ))
                .forEach(
                        canvasVariantEntry -> {
                            class_9279 nbtComponent = class_9279.field_49302
                                    .method_57447(registryOps, CanvasEntity.field_49238, canvasVariantEntry)
                                    .getOrThrow()
                                    .method_57451(nbt -> nbt.method_10582("id", "bwt:canvas"));
                            class_1799 itemStack = new class_1799(canvasItem);
                            itemStack.method_57379(class_9334.field_49609, nbtComponent);
                            entries.addAfter(canvasItem, itemStack);
                        }
                );
    }
}
