package com.bwt.mixin;

import com.bwt.items.BwtItems;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1681;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_3857;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1681.class)
public abstract class EggEntityMixin extends class_3857 {
    @Unique
    protected boolean chickenSpawned;

    public EggEntityMixin(class_1299<? extends class_3857> entityType, class_1937 world) {
        super(entityType, world);
        this.chickenSpawned = false;
    }

    @Inject(method = "<init>(Lnet/minecraft/world/World;Lnet/minecraft/entity/LivingEntity;)V", at = @At("TAIL"))
    public void bwt$init1(class_1937 world, class_1309 owner, CallbackInfo ci) {
        this.chickenSpawned = false;
    }

    @Inject(method = "<init>(Lnet/minecraft/world/World;DDD)V", at = @At("TAIL"))
    public void bwt$init2(class_1937 world, double x, double y, double z, CallbackInfo ci) {
        this.chickenSpawned = false;
    }

    @Inject(method = "<init>(Lnet/minecraft/entity/EntityType;Lnet/minecraft/world/World;)V", at = @At("TAIL"))
    public void bwt$init3(class_1299<class_1681> entityType, class_1937 world, CallbackInfo ci) {
        this.chickenSpawned = false;
    }

    @Inject(method = "onCollision", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/World;spawnEntity(Lnet/minecraft/entity/Entity;)Z"))
    public void bwt$preventRawEggDrops(class_239 hitResult, CallbackInfo ci) {
        this.chickenSpawned = true;
    }

    @Inject(method = "onCollision", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/projectile/thrown/EggEntity;discard()V"))
    public void bwt$spawnRawEgg(class_239 hitResult, CallbackInfo ci) {
        if (!this.chickenSpawned) {
            method_37908().method_8649(new class_1542(method_37908(), method_23317(), method_23318(), method_23321(), new class_1799(BwtItems.rawEggItem)));
        }
    }
}
