package com.bwt.mixin;

import com.bwt.utils.VoxelShapedEntity;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1924;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;

@Mixin(class_1924.class)
public interface EntityVoxelShapeCollisionMixin {
    @ModifyReturnValue(method = "getEntityCollisions", at = @At("TAIL"))
    default List<class_265> bwt$getEntityCollisions(List<class_265> original, class_1297 entity, @Local List<class_1297> list) {
        if (list.stream().noneMatch(entity1 -> entity1 instanceof VoxelShapedEntity)) {
            return original;
        }
        class_265 entityVoxelShape = entity instanceof VoxelShapedEntity voxelShapedEntity ? voxelShapedEntity.getVoxelShape() : class_259.method_1078(entity.method_5829().method_1014(1e-7));
        return list.stream().map(entity1 -> {
            if (entity1 instanceof VoxelShapedEntity voxelShapedEntity) {
                return voxelShapedEntity.getVoxelShape().method_1096(entity1.method_19538().method_10216(), entity1.method_19538().method_10214(), entity1.method_19538().method_10215());
            }
            return class_259.method_1078(entity1.method_5829().method_997(entity1.method_19538()));
        }).filter(shape ->
                class_259.method_1074(shape, entityVoxelShape, class_247.field_16896)
        ).collect(Collectors.toList());
    }
}
