package com.bwt.recipes;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9695;
import net.minecraft.recipe.*;
import org.jetbrains.annotations.Nullable;

public record DisabledRecipe(String group) implements class_1860<class_9695> {
    public DisabledRecipe() {
        this("");
    }

    @Override
    public class_1799 method_17447() {
        return new class_1799(class_2246.field_10124);
    }

    @Override
    public class_1865<?> method_8119() {
        return BwtRecipes.DISABLED_RECIPE_SERIALIZER;
    }

    @Override
    public boolean method_8115(@Nullable class_9695 input, class_1937 world) {
        return false;
    }

    @Override
    public boolean method_8113(int width, int height) {
        return false;
    }

    @Override
    public String method_8112() {
        return null;
    }

    @Override
    public class_3956<?> method_17716() {
        return BwtRecipes.DISABLED_RECIPE_TYPE;
    }

    @Override
    public boolean method_8118() {
        return true;
    }

    @Override
    public boolean method_49188() {
        return false;
    }

    @Override
    public class_1799 method_8116(class_9695 input, class_7225.class_7874 lookup) {
        return class_1799.field_8037;
    }

    @Override
    public class_1799 method_8110(class_7225.class_7874 registriesLookup) {
        return class_1799.field_8037;
    }

    public static class Serializer implements class_1865<DisabledRecipe> {
        public static final MapCodec<DisabledRecipe> CODEC = RecordCodecBuilder.mapCodec(
                instance -> instance
                        .group(Codec.STRING.optionalFieldOf("group", "").forGetter(recipe -> recipe.group))
                        .apply(instance, DisabledRecipe::new)
        );
        public static final class_9139<class_9129, DisabledRecipe> PACKET_CODEC = class_9139.method_56437(
                Serializer::write, Serializer::read
        );

        public Serializer() {
        }

        @Override
        public MapCodec<DisabledRecipe> method_53736() {
            return CODEC;
        }

        @Override
        public class_9139<class_9129, DisabledRecipe> method_56104() {
            return PACKET_CODEC;
        }

        private static DisabledRecipe read(class_9129 buf) {
            String group = buf.method_19772();
            return new DisabledRecipe(group);
        }

        private static void write(class_9129 buf, DisabledRecipe recipe) {
            buf.method_10814(recipe.group);
        }
    }

    public interface RecipeFactory<T extends DisabledRecipe> {
        T create(String group);
    }
}
